/*
 * Interlan Ethernet Communications Controller interface Standalone driver
 */

#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "../is68kif/if_ilreg.h"

#define	NIL	1
struct ildevice *ilstd[] = { (struct ildevice *)0x3fe800, 0 };

extern u_char		broaddr[6];	/* Ethernet broadcast address */
u_char			ilme[6];	/* Ethernet address of this machine */
u_char			ilhost[6];	/* Ethernet address of host machine */
struct ilrboot_packet {
	struct il_rheader	bp_eh;		/* standard ethernet header */
	int			bp_pkid;	/* packet id */
	char			bp_cmd;		/* command */
	int			bp_offset;	/* offset */
	int			bp_len;		/* length */
	char			bp_data[BOOT_DATACNT];	/* data */
	int			crc;
	char			foo;
}			il_rcvx;
struct boot_packet	il_rcv;
struct boot_packet	il_xmt;
int			ilsend();
int			ilpkid;
struct st		ilst = {512, -1, -1, -1, -1, NULL};

#define ilcwait(x)	while ((x->il_csr & IL_CDONE) == 0)

struct	il_stats is_stats;	/* holds on-board statistics */
struct	il_stats is_sum;	/* summation over time */

ilopen(io)
	register struct iob *io;
{
	register struct ildevice *iladdr = ilstd[io->i_unit];
	unsigned int i;
	register char *p0;

	if (io->i_unit >= NIL || !probe(&iladdr->il_csr,&i)) {
		printf("il: not present\n");
		return -1;
	}
	ilpkid = 0;
	io->i_st = ilst;

	/* Reset the board and map the statistics buffer onto the BUS. */
	iladdr->il_csr = ILC_RESET;
	ilcwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il: rst fail, csr=%b\n", iladdr->il_csr, IL_BITS);
	i = paddr((int)&is_stats);
	iladdr->il_bar = i;
	iladdr->il_bcr = sizeof (struct il_stats);
	iladdr->il_bae = i >> 16;
	iladdr->il_csr = ILC_STAT;
	ilcwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il: sts fail, csr=%b\n", iladdr->il_csr, IL_BITS);
	byterev(&is_stats, sizeof(struct il_stats));
	bcopy(is_stats.ils_addr, ilme, 6);

	iladdr->il_csr = ILC_OFFLINE;
	ilcwait(iladdr);
	iladdr->il_csr = ILC_CISA;
	ilcwait(iladdr);
	iladdr->il_csr = ILC_ONLINE;
	ilcwait(iladdr);

	return netopen(ilsend, io, &il_xmt, &il_rcv, &ilpkid, ilme, ilhost);
}

ilclose(io)
	register struct iob *io;
{
	return netclose(ilsend, io, &il_xmt, &il_rcv, &ilpkid, ilme, ilhost);
}

ilstrategy(io, func)
	register struct iob *io;
{
	return netstrategy(ilsend, io, func, &il_xmt, &il_rcv, &ilpkid, 
		ilme, ilhost);
}

ilsend(io, bpx, bpr, pkidp)
	struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
{
	register struct ildevice *iladdr = ilstd[io->i_unit];
	register int retry = 0, w, rcv = 21;
	int i;

	byterev(bpx, sizeof(struct boot_packet));
	/* recieve packet in il_rcvx instead of bpr because of funky header */
	i = paddr(&il_rcvx);
	do {
		if (rcv++ > 20) {
			rcv = 0;
			if (retry++ > 40)
				goto lost;
			ilxmit(io, bpx);
		}
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof (struct ilrboot_packet);
		iladdr->il_bae = hiword(i);
		iladdr->il_csr = ILC_RCV;
		while (w = ilrwait(iladdr)) {
			if ((w == -1) || (retry++ > 40))
				goto lost;
			ilxmit(io, bpx);
		}
		/* transfer packet into bpr and byte swap */
		bcopy(il_rcvx.bp_eh.ilr_dhost, bpr, sizeof(struct boot_packet));
		byterev(bpr, sizeof(struct boot_packet));
		if (iladdr->il_csr & IL_STATUS) 
			bpr->bp_eh.ether_type = 0;
	} while (bcmp(bpr->bp_eh.ether_dhost, broaddr, 6) == 0 || 
		 bpr->bp_eh.ether_type != ETHERTYPE_ISIBOOT ||
		 bpr->bp_pkid != *pkidp );
	bpx->bp_cmd = bpr->bp_cmd;
	*pkidp = (*pkidp) + 1;
	return 1;
lost:	printf("il: lost connection\n");
	return 0;
}

ilxmit(io, bpx)
	struct iob *io;
	register struct boot_packet *bpx;
{
	register struct ildevice *iladdr = ilstd[io->i_unit];
	int i = paddr(bpx);

	iladdr->il_bar = loword(i);
	iladdr->il_bcr = sizeof (struct boot_packet);
	iladdr->il_bae = hiword(i);
	iladdr->il_csr = ILC_XMIT;
	ilcwait(iladdr);
}

ilrwait(iladdr)
	register struct ildevice *iladdr;
{
	register int i = 1000;

	while ((iladdr->il_csr & IL_RDONE) == 0) {
		if (getlocal() == 'x') {
			printf("il: aborted\n");
			return(-1);
		}
		if (--i < 0)
			return (-2);
		DELAY(250);
	}
	return (0);
}
