/* 
 * VMEBUS ICP8/16 execersizer:
 * 	TODO: make this test use ../dev/cpreg.h
 */
#include "../h/types.h"
#include "../dev/cpreg.h"
#include "saio.h"
#include "sais68k.h"

struct cpdevice *cpstd = (struct cpdevice *)&vme_stdio[0xFFF520];

char *string = "The quick brown fox jumped over the lazy dog.\n\r";
#define STRLEN		47
#define STRBUFFERSIZE	0x20000
#define PR_VAL		(PR_XOFF|PR_PENABLE|PR_BITS7|0xBB)
char strbuffer[STRLEN + STRLEN + STRBUFFERSIZE];

short	silo[50];
char	buf[50];
char	character[50];
int	verbose = 0;

struct	iob	icpbuf;

main()
{
	register char *s;
	register int i;
	register unsigned int line = 0;
	register unsigned int c;
	register struct cpdevice *cpaddr;
	unsigned long rand();
	register int len;
	register unsigned int bc;
	register char *p;
	unsigned short *sp;
	unsigned long qbaddr;

	printf("\n--- %i Standalone ICP8/16 Test ---\n\n");
	printf("  Enter address of ICP8/16 (default = %x): ", cpstd);
	stripwhite(gets(buf));
	cpaddr = (struct cpdevice *)gethex(buf);
	if (cpaddr == 0)
		cpaddr = cpstd;

menu:	printf(" a) Select line number\n");
	printf(" b) Echo test\n");
	printf(" c) Transfer test\n");
	printf(" d) all ports transfer\n");
	printf(" e) printer test\n");
	printf(" f) modem line test\n");
	printf(" g) Preform reset\n");
	printf(" h) Print resigters\n");
	printf(" i) Transfer test, random address length boundary\n");
	printf(" j) Transfer test, long transfers\n");
	printf(" k) Test silo dma\n");
	printf(" l) Toggle verbose mode\n");

	while (1) {
	    printf("Enter letter of functionality: ");
	    stripwhite(gets(buf));
	    if (buf[0] == 'a') {
		printf("    line number (0-15): ");
		stripwhite(gets(buf));
		line = getnum(buf);
		if (line > 15 || line < 0)
			line = 0;
	    } else if (buf[0] == 'b') {
		cpaddr->cp_sel = line << SEL_SHIFT;
		cpaddr->cp_pr = PR_VAL;
		cpaddr->cp_acr = 1 << line;
		cpaddr->cp_ler = 1 << line;
		icpbuf.i_ma = (long) character;
		icpbuf.i_cc = 1;
		qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		while (1) {
		    if (getlocal())
			    break;
		    if ((c = cpaddr->cp_swr) & SWR_VDP) {
			character[0] = c & 0xFF;
			cpaddr->cp_bah = qbaddr>>16;
			cpaddr->cp_bal = qbaddr;
			cpaddr->cp_bc = 1;
			cpaddr->cp_tcr = 1 << line;
			printf("%c",c);		/* echo on console */
			while (cpaddr->cp_tcr == 0)
			    DELAY(1000);
		    }
		}
	    } else if (buf[0] == 'c') {
		cpaddr->cp_sel = line << SEL_SHIFT;
		cpaddr->cp_pr = PR_VAL;
		cpaddr->cp_acr = 1 << line;
		cpaddr->cp_ler = 1 << line;
		icpbuf.i_ma = (long) string;
		icpbuf.i_cc = STRLEN;
		qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		while (1) {
		    if (getlocal())
			    break;
		    cpaddr->cp_bah = qbaddr>>16;
		    cpaddr->cp_bal = qbaddr;
		    cpaddr->cp_bc = STRLEN;
		    cpaddr->cp_tcr = 1 << line;
		    DELAY(1000);
		    while (cpaddr->cp_tcr == 0)
			    DELAY(1000);
		}
	    } else if (buf[0] == 'd') {
		int xline;
		printf("    number of lines (1-16): ");
		stripwhite(gets(buf));
		line = getnum(buf);
		if (line > 16 || line <= 0)
		    line = 1;
		icpbuf.i_ma = (long) string;
		icpbuf.i_cc = STRLEN;
		qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		while (1) {
		    if (getlocal())
			break;
		    for (i = 0 ; i < line ; i++) {
			cpaddr->cp_sel = i << SEL_SHIFT;
			cpaddr->cp_pr = PR_VAL;
			cpaddr->cp_bah = qbaddr>>16;
			cpaddr->cp_bal = qbaddr;
			cpaddr->cp_bc = STRLEN;
			xline |= 1 << line;
		    }
		    cpaddr->cp_acr = xline;
		    cpaddr->cp_ler = xline;
		    cpaddr->cp_tcr = xline;
		    line = 0;
		    DELAY(1000);
		    while ((i |= cpaddr->cp_tcr) != xline)
			DELAY(1000);
		}
	    } else if (buf[0] == 'e') {
		cpaddr->cp_sel = SEL_LP;
		icpbuf.i_ma = (long) string;
		icpbuf.i_cc = STRLEN;
		qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		while (1) {
		    if (getlocal())
			    break;
		    cpaddr->cp_bah = qbaddr>>16;
		    cpaddr->cp_bal = qbaddr;
		    cpaddr->cp_bc = STRLEN;
		    cpaddr->cp_sr = LSR_GO;
		    DELAY(1000);
		    while (cpaddr->cp_sr & LSR_GO)
			    DELAY(1000);
		    cpaddr->cp_sr = LSR_FLUSH;
		    DELAY(10);
		    while (cpaddr->cp_sr & LSR_FLUSH)
			    DELAY(1000);
		    printf("...\r");
		}
	    } else if (buf[0] == 'f') {
		cpaddr->cp_acr = 0xFFFF;
		DELAY(100000);
		printf("    Carrier Asserted on all lines, detected on\n");
		while (1) {
		    DELAY(100000);
		    if (getlocal())
			    break;
		    printf(
"\r                                                                     \r");
		    c = cpaddr->cp_dcr;
		    if (c) {
			    printf("    Detected on line(s): ");
			    for (i = 0 ; i < 16 ; i++)
				if (c & (1<<i))
				    printf("%d ",i);
		    } else
			    printf("    Not detected on any lines");
	        }
	        cpaddr->cp_acr = 0x0000;
	    } else if (buf[0] == 'g') {
		printf("    Perform Master Clear\n");
		cpaddr->cp_sel = SEL_MC;
		DELAY(1000);
		while (cpaddr->cp_sel & SEL_MC)
		    DELAY(1000);
		printf("    Done.\n");
	    } else if (buf[0] == 'h') {
		printf("    Print Registers\n");
		printf("    SEL	%x\n",cpaddr->cp_sel);
		printf("    ISR	%x\n",cpaddr->cp_isr);
		printf("    LER	%x\n",cpaddr->cp_ler);
		printf("    TCR	%x\n",cpaddr->cp_tcr);
		printf("    BRK	%x\n",cpaddr->cp_brk);
		printf("    SWR	%x\n",cpaddr->cp_swr);
		printf("    ACR	%x\n",cpaddr->cp_acr);
		printf("    DCR	%x\n",cpaddr->cp_dcr);
		printf("    DRR	%x\n",cpaddr->cp_drr);
		printf("    PR	%x\n",cpaddr->cp_pr);
		printf("    SR	%x\n",cpaddr->cp_sr);
		printf("    BAH	%x\n",cpaddr->cp_bah);
		printf("    BAL	%x\n",cpaddr->cp_bal);
		printf("    BC	%x\n",cpaddr->cp_bc);
	    } else if (buf[0] == 'i') {
		cpaddr->cp_sel = line << SEL_SHIFT;
		cpaddr->cp_pr = PR_VAL;
		cpaddr->cp_acr = 1 << line;
		cpaddr->cp_ler = 1 << line;
		while (1) {
		    i = (int)(((double)rand()/0x7ffffffe)*STRBUFFERSIZE);
		    bcopy(string, p = &strbuffer[i], len = STRLEN);
		    while (len) {
			bc = (int)(((double)rand()/0x7ffffffe)*(len-1)+1);
			if (verbose)
			    printf("%d %d@%x:%s", len, bc, p, p);
			if (bc == 0 || bc > len)
			    continue;
			icpbuf.i_ma = (long) p;
			icpbuf.i_cc = bc;
			qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
			cpaddr->cp_bah = qbaddr>>16;
			cpaddr->cp_bal = qbaddr;
			cpaddr->cp_bc= bc;
			cpaddr->cp_tcr = 1 << line;
			DELAY(1000);
			while (cpaddr->cp_tcr == 0)
			    DELAY(1000);
			len -= bc;
			p += bc;
		    }
		    if (getlocal())
			break;
		}
	    } else if (buf[0] == 'j') {
		cpaddr->cp_sel = line << SEL_SHIFT;
		cpaddr->cp_pr = PR_VAL;
		cpaddr->cp_acr = 1 << line;
		cpaddr->cp_ler = 1 << line;
		while (1) {
		    bc = 0;
		    for (p = strbuffer; p < &strbuffer[STRBUFFERSIZE];){
			if ((bc + STRLEN) > 0x8000)
				break;
			for (i = 0; i < STRLEN ; i++, bc++)
			    *p++ = string[i];
		    }
		    p = strbuffer;
		    printf("%d@%x\n",bc,p);
		    icpbuf.i_ma = (long) p;
		    icpbuf.i_cc = bc;
		    qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		    cpaddr->cp_bah = qbaddr>>16;
		    cpaddr->cp_bal = qbaddr;
		    cpaddr->cp_bc = bc;
		    cpaddr->cp_tcr = 1 << line;
		    DELAY(10000);
		    while (cpaddr->cp_tcr == 0)
			DELAY(10000);
		    if (getlocal()) {
			printf("\n");
			break;
		    }
		}
	    } else if (buf[0] == 'k') {
		cpaddr->cp_sel = line << SEL_SHIFT;
		cpaddr->cp_pr = PR_VAL;
		cpaddr->cp_acr = 1 << line;
		cpaddr->cp_ler = 1 << line;

loop:		printf("\n   Hit return to recieve ... ");
		stripwhite(gets(buf));
		if (buf[0])
		    continue;

		sp = &silo[0];
		*sp = 0;
		icpbuf.i_ma = (long) sp;
		icpbuf.i_cc = 50;
		qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		cpaddr->cp_sel = SEL_SILO;
		cpaddr->cp_bah = qbaddr>>16;
		cpaddr->cp_bal = qbaddr;
		cpaddr->cp_bc = 50;		/* 24 characters + null!! */
		cpaddr->cp_pr = (2 << 8) | 1;	/* fill level | age time */
		cpaddr->cp_sr = SSR_SD;

		/* wait for silo interrupt to be posted */
		while (1) {
		    if (getlocal())
			break;
		    if (cpaddr->cp_isr & ISR_SI) {
			if ((cpaddr->cp_sr & SSR_SDD) == 0)
			    printf("ERROR: SI without SDD\n");
			break;
		    }
		    DELAY(1000);
		}

		p = &buf[0];
		while ((c = *sp++) & SWR_VDP)
			*p++ = c & 0xFF;
		*p++ = 0;

		if (strlen(buf)) {
		    printf("%s", buf);	/* echo on console */
		    cpaddr->cp_sel = line << SEL_SHIFT;
		    icpbuf.i_ma = (long) buf;
		    icpbuf.i_cc = strlen(buf);
		    qbaddr = VDMA_STD(qbsetup(&icpbuf, 0),vbnum);
		    cpaddr->cp_bah = qbaddr>>16;
		    cpaddr->cp_bal = qbaddr;
		    cpaddr->cp_bc = strlen(buf);
		    cpaddr->cp_tcr = 1 << line;
		    DELAY(1000);
		    while (cpaddr->cp_tcr == 0)
			DELAY(1000);
		}
		goto loop;
	    } else if (buf[0] == 'l') {
		verbose ^= 1;
		printf("Verbose mode %s\n", verbose ? "on" : "off");
	    } else
		goto menu;
	    printf("\n");
	}
}
