/*	gt.c	1.1	87/12/15	*/

/*
 * scsi tape driver
 */

#include "saio.h"
#include "sais68k.h"
#include "../dev/scsi.h"
#include "../dev/gsreg.h"

/*             _________________________________
 * i_unit:     | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *             ---------------------------------
 *             \__________/ \_____/ \_________/ 
 *                flags      cont      device
 */

#define NGT			4
#define NGT_DEV			8
#define GT_CTLR(unit)		(unit&0x1F)
#define GTF_SETBLKSZ		0x80
#define GTF_ISI			0x40
#define GTF_SWAB		0x20

#define GT_MAXRETRY		3
#define GT_MAXCNT		0x1FE00

#define GT_BLKCNT		1
#define GT_BYTCNT		2

#define GT_SRECS		0
#define GT_SFILES		0x10000

int			sadie_blocksize;
struct st 		gtst = { 512, -1, -1, -1, -1, NULL};
int			gt_bn;
int			gt_resid;
int			gt_blksz;
u_char			gt_opened;
u_char			gt_filemark;

int			gtstrat();

struct hacb_dcb		gt_dcb;
union scsi_sns		gt_sns;
struct scsi_inq		gt_inq;
struct scsi_msen	gt_msen;
struct scsi_msel	gt_msel;
struct scsi_blklim	gt_blklim;


struct	iob	cgtbuf;
union scsi_sns		*gt_sns_qbaddr;
struct scsi_inq		*gt_inq_qbaddr;
struct scsi_msen	*gt_msen_qbaddr;
struct scsi_msel	*gt_msel_qbaddr;
struct scsi_blklim	*gt_blklim_qbaddr;

gtopen(io)
	register struct iob *io;
{

/*printf("gtopen\n"); /**/
	if (gt_sns_qbaddr == NULL) {
		cgtbuf.i_ma = (long) &gt_sns;
		cgtbuf.i_cc = sizeof(gt_sns);
		gt_sns_qbaddr = (union scsi_sns *)VDMA_STD(qbsetup(&cgtbuf, 1),vbnum);

		cgtbuf.i_ma = (long) &gt_inq;
		cgtbuf.i_cc = sizeof(gt_inq);
		gt_inq_qbaddr = (struct scsi_inq *)VDMA_STD(qbsetup(&cgtbuf,1),vbnum);

		cgtbuf.i_ma = (long) &gt_msen;
		cgtbuf.i_cc = sizeof(gt_msen);
		gt_msen_qbaddr=(struct scsi_msen *)VDMA_STD(qbsetup(&cgtbuf,1),vbnum);

		cgtbuf.i_ma = (long) &gt_msel;
		cgtbuf.i_cc = sizeof(gt_msel);
		gt_msel_qbaddr=(struct scsi_msel *)VDMA_STD(qbsetup(&cgtbuf,1),vbnum);

		cgtbuf.i_ma = (long) &gt_blklim;
		cgtbuf.i_cc = sizeof(gt_blklim);
		gt_blklim_qbaddr=(struct scsi_blklim *)
				    VDMA_STD(qbsetup(&cgtbuf,1),vbnum);
	}

	if (gsopen(GT_CTLR(io->i_unit))) {
		printf("gt%d: controller not present\n",io->i_unit);
		return(-1);
	}

/*printf("do inq & rewind\n"); /**/
	if (gtinq(io->i_unit) || gtrewind(io->i_unit))
		return(-1);
/*printf("done\n"); /**/
	if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
		if (gtspace(io->i_unit, io->i_boff, GT_SFILES))
			return(-1);
	gt_bn = 0;

/*printf("do size\n"); /**/
	if (gtsize(io->i_unit)) {
		return(-1);
	}
	gt_blksz = gtst.nbsec;
/*printf("done - read isisize\n"); /**/
	if (sadie_blocksize)
		gtst.nbsec = sadie_blocksize;
	else if (io->i_unit & GTF_ISI)
		if (gtreadisisize(io))
			return(-1);
#ifdef SETBLKSZ
	if (io->i_unit & GTF_SETBLKSZ) {
		gt_blksz = gtreadblksz(io->i_unit);
	}
#endif SETBLKSZ

/*printf("done - select mode\n"); /**/
	if ((io->i_boff == 0) || (io->i_flgs&F_BLKOFF))
	    if (gtslctmod(io->i_unit))
		return(-1);
	
	if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
		io->i_boff = 0;
	io->i_cc = 0;
	gt_opened = 1;
	io->i_st = gtst;
/*printf("open done\n"); /**/
	return (0);
}

gtclose(io)
	register struct iob *io;
{
	if (gt_opened) {
		gt_opened = 0;
		return(gtrewind(io->i_unit));
	}
	return (-1);
}

gtstrategy(io, func)
	register struct iob *io;
{
	int unit = io->i_unit;
	int bn = io->i_bn * (gtst.nbsec / gt_blksz);
	int bpart, bleft, cmd, dir, count;
	unsigned long qbaddr;

	if (bn != gt_bn)
		if (unit & GTF_ISI) {
/*printf("do isispace\n"); /**/
			if (gtisispace(unit, bn - gt_bn)) {
				printf("gt%d: bad seek\n", unit);
				return (-1);
			}
		} else {
/*printf("do space\n"); /**/
			if (gtspace(unit, bn - gt_bn, GT_SRECS)) {
				printf("gt%d: bad seek\n", unit);
				return (-1);
			}
		}
	gt_bn = bn;
	if (func == READ) {
		cmd = CMD_READ;
		dir = DCB_DIR_IN;
	} else {
		cmd = CMD_WRITE;
		dir = DCB_DIR_OUT;
		printf("gt%d: can`t write\n", unit);
		return (-1);
	}

	bleft = io->i_cc;
	do {
		bpart = (bleft < GT_MAXCNT) ? bleft+(bleft&1) : GT_MAXCNT;
/*printf("do header if isi\n"); /**/
		if (unit & GTF_ISI)
			if ((bpart = gtisiheader(unit, GT_BYTCNT)) < 0)
				return(-1);
		count = (bpart + gt_blksz - 1) / gt_blksz;
		gt_resid = count;
		qbaddr = qbsetup(io, 0);
		SET_CDB_0(&gt_dcb.dcb_cdb, cmd, 0,
			((count>>8)&0xFFFF) | 0x10000, count & 0xFF, 0, 0);
		SET_DCB(&gt_dcb, DCB_NOIE, dir,
			(unit & GTF_SWAB) ? DCB_SW : DCB_NOSW, DCB_NODISC,
			sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
			qbaddr, bpart, gt_blksz);
/*printf("do read/write\n"); /**/
		if (gtcommand(unit, &gt_dcb))
			return(-1);
		bpart -= (gt_resid * gt_blksz);
		io->i_ma += bpart;
		bleft -= bpart;
		gt_bn += count;
		if (gt_filemark) {
			gt_filemark = 0;
			return (io->i_cc - bleft);
		}
	} while (bleft > 0);
	return (io->i_cc);
}

gtinq(unit)
{
	/* do an inquiry command and find out what kind of device it is */
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_INQUIRY, 0, 0, sizeof(gt_inq), 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, 
	paddr(gt_inq_qbaddr), sizeof (gt_inq), 1);
/*printf("do inq-real\n"); /**/
	if (gtcommand(unit, &gt_dcb)) {
		return (-1);
	}
	if (gt_inq.inq_pdtype != INQ_PDT_TAPE) {
		printf("gt%d: not a tape\n", unit);
		return (-1);
	}

	/* see if it is ready 
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_TESTREADY, 0, 0, 0, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_NO, 0, DCB_NODISC,
		sizeof (struct cdb_0), 0, 0, 0, 0, 0, 0);
	if (gtcommand(unit, &gt_dcb))
		return (-1);
	*/

	return (0);
}

gtrewind(unit)
{
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_REZERO, 0, 0, 0, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_NO, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,0,0,1);
	if (gtcommand(unit, &gt_dcb)) {
		printf("gt%d: rewind failed\n",unit);
		return(-1);
	}
	return(0);
}

gtspace(unit,count,rec_fil)
{
	u_int	lba = (((u_int )count >> 8) & 0xFFFF) | (u_int )rec_fil;
	u_int	bc  = (u_int )count & 0xFF;

	/* space forward/backward 'count' records/files */
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_SPACE, 0,
	    lba, bc, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_NO, 0, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, 0, 0, 1);
	if (gtcommand(unit, &gt_dcb)) {
		printf("gt%d: space failed\n", unit);
		return (-1);
	}
	return (0);
}

gtsize(unit)
{
	/* get current block size information */
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_MSENSE, 0, 0, sizeof(gt_msen), 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(gt_msen_qbaddr), sizeof(gt_msen), 1);
	if (gtcommand(unit, &gt_dcb)) {
		printf("gt%d: mode sense failed\n", unit);
		return (-1);
	}
	gtst.nbsec = SCSI_HML(gt_msen.msen_bd.bd_bl);

	/* get block limits information */
	bzero(&gt_blklim, sizeof(struct scsi_blklim));
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_BLKLIM, 0, 0, 0, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(gt_blklim_qbaddr), sizeof(gt_blklim), 1);
	if (gtcommand(unit, &gt_dcb))
		printf("gt%d: blocklimits failed\n", unit);

	return(0);
}

gtslctmod(unit)
{
	/* select buffering mode (if possible) */
	/* also select block size (if needed and possible) */
	gt_msen.msen_len = 0;
	gt_msen.msen_mtype = 0;
	gt_msen.msen_wprot = 0;
	gt_msen.msen_rsvd = 0x10; /* use buffered mode */
	gt_msen.msen_bdl = 8;
	gt_msen.msen_bd.bd_density = 0;
	SCSI_HML_SET(gt_msen.msen_bd.bd_nb, 0);
	SCSI_HML_SET(gt_msen.msen_bd.bd_bl, gt_blksz);
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_MSELECT, 0, 0, 12, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(gt_msen_qbaddr), 12, 1);
	if (gtcommand(unit, &gt_dcb))
		printf("Mode Select Failed - Ignored\n");
	
	return(0);
}

gtcommand(unit, dcb)
	register struct hacb_dcb	*dcb;
{
	register struct hacb_dcb	*dp = gsgetdcb(GT_CTLR(unit));
	int				count = 0;

	while (1) {
	    bcopy(dcb, dp, sizeof(struct hacb_dcb));
	    switch (gtissue(unit,dp)) {
		case  SNS_7_KEY_NO_SENSE:
		case  SNS_7_KEY_RECOVERED:
				return (0);		/* ok */
		case  SNS_7_KEY_ABORT_CMD:
		case  SNS_7_KEY_UNIT_ATTN:
				if (++count == GT_MAXRETRY)
					return (-1);	/* hard error */
				else
					continue;	/* retry */
		case  -(SCSI_STATUS_BUSY):
					continue;	/* retry forever */
		default:
				return (-1);		/* hard error */
	    }
	}
}

gtissue(unit, dcb)
	register struct hacb_dcb	*dcb;
{
	register int nsense = 0;
#define	SHHHH(x)	(x)

	if (gspoll(GT_CTLR(unit), 10000000)) {
		return (-1);
	}
	if (dcb->dcb_err == 0) {		/* return if no error */
		gt_resid = 0;
		return (0);
	}
	if ((dcb->dcb_scsi_status & SCSI_STATUS_CHECK) == 0) {
	    SHHHH(printf("gt%d: fatal error: cerr %x: scsi %b\n", unit,
		dcb->dcb_cerr, dcb->dcb_scsi_status,
		SCSI_STATUS_BITS));
	    return (-1);
	}
	if (dcb->dcb_scsi_status != SCSI_STATUS_CHECK)
		return(-(dcb->dcb_scsi_status));
	SET_CDB_0(&dcb->dcb_cdb, CMD_SENSE, 0, 0, sizeof (gt_sns), 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, 
	    paddr(gt_sns_qbaddr), sizeof (gt_sns), 1);
	do {
		dcb->dcb_err = 0;
		if (gspoll(GT_CTLR(unit), 8000)) {
		    SHHHH(printf("gt%d: SENSE timeout\n", unit));
		    return (-1);
		}
	} while (dcb->dcb_err && (nsense++ < 5));
	if (dcb->dcb_err) {
	    SHHHH(printf("gt%d: SENSE: fatal error: cerr %x: scsi %b\n", unit,
		dcb->dcb_cerr, dcb->dcb_scsi_status,
		SCSI_STATUS_BITS));
	    return (-1);
	}
	if (gt_sns.sns_7.sns_7_class != 7) {
	    SHHHH(printf("gt%d: invalid sense class %d\n", unit,
		gt_sns.sns_7.sns_7_class));
	    return (-1);
	}
	SHHHH(printf("gt%d: %s", unit,
	    ascii_sns_7_key[gt_sns.sns_7.sns_7_key]));
	if (gt_sns.sns_7.sns_7_valid) {
		gt_resid = SCSI_HMML(gt_sns.sns_7.sns_7_info);
	    SHHHH(printf(": resid=%d", SCSI_HMML(gt_sns.sns_7.sns_7_info)));
	}
	SHHHH(printf("\n"));
	if (gt_sns.sns_7.sns_7_eom) {
	    SHHHH(printf("gt%d: unexpected physical eot\n", unit));
		return(-1);
	}
	if (gt_sns.sns_7.sns_7_fil_mk)
		gt_filemark = 1;
	return (gt_sns.sns_7.sns_7_key);
}

gtreadisisize(io)
	register struct iob *io;
{
	int		unit = io->i_unit;

/*printf("gtreadisisize - gtisiheader\n"); /**/
	gtst.nbsec = gtisiheader(unit,GT_BYTCNT);
/*printf("gtreadisisize - gtspace\n"); /**/
	if (gtspace(unit, -1, GT_SRECS)) {
		printf("gt%d: reverse space not supported; rewinding...\n",unit);
		if (gtrewind(unit))
			return(-1);
		if (io->i_boff && (io->i_flgs&F_BLKOFF) == 0)
			if (gtspace(unit, io->i_boff, GT_SFILES))
				return(-1);
	}
}

gtisispace(unit, count)
{
	int	c, tb;

	if (count < 0)
		printf("gt%d: reverse space record not supported\n", unit);

	for (c = (count / (gtst.nbsec / gt_blksz)); c > 0; c--) {
		/* read a header block */
		tb = gtisiheader(unit, GT_BLKCNT);
		if (tb < 0)
			return(-1);
		if (tb == 0)
			return(0);
		/* space forward rest of record */
		if (gtspace(unit, tb, GT_SRECS))
			return(-1);
	}
	return(0);
}

gtisiheader(unit, retval)
{
	struct isihead	{
		u_short	ih_id;
		u_short	ih_fileno;
		u_short	ih_fileba;
		u_short	ih_blksz;
		u_short	ih_count;
		u_char	ih_pad[8182];
	}			gt_ih;
	unsigned long qbaddr;

	cgtbuf.i_ma = (long) &gt_ih;
	cgtbuf.i_cc = sizeof(gt_ih);
	qbaddr = VDMA_STD(qbsetup(&cgtbuf, 0),vbnum);

	gt_ih.ih_id = 0;
	/* read header block */
	SET_CDB_0(&gt_dcb.dcb_cdb, CMD_READ, 0, 0x10000, 1, 0, 0);
	SET_DCB(&gt_dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
		sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
		qbaddr, 10, gt_blksz);
/*printf("gtisiheader - read header\n"); /**/
	if (gtcommand(unit, &gt_dcb) || (gt_ih.ih_id != 0xA1FE))
		return(-1);
/*printf("gtisiheader - read header - done\n"); /**/
	if (retval == GT_BLKCNT)
		return(gt_ih.ih_count);
/*printf("gtisiheader - past return 1\n"); /**/
	if (retval == GT_BYTCNT)
		return(gt_ih.ih_blksz);
/*printf("gtisiheader - past return 2\n"); /**/
	return(-1);
}
