/*	standalone driver subroutines for gs.c	*/
#ifdef	M68030
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#else	M68030
#ifdef	M68020
#ifdef	QX
#define	GS_CPUMEMT	MEMT_16BIT
#else	QX
#define	GS_CPUMEMT	((((*BSR) & BSR_MEMWIDTH) == BSR_16BITMEM) \
				? MEMT_16BIT : MEMT_32BIT)
#endif	QX
#ifdef	M68025
#define	GS_ADDRMOD	(ADRM_EXT_N_D)
#else	M68025
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68025
#else	M68020
#define	GS_CPUMEMT	(MEMT_16BIT)
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68020
#endif	M68030

struct gs_scsiu_device *GS_scsiu_std[NGS] = {
		(struct gs_scsiu_device *)&vme_stdio[0xFFFFc0],
		(struct gs_scsiu_device *)&vme_stdio[0xFFFFd0],
		(struct gs_scsiu_device *)&vme_stdio[0xFFFFe0],
		(struct gs_scsiu_device *)&vme_stdio[0xFFFFf0]
};
int	gs_scsiu_poll();

struct  iob     cgsbuf;
struct gs_hacb *gs_qbaddr[NGS];

gs_scsiu_init(cont)
{
	struct gs_scsiu_device	*gsaddr = GS_scsiu_std[cont];
	struct gs_hacb		*hacb = &gs_hacb[cont];
	int	i;

	if (!probe(&gsaddr->gs_loc, &i))
		return (-1);
	for (i = 160000; gsaddr->gs_loc == 0xFFFF && i; i--)
		DELAY(200);
	if ((gsaddr->gs_loc & GS_LOC_ID_MASK) != GS_LOC_ID )
		return (-1);
        if (gs_qbaddr[cont] == NULL) {
                cgsbuf.i_ma = (long) &gs_hacb[cont];
                cgsbuf.i_cc = sizeof(struct gs_hacb);
                gs_qbaddr[cont] = (struct gs_hacb *)
                        (VDMA_STD(qbsetup(&cgsbuf, 1),vbnum));
        }

	bzero((char *)gs_qbaddr[cont], sizeof(struct gs_hacb));
	i = 160000;
	do {
        	gsaddr->gs_loc = GS_LOC_INIT;
		if (i-- == 0)
			return(-1);
	} while (gsaddr->gs_loc != GS_LOC_INIT_OK);

	/* addr modifier/interrupt vector, addr of host adaptor control block */
	gsaddr->gs_loc = 0;
	gsaddr->gs_loc = paddr(gs_qbaddr[cont]) >> 16;
	gsaddr->gs_loc = paddr(gs_qbaddr[cont]);
	for (i = 160000; gsaddr->gs_loc == 0xFFFF && i; i--)
		DELAY(200);
	if ((gsaddr->gs_loc & GS_LOC_ID_MASK) != GS_LOC_ID )
		return (-1);
	gs_poll[cont] = gs_scsiu_poll;
	return(0);
}

gs_scsiu_poll(ctlr, time)
{
	int			cont  = GS_CONT(ctlr);
	int			targ  = GS_TARG(ctlr);
	struct gs_scsiu_device	*gsaddr = GS_scsiu_std[cont];
	struct gs_hacb		*hacb = &gs_hacb[cont];
	long			i;

	i = 160000;
#ifdef DEBUG
	gsprintdcb(cont, targ);
#endif DEBUG
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
		if (i-- == 0) {
			printf("gs%d: semaphore 1 timeout\n", cont);
			return (-1);
		}
	} while (hacb->hacb_semhadpt);

	hacb->hacb_dcr |= (DCR_GO << targ);
	hacb->hacb_semhost = 0;
	gsaddr->gs_loc = GS_LOC_GO;
	for (; hacb->hacb_dcr & (DCR_GO << targ); time--) {
		if (time == 0) {
			printf("gs%d: controller timed out\n", cont);
			return (-1);
		}
		DELAY(400);
	}

	i = 160000;
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
		if (i-- == 0) {
			printf("gs%d: semaphore 2 timeout\n", cont);
			return (-1);
		}
	} while (hacb->hacb_semhadpt);
	hacb->hacb_dcr &= ~(DCR_BUSY << targ);
	hacb->hacb_semhost = 0;
#ifdef DEBUG
	gsprintdcb(cont, targ);
#endif DEBUG
	return (0);
}
