/*	standalone INTERPHASE driver subroutines for gs.c	*/

#define BZERO_INTER(ap, len)	{ register char *p = (char *)(ap);	\
				  register u_int l = (u_int )(len);	\
				  while (l--) *p++ = 0; }

#define	GS_DMA_BURST		32
#define	GS_INTER_SEL_TIMO	400
#define	GS_INTER_DISC_TIMO	0
#define	GS_VME_TIMO		0
#define	GS_OWN_ID		7

int			gs_inter_memt;
struct inter_sgl	gs_sgl;
u_int			gs_sgl_vdma;
struct	iob		gs_inter_cbuf;
u_long			gs_inter_null;

#define INTER_OFFSET(add)	(char *)((u_long )(add) - (u_long)(gsaddr))

struct gs_inter_device *GS_inter_std[NGS] = {
		(struct gs_inter_device *)&vme_short[0x3000],
		(struct gs_inter_device *)&vme_short[0x3800],
		(struct gs_inter_device *)&vme_short[0x4000],
		(struct gs_inter_device *)&vme_short[0x4800]
};

int	gs_inter_poll();

gs_inter_init(cont)
{
	struct gs_inter_device		*gsaddr = GS_inter_std[cont];
	struct inter_cib		*cibp = &gsaddr->gs_hus.ih_cib;
	struct inter_iopb		*iopb = &gsaddr->gs_hus.ih_iopb[0];
	int	l = 0;

	if (!probe(gsaddr->gs_cq, &l))
		return (-1);

	gsaddr->gs_mcsb.mcsb_mcr = GS_I_MCR_RES; 	/* reset board */
	DELAY(0x100);
	gsaddr->gs_mcsb.mcsb_mcr = 0; 			/* release reset */
	do { 
	    	if (l++ > 0x20000)
			return (-1);
	    	DELAY(0x1000);
	} while (gsaddr->gs_mcsb.mcsb_msr != GS_I_MSR_BOK);

	if (!gs_inter_memt)
#ifdef	M68020
		if (GS_CPUMEMW == BSR_16BITMEM)
			gs_inter_memt = GS_I_IOPB_MT_16;
		else
#endif	M68020
			gs_inter_memt = GS_I_IOPB_MT_32;

	/* initialize controller */
	BZERO_INTER(cibp, sizeof(struct inter_cib));
	cibp->ic_dma_burst = GS_DMA_BURST;
	cibp->ic_pri_busid = GS_OWN_ID;
	cibp->ic_sec_busid = GS_OWN_ID;
	cibp->ic_crb_off = (u_short )INTER_OFFSET(&gsaddr->gs_crb);
	cibp->ic_sel_timo_h = GS_INTER_SEL_TIMO >> 16;
	cibp->ic_sel_timo_l = GS_INTER_SEL_TIMO & 0xFFFF;
	cibp->ic_resel_timo_h = GS_INTER_DISC_TIMO >> 16;
	cibp->ic_resel_timo_l = GS_INTER_DISC_TIMO & 0xFFFF;
	cibp->ic_vme_timo_h = GS_VME_TIMO >> 16;
	cibp->ic_vme_timo_l = GS_VME_TIMO & 0xFFFF;
	BZERO_INTER(iopb, sizeof(struct inter_iopb));
	iopb->iopb_cmd = GS_I_IOPB_CMD_INIT_CTL;
	iopb->iopb_mem_type = GS_I_IOPB_MT_DP;
	iopb->iopb_address_l = (u_short )INTER_OFFSET(cibp);
	iopb->iopb_maxlen_l = sizeof(struct inter_cib);
	if (gs_inter_issue(gsaddr, 0xFF, IOPB_HEAD - 2, 0x2000) ||
	    gsaddr->gs_hus.ih_iopb->iopb_cerr)
		return(-1);
	if (gs_sgl_vdma == 0) {
		gs_inter_cbuf.i_ma = (long)&gs_sgl;
		gs_inter_cbuf.i_cc = sizeof (struct inter_sgl);
		gs_sgl_vdma = VDMA_STD(qbsetup(&gs_inter_cbuf, 1),vbnum);
	}

	bzero(&gs_hacb[cont], sizeof(struct gs_hacb));
	gs_poll[cont] = gs_inter_poll;
	return (0);
}

gs_inter_poll(ctlr, time)
{
	int			cont  = GS_CONT(ctlr);
	int			targ  = GS_TARG(ctlr);
	struct gs_inter_device	*gsaddr = GS_inter_std[cont];
	struct inter_iopb	*iopb = gsaddr->gs_hus.ih_iopb;
	struct hacb_dcb		*dcb = &gs_hacb[cont].hacb_dcb[targ];
	int			reslen;

	BZERO_INTER(iopb, sizeof(struct inter_iopb));
	iopb->iopb_cmd = GS_I_IOPB_CMD_PASS;
	if (dcb->dcb_dir == DCB_DIR_OUT)
		iopb->iopb_options |= GS_I_IOPB_OPT_DIR;
	if (dcb->dcb_dlen && (reslen = dcb->dcb_dlen % dcb->dcb_dbsz)) {
#ifdef SGL_IN_SHORTIO
		struct inter_sgl	*sgl = &gsaddr->gs_hus.ih_sgl[targ];

		iopb->iopb_mem_type = GS_I_IOPB_MT_DP;
		iopb->iopb_address_l = (u_long )INTER_OFFSET(sgl);
#else SGL_IN_SHORTIO
		struct inter_sgl	*sgl = &gs_sgl;

		iopb->iopb_mem_type = gs_inter_memt | GS_ADDRMOD;
		iopb->iopb_address_h = (u_long )gs_sgl_vdma >> 16;
		iopb->iopb_address_l = (u_long )gs_sgl_vdma & 0xFFFF;
#endif SGL_IN_SHORTIO
		iopb->iopb_options |= GS_I_IOPB_OPT_SG;
		iopb->iopb_maxlen_l = 2;
		sgl->is_el1_cnt = dcb->dcb_dlen;
		sgl->is_el1_add_h = (u_long )dcb->dcb_dadr >> 16;
		sgl->is_el1_add_l = (u_long )dcb->dcb_dadr & 0xFFFF;
		sgl->is_el1_mem = gs_inter_memt | GS_ADDRMOD;
		sgl->is_el2_cnt = dcb->dcb_dbsz - reslen;
		sgl->is_el2_add_h = (u_long )gs_inter_null >> 16;
		sgl->is_el2_add_l = (u_long )gs_inter_null & 0xFFFF;
		sgl->is_el2_mem = 
		    GS_I_IOPB_TT_NOINC | gs_inter_memt | GS_ADDRMOD;
	} else {
		iopb->iopb_mem_type = gs_inter_memt | GS_ADDRMOD;
		iopb->iopb_address_h = (u_long )dcb->dcb_dadr >> 16;
		iopb->iopb_address_l = (u_long )dcb->dcb_dadr & 0xFFFF;
		iopb->iopb_maxlen_h = dcb->dcb_dlen >> 16;
		iopb->iopb_maxlen_l = dcb->dcb_dlen & 0xFFFF;
	}
	iopb->iopb_unitadd = targ | (dcb->dcb_cdb.cdb_0.cdb_0_lun << 3);
	bcopy(&dcb->dcb_cdb, &iopb->iopb_cdb, dcb->dcb_cdblen);

	if (gs_inter_issue(gsaddr, targ, IOPB_HEAD + dcb->dcb_cdblen, time))
		return(-1);
	if (iopb->iopb_cerr != 0x34) {
		dcb->dcb_scsi_status = iopb->iopb_scsi_status;
		dcb->dcb_cerr = iopb->iopb_cerr;
	}
	return(0);
}

gs_inter_issue(gsaddr, targ, iopblen, time)
	struct gs_inter_device	*gsaddr;
{
	struct inter_cqe		*mcep = &gsaddr->gs_mce;
	struct inter_crb		*crbp = &gsaddr->gs_crb;
	struct inter_iopb		*cio = &gsaddr->gs_crb.crb_iopb;
	struct inter_iopb		*iopb = gsaddr->gs_hus.ih_iopb;
	int				l = 0;

	BZERO_INTER(mcep, sizeof(struct inter_cqe));
	mcep->cqe_iopblen = iopblen;
	mcep->cqe_iopblen = iopblen;
	mcep->cqe_tag_l = targ;
	mcep->cqe_tag_h = (u_short )INTER_OFFSET(iopb);
	mcep->cqe_iopbadd = mcep->cqe_tag_h;
	mcep->cqe_qecr = GS_I_CQE_QECR_GO;

	while (!(crbp->crb_crsw & GS_I_CRB_CRSW_CRBV)) {
	    	if (l++ > time)
			return (-1);
	    	DELAY(0x1000);
	} 
	if (!(crbp->crb_crsw & GS_I_CRB_CRSW_CC) ||
	    !(crbp->crb_crsw & GS_I_CRB_CRSW_CRBV))
		return(-1);
	if (crbp->crb_tag_l != targ) {
		crbp->crb_crsw = 0;
		return(-1);
	}
	if (crbp->crb_crsw & (GS_I_CRB_CRSW_ERR | GS_I_CRB_CRSW_EXC)) {
		iopb->iopb_scsi_status = cio->iopb_scsi_status;
		iopb->iopb_cerr = cio->iopb_cerr;
	}
	crbp->crb_crsw = 0;
	return (0);
}
