/*	standalone driver subroutines for gs.c	*/

#define	GS_GEN_OPT		(CIPR_PB_OPT_PAR | CIPR_PB_OPT_DIS)
#define	GS_THROTTLE_TYPE	(CIPR_THR_TRANS)
#define	GS_THROTTLE_CNT		32
#define	GS_OWN_ID		7
#define GS_DISC_TIMO		0x0
#define GS_SEL_TIMO		0x180 << 16
#define GS_RETRY_CTL		0x10 << 8	/* retry scsi bus errs */
#define GS_RETRY_LIM		0x02
#define GS_UNIT_FLAGS		0x02

struct gs_cipr_device *GS_cipr_std[NGS] = {
		(struct gs_cipr_device *)&vme_short[0x2000],
		(struct gs_cipr_device *)&vme_short[0x2200],
		(struct gs_cipr_device *)&vme_short[0x2400],
		(struct gs_cipr_device *)&vme_short[0x2600]
};
int	gs_cipr_poll();
struct gs_type0	gs_t0pb[NGS];	/* ciprico type 0 parameter blocks */
u_int gs_t0_vdma[NGS];
struct  iob  gs_cipr_cbuf;
u_int	gs_cipr_memt;

gs_cipr_init(cont)
{
	struct gs_cipr_device	*gsaddr = GS_cipr_std[cont];
	struct gs_type0		*t0 = &gs_t0pb[cont];
	struct cipr_pb		*pbp = (struct cipr_pb *)&t0->t0_pb;
	int	l;

	if (!probe(gsaddr->gs_status, &l))
		return (-1);
/*printf("do reset..");	/**/
	gsaddr->gs_reset[0] = 0; /* reset board */
	l = 0;
	while (!(gsaddr->gs_status[0] & GS_CIPR_RDY) && ++l < 0x800000)
		DELAY(8000);
	if (!(gsaddr->gs_status[0] & GS_CIPR_RDY))
		return(-1);
/*printf("done\n");	/**/
	bzero(&gs_hacb[cont], sizeof(struct gs_hacb));
	if (!gs_cipr_memt)
#ifdef	M68020
		if (GS_CPUMEMW == BSR_16BITMEM)
			gs_cipr_memt = GS_CIPR_MEMT_16BIT | GS_ADDRMOD;
		else
#endif	M68020
			gs_cipr_memt = GS_CIPR_MEMT_32BIT | GS_ADDRMOD;

        if (gs_t0_vdma[cont] == 0) {
                gs_cipr_cbuf.i_ma = (long)t0;
                gs_cipr_cbuf.i_cc = sizeof (struct gs_type0);
                gs_t0_vdma[cont] = VDMA_STD(qbsetup(&gs_cipr_cbuf, 1),vbnum);
        }


	/* give general options command; set options */
	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_cdb[0] = 0x07;	/* general options command */
	pbp->pb_targ = 0xFF;	/* command to controller */
	pbp->pb_rsvd = GS_GEN_OPT;
	pbp->pb_flags = GS_THROTTLE_TYPE | GS_THROTTLE_CNT;
	pbp->pb_addmod = GS_OWN_ID;
/*printf("do general options...");	/**/
	gs_cipr_issue(gsaddr, t0, gs_t0_vdma[cont], 0x800000);
/*printf("done\n");	/**/

	/* do unit options command on all 8 targets */
	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_cdb[0] = 0x08;	/* unit options command */
	pbp->pb_targ = 0xFF;	/* command to controller */
	pbp->pb_rsvd = GS_DISC_TIMO >> 8;
	pbp->pb_flags = GS_DISC_TIMO;
	pbp->pb_datadr = GS_SEL_TIMO | GS_RETRY_CTL | GS_RETRY_LIM;
	pbp->pb_datlen = GS_UNIT_FLAGS;
	while (pbp->pb_addmod < 8) {
/*printf("do unit %d options...", pbp->pb_addmod);	/**/
		gs_cipr_issue(gsaddr, t0, gs_t0_vdma[cont], 0x800000);
/*printf("done\n");	/**/
		pbp->pb_addmod++;
	}

	gs_poll[cont] = gs_cipr_poll;
	return (0);
}

gs_cipr_poll(ctlr, time)
{
	int			cont  = GS_CONT(ctlr);
	int			targ  = GS_TARG(ctlr);
	struct gs_cipr_device	*gsaddr = GS_cipr_std[cont];
	struct gs_type0		*t0 = &gs_t0pb[cont];
	struct cipr_pb		*pbp = (struct cipr_pb *)&t0->t0_pb;
	struct cipr_sb		*sbp = (struct cipr_sb *)&t0->t0_sb;
	struct hacb_dcb		*dcb = &gs_hacb[cont].hacb_dcb[targ];
	int			reslen;

	bzero(t0, sizeof(struct gs_type0));
	pbp->pb_flags = CIPR_PB_FL_STD |
		(dcb->dcb_dlen ? CIPR_PB_FL_DAT : 0) |
		((dcb->dcb_dir == DCB_DIR_OUT) ? CIPR_PB_FL_DIR : 0);
	pbp->pb_addmod = GS_ADDRMOD;
	pbp->pb_targ = targ;
	if (dcb->dcb_dlen && (reslen = dcb->dcb_dlen % dcb->dcb_dbsz))
		pbp->pb_datlen = dcb->dcb_dlen + dcb->dcb_dbsz - reslen;
	else
		pbp->pb_datlen = dcb->dcb_dlen;
	pbp->pb_datadr = (u_int )dcb->dcb_dadr;
	bcopy(&dcb->dcb_cdb, pbp->pb_cdb, dcb->dcb_cdblen);
/*printf("doing upper cmd...");	/**/
	if (gs_cipr_issue(gsaddr, t0, gs_t0_vdma[cont], time))
		return(-1);
/*printf("done\n");	/**/
	if (sbp->sb_flags & CIPR_SB_FL_ERR) {
		dcb->dcb_scsi_status = sbp->sb_scsi_status;
		dcb->dcb_cerr = sbp->sb_cerr;
	}
	return(0);
}

gs_cipr_issue(gsaddr, t0, vdma, time)
	struct gs_cipr_device	*gsaddr;
	struct gs_type0		*t0;
{
	int			l = 0;

	gsaddr->gs_addbuf[0] = gs_cipr_memt;
	gsaddr->gs_addbuf[0] = paddr(vdma) >> 16;
	gsaddr->gs_addbuf[0] = paddr(vdma);
	gsaddr->gs_chatt[0] = CIPR_CHATT_T0;
	do {
		DELAY(8000);
	} while (!(t0->t0_sb.sb_flags & CIPR_SB_FL_CC) && ++l < time);
	if (gsaddr->gs_status[0] & 0x0010)
		printf("gs: memory transfer error\n");
	if (!(t0->t0_sb.sb_flags & CIPR_SB_FL_CC))
		return (-1);
	return (0);
}
