/*#define DEBUG*/
#define SCSIU
#define INTERPHASE	/**/
#define CIPRICO		/**/

#define	ASCII_SNS_7_KEY

#include "saio.h"
#include "sais68k.h"
#include "../dev/scsi.h"
#include "../dev/gsreg.h"

/*        _________________________________
 * ctlr:  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *        ---------------------------------
 *                 \_cont____/ \__targ___/
 */
#define	GS_CONT(ctlr)	(ctlr >> 3)
#define	GS_TARG(ctlr)	(ctlr & 0x7)

#define NGS		4

#ifdef	M68030
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#else	M68030
#ifdef	M68020
#ifdef	QX
#define	BSR_16BITMEM	0x10		/* stolen from board.V20.h */
#define	GS_CPUMEMW	(BSR_16BITMEM)
#else	QX
#define	GS_CPUMEMW	((*BSR) & BSR_MEMWIDTH)
#endif	QX
#ifdef	M68025
#define	GS_ADDRMOD	(ADRM_EXT_N_D)
#else	M68025
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68025
#else	M68020
#define	GS_CPUMEMW	(BSR_16BITMEM)
#define	GS_ADDRMOD	(ADRM_STD_N_D)
#endif	M68020
#endif	M68030

int	(*gs_poll[NGS])();

struct gs_hacb	gs_hacb[NGS];	/* host adaptor control blocks */
gsopen(ctlr)
{
	int cont = GS_CONT(ctlr);

	if (cont >= NGS) {
		printf("gs%d: bad controller\n", cont);
		return (-1);
	}
	if (1
#ifdef SCSIU
	    && gs_scsiu_init(cont)
#endif SCSIU
#ifdef CIPRICO
	    && gs_cipr_init(cont)
#endif CIPRICO
#ifdef INTERPHASE
	    && gs_inter_init(cont)
#endif INTERPHASE
	    ) {
		printf("gs%d: init failed\n", cont);
		return (-1);
	}
	return (0);
}

gspoll(ctlr, time)
{
	int			cont  = GS_CONT(ctlr);

	(*gs_poll[cont])(ctlr, time);
}

struct hacb_dcb *gsgetdcb(ctlr)
{
	return (&gs_hacb[GS_CONT(ctlr)].hacb_dcb[GS_TARG(ctlr)]);
}

gsprint(p, s, l)
	register u_char *p, *s;
{
	register int i;

	printf("  %s: %d bytes @ %x\n", p, l, s);
	for (i = 0 ; i < l; i++)
		printf("    %2d: %2x\n", i, *s++);
}

#ifdef	DEBUG
gsprintdcb(cont, targ)
{
	register u_char *c = (u_char *)&gs_hacb[cont].hacb_dcb[targ]; 
	register int i, s;

/*
	s = spltty();
*/
	printf("\nDCB: cont %d targ %d lun %d:", cont, targ,
	    gs_hacb[cont].hacb_dcb[targ].dcb_cdb.cdb_0.cdb_0_lun);
	for (i = 0 ; i < sizeof(struct hacb_dcb); i++) {
		if ((i % 16) == 0)
			printf("\n  %2d:", i);
		printf(" %2x", *c++);
	}
	printf("\n");
/*
	printf("\nSpace to execute, 'q' to disable: ");
	while ((i = cngetc()) == -1)
		;
	if (i == 'q')
		gsdebug = 0;
	splx(s);
*/
}
#endif	DEBUG

#ifdef CIPRICO
#include "gs_cipr.c"
#endif CIPRICO

#ifdef INTERPHASE
#include "gs_inter.c"
#endif INTERPHASE

#ifdef SCSIU
#include "gs_scsiu.c"
#endif SCSIU
