
.TL
Color Graphics Display Controller
Specification
.AI
Integrated Solutions
2240 Lundy Ave.
San Jose, Ca.
.AE
.DA
.NH
Scope
.PP
This document describes the Integrated Solutions VME COLOR graphics
display subsystem.
The text provided in  this manual includes a product overview,
specifications, configurations information and programming
information.
.NH
Introduction
.PP
The graphics display system consists of a graphics display
controller which contains the video logic to generate the
display as well as a microcoded graphics processor to
perform graphics primitives.
A separate display memory card is used to store four planes of
pixel information and is connected to the controller over a private bus.
.PP
A writable control store daughter board is available as an
option which enables the user to develope their own microcode.
This board attaches physically to the graphics display controller
card.
.NH
Display Controller Architecture
.PP
The Display Controller consists of two sections for image
generation and refresh. The image generation section 
consists of a AMD 29116 Microcoded ALU that
resides on the VME bus as a slave co-processing function.
The other section provides all the video timing signals
and serialization of the Video data received from the Display 
Memory.
It also arbitrates access to the Display Memory between the
VME bus and the image generator.
.NH 2
Graphics Processor
.PP
The Graphics Processor is a microcoded 16 bit
ALU with two address generators for display
image memory, and up to 2K 64 bit words of microcode memory. Commands and
operands are supplied to the image generator through a 64 word
deep FIFO. Commands are processed through a microcode look-up table 
which
supplies microroutine starting addresses to the graphics processor sequencer.
The processor operates on a high speed internal bus designated the "PD"
bus which allows it to communicate to the Display Memory and other
peripherals under microcode control.
The sequencer executes
commands through a collection of microcoded routines which have been
programmed in the microcode memory. 
Some of the features of the ALU include the ability to execute all instructions
in one 100 ns microcycle.
The ALU also has a 16 bit barrel shifter which enables the controller to
rotate a word by any amount and merge it with another in one microcycle.
.NH 2
Display Refresh Subsystem
.PP
The Display Refresh Subsystem contains the Memory Access Manager
and the Video Interface sections. The Memory Access Manager
arbitrates access priority to the display image memory
between the video interface and the external port. 
The Video Interface generates all video timing signals and
converts pixels into a RGB RS343 signal.
Since a pixel is 4 bits, up to 16 out of a pallette of 4096 colors
are displayable simultaneously.
.NH 2
Memory Access Manager
.PP
The Memory Access Manager section of the display refresh board
arbitrates the access and generates the basic timing signals for
the display image memory. The basic memory cycle is 593 nsec with
access divided equally between the display refresh and external
access within the cycle.
This memory interleaving allows an external source to have
access to the display image memory during the display refresh period.
External access is asynchronous with the display refresh with access
times varying between 296 nsec and 593 nsec.
.NH 2
Display Image Memory
.PP
The memory consists of 4 separate planes of memory, each plane containing
64K x 32 bits of storage.  Each plane has separate data paths for the
refresh and external data, each completely asynchronous from each other.
This means that refresh video data can be output at the same time the
graphics processor is updating the memory.  The refresh output simply
goes to a 8:1 multiplexer which returns to the video refresh circuitry
of the GIP board to be demultiplexed into the video shift register.
.NH 2
VME Access
.PP
The Color Display Memory is organized on a per plane basis.
When reading or writing the display memory from the VME bus,
only one plane may be accessed at any one time.
Since a pixel in a color system is defined as 4 bits, with each bit
assigned to a memory plane, four accesses are required to completely
change a pixel.  The width of the accessed word may be either 16 or
32 bits (sub-pixels).  Byte access is not supported.
.NH
Specifications
.NH 2
Video Interface Timing
.PP
Below are specification for the timing signals sent to the
video monitor.
.TS
tab (/) allbox;
l l l .
Description/Monochrome/Color
Screen Format/1280 x 1024/1280 x 1024 x 4
Vertical Frame/15.87 ms (63.0 Hz)/16.58 ms (60.3 Hz)
Vertical Blanking/682.3 us/502.5 us
Vertical Front Porch/0.0 us/0.0 us
Vertical Sync/237.3 us/251.3 us
Vertical Back Porch/445.0 us/251.3 us
Horizontal Scan/14.833 us (67.4 Khz)/15.704 us (63.7 Khz)
Horizontal Blank/3.845 us/3.852 us
Horizontal Front Porch/0.824 us/0.148 us
Horizontal Sync/1.099 us/1.185 us
Horizontal Back Porch/1.923 us/2.519 us
Pixel Cell Time/8.6 nsec (116.5 Mhz)/9.3 nsec (108.0 Mhz)
Monitor Interface/TTL hsync, vsync & ECL video/RS-343 composite RGB video
Screen Refresh/Non-interlaced/Non-interlaced
.TE
.NH 2
Physical, Power and Environmental  Specifications
.PP
The Display Controller and the Display Memory is packaged on
160 X 233 mm dual wide VME cards.
.PP
Power Requirements
.TS
tab (/) allbox;
l l l .
Display Controller/+5 volts/8 amps
/-5.2 volts/2.5 amps
Display Memory/+5 volts/3.5 amps
.TE
.PP
Environmental
.TS
tab (/) allbox;
l l l .
/Operating/Storage
Ambient Temperature/60 degrees C max/120 degrees C max
Humidity/80 % relative/80 % relative
.TE
.NH
Configuration
.NH 2
Address Map
.PP
The display memory base addresses of the graphics controller 
is relocatable to any address
from 700000 to e00000 hex in increments of 1 Mb.  This is done by opening or
closing jumpers E1 to E6 that feeds the Base address comparator PAL20L2 
at location 2vw. Base Address 1 determines the base address of the display
memory while the Base Address 2 determines the address of the control
registers.
The table below specifies what address range is assigned
to various jumper configurations.
.sp
.TS
tab (/) allbox;
l l l c c .
E5-E6/E3-E4/E1-E2/Base Address 1 (hex)/Base Address 2 (hex)
In/In/In/700000/fe0000
In/In/Out/800000/fe4000
In/Out/In/900000/fe8000
In/Out/Out/a00000/fec000
Out/In/In/b00000/ff0000
Out/In/Out/c00000/ff4000
Out/Out/In/d00000/ff8000
Out/Out/Out/e00000/ffc000
.TE
.PP
The address modifier bits that the image processor will respond to is 
determined by the programming in the PAL20L2 at location 2vw. 
The default value that the board will respond to is standard
addressing  with AM5, AM4 and AM3 are high,
and Supervisory Program access with AM2, AM1 high and AM0 low.
.NH 2
Control Register Addresses
.PP
The table below lists the addresses of the control registers.
The writable control store, snake shift and snake registers are
active only when the writable control store option is installed.
(See the Writable Control Section)
.TS
tab (/) allbox;
l l .
FIFO/Base Address 2
Snake Register/Base Address 2 + 0002 hex
Snake Shift/Base Address 2 + 0004 hex
Reset Microcode/Base Address 2 + 0006 hex
4K Writable Control Store/Base Address 2 + 1000 hex
.TE
.NH 2
Interrupts
.PP
The interrupt request level and interrupt vector is set by jumpers
E7 - E10 and E17 - E30.  The graphics board has the ability to request
interrupts on levels 4 through 6 and send interrupt vector numbers
128 through 255.  The table below details the jumper settings.
.TS
tab (/) allbox;
l l l .
E9-E10/E8-E7/Interrupt Level
In/In/undefined
In/Out/4
Out/In/5
Out/Out/6
.TE
.PP
For the interrupt vectors, 7 pairs of jumpers set whether or not each of
the lower 7 bits in a vector byte returned to the host is set or not.
The highest bit is always set high. Jumper pair E17-E18 corresponds to
bit 0 and goes up to jumper pair E29-E30 which defines bit 6.  If the
jumper pair is shorted, that bit is set to 0.  For example, to send
vector 128 to the host, all 7 sets of jumpers should be shorted.
.sp
.NH
Software Interface
.NH 2
Display Memory
.PP
Display Memory is a shared resource between the Graphics Processor and the VME
bus.  The host processor may access the Display Memory from the VME bus
anytime that the Graphics Processor is in a idle loop waiting to receive
commands from the Host.  Once the Graphics Processor receives a command,
accesses from the VME bus are no longer recognized.
Any attempt at display memory access during this time will result in a
time out bus error since DTACK will not be asserted.
Only longword and word accesses are supported.
.NH 2
FIFO register
.PP
This register is used by the host to write graphics commands
and parameters to the
Graphics processor.  
All reading and writing must be word accesses.
Unlike the Display Memory, the FIFO may be accessed at anytime.
The FIFO has a capacity of 64 words.
.PP
The user may obtain the status of the FIFO by performing a read
at this location. Bit 7 signifies if the FIFO is completely empty.
If bit 0 is a 1, the FIFO is empty and VME accesses may be performed.
Before attempting VME accesses,
it is recommended that the last command to the microcode processor
be one that takes a known short time to execute. (i.e. interrupt_off)
Since the VME bus turns on only when the microcode is finished, using
a long command such as boxc results in unpredictable access.
.NH 2
Reset Register
.PP
The graphics board has a special address location called RESET which when
written to with any data will perform an internal reset of the microcode.
Doing this is exactly the same as issuing a INIT microcode instruction.
.NH 2
Writable Control Store Option
.PP
The image processor can be optionally equipped with a
writable control store daughter board which allows the user to
download new microcode without burning a set of PROM's.
.PP
This board has a 4K microcode capacity which is double the capacity of the
Graphics board.  
It consists of 2K of writable RAM and 2K of PROM.
This daughter board interfaces to the Graphics Controller
board through the PROM sockets on the controller card.  Hence, no microcode
is stored on the graphics controller card when this option is in place.
.PP
In addition to the pipeline registers that are connected to the data
outputs of the control store, an additional duplicate set of registers
(called "shadow registers" are provided to enable access to the 
control store from the VME bus.  These
registers are all connected together in a serial loop called the "snake".
In this loop is also a 16 bit register called the snake register that
interfaces the "snake" loop to the VME bus.
.PP
When this board is installed, several new registers become active.
These registers control the loading operation of the control store.
.NH 3
Snake Register
.PP
This is a 16 bit register that acts as a window into the control
store from the VME bus.  All microcode that is loaded into the
RAM's pass through this register.
.PP
To write into the control store
the user must first load the snake register and then shift the data
into the right place.  Because the width of all the shadow registers is
64 bits wide, the user must load and shift the snake register 4 times before
a write can be performed to the control store.
.PP
For example, suppose a user wishes to write a location in the control
store.  Assume that the user already has 8 bytes of data ready for
writing.  The sequence will be:
.IP 1)
Load the snake register with the first word of data.
.IP 2)
Read location Snake Shift (Base Address 2 + 2002 hex) which will cause the
data to be shifted out 1 bit.  Since there are 16 bits in the
snake register, repeat this step 16 times. The Snake register
is now ready to accept more data.
.IP 3)
Load the next word of data, and repeat steps 2 and 3 for a
total of 4 times until all 64 bits of data has been placed
in position.
.IP 4)
Write to the location of interest in the control store.  The data
in the shadow register will be transfered into the control store.
Remember that A0 gets translated into DS0 and DS1 which is not used
by the snake register in determining the control store address.  For
example, to write constrol store location 1024 decimal, you must write
to VME address of (Base2 + 1000 + 800) hex.
.PP
To read a location in the control store the above procedure is basically 
reversed.
.NH 2
Display Memory Address Map
.PP
The color display memory base addresses of the graphics controller 
is relocatable to any address
from 700000 to e00000 hex in increments of 1 Mb.  
From the point of view of the host processor, the display memory appears
as a linear set of addresses ranging from the base address to base address
+ ffffe hex for four memory planes.  However, the display memory
appears as a two dimensional image on the screen, not all of which
are visible.  The table below lists the addresses of the display memory
planes with respect to the VME address space
and the graphics processor address
space.  They are different because the graphics processor deals only with
32 bit words.
.TS
tab (/) allbox;
l l l l .
Display Memory Region/VME start address/GP start address/Memory Size
Plane 0/Base Address 1/0 hex/160 Kbytes
Undisplayed Plane 0/Base Address 1 + 28000 hex/a000 hex/96 Kbytes
Plane 1/Base Address 1 + 40000/10000 hex/160 Kbytes
Undisplayed Plane 1/Base Address 1 + 68000 hex/1a000 hex/96 Kbytes
Plane 2/Base Address 1 + 80000/20000 hex/160 Kbytes
Undisplayed Plane 2/Base Address 1 + A8000 hex/2a000 hex/96 Kbytes
Plane 3/Base Address 1 + C0000/30000 hex/160 Kbytes
Undisplayed Plane 3/Base Address 1 + E8000 hex/3a000 hex/96 Kbytes
Total///1024 Kbytes
.TE
.PP
Mapping from linear address space to the two dimensional screen address
space requires the user to know the pitch.  Pitch is defined as the offset
between adjacent vertical words on the screen.  Since the display resolution
is fixed at 1280 horizontal pixels, this means that the pitch is 40 if the
addressing increment is a longword (32 bits).
For example, the upper left hand corner of the screen
being location 0, the address of the word vertically underneath that word
would have the graphics processor display address of 40 decimal.
.NH 2
Microcode Instruction Set
.PP
The microcode instruction set has been designed to be optimally used
by the Window Manager to operate with the
color monitor.
.PP
All address pointers (such as "mask", "src" or "dest") describe 32 bit
word locations in the display memory.
Because 16 bits (the size of the
input paramers) are not large enough
to describe all the monochrome memory that are available, 
they were split into higher
and lower address parameters labled "xxx_h" and "xxx_l".  
Unlike the monochrome system, the color does not have a second displayable
page.  
The higher address parameter therefore has no meaning, but has been retained
for compatibility with the monochrome system.
Any value placed in the higher parameter will be ignored.
.PP
The parameters are checked for validity when the command is processed
by the micrcode.
Parameters x, y, w and h must be beteen 0 and the respective maximum
screen size.
If any of the parameters are invalid, that command is ignored.  Any
invalid commands are also ignored.
.sp
.LP
.B
alu_clear, alu_set, alu_toggle
.R
.IP
The image processor is configured to perform logical operations
when filling is taking place.
Once one of these commands are issued, the mode selected remains in
effect until another alu mode command.
The modes supported are Clear and Set.
Performing an alu_clear has the same effect as set_color(0), while
alu_set is the sames as set_color(15).  alu_toggle has no effect
but is there to retain command compatibility with the monochrome system.
.sp
.LP
.B
box (dest_h, dest_l, x, y, w, h)
.R
.IP
Draws a filled box of width "w" and height "h"
with the upper left corner at (x, y).
The "dest_hl" pointer defines where in the display memory 
the origin point (0,0) is.  Dest_l set to 0
will define the origin point to the upper left hand corner
of the screen.
Note that the pointer only addresses words in 32 bit chunks.
The current color is used for filling.
.sp
.LP
.B
boxc (src_h, src_l, xs, ys, dest_h, dest_l, xd, yd, w, h)
.R
.IP
Copies a rectangular region of width "w" and height "h"
with upper left corner at (xs, ys) to
another region of the same size with upper left corner (xd, yd)
The "src" and "dest" parameters have the same function as described in the
box instruction.
If clipping is active and the destination rectangle is clipped,
the source rectangle is similarly adjusted the same way to reflect the
new width, height and starting position.
Alu mode or current color has no effect.
.sp
.LP
.B
boxp (pattern_h, pattern_l, xphase, yphase, dest_h, dest_l, x, y, w, h)
.R
.IP
Draws a 32 x 32 x 4 pattern located at "pattern" into a rectangular region
of width "w" and height "h" with upper left corner at (x, y).
"Xphase" and "yphase" specify a screen coordinate that would contain the upper
left corner of the pattern if it were extended to cover that point.
Note that the pattern is four planes deep.  From the point of VME bus
the pattern occupies four separate
regions of display memory with a fixed offset of 40000 hex from each other.
Alu mode or current color has no effect.  
.sp
.LP
.B
clip (x, y, w, h)
.R
.IP
Set clipping window region of width "w" and height "h" with upper 
left corner at (x, y).
When clipping is on, no pixels outside this region will be drawn.
An exception for this is the vector command.  Future releases will
remove this restriction.
The clipping region is for destination addresses only, it has no effect 
on reading the display memory.
.sp
.LP
.B
clip_on
clip_off
.R
.IP
Clipping is turned off and on with these commands.  When clipping is turned
off, no check is made for off screen access.  This is useful in situations
where it is known that this cannot occur and maximum performance is desired.
.sp
.LP
.KS
.B
init
.R
.IP
The screen is cleared, page 0 is selected, alu mode is set to clear,
clipping window is set to the display memory size with clipping turned off.
Interrupts are disabled.
The color lookup table is set to red, blue, green equal to 0 for color 0,
and all other colors are set to red, blue, green equal to 15.
.KE
.sp
.LP
.KS
.B
intrp_on, intrp_off
.R
.IP
These commands determine whether or not an interrupt is issued to the
host when the FIFO is empty and the graphics processor is waiting for more
commands.  This is the only reliable way for the host to determine that
the FIFO is empty and is safe to access the display memory.  If the
interrupts were previously turned off and then turned on, an interrupt will
be issued immediately if the FIFO is empty.
When the board is first initialized, interrupts are disabled.
.KE
.sp
.LP
.B
paint (mask_h, mask_l, mx, my, dest_h, dest_l, rx, ry, w, h)
.R
.IP
Paints a rectangular region of width "w" and height "h" with upper left
corner at (rx, ry).  The rectangle is
filled with the current color
only where a bit is set in the mask rectangle.
The mask rectangle is assumed to be the same size as the destination
rectangle and is located at (mx, my) which is relative to the "mask_hl"
pointer.
Since the mask is a single plane entity, it is assumed that it is loaded
in plane 0.
.sp
.LP
.B
pgsel (i)
.R
.IP
Selects which page (0 or 1) is to be displayed.
The selected page will be displayed starting on the susequent frame.
This command has no effect with the color system, but is retained for
compatibility with the monochrome system.
.sp
.LP
.KS
.B
set_color (color)
.R
.IP
The current color is set to the bottom 4 bits of "color".
Subsequent drawing operations will be drawn using this color.
Note that this color is really a address into the color lookup
table in the video dacs and the actual color displayed is 
dependent on the contents of the table.
.KE
.sp
.LP
.KS
.B
set_lookup ( color, red, green, blue )
.R
.IP
Sets the color lookup table so that the color will output the specified
RGB value.
Since this color system supports only 4 bits, only the lower 4 bits
of color, red, green and blue are used.
.KE
.sp
.LP
.B
src_pitch (width), dst_pitch (width)
.R
.IP
Sets the size of the pitch to be "width" words.
A word is defined as 32 bits.  The default width upon system
initialization is 40 words,
which is the width of the screen (40 * 32 = 1280).  
The minimum and maximum width
allowed is 1 and 64, respectively.
If a bad width is received, the command is aborted and the previous
pitch will still be in effect.
.IP
Pitch is used to map between linear addresses
of the display memory and the two dimensional (x,y) addressing used
by the graphics software.
The width of the pitch determines the offset between two adjacent
words in the "y" direction.
Src_pitch affects any command that uses source addresses.  This
includes "src", "pattern", "mask" and "font" address pointers.
Similarly,  dst_pitch affects the "dest" address pointer.
.sp
.LP
.B
vector (dest_h, dest_l, x0, y0, x1, y1)
.R
.IP
Draws a vector with the current color from (x0, y0) to (x1, y1).
.KE
.sp
.NH 2
Microcode OpCode Assignments
.PP
The following table shows the codes assigned to each of the microcode
instructions.
.TS
tab (/) allbox;
l c .
Instruction/OpCode (hex)
alu_clear/8001
alu_set/8002
alu_toggle/8003
box/8004
boxc/8005
boxp/8006
clip/8007
clip_on/8008
clip_off/8009
init/800a
intrp_on/800b
intrp_off/800c
paint/800d
pgsel/800e
set_lookup/8020
set_color/8021
src_pitch/8010
dst_pitch/8011
vector/8013
.TE
