/* CONTEXT/BOARD STATUS REGISTER (CBX) */
#ifdef LOCORE
#define	CBX		0xC1A000
#else  LOCORE
#define	CBX		((u_short *)0xC1A000)
#endif LOCORE
#define CXR		CBX
#define BSR		CBX
#define CTXMASK		0x0f
#define CTXSHIFT	0

/* CONSOLE BAUD RATE */
#define	BSR_E39		0x0080		/* jumper to E38, reads as zero */
#define	BSR_E40		0x0040		/* jumper to E38, reads as zero */
#define	BSR_BAUD	(BSR_E39|BSR_E40)/* E39 and E40 determine baud rate */
#define BSR_BAUD_9600	(BSR_E39|BSR_E40)/* no jumpers at E39 or E40 */
#define BSR_BAUD_19200	(BSR_E39)	/* E40 jumpered to E38 */
#define BSR_BAUD_1200	(BSR_E40)	/* E39 jumpered to E38 */
#define BSR_BAUD_300	(0) 		/* E39 and E40 jumpered to E38 */

/* NOT USED */
#define	BSR_E41		0x0020		/* jumper in, reads as zero */

/* CPU SPEED */
#define BSR_NSPEEDS	2
#define	BSR_E42		0x0010		/* jumper in, reads as zero */
#define	BSR_CPUSPEED	(BSR_E42)	/* E42 determines the CPU speed */
#define	BSR_CPUSPEED10	(BSR_E42)	/* no jumper on E42 */
#define	BSR_CPUSPEED12	(0)		/* E42 is jumpered to E38 */

/* PARITY ENABLE/DISABLE */
#define	BSR_PARITYON	0x0100		/* turn parity checking on */
#define	BSR_PARITYOFF	0x0200		/* turn parity checking off */

/* PROM */
#ifdef LOCORE
#define	PROM		0xC00000
#else  LOCORE
#define	PROM		((u_short *)0xC00000)
#endif LOCORE

#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8

/* NUMBER OF CONTEXTS */
#define NCTX	16	

/* SEGMENT REGISTERS */
#define NSEGPERCTX	64		/* number of segs per context */
#define NSEGREG		NSEGPERCTX*NCTX	/* total number of seg registers */
#define	SEGREGBASE	0x810001	/* base address of seg registers */
#define	SEGREGINCR	0x020000	/* incr to next seg reg in same ctx */
#define SEGREGSHIFT	17		/* shift for #<=>seg reg conversion */
#define SEGCTXINCR	0x000800	/* incr to same seg reg in next ctx */
#define SEGCTXSHIFT	11		/* shift for #<=>ctx reg conversion */
#define SEGNXTINCR	1		/* incr contents of reg for next seg */

/* PAGE REGISTERS */
#define NPAGPERSEG	32		/* number of pages in a segment */
#define PAGSEGSHIFT	5		/* shift for pag<=>seg conversion */
#define NPAGBANKS	64		/* number of page register banks */
#define NPAGREG		NPAGBANKS*NPAGPERSEG /* number of page registers */
#define	PAGREGBASE	0xC18000	/* base address of page registers */
#define	PAGREGINCR	0x000002	/* incr to next page register */
#define PAGREGSHIFT	1		/* shift for #<=>pag reg conversion */
#define PAGNXTINCR	1		/* incr contents of pag for next page */
#define PAGREFBIT	15		/* page referenced bit */
#define PAGMODBIT	14		/* page modified bit */
#define PAGOUTBIT	13		/* paged out bit */
#define PAGINVBIT	12		/* page invalid bit */
#define PAGNUMMASK	0xFFF		/* mask for physical page number */
