#include "fifo.h"
#include "graphics.h"


# define NPATT2 36
short test_patt[NPATT2] = {0,
			0x1, 0x2, 0x4, 0x8,
			0x10, 0x20, 0x40, 0x80,
			0x100, 0x200, 0x400, 0x800,
			0x1000, 0x2000, 0x4000, 0x8000,
			~0x1, ~0x2, ~0x4, ~0x8,
			~0x10, ~0x20, ~0x40, ~0x80,
			~0x100, ~0x200, ~0x400, ~0x800,
			~0x1000, ~0x2000, ~0x4000, ~0x8000,
                         0xffff, 0x5555, 0xaaaa};


# define NPATT 4
extern int has_color;
int lerrs;
int terrs;
int lapcnt;
static char *bank0[] = {"1E", "2E", "3E", "4E", "1F", "2F", "3F", "4F",
                        "1P", "2P", "3P", "4P", "1R", "2R", "3R", "4R" };
static char *bank1[] = {"1K", "2K", "3K", "4K", "1L", "2L", "3L", "4L",
                        "1U", "2U", "3U", "4U", "1V", "2V", "3V", "4V" };
static char *bank2[] = {"1H", "2H", "3H", "4H", "1J", "2J", "3J", "4J",
                        "1S", "2S", "3S", "4S", "1T", "2T", "3T", "4T" };
static char *bank3[] = {"1M", "2M", "3M", "4M", "1N", "2N", "3N", "4N",
                        "1W", "2W", "3W", "4W", "1X", "2X", "3X", "4X" };

static int stat_bank0[16];
static int stat_bank1[16];
static int stat_bank2[16];
static int stat_bank3[16];

mem_test ()

{
  char buf[80];
  short *start, *stop;
  long nbanks, repeat, forever;
  char allc, test;
  int abort;
  int i;
  int *q;

  lerrs = 0;
  terrs = 0;
  if (!has_color) {
  for (i=0; i<=15; i++)
    {
    stat_bank0 [i] = 0;
    stat_bank1 [i] = 0;
    stat_bank2 [i] = 0;
    stat_bank3 [i] = 0;
    }
  }
  printf("Memory Diagnostics\n\n");
  printf("Test memory region: (a)all (b)page0 (c)your spec  ? ");
  stripwhite(gets(buf));

  allc = buf[0];
  switch (allc)
    {
    case 'a' : start = (short *)STARTADDR;
               stop  = (short *)MAXADDR;
               break;
    case 'b' : start = (short *)STARTADDR;
               stop  = (short *)PG0_END;
               break;
    case 'c' : printf("  Enter hex start address: ");
               stripwhite(gets(buf));
               start = (short *)gethex(buf);
               printf("  Enter hex stop address:  ");
               stripwhite(gets(buf));
               stop = (short *)gethex(buf);
               break;
    default  : start = (short *)STARTADDR;
               stop  = (short *)MAXADDR;
               break;
    }

  printf("Repeat count in decimal (0 means forever): ");
  stripwhite(gets(buf));
  repeat = atol(buf);
  forever = (repeat == 0 ? 1 : 0);

  printf("\nTests available:\n");
  printf("  a) pattern\n");
  printf("  w) walk\n");
  printf("  p) ping pong\n");
  printf("  r) random\n");
  printf("  u) uniq\n");
  printf("Which ?  ");
  stripwhite(gets(buf));
  test = buf[0];
  printf("\n");

  for (lapcnt = 1; (forever || repeat-- > 0); lapcnt++)
    {
    if (abort = getlocal() == 'q') break;
    printf("Lap %d ", lapcnt);
    switch (test)
      {
      case 'a' : if (abort = patt(start, stop)) goto stop_it; break;
      case 'p' : if (abort = ping(start, stop)) goto stop_it; break;
      case 'r' : if (abort = rndm(start, stop)) goto stop_it; break;
      case 'u' : if (abort = uniq(start, stop)) goto stop_it; break;
      case 'w' : if (abort = walk(start, stop)) goto stop_it; break;
      default  : printf ("Invalid test selection.\n");
                 abort = 1;
                 goto stop_it;  break;
      }

    printf("%d errors this lap\n\n", lerrs);
    lerrs = 0;
    }

stop_it:
  if (abort)
    {
    printf("\n\nTest aborted");
    printf(" with %d total errors\n", terrs);
    abort = 0;
    }
  else
    {
    printf("\nTest completed");
    printf(" with %d total errors\n", terrs);
    }
  if (!has_color) {
  if (terrs > 0)
    {
    printf("Chip error statistics\n");
    for (i=0; i<=15; i++)
      {
      if (stat_bank0 [i] > 0)
        printf("   %s: %d errors\n", bank0[i],stat_bank0[i]); 
      if (stat_bank1 [i] > 0)
        printf("   %s: %d errors\n", bank1[i],stat_bank1[i]); 
      if (stat_bank2 [i] > 0)
        printf("   %s: %d errors\n", bank2[i],stat_bank2[i]); 
      if (stat_bank3 [i] > 0)
        printf("   %s: %d errors\n", bank3[i],stat_bank3[i]); 
      }
    }
  }
}




patt(start, stop)
unsigned short *start;
register unsigned short *stop;

{
  register unsigned short *addr;
  register unsigned short cpatt, rpatt;
  int   first_err;
  int   bank;
  short bad_bit;
  short bitno;
  short n;

  printf("  Pattern Test: Start = 0x%x, Stop = 0x%x\n", 
         (int)start, (int)stop);
  for (n = 0; n < NPATT2; n++)
    {
    cpatt = test_patt[n];
    first_err = 0;

    printf("\rWriting   %x", cpatt);
    for (addr = start; addr <= stop; addr++)
       *addr = cpatt;
    if (getlocal() == 'q') return 1;

    printf("\rVerifying %x", cpatt);
    for (addr = start; addr <= stop; addr++)
       {
       rpatt = *addr;
       if (rpatt != cpatt)
          {
          if (first_err == 0) printf("\n");
          first_err = 1;
	  if (lerrs++ > 100)
	     {
             printf("   Too many errors!                     \n");
	     return 1;
             }
	  terrs++;
          if (has_color) {
	  printf("   Error at %x:  %x -> %x\n", 
                 (int)addr, cpatt, rpatt);
          }
          else {
	  printf("   Error at %x:  %x -> %x (chip", 
                 (int)addr, cpatt, rpatt);
          bad_bit = rpatt ^ cpatt;
          bank    = (int)addr & 0x6;
          for (bitno = 0; bitno <= 15; bitno++)
            {
            if ((bad_bit & (1 << bitno)) != 0)
               switch (bank)
                 {
	         case 0 : printf(" %s", bank0[bitno]); 
                          stat_bank0[bitno]++;
                          break;
	         case 2 : printf(" %s", bank1[bitno]);
                          stat_bank1[bitno]++;
                          break;
                 case 4 : printf(" %s", bank2[bitno]);
                          stat_bank2[bitno]++;
                          break;
	         case 6 : printf(" %s", bank3[bitno]);
                          stat_bank3[bitno]++;
                          break;
                 }
             }
          printf (")\n");
          }
          }
       }
    if (getlocal() == 'q') return 1;
    }
  printf("\r                                      \r");
  return 0;
}



/*
**	Should I modify this to accept the function to call as an argument?
*/
walk(start, stop)
unsigned short *start;
unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1, *addr2;
	register unsigned short cpatt, pattc;
	short n;

	printf("  Walk Test: Start=0x%x, Stop=0x%x\n", (int)start, (int)stop);
	for (n = 0; n < NPATT; n++)
	{
		cpatt = test_patt[n];
		pattc = ~cpatt;
		for (rstart = start; rstart < stop; rstart += 0x1000)
		{
			printf("\r    Writing   %x:    ", cpatt);
			for (addr1 = start; addr1 <= stop; addr1++)
				*addr1 = cpatt;
			rstop = rstart + 0xfff;	/* note automatic conversion */
			rstop = (rstop <= stop ? rstop : stop);
			printf("\r    Walking   %x:    ", pattc);
			if (walk1(rstart, rstop, cpatt))
				return 1;
			printf("\r    Test A    %x:    ", cpatt);
			for (addr1 = start; addr1 < rstart; addr1++)
				if (*addr1 != cpatt)
					error(addr1, cpatt, *addr1);
			printf("\r    Test B    %x:    ", cpatt);
			for (addr1 = rstop + 1; addr1 < stop; addr1++)
				if (*addr1 != cpatt)
					error(addr1, cpatt, *addr1);
			if (getlocal() == 'q')
				return 1;
		}
	}
	printf("\r                     \r");
	return 0;
}

walk1(start, stop, cpatt)
unsigned short *start;
register unsigned short *stop, cpatt;
{
	register unsigned short *addr, *addr2;
	register unsigned short pattc, rpatt;
	
	pattc = ~cpatt;
	for (addr = start; addr <= stop; addr++)
	{
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2++)
		{
			rpatt = *addr2;
			if (rpatt != cpatt && addr2 != addr)
				error(addr2, cpatt, rpatt);
		}
		rpatt = *addr;
		if (rpatt != pattc)
			error(addr, pattc, rpatt);
		*addr = cpatt;
		if (getlocal() == 'q')
			return 1;
	}
	for (addr = start; addr <= stop; addr++)
	{
		rpatt = *addr;
		if (rpatt != cpatt)
			error(addr, cpatt, rpatt);
	}
	return 0;
}


ping(start, stop)
unsigned short *start;
register unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1;

	printf("  Ping-pong Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (rstart = start; rstart < stop; rstart += 0x1000)
	{
		for (addr1 = start; addr1 <= stop; addr1++)
			*addr1 = 0;
		rstop = rstart + 0xfff;	/* note automatic conversion of fff */
		rstop = (rstop <= stop ? rstop : stop);
		printf("\r    ping-pong %x to %x        ",(int)start, (int)stop);
		if(ping1(rstart, rstop))
			return 1;
		for (addr1 = start; addr1 < rstart; addr1++)
			if (*addr1 != 0)
				error(addr1, 0, *addr1);
		for (addr1 = rstop + 1; addr1 < stop; addr1++)
			if (*addr1 != 0)
				error(addr1, 0, *addr1);
		if (getlocal() == 'q')
			return 1;
	}
	printf("\r                              \r");
	return 0;
}

ping1(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr1, *addr2, *addr3, *addr4;
	register unsigned short caddr1, caddr2, caddr3, caddr4;
	short n;

	for (addr1 = start; addr1 <= stop; addr1++)
		*addr1 = 0;
	for (addr1 = start, addr2 = stop; addr1 < addr2; addr1++, addr2--)
	{
		*addr1 = 0xffff;
		*addr2 = 0xffff;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3++, addr4--)
		{
			if (*addr3 != 0xffff)
				error(addr3, 0xffff, *addr3);
			if (*addr4 != 0xffff)
				error(addr4, 0xffff, *addr4);
		}
		for (addr3 = addr1+1, addr4 = addr2-1; addr3 <= addr4;
			addr3++, addr4--)
		{
			if (*addr3 != 0)
				error(addr3, 0, *addr3);
			if (*addr4 != 0)
				error(addr4, 0, *addr4);
		}

		if (getlocal() == 'q')
			return 1;
	}
	for ( --addr1, ++addr2; addr1 >= start; addr1--, addr2++)
	{
		*addr1 = 0;
		*addr2 = 0;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3++, addr4--)
		{
			if (*addr3 != 0xffff)
				error(addr3, 0xffff, *addr3);
			if (*addr4 != 0xffff)
				error(addr4, 0xffff, *addr4);
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3++, addr4--)
		{
			if (*addr3 != 0)
				error(addr3, 0, *addr3);
			if (*addr4 != 0)
				error(addr4, 0, *addr4);
		}

		if (getlocal() == 'q')
			return 1;
	}
	return 0;
	
}


error(addr, wrote, read)
register unsigned short *addr, wrote, read;
{
	lerrs++;
	terrs++;
	printf("Error at %x: wrote %x, read %x\n", (int)addr, wrote, read);
	*addr = wrote; /* try to reset to correct value */
}


# define ADDRLEN 32

uniq(start, stop)
unsigned long *start;
register unsigned long *stop;
{
	register unsigned long *addr;
	register unsigned long raddr, saddr;
	short n;

	printf("  Uniqueness test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (n = 0; n < ADDRLEN; n++)
	{
		printf("\r    seed %x    ",n);
		saddr = (((unsigned long)addr >> n)
		  | ((unsigned long)addr << (ADDRLEN-n)));
		for (addr = start; addr <= stop; addr++)
			*addr = saddr;
		for (addr = start; addr <= stop; addr++)
		{
			raddr = *addr;
			if (raddr != saddr)
				error(addr, saddr, raddr);
		}
		if (getlocal() == 'q')
			return 1;
	}
	printf("\r                           \r");
	return (0);
}



rndm(start, stop)
unsigned short *start;
register unsigned short *stop;

{
  register unsigned short *addr;
  register unsigned short cpatt, rpatt;
  int i;

  printf("  Random Test: Start = 0x%x, Stop = 0x%x\n", 
         (int)start, (int)stop);

  printf("\rWriting   ");
  srandom(1);
  for (i = 1; i <= lapcnt; i++) random();	/* get new seed */
  for (addr = start; addr <= stop; addr++)
     {
     cpatt = (unsigned short) random();
     *addr = cpatt;
     }
  if (getlocal() == 'q') return 1;
  
  printf("\rVerifying ");
  srandom(1);
  for (i = 1; i <= lapcnt; i++) random();       /* get back seed */
  for (addr = start; addr <= stop; addr++)
     {
     cpatt = (unsigned short) random();
     rpatt = *addr;
     if (rpatt != cpatt)
        {
	if (lerrs++ > 100)
	  {
          printf("   Too many errors!                   \n");
	  return 1;
          }
        terrs++;
        printf("   Error at %x:  %x -> %x\n", (int)addr, cpatt, rpatt);
        }
     if (getlocal() == 'q') return 1;
     }
  printf("\r                                      \r");
  return 0;
}

