
#define ALUC	0x8001          /* alu_clear */
#define ALUS	0x8002          /* alu_set */
#define ALUT	0x8003          /* alu_toggle */
#define BOX	0x8004          /* box */
#define BOXC	0x8005          /* box_copy */
#define BOXP	0x8006          /* box_pattern */
#define CLIP	0x8007          /* clip */
#define CLPON	0x8008          /* clip_on */
#define CLPOF	0x8009          /* clip_off */
#define INIT	0x800A          /* init */
#define INTON	0x800B          /* interrupt_on */
#define INTOF	0x800C          /* interrupt_off */
#define PAINT	0x800D          /* paint */
#define PGSEL	0x800E          /* page_select */
#define PGSF	0x800F          /* page_select_fill */
#define SPTCH	0x8010          /* source_pitch */
#define DPTCH	0x8011          /* destination_pitch */
#define TEXT	0x8012          /* text */
#define VECT	0x8013          /* vector */
#define LOOKUP	0x8020          /* set lookup table */
#define SCOLOR  0x8021          /* set current color */

extern int back_color;
extern int fore_color;

/*
#define alu_clear \
        GIPoutput(2, SCOLOR, back_color)
#define alu_set \
        GIPoutput(2, SCOLOR, fore_color)
*/
#define alu_clear \
        GIPoutput(1, ALUC)
#define alu_set \
        GIPoutput(1, ALUS)

#define alu_toggle \
        GIPoutput(1, ALUT)

#define	box(dest_h, dest_l, x, y, w, h) \
        GIPoutput(7, BOX, dest_h, dest_l, x, y, w, h)

#define	boxc(src_h, src_l, xs, ys, dest_h, dest_l, xd, yd, w, h) \
	GIPoutput(11, BOXC, src_h, src_l, xs, ys, dest_h, dest_l, xd, yd, w, h)

#define	boxp(patt_h, patt_l, xp, yp, dest_h, dest_l, x, y, w, h) \
	GIPoutput(11, BOXP, patt_h, patt_l, xp, yp, dest_h, dest_l, x, y, w, h)

#define clip(x, y, w, h) \
        GIPoutput(5, CLIP, x, y, w, h)

#define clipon \
        GIPoutput(1, CLPON) 

#define clipoff \
        GIPoutput(1, CLPOF) 

#define init \
        GIPoutput(1, INIT)

#define intrp_on \
        GIPoutput(1, INTON)

#define intrp_off \
        GIPoutput(1, INTOF)

#define paint(mask_h, mask_l, mx, my, dest_h, dest_l, x, y, w, h) \
        GIPoutput(11, PAINT, mask_h, mask_l, mx, my, dest_h, dest_l, x, y, w, h)

#define pgsel(page) \
        GIPoutput(2, PGSEL, page)

#define pgsel_fill(page) \
        GIPoutput(2, PGSF, page)

#define src_pitch(width) \
        GIPoutput(2, SPTCH, width)

#define dst_pitch(width) \
        GIPoutput(2, DPTCH, width)

#define text(font_h, font_l, dest_h, dest_l, x, y, n, buf) {           \
        GIPoutput(8, TEXT, font_h, font_l, dest_h, dest_l, x, y, n);   \
        GIPoutlist(buf, (n + 1) / 2);                                  \
}

#define vector(dest_h, dest_l, x0, y0, x1, y1) \
        GIPoutput(7, VECT, dest_h, dest_l, x0, y0, x1, y1)

#define set_lookup(red, green, blue, addr) \
        GIPoutput(5, LOOKUP, red, green, blue, addr)

#define set_color(color) \
        GIPoutput(2, SCOLOR, color)
