.TL
Standalone Debugger for the Graphics Board
.AI
Integrated Solutions
2240 Lundy Ave.
San Jose, Ca.
.AE
.DA
.NH
Introduction
.PP
The graphics display system is one of the most complex products that
Integrated Solutions has ever built.  In order to assist in determining
faults in the field a standalone diagnostics program called "debug" exists
in the /usr/stand directory.  Debug was orginally designed to be used 
for debugging the microcode and individual sections of the hardware.  
As a result, there are a large number of commands that probably will not be
useful for fault determination at the board level.  However, some commands are
extremely useful for this purpose.  In this guide, only such programs
are documented.  Feel free to browse through the rest.
.PP
Debug really consists of a small main program and three different subprograms 
each with their own set of prompts.
The subrograms are each concerned with testing the Microcode, Hardware and
Graphics commands.
They all have the same protocal in that a "?" character will display all the
available commands and "q" (for quit) will always exit from any point in the
program and return to the next higher level of prompt.
.NH
Booting Debug
.PP
Unlike other stand alone programs, debug manipulates the graphics screen
directly and hence is not able to print diagnostics messages on the screen.
To converse with the debug program a terminal will be required.  
First disconnect the keyboard from the back of the monitor.
Then connect
the terminal to the RS232 connector labled "Port 0" on the Optimum box
directly under the fat cable that goes to the monitor.
Make sure that the terminal is set to run at 1200 baud.
.PP
To bring up debug, just type "sd(0,6)stand/debug.Vxx" at the boot program that
appears when the system is reset.  Depending upon the type of cpu you are
running, xx should be either a 10 or 20.  It is like booting Unix, so the
device you may boot from depends on the disk in the system, which may
be "sd", "el" or "hp".  
.PP
When debug comes up, it will print a header
followed by the virtual and physical address location of the
display memory.  Next, it will probe the display memory to find out if the
gip is a color or a monochrome system.  Certain commands will be disabled
depending upon which type of GIP hardware is present. 
Debug will then issue an initialize command to the
GIP microcode who will in turn clear the screen to black.
The prompt character for the main program is "->".
.sp
.nf
     sd(0,0)debug.V20
     49764+13588+119376  start 0x1000

     GIP Board Debugger   (6/7/85)
     Fifo at 0x7fc000, Display Memory at (0x400000,0xe00000)
     Monochrome System
     type ? for help.

     ->
.fi
.NH
Main Command Prompt
.PP
The main command promt is used as a gateway to the three subprograms that
perform the bulk of the testing.  All other miscellaneous functions are
grouped here.  Set and Clear screen uses the VME bus to change the screen
to blank or white and is useful for quickly checking if the VME data path
to the display memory is functional.  Zap issues an initialize signal to
the microcode which will result in a black screen.
.sp
.nf
     -> ?
     Commands:
        c)  Clear screen
        g)  Graphic commands
        h)  Hardware tests
        m)  Microcode tests
        q)  Quit and return to PROM monitor
        s)  Set screen to white
        t)  Toggle use of interrupts
        z)  Zap 29116 ALU
.fi
.NH
Microcode Tests
.PP
These set of commands is probably most useful for testing boards in the
field.  In particular, the Blit and Vector tests are especially demanding
to the hardware and will be useful in determining board functionality.
These commands run forever until interrupted when a "q" (for quit) character
is typed by the user.
.sp
.nf
     Microcode Automatic Tests

     m> ?
     Tests available are:
        b)   blit test
        e)   erode demo
        f)   font test
        m)   memory access test
        n)   box pattern test
        p)   paint test
        r)   random box test
        s)   box size test
        t)   box toggle test
        v)   vector test
        w)   walking address test
        d)   toggles debug mode

     m> b
     blit test
     width ?  128
     Freeze motion ...  (type f to resume)        <user types a "f">
     Freeze motion ...  (type f to resume)        <user types a "f">
     Freeze motion ...  (type f to resume)        <user types a "f">

     m> t
     random box toggle test

     m> v
     vector test
     toggle? n
.fi
.NH
Hardware Tests
.PP
The hardware test program's purpose is to exercise various parts of the GIP
hardware.  It mostly contains things that would assist in board repair
and the only thing of interest to field service would be the vme bus
memory test and the monitor alignment grid commands.
.sp
.nf
     Hardware tests
     h> ?
        a) address generator test
        d) debug mode
        f) fifo read write test
        g) alignment grid
        i) interrupt test
        m) microcode memory access test
        q) quit and return to main prompt
        v) vme memory access test
        x) memory read and write exercise

     h> v
     Memory Diagnostics
     Test memory region: (a)all (b)page0 (c)your spec  ? a
     Repeat count in decimal (0 means forever): 1

     Lap 1   Pattern Test: Start = 0x400000, Stop = 0x4777fe
     Writing/Veryfying xxxx
     Test completed with 0 total errors

     h> g
     Alignment Grid
.fi
.NH
Graphics Commands
.PP
The final subprogram is concerned with the microcde command interface
to the VME board.  The commands seen in this section correspond exactly
with the microcode instruction set that is available on the GIP card.
It provides a means of manually invoking the primitive graphics commands.
.sp
.nf
     Graphic Commands

     g> ?
     Commands :
         a)   alu mode
         b)   box
         c)   clip
         d)   destination pitch
         i)   interrupt
         l)   load new pattern
         n)   new page select
         p)   pattern box
         r)   raster addresses (dest & src)
         s)   source pitch
         t)   paint box
         u)   setup reference blit pattern
         v)   vector
         y)   copy box
         z)   initialize
.fi
