#define QUAD	0x6000
#define OPCODE	0x1e00
#define DEST	0x01e0
#define REG	0x001f

int quad, opcode, dest, reg;

dasm (instr)

/* This procedure disassembles the 29116 instruction stream */

int instr;

{

  /* decode all the fields */
  quad   = (instr & QUAD)   >> 13;
  opcode = (instr & OPCODE) >> 9;
  dest   = (instr & DEST)   >> 5;
  reg    = (instr & REG);
  switch (quad)
    {
    case 0 : quad0_decode ();                   break;
    case 1 : quad1_decode ();                   break;
    case 2 : quad2_decode ();                   break;
    case 3 : quad3_decode ();                   break;
    default: printf("                      ");  break;
    }
}


quad0_decode ()

{
  if (dest <= 11) 
    switch (opcode) {
      case  0: printf ("TOR1 TORAA,");  
               pr_toi ();
               pr_reg ();  break;
      case  2: printf ("TOR1 TORIA,");  
               pr_toi ();
               pr_reg ();  break;
      case  3: printf ("TOR1 TODRA,");  
               pr_toi ();
               pr_reg ();  break;
      case  8: printf ("TOR1 TORAY,");  
               pr_toi ();
               pr_reg ();  break;
      case 10: printf ("TOR1 TORIY,");  
               pr_toi ();
               pr_reg ();  break;
      case 11: printf ("TOR1 TODRY,");  
               pr_toi ();
               pr_reg ();  break;
      case 12: printf ("TOR1 TORAR,");  
               pr_toi ();
               pr_reg ();  break;
      case 14: printf ("TOR1 TORIR,");  
               pr_toi ();
               pr_reg ();  break;
      case 15: printf ("TOR1 TODRR,");  
               pr_toi ();
               pr_reg ();  break;
      }
  else
    switch (dest)
      {
      case 12: printf ("ROTR1 %d,RTRA,  ",opcode);
               pr_reg();  break;
      case 14: printf ("ROTR1 %d,RTRY,  ",opcode);
               pr_reg();  break;
      case 15: printf ("ROTR1 %d,RTRR,  ",opcode);
               pr_reg();  break;
      }
}


quad1_decode ()

{
    switch (dest) {
      case  0: printf ("ROTR2 %d,RTAR,  ",opcode);  
               pr_reg ();  break;
      case  1: printf ("ROTR2 %d,RTDR,  ",opcode);  
               pr_reg ();  break;
      case  2: printf ("ROTC  %d,CDAI,  ",opcode);  
               pr_reg ();  break;
      case  3: printf ("ROTC  %d,CDRI,  ",opcode);  
               pr_reg ();  break;
      case  4: printf ("ROTC  %d,CDRA,  ",opcode);  
               pr_reg ();  break;
      case  5: printf ("ROTC  %d,CRAI,  ",opcode);  
               pr_reg ();  break;
      case  7: printf ("ROTM %d,MDAI,   ",opcode);  
               pr_reg ();  break;
      case  8: printf ("ROTM %d,MDAR,   ",opcode);  
               pr_reg ();  break;
      case  9: printf ("ROTM %d,MDRI,   ",opcode);  
               pr_reg ();  break;
      case 10: printf ("ROTM %d,MDRA,   ",opcode);  
               pr_reg ();  break;
      case 12: printf ("ROTM %d,MARI,   ",opcode);  
               pr_reg ();  break;
      case 14: printf ("ROTM %d,MRAI,   ",opcode);  
               pr_reg ();  break;
    }
}


quad2_decode ()

{
  if (dest <= 11)
    switch (opcode) {
      case  1: printf ("TOR2 TODAR,");  
               pr_toi ();
               pr_reg ();  break;
      case  2: printf ("TOR2 TOAIR,");  
               pr_toi ();
               pr_reg ();  break;
      case  5: printf ("TOR2 TODIR,");  
               pr_toi ();
               pr_reg ();  break;
      case  6: printf ("SHFTR SHRR,");  
               pr_shft();
               pr_reg ();  break;
      case  7: printf ("SHFTR SHDR,");  
               pr_shft();
               pr_reg ();  break;
      case 12: printf ("SOR  MOVE, ");  
               pr_sori ();
               pr_reg ();  break;
      case 13: printf ("SOR  COMP, ");
               pr_sori ();
               pr_reg ();  break;
      case 14: printf ("SOR  INC,  ");
               pr_sori ();
               pr_reg ();  break;
      case 15: printf ("SOR  NEG,  ");
               pr_sori ();
               pr_reg ();  break;
      }
  else
    switch (dest)
      {
      case 12: printf ("BOR2  %d,LD2NR, ",opcode);
               pr_reg();  break;
      case 13: printf ("BOR2  %d,LDC2NR,",opcode);
               pr_reg();  break;
      case 14: printf ("BOR2  %d,A2NR,  ",opcode);
               pr_reg();  break;
      case 15: printf ("BOR2  %d,S2NR,  ",opcode);
               pr_reg();  break;
      }
}



quad3_decode ()

{
  if (dest <= 11)
    switch (opcode) {
      case  1: printf ("TONR TODA, ");  
               pr_toi ();
               pr_dest();  break;
      case  2: printf ("TONR TOAI, ");  
               pr_toi ();
               pr_dest();  break;
      case  5: printf ("TONR TODI, ");  
               pr_toi ();
               pr_dest();  break;
      case  6: printf ("SHFTNR SHA,");  
               pr_shft();
               pr_dest();  break;
      case  7: printf ("SHFTNR SHD,");  
               pr_shft();
               pr_dest();  break;
      case  8: if (dest == 10)
               printf ("NOOP");
               break;
      case 12: printf ("SONR MOVE, ");  
               pr_soni ();
               pr_dest ();  break;
      case 13: printf ("SONR COMP, ");
               pr_soni ();
               pr_dest ();  break;
      case 14: printf ("SONR INC,  ");
               pr_soni ();
               pr_dest ();  break;
      case 15: printf ("SONR NEG,  ");
               pr_soni ();
               pr_dest ();  break;
      }
  else
    switch (dest)
      {
      case 12: if (reg < 24) {
                 printf ("BONR  %d,",opcode);
                 pr_boi (); 
                 }
               else {
                 printf ("ROTNR %d,",opcode);
                 pr_boi ();
                 }
               break;
      case 13: printf ("BOR1  %d,SETNR, ",opcode);
               pr_reg();  break;
      case 14: printf ("BOR1  %d,RSTNR, ",opcode);
               pr_reg();  break;
      case 15: printf ("BOR1  %d,TSTNR, ",opcode);
               pr_reg();  break;
      }
}


pr_sori ()

/* single operand ram instruction opcodes */ 
{
  switch (dest)
    {
    case  0: printf ("SORA, "); break;
    case  2: printf ("SORY, "); break;
    case  3: printf ("SORS, "); break;
    case  4: printf ("SOAR, "); break;
    case  6: printf ("SODR, "); break;
    case  7: printf ("SOIR, "); break;
    case  8: printf ("SOZR, "); break;
    case  9: printf ("SOZER,"); break;
    case 10: printf ("SOSER,"); break;
    case 11: printf ("SORR, "); break;
    default: printf ("????, "); break;
    }
}

pr_soni ()

/* single operand non-ram instruction opcodes */ 
{
  switch (dest)
    {
    case  4: printf ("SOA,  "); break;
    case  6: printf ("SOD,  "); break;
    case  7: printf ("SOI,  "); break;
    case  8: printf ("SOZ,  "); break;
    case  9: printf ("SOZE, "); break;
    case 10: printf ("SOSE, "); break;
    default: printf ("????, "); break;
    }
}


pr_toi ()

/* two operand instruction opcodes */ 
{
  switch (dest)
    {
    case  0: printf ("SUBR, "); break;
    case  1: printf ("SUBRC,"); break;
    case  2: printf ("SUBS, "); break;
    case  3: printf ("SUBSC,"); break;
    case  4: printf ("ADD,  "); break;
    case  5: printf ("ADDC, "); break;
    case  6: printf ("AND,  "); break;
    case  7: printf ("NAND, "); break;
    case  8: printf ("EXOR, "); break;
    case  9: printf ("NOR,  "); break;
    case 10: printf ("OR,   "); break;
    case 11: printf ("EXNOR,"); break;
    default: printf ("?????,"); break;
    }
}


pr_shft()

/* shift instruction opcodes */ 
{
  switch (dest)
    {
    case  0: printf ("SHUPZ,"); break;
    case  1: printf ("SHUP1,"); break;
    case  2: printf ("SHUPL,"); break;
    case  4: printf ("SHDNZ,"); break;
    case  5: printf ("SHDN1,"); break;
    case  6: printf ("SHDNL,"); break;
    case  7: printf ("SHDNC,"); break;
    case  8: printf ("SHDNV,"); break;
    default: printf ("?????,"); break;
    }
}



pr_reg ()

{
  printf ("R%d   ",reg);
}


pr_dest ()

{
  switch (reg)
    {
    case  0: printf ("NRY   ");   break;
    case  1: printf ("NRA   ");   break;
    case  4: printf ("NRS   ");   break;
    case  5: printf ("NRAS  ");   break;
    default: printf ("?????,");   break;
    }
}


pr_boi  ()

/* bit oriented and rotate by N instructions */

{
  switch (reg)
    {
    case  0: printf("TSTNA  ");   break;
    case  1: printf("RSTNA  ");   break;
    case  2: printf("SETNA  ");   break;
    case  4: printf("A2NA   ");   break;
    case  5: printf("S2NA   ");   break;
    case  6: printf("LD2NA  ");   break;
    case  7: printf("LDC2NA ");   break;
    case 16: printf("TSTND  ");   break;
    case 17: printf("RSTND  ");   break;
    case 18: printf("SETND  ");   break;
    case 20: printf("A2NDY  ");   break;
    case 21: printf("S2NDY  ");   break;
    case 22: printf("LS2NY  ");   break;
    case 23: printf("LDC2NY ");   break;
    case 24: printf("RTDY   ");   break;
    case 25: printf("RTDA   ");   break;
    case 28: printf("RTAY   ");   break;
    case 29: printf("RTAA   ");   break;
    default: printf("???????");   break;
    }
}

