#include "../machine/board.h"

int	dorte;


#ifdef	PROMDIAG
extern int go_no_go;
	p_fpu()
#else
int go_no_go = 0;
	main()
#endif
{
	printf("\n--- %i Standalone 68881/2 Diagnostics --- (%s)\n",
					time_str(read_time()) );
	bs_20("");				/* initilize the back space counter */
	if( ! go_no_go) {
		printf("\n Set FPU_USE bit in the sysytem control register.\n");
      printf("    Do not expect to get F-LINE trap when fnop is executed.\n");
	}
	if (testfpuuseon()) {
		printf("    Failed, Unexpected F-LINE trap occured.\n");
		return(1);
	}
	if( ! go_no_go) {
		printf(" Reset FPU_USE bit in the sysytem control register.\n");
		printf("    Expect to get F-LINE trap when fnop is executed.\n");
	}
	if (testfpuuseoff()) {
		printf("    Failed, Expected F-LINE trap did not occur.\n");
		return(1);
	}
	if( ! go_no_go)
		printf("    Got expected F-LINE trap when fnop was executed.\n");
	fpuon();
	if(ontest()) return(1);
	fpuoff();
	return(onoff());
}

ontest()
{
	float test, ans;
	register i;

 	if( ! go_no_go) 
		printf(" Set FPU_USE bit on and test FPU instruction\n");

	test = 1.0;
	for (i = 0 ; i < 1000 ; i++)
		test *= 1.0;
	if (test != 1.0) {
		bs_20(" ***  Failed, result != 1.0\n");
		return(1);
	}
	test  = 3.141592654;
	test /= 3.0;
	test *= 3.141592654;
	ans = 3.289868134;       /* 0x400a51a6; */
	if(test != ans){
	  bs_20("  ***  Failed, results != %lx\n", ans);
       return(1);
	}
	return(0);
}


onoff()
{
	float test;
	register int cnt = 0;
	dorte = 1;

	if( ! go_no_go) {
		printf(" Set FPU_USE bit on and off between FPU instructions.  ");
		printf("\n    Type any character to terminate.  ");
	}
	test = 1.0;
	while ((getlocal() == 0)) {
		test *= 1.0;
		fpuoff();
		if (test != 1.0) {
			printf("  Failed, resulst != 1.0\n");
			return(1);
		}
#ifdef	PROMDIAG
		if(cnt++ > 100 && go_no_go) break;
#endif
	}
	bs_20("** Passed **");
	return(0);
}



