#include "../h/param.h"

#define BSIZE	0x1000
#define DBLOCK	30000
#define PCLEAR	0x0
#define	MAXADDR	0x9ffffe		/* prevent conficts with controllers */

unsigned char	*pbuf1, *pbuf2;
int		maxbufsiz, maxdblock, mindblock;
unsigned char	*bstart, *bend;
int		v;
int		rep, ran, ranall, retry;
int		werr, rerr, verr;
int		patlen;
char		pat[80];

extern int	end;
#ifdef	M68030
extern int	memsize;
#else
extern int	topmem;
#endif

main()
{
        register int i;
	register int fi, nlap;
        char buf[50];

	printf("\n--- %i Standalone DMAX Test ---\n\n");

loop:	rerr = 0; werr = 0; verr = 0;
        do  {
                printf("device: "); gets(buf);
		if (strlen(buf) == 2) {
			strcat(buf, "(0,1)");
			printf("        opening %s\n", buf);
		}
                fi = open(buf, 2);
        } while (fi < 0);
	do  {
		printf("Max block length (default is %d bytes): ", BSIZE);
		gets(buf);
		if (buf[0]) {
			maxbufsiz = getnum(buf);
			if (maxbufsiz < 0)
				printf("Illegal number\n");
			if (maxbufsiz & 1) {
				printf("Size must be even\n");
				maxbufsiz = -1;
			}
		} else
			maxbufsiz = BSIZE;
	} while (maxbufsiz < 0);
	maxbufsiz += 2;
	do  {
		printf("Min disk block number (default is block %d): ", 0);
		gets(buf);
		if (buf[0]) {
			mindblock = getnum(buf);
			if (mindblock < 0)
				printf("Illegal number\n");
			if (mindblock & 1) {
				printf("Block size must be even\n");
				mindblock = -1;
			}
		} else
			mindblock = 0;
	} while (mindblock < 0);
	do  {
		printf("Max disk block number (default is block %d): ", DBLOCK);
		gets(buf);
		if (buf[0]) {
			maxdblock = getnum(buf);
			if (maxdblock < 0)
				printf("Illegal number\n");
			else if (maxdblock & 1)
				printf("Block size must be even\n");
			else if (maxdblock < mindblock)
				printf("Max < Min\n");
			else
				continue;
			maxdblock = -1;
		} else
			maxdblock = DBLOCK;
	} while (maxdblock < 0);
	maxdblock -= mindblock;
	do  {
		printf("Number of blocks per lap (default 1000) : ");
		gets(buf);
		rep =  getnum(buf);
		if (rep == 0)
			rep = 1000;
		else if (rep < 0)
			printf("Illegal number\n");
	} while (rep < 0);
	do  {
		printf("Read/Verify retry count (default 0) : ");
		gets(buf);
		if (buf[0]) {
			retry = getnum(buf);
			if (retry < 0) 
				printf("Illegal number\n");
		} else
			retry = 0;
	} while (retry < 0);
	printf("Random patterns (default yes) : ");
	stripwhite(gets(buf));
	ran =  (buf[0]=='n' || buf[0]=='N') ? 0 : 1;
	if (ran) {
		printf("Random patterns per byte (default no) : ");
		stripwhite(gets(buf));
		ranall =  (buf[0]=='y' || buf[0]=='Y') ? 1 : 0;
	} else {
		do {
			printf("Length of byte pattern (1-%d):	", sizeof(pat));
			gets(buf);
			patlen = getnum(buf);
		} while (patlen <= 0 || patlen > sizeof(pat));
		for (i = 0 ; i < patlen; i++) {
			printf("Byte %2d of pattern:	", i);
			gets(buf);
			pat[i] = gethex(buf);
		}
	}
	printf("Test with parity? (default yes): ");
	stripwhite(gets(buf));
	if (buf[0] == 'n' || buf[0] == 'N')
		_parityoff();
	else
		_parityon();
#ifdef	M68025C
	printf("Enable External Cache ? (default no): ");
	stripwhite(gets(buf));
	if (buf[0] == 'y' || buf[0] == 'Y')
		onetoone(1);
	else
		onetoone(0);
#endif	M68025C
	printf("Verbose ? (default no): ");
	stripwhite(gets(buf));
	v =  (buf[0]=='y' || buf[0]=='Y') ? 1 : 0;
barea:	
	bstart = (unsigned char *)(((int)&end & ~1) + 0x4);
#ifdef	M68030
	bend = (unsigned char *) ((MIN(MAXADDR,memsize)&~1) - maxbufsiz - 0x4);
#else
	bend = (unsigned char *) ((MIN(MAXADDR,topmem) & ~1) - maxbufsiz - 0x4);
#endif
	printf("Start of buffer area (0x%x): ", bstart);
	gets(buf);
	if (buf[0])
		bstart =  (unsigned char *)(gethex(buf) & ~1);
	printf("End of buffer area (0x%x)  : ", bend);
	gets(buf);
	if (buf[0])
		bend =  (unsigned char *)(gethex(buf) & ~1);
	if (bend-bstart <= 2*maxbufsiz) {
		printf("  buffer area too small\n");
		goto barea;
	}
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);
	printf("\n");
	for (i = 0 ; ((nlap == 0) ? 1 : (i < nlap)) ; i++) {
		printf("  Lap %d                     \n",i);
		if (dtest(fi))
			break;
	}
	printf("\nDone DMA Test: %d Read-errors, %d Write-errors, %d Verify-errors\n", 
		rerr, werr, verr);
	close(fi);
	goto loop;
}

dtest(fi)
{
	register int i, count, nretry = retry;
	register int j, k;
	unsigned rand();
	int dblock,bufsiz;

	for (j = 0; j < rep; j++)
	{
		dblock = mindblock + (int)(((double)rand()/0x7ffffffe)*(maxdblock));
buffcom:	bufsiz = (int)(((double)rand()/0x7ffffffe)*(maxbufsiz));
		if (bufsiz&1 || bufsiz <= 2)
			goto buffcom;
		pbuf1 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		pbuf2 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		if (pbuf1 + bufsiz > bend)
			pbuf1 -= bufsiz;
		if (pbuf2 + bufsiz > bend)
			pbuf2 -= bufsiz;
		if (abs(pbuf1 - pbuf2) <= bufsiz)
			if (pbuf2 > pbuf1) {
				pbuf2 += bufsiz;
				if (pbuf2< bstart || pbuf2 + bufsiz > bend)
					pbuf2 = bstart;
			} else {
				pbuf1 += bufsiz;
				if (pbuf1 < bstart || pbuf1 + bufsiz > bend)
					pbuf1 = bstart;
			}
		pbuf1 = (unsigned char *)((int)pbuf1 & ~1);
		pbuf2 = (unsigned char *)((int)pbuf2 & ~1);
		if (pbuf1 < bstart || pbuf2 < bstart || pbuf1+bufsiz > bend ||
			pbuf2+bufsiz > bend || abs(pbuf1-pbuf2) < bufsiz)
			goto buffcom;
		if (v) printf("\r    Load    ");
		if (ran) {
		    if (ranall)
			for (i = 0; i < bufsiz; i++)
				pbuf1[i] = rand();
		    else {
			k = rand();
			for (i = 0; i < bufsiz; i++)
				pbuf1[i] = k;
		    }
		} else {
			k = (rand() & 0x7FFFFFFE) % patlen;
			for (i = 0; i < bufsiz; i++) {
				pbuf1[i] = pat[k++];
				if (k >= patlen)
					k = 0;
			}
		}
#ifdef	DEBUG
		printf("block %d: pbuf1=%x pbuf2=%x len=%x val=%x\n", 
			dblock, (int)pbuf1, (int)pbuf2, bufsiz-2, pbuf1[0]);
#endif	DEBUG
		if (getlocal() == 'x')
			return -1;
		lseek(fi, dblock*512, 0);
		if (v) printf("\r    Write   ");
		if (write(fi, pbuf1, bufsiz-2) != bufsiz-2) {
			werr++;
			printf("Bad write: block %d: pbuf1=%x pbuf2=%x len=%x\n", 
				dblock, (int)pbuf1, (int)pbuf2, bufsiz-2);
		}
doretry:	for (i = 0; i < bufsiz; i++)	/* clear pattern */
			pbuf2[i] = PCLEAR;
		pbuf2[bufsiz-1] = pbuf1[bufsiz-1];	/* end sentenal */
		pbuf2[bufsiz-2] = pbuf1[bufsiz-2];	/* end sentenal */
		if (getlocal() == 'x')
			return -1;
		lseek(fi, dblock*512, 0);
		if (v) printf("\r    Read    ");
		if (read(fi, pbuf2, bufsiz-2) != bufsiz-2) {
			rerr++;
			printf("Bad read: block %d: pbuf1=%x pbuf2=%x len=%x\n",
				 dblock, (int)pbuf1, (int)pbuf2, bufsiz-2);
			continue;
		}
		/* check pattern */
		if (v) printf("\r    Verify  ");
		for (i = 0; i < bufsiz; i++) {
			register unsigned char pc1,pc2;
			register int nclear;

			pc1 = pbuf1[i];
			pc2 = pbuf2[i];
			if (pc1 != pc2) {
				verr++;
				printf("Bad compare: block %d: pbuf1=%x pbuf2=%x len=%x\n", 
					dblock, (int)pbuf1, (int)pbuf2, bufsiz);
				printf("             index %x: expected %x got %x\n",
					i, pc1, pc2);
				nclear = 0;
				if (pc2 == PCLEAR)
					nclear++;
				for (k = i + 1; k < bufsiz; k++) {
					pc1 = pbuf1[k];
					pc2 = pbuf2[k];
					if (pc1 == pc2)
						break;
					verr++;
					if (pc2 == PCLEAR)
						nclear++;
				}
				printf("             run of %x bytes",k-i);
				if (k == bufsiz)
					printf(" (end of buffer)");
				printf(", %x bytes of clear pattern ",nclear);
				i = k;
				if (nretry > 0) {
					printf(", retry read/verify\n");
					nretry--;
					goto doretry;
				}
				printf("\n");
			}
		}
	if (v) printf("\r                                \r"); /**/
	}
	return 0;
}
