
/* a library of routines shared by the 68030 standalone routines
 * softint, timer, cache, vdma, nvram, etc..
 */

#include	"../h/types.h"
#include	"saio.h"
#include	"../dev/sioreg.h"
#include	"../machine/board.h"


#define devtoblk(x)	((x)/ NCPB)
#define devtochan(x)	((x)% NCPB)

struct siochan 	 	*sio_addr[NSIO];
struct sioblock 	*blk_addr[NBLOCKS];

extern int	ignore_intr, dorte;

char	keybd_intr;
int	last_len = -1;

/*****************/
/* sio char interrupt handler */
sio_hdlr()
{
	keybd_intr = getlocal();
}


/*****************/
/* Sio initialization */
sio_init(flg)
int	flg;
{
	register chan = devtochan(RTCOUNTER);
	register blk = devtoblk(RTCOUNTER);
	register int i, b, c, opcr, acr;
	struct s2698device *p;
	
	keybd_intr = 0;
	p = (struct s2698device *)OCTART_ADDR;
	for (i = 0 ; i < NSIO; i++)
		if (devtochan(i) == 0)
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chana;
		else
			sio_addr[i] = &p->s2698_block[devtoblk(i)].blk_chanb;

	_splx(0x2700);
	while ((afcrb(&sio_addr[chan]->chan_sr_csr)&SR_TXEMT) == 0);

	afcwb(&sio_addr[chan]->chan_cr,	CR_DISABLE_TX | CR_DISABLE_RX);
	for (i = 0 ; i < NBLOCKS; i++) {
		blk_addr[i] = &p->s2698_block[i];
		afcrb(&blk_addr[i]->blk_ct_stop);
		afcwb(&blk_addr[i]->blk_isr_imr, 0);
		afcwb(&blk_addr[i]->blk_ipcr_acr, ACR_BRGS);
	}
	if(flg) {
		afcwb(&blk_addr[blk]->blk_isr_imr,
								(IMR_MPI_PORT_CHANGE | IMR_CHANA_RXRDY));
		dorte = 1;
		ignore_intr = 1;		/* ignore the first interrupt */
		_splx(0x2000);
		rupt_enable();
		ignore_intr = 0;
		set_vec(SIO_VECT, sio_hdlr);
	}else
		rupt_disable();
	afcwb(&sio_addr[chan]->chan_cr,	CR_ENABLE_TX | CR_ENABLE_RX);

}

/*****************/
char *
time_str (time)
register int	time;
{
	int min, sec;
	static	char	str[9];
	
	if(time < 0) time = ~time + (24 * 3600);
	min = (time%3600)/60;
	sec = time%60;
	sprintf(str,"%d:%s%d:%s%d", time/3600, (min > 9)? "":"0", min,
						  			   (sec > 9)? "":"0", sec);
	return(str);
}

/*****************/
print_time(time)
{
	printf("%s", time_str(time));
}

/*****************/
read_time()
{
	int	hour,minute,second;

	afcwb(NVRAM_CONTROL, NVRAM_READ);
	hour = (afcrb(NVRAM_HOUR) >> 4) * 10 + (afcrb(NVRAM_HOUR) & 0x0f);
	minute = (afcrb(NVRAM_MINUTE) >> 4) * 10 + (afcrb(NVRAM_MINUTE) & 0x0f);
	second = (afcrb(NVRAM_SECOND) >> 4) * 10 + (afcrb(NVRAM_SECOND) & 0x0f);
	afcwb(NVRAM_CONTROL, 0);
	return((hour*3600)+(minute*60)+second);
}

int	last_len = -1;
bs_20(str)
char	*str;
{
	register int len, i;

	if(len = strlen(str)) {
		if (last_len > 0) {
			for(i = 0; i <last_len; i++) putchar('\b');
			for(i = 0; i < last_len; i++) putchar(' ');
			for(i = 0; i < last_len; i++) putchar('\b');
		}
		printf(" %s",str);
		last_len = len +1;
	}else
		last_len = -1;
}

/**************** EOF *******************/
