
#include "../machine/board.h"

#define	ICACHE_CLEAR	0x0008
#define	ICACHE_ENABLE	0x0001
#define	DCACHE_CLEAR	0x0800
#define	DCACHE_WA		0x2000

#define CACHE_ON	ICACHE_CLEAR|ICACHE_ENABLE|DCACHE_CLEAR|DCACHE_WA
#define CACHE_OFF	ICACHE_CLEAR|DCACHE_CLEAR

#ifdef	V30
#define	_cacheoff()	set_cacr(CACHE_OFF)
#define	_cacheon()	set_cacr(CACHE_ON)
#endif	V30

extern	int	dorte;

main()
{
#define	count	100000000
	int i, start_time;
	char	c;

	printf("\n--- %i Standalone CPU Speed Test (%s) ---\n\n",DATE);

	printf("Time with a stop watch.  The nominal elapsed times\n");
	printf("for previous tests of %d iterations were:\n", count);
	printf("    --- Cache ------ON------OFF-\n");
/*	printf("    9:08    on Q10 @10MHz\n");
 *	printf("    ?:??    on Q10 @12MHz\n");
 *	printf("    ?:??    on V10 @10MHz\n");
 *	printf("    8:16    on V10 @11.1MHz\n");
 *	printf("    ?:??    on V10 @12MHz\n");
 */
 	printf("    V10 @11.1MHz   8:16     N/A\n");
	printf("    V20 @12MHz     ?:??     ?:??\n\n");
	printf("    V20 @16.67MHz  2:38     ?:??\n");
	printf("    V30 @16.67MHz  ?:??     ?:??\n");
	printf("    VQX @16.67MHz  2:52     3:57\n\n");
	printf("    V25 @25MHz     2:22     ?:??\n");
	printf("    V30 @25MHz     0:48     2:14\n");

	while (1) {
		i = count;
#ifndef	V10
		printf("\nRun with internal cache? (y/n default yes): ");
		if((c = wgetlocal()) == 'n') 
			_cacheoff();
		else {
			_cacheon();
			c = 'y';
		}
		putchar(c);
#endif	V10
		printf("\nPress any key to begin timing ...");
		c = wgetlocal();
		if(c == '' || c == '') 	return;

		printf("\nstarted ");
#ifdef	V30
		start_time = read_time();
#endif	V30
		while (i--);
		printf(".. done.");
#ifdef	V30
		printf("  Elapsed time:");
		print_time(read_time() - start_time);
#endif	V30
		putchar('\n');
	}
}

#ifdef	V30
print_time(time)
int	time;
{
	int  day, hour, minute, second;

	if(time < 0) time = ~time + (24 * 3600);
	hour = time/3600;
	minute = (time/60)%60;
	second = time%60;
	printf(" %2d:%c%d:%c%d\n", time/3600, (time%60 < 10)? '0' :'\0',
								minute, (second < 10)? '0' :'\0',
							    second);
}
read_time()
{
	int	hour,minute,second;

	afcwb(NVRAM_CONTROL, NVRAM_READ);
	hour = bcd_to_binary(afcrb(NVRAM_HOUR));
	minute = bcd_to_binary(afcrb(NVRAM_MINUTE));
	second = bcd_to_binary(afcrb(NVRAM_SECOND));
	afcwb(NVRAM_CONTROL, 0);
	return((hour*3600)+(minute*60)+second);
}

bcd_to_binary(i)
unsigned char i;
{
	return((i >> 4) * 10 + (i & 0x0f));
}
#endif	V30
