#include "saio.h"

devread(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_RDDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, READ);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devwrite(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_WRDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, WRITE);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devopen(io)
	register struct iob *io;
{
	return ((*devsw[io->i_ino.i_dev].dv_open)(io));
}

devclose(io)
	register struct iob *io;
{
	badclose(io);
	return ((*devsw[io->i_ino.i_dev].dv_close)(io));
}

devioctl(io, cmd, arg)
	register struct iob *io;
	int cmd;
	caddr_t arg;
{
	return ((*devsw[io->i_ino.i_dev].dv_ioctl)(io, cmd, arg));
}

/*ARGSUSED*/
nullsys(io)
	struct iob *io;
{
}

/*ARGSUSED*/
nullioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{
	return (ECMD);
}

#ifndef	NODRIVERS
#ifdef	QX
	int	qdstrategy(), qdopen();
	int	qtstrategy(), qtopen(), qtclose();
	int	qxstrategy(), qxopen(), qxclose();
#else
	int	sdstrategy(), sdopen();
	int	exstrategy(), exopen(), exclose();
	int	nwstrategy(), nwopen(), nwclose();
#endif	QX
int	smstrategy(), smopen(), smioctl();
int	gdstrategy(), gdopen();
int	gtstrategy(), gtopen(), gtclose();
int	tsstrategy(), tsopen(), tsclose();
int	dastrategy(), daopen(), daclose();
int	vbstrategy(), vbopen(), vbclose();
int	mestrategy(), meopen();
#endif	NODRIVERS

/*
 * Standalone dev switch.  Devices must be listed in auto-boot search priority
 */
struct devsw devsw[] = {
#ifndef	NODRIVERS
#ifdef	QX
	{"qd",	makedev(5,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT|DEV_CLUST,
			qdstrategy,qdopen,nullsys,nullioctl },
#else
	{"sd",	makedev(1,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			sdstrategy,sdopen,nullsys,nullioctl },
#endif	QX
	{"sm",	makedev(2,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			smstrategy,smopen,nullsys,smioctl },
	{"gd",	makedev(3,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			gdstrategy,gdopen,nullsys,nullioctl },
#ifdef	QX
	{"qt",	8, "(100,5)",  	  		DEV_TAPE|DEV_AUTOBOOT,
			qtstrategy,qtopen,qtclose,nullioctl },
#endif	QX
#ifdef	V30
	{"ts",	9, "(0,4)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V30
#ifdef	V25
	{"ts",	9, "(0,1)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V25
#ifdef	V20
	{"ts",	9, "(0,0)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V20
#ifdef 	QX
	{"ts",	9, "(0,5)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif 	QX
			tsstrategy,tsopen,tsclose,nullioctl },
#ifdef	V30
	{"gt",	8, "(100,4)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V30
#ifdef	V25
	{"gt",	8, "(100,1)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V25
#ifdef	V20
	{"gt",	8, "(100,0)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	V20
#ifdef 	QX
	{"gt",	8, "(100,5)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif 	QX_
		gtstrategy,gtopen,gtclose,nullioctl },
	{"vb",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT|DEV_CLUST,
			vbstrategy,vbopen,vbclose,nullioctl },
#ifdef	QX
	{"qx",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			qxstrategy,qxopen,qxclose,nullioctl },
#else	not_QX
	{"ex",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			exstrategy,exopen,exclose,nullioctl },
	{"nw",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			nwstrategy,nwopen,nwclose,nullioctl },
#endif	QX
	{"da",	0, 0,				DEV_DART|DEV_CLUST,
			dastrategy,daopen,daclose,nullioctl },
	{"me",	0, "(0,0)@",			DEV_DISK|DEV_AUTOBOOT|DEV_CLUST,
			mestrategy,meopen,nullsys,nullioctl },
#endif	NODRIVERS
	{0, 	0, 0, 			
			0,0,0,0 },
};
