/* 
 * VBUS 68030 Specific, 
 *	test external cache
 */
#include 	"saio.h"
#include 	"sais68k.h"
#include	"../machine/psl.h"
#include	"../machine/m68k.h"
#include	"../machine/trap.h"

#define CACHESIZE	0x10000
#define	PAT1	0xdeadbeef
#define	PAT2	0x55555555
#define	PAT3	0xaaaaaaaa

#define	CLASH(x)	((x) | CACHESIZE)
#define	CWA(x)		((x) + MAXPHYSMEM)
#define	CNWA(x)		((x) + MAXPHYSMEM * 2)

struct tdlong pta_pad[4*((1<<30)/PPTASPACE) + 2]; 
					/* 2 is for quad alignment */
struct tdlong *pta, *ptap0, *ptap1;
struct tdlong ztdlong = {0, 0, 0x7e, 0, 0, 0, 0, 0};
struct rpd rpd = {0, 4*((1<<31)/PPTASPACE), DTLONG, 0};
struct tcr tcr = {1, 0, 0, PS4K, 0, TIA, TIB, 0, 0};

unsigned long cwa_addr = MAXPHYSMEM;		/* cached write allocate */
unsigned long ncwa_addr = MAXPHYSMEM * 2;	/* cached no write allocate */

extern char end;

/*
 * This test assumes tt0 has been setup to map
 * 256 meg Virtual = Real, uncached.
 * Refer to M.V30.s.
 */

main()
{
	unsigned long taddr;

	taddr = ((long)&end + 3) & ~3;		/* long aligned */
	setupmmu();
	twrite(CWA(taddr), PAT1);
	tread(CWA(taddr), PAT1);
	tread(taddr, PAT1);
	twrite(taddr,PAT2);
	tread(taddr,PAT2);
	tread(CWA(taddr), PAT1);
	flush_cache_all();
	tread(CWA(taddr),PAT2);
	twrite(taddr, PAT1);
	twrite(CNWA(CLASH(taddr)), PAT3);
	tread(CLASH(taddr), PAT3);
	tread(CWA(taddr), PAT2);
	tread(CWA(CLASH(taddr)), PAT3);
	tread(CWA(taddr),  PAT1);
	tinvalidate();
}

setupmmu()
{
	register u_long	addr, i;
	register struct tdlong *td;


	/* 
 	 * quadword align pta.
	 */
	pta = (struct tdlong *)(((u_long)pta_pad + 15) & ~15);

	/*
	 * Setup CACHED WRITE ALLOCATE mapping
	 */
	addr = 0;
	i = MAXPHYSMEM / PPTASPACE;
	td = &pta[MAXPHYSMEM / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_limit = btoc(PPTASPACE);
		i -= td->td_limit;
		addr += td->td_limit;
		td++;
	}

	/*
	 * Setup CACHED NO WRITE ALLOCATE mapping
	 */
	addr = 0;
	i = MAXPHYSMEM / PPTASPACE;
	td = &pta[MAXPHYSMEM / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = NO_WA(addr);
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_limit = btoc(PPTASPACE);
		i -= td->td_limit;
		addr += td->td_limit;
		td++;
	}

	/*
	 * initialize root pointer
	 */
	rpd.rp_addr = (unsigned long)pta;
	loadmmu(MMUCRP, &rpd);

	/*
	 * Initialize translation control register
	 */
	loadmmu(MMUTC, &tcr);
}

tinvalidate()
{
}

twrite(addr, pattern)
long *addr;
{
	*addr = pattern;
}

tread(addr, expected)
long *addr;
{
	long actual;

	if ((actual = *addr) != actual)
		printf("READ failed: addr = 0x%x, expected=0x%x, actual=0x%x\n",
				addr, expected, actual);
}
