/* check to see if memory still has a valid copy of a text image */

#include "saio.h"
#include "sais68k.h"
#include <a.out.h>

unsigned int	buf[(4096/4) + 512];

main()
{
	union {
		struct exec exec;
		char dummy[520];
	} X;
#define	x	X.exec
	register int i, io, loc, k, nerr;
	register unsigned int *addrmem;
	register char cp[30];

	printf("\n--- %i Text Overwrite Diagnostic ---\n\n");

loop:	printf("type in text file name: ");
	nerr = 0;
	stripwhite(gets(cp));
	if ((io = open(cp, 0)) < 0)
		goto loop;
	i = read(io, (char *)&x, sizeof x);
	if (i != sizeof x || x.a_magic != 0407 ) {
		printf("file not bootable\n");
		goto loop;
	}
# if	defined(M68020) || defined(M68030)
	x.a_entry &= 0x0FFFFFFF;
# else	M68020
	x.a_entry &= 0x007FFFFF;
# endif	M68020
	addrmem = (unsigned int *)x.a_entry;
	printf("compairing text of file to address %x, lenght %d\n", 
		addrmem, x.a_text);
	for (loc = 0; loc < x.a_text ; loc += 4096) {
		if (read(io, buf, 4096) != 4096) {
			printf("read error\n");
			exit();
		}
		if ((x.a_text - loc + 1) < 4096)
			k = x.a_text - loc + 1;
		else
			k = 4096;
		for (i = 0 ; i < k/sizeof(int) ; i++) {
			if (*addrmem != buf[i]) {
				printf("mismatch: file @%x=%x, mem @%x=%x\n",
					loc+i, buf[i], addrmem, *addrmem);
				nerr++;
			}
			addrmem++;
		}
	}
	if (nerr == 0)
		printf("\nText image preserved\n\n");
	else
		printf("\nText image damaged, %d mismatches\n\n", nerr);
	goto loop;
}
