
/* 
 * VBUS 68030 Specific, 
 *	test external cache
 */
#include 	"saio.h"
#include 	"sais68k.h"
#include	"../machine/psl.h"
#include	"../machine/m68k.h"
#include	"../machine/trap.h"
#include	"../h/types.h"
#include	<ctype.h>
#include	<setjmp.h>

#define CACHESIZE	0x10000
#define LINESIZE	16
#define	CLASH(x)	((u_long)(x) | CACHESIZE)
#define	CWA(x)		((u_long)(x) + MAXPHYSMEM)
#define	CNWA(x)		((u_long)(x) + MAXPHYSMEM * 2)
#define	SAME_LINE(x,y)	((((u_long)(x)%CACHESIZE)/LINESIZE) == \
				(((u_long)(y)%CACHESIZE)/LINESIZE))

struct tdlong pta_pad[4*((1<<30)/PPTASPACE) + 2]; 
					/* 2 is for quad alignment */
struct tdlong *pta, *ptap0, *ptap1;
struct tdlong ztdlong = {0, 0, 0x7e, 0, 0, 0, 0, 0, 0, 0};
struct rpd rpd = {0, 4*((1<<31)/PPTASPACE), DTLONG, 0};
struct tcr tcr = {1, 0, 0, PS4K, 0, TIA, TIB, 0, 0};
struct rpd old_rpd;
	
struct tcr tcoff = {0, 0, 0, PS4K, TIA, TIB, 0, 0, 0};
struct ttr ttoff = {		/* clear translation */
	0,				/* starting at 0 */
	0xff,
	0, 1,			/* enable = off, cache inhibit = off */ 
	0, 1, 			/* both r/w */
	4, 3,			/* fc = 5,6 */
};
struct ttr ttzip = {		/* clear translation */
	0,				/* starting at 0 */
	0xff,
	0, 0,			/* enable = off, cache inhibit = off */ 
	0, 0, 			/* both r/w */
	0, 0,			/* fc =  */
};
struct ttr fc3tt = {		/* system transparent */
	0,			/* starting at 0 */
	0xff,
	1, 1,			/* enable, cache inhibit */ 
	0, 1, 			/* both r/w */
	3, 0,			/* fc = 3 */
};

struct ttr new_tt = {		/* function code 3  transparent */
	0,			/* starting at 0 */
	(MAXPHYSMEM/(1<<24))-1,	/* 256 meg memory */
	1, 1,			/* enable, cache inhibit */ 
	0, 1, 			/* both r/w */
	4, 3,			/* fc = 1xx */
};

extern char end;
u_long taddr, first, last, plast, run_silent, loop_on_errors, testing;
u_long *lptr;
u_short *sptr;
u_char *cptr;
char buf[80];
extern u_long memsize;
jmp_buf	cache;
extern	int (*user_exit)(), dorte;
int cacr = ICACHE_CLEAR | DCACHE_CLEAR;
int trace_cnt = 0, error_cnt = 0;

#ifdef	PROMDIAG
extern int go_no_go;
	p_cache()
#else
int go_no_go = 0;
	main()
#endif
{
	int cache_C_D();
	u_char c;

	printf("\n--- %i Standalone CACHE Diagnostics --- (%s)\n",
					time_str(read_time()) );
	bs_20("");				/* initilize the back space counter */
	/*getmmu(MMUCRP, &old_rpd);	/* save old crp */

	if(setjmp(cache) == '') return(1); /* prepare to return here on ^C */
	user_exit = cache_C_D;
	testing = 0;				/* prevent phony terminate messages */

	if(! go_no_go) {
		printf("\n Run test in silence (verbose off)? (n/y):");
			c = Getchar();
			run_silent = (c == 'Y' || c == 'y')? 1 : 0;
		printf("\n Loop on errors? (n/y):");
			c = Getchar();
			loop_on_errors = (c == 'Y' || c == 'y')? 1 : 0;

		while (1) {
			cacr &= ~(ICACHE_BURST|DCACHE_BURST);
			printf("\n\n Internal Cache control options:");
			disp_cacr();
			printf("\n    0 - Disable all Internal Cache (default)");
			printf("\n    1 - Toggle Instruction Cache (on/off)");
			printf("\n    2 - Toggle Data Cache (on/off)");
			printf("\n    3 - Toggle Write Allocate (on/off)");
			printf("\n    4 - Enable Instruction & Data with Write Allocate");
			printf("\n    \(space, C/R, ESC to exit\)");
			while(1) {
				printf("\n Enter option of choice: ");
				c = Getchar();
				if(c == '0') 		cacr  = ICACHE_CLEAR | DCACHE_CLEAR;
				else if(c == '1') 	cacr ^= (ICACHE_ENABLE | ICACHE_CLEAR);
				else if(c == '2')	cacr ^= (DCACHE_ENABLE | DCACHE_CLEAR);
				else if(c == '3')	cacr ^= DCACHE_WA;
				else if(c == '4')	cacr  = 
									ICACHE_ENABLE|DCACHE_ENABLE|DCACHE_WA;
				else break;
				disp_cacr();
			}
			if(iscntrl(c) || isspace(c)) break;
		}
		if (cacr & (ICACHE_ENABLE | DCACHE_ENABLE) ){
			printf("\n Burst mode enabled(n/y)? ");
			c = Getchar();
			if (c == 'y' || c == 'Y'){
				if (cacr & ICACHE_ENABLE) cacr |= ICACHE_BURST;
				if (cacr & DCACHE_ENABLE) cacr |= DCACHE_BURST;
			}
		}
		disp_cacr();
	} else
		cacr =  ICACHE_ENABLE|DCACHE_ENABLE|DCACHE_WA;

	/*** start test *****/ 
	while (1) {
		testing = 1;
		taddr = ((long)&end + (LINESIZE-1)) & ~(LINESIZE-1);	
		setupmmu(cacr);
		test_physmem();
		flush_all_caches();		/* flush all cache */
		enable_ext_cache();
		test_cache_ram();
		test_flush();
		test_inval();
		test_clash();
		test_wa();
		test_nwa();
		test_wa_align();
		test_nwa_align();
		test_short();
		test_byte();
		test_exec();
		testing = 0;				/* prevent phony terminate messages */
		if(go_no_go) bs_20((error_cnt)? "\r** Failed **":"\r** Passed **");
		resetmmu();
		/* end of test */
		if(go_no_go) return(error_cnt);
		putchar('\n');
	}
}

/********   test and support functions *******************/
setupmmu(cacr)
{
	register u_long	addr, i;
	register struct tdlong *td;

	/* 
 	 * quadword align pta.
	 */
	pta = (struct tdlong *)(((u_long)pta_pad + 15) & ~15);

	/*
	 * map 0 to MAXPHYSMEM as uncached V=R
	 * map all fc3 V=R
	 */

	set_cacr(ICACHE_CLEAR|DCACHE_CLEAR);

	/*
	 * Setup CACHED WRITE ALLOCATE mapping
	 * vaddr MAXPHYSMEM maps to 0. 
	 */
	addr = 0;
	i = btop(MAXPHYSMEM);
	td = &pta[MAXPHYSMEM / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = addr;
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
	 * Setup CACHED NO WRITE ALLOCATE mapping
	 * vaddr (MAXPHYSMEM*2) maps to 0. 
	 */
	addr = 0;
	i = btop(MAXPHYSMEM);
	td = &pta[(MAXPHYSMEM*2) / PPTASPACE];
	while (i > 0) {
		*td = ztdlong;
		td->td_addr = NO_WA(addr);
		td->td_dt = DTPAGE;
		td->td_s = 1;
		td->td_limit = btop(PPTASPACE);
		i -= td->td_limit;
		addr += PPTASPACE;
		td++;
	}

	/*
	 * initialize root pointer
	 */
	tbia();						/* pflusha */
	flush_all_caches();

	rpd.rp_addr = (unsigned long)pta;
	loadmmu(MMUCRP, &rpd);

	loadmmu(MMUTT1, &fc3tt);
	new_tt.tt_ci = 1;			/* disable cache for code */
	loadmmu(MMUTT0, &new_tt);
	/*
	 * Initialize translation control register
	 */
	loadmmu(MMUTC, &tcr);
	set_cacr(cacr);
}

resetmmu()
{
	disable_ext_cache();
	flush_all_caches();				/* flush all cache */
	loadmmu(MMUTC,  &tcoff);		/**/
	loadmmu(MMUTT0, &ttzip);		/* clear & disable tt0 */
	loadmmu(MMUTT1, &ttzip);		/* clear & disable tt1 */

	if(testing)	printf("   ........terminated.\n");
}


test_physmem()
{
	first = taddr;
	last = taddr + CACHESIZE * 2;
	if(go_no_go) bs_20(" physical memory");
	else printf("\n Testing physical memory from 0x%x to 0x%x", first, last);
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, lptr, 0);
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(1, lptr, lptr, 0) && loop_on_errors) {
			twrite(lptr, lptr, 0);
			lptr--;
		}
}


test_cache_ram()
{
	if(go_no_go)bs_20(" cache ram");
	else printf("\n Testing cache ram");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < plast ; lptr++)
		twrite(lptr, lptr, 0);

	/* read cached, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(2, CWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, lptr, 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, ~(u_long)lptr, 0);

	/* read cached, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(3, CWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			lptr--;
		}

	flush_all_caches();		/* flush all cache */
}


test_flush()
{
	if(go_no_go)bs_20(" cache flush");
	else printf("\n Testing cache flush");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < plast ; lptr++)
		twrite(lptr, lptr, 0);

	/* read cached, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(4, CWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, lptr, 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, ~(u_long)lptr, 0);

	/* read cached, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(5, CWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			lptr--;
		}

	flush_all_caches();		/* flush all cache */
	
	/* read cached, should be the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(6, CWA(lptr), ~(u_long)lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			flush_int_cache_single(lptr);
			lptr--;
		}

	flush_all_caches();		/* flush all cache */
}


test_inval()
{
	u_long *tptr;

	if(go_no_go)bs_20(" cache invalidate");
	else 	printf("\n Testing cache invalidate");
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;
	flush_all_caches();		/* flush all cache */
	for (tptr = (u_long *)first ; ((u_long)tptr + 3)<plast ; tptr++)
		twrite(tptr, tptr, 0);

	/* read cached, should be the address */
	for (tptr = (u_long *)first ; ((u_long)tptr + 3)<last ; tptr++)
		if (tread(7, CWA(tptr), tptr, 0) && loop_on_errors) {
			twrite(tptr, tptr, 0);
			tptr--;
		}
	
	/* write phys mem with the address compliment */
	for (tptr = (u_long *)first ; ((u_long)tptr + 3)<last ; tptr++)
		twrite(tptr, ~(long)tptr, 0);

	/* read cached, should be the address */
	for (tptr = (u_long *)first ; ((u_long)tptr + 3)<last ; tptr++)
		if (tread(8, CWA(tptr), tptr, 0) && loop_on_errors) {
			twrite(tptr, ~(long)tptr, 0);
			tptr--;
		}

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++) {
		afcww(lptr, 0);		/* invlidate the line */
		flush_int_cache_single(lptr);
#ifdef	TOOLONG
		for (tptr = (u_long *)lptr ; ((u_long)tptr + 3)<last ; tptr++)
			if (SAME_LINE(lptr, tptr))
				if (tread(9, CWA(tptr), ~tptr, 0) && loop_on_errors) {
					afcww(lptr, 0);		/* invlidate the line */
					flush_int_cache_single(lptr);
					tptr--;
				}
			else
				if (tread(10, CWA(tptr), tptr, 0) && loop_on_errors) {
					afcww(lptr, 0);		/* invlidate the line */
					flush_int_cache_single(lptr);
					tptr--;
				}
#else	TOOLLONG
		if (tread(9, CWA(lptr), ~(u_long)lptr, 0) && loop_on_errors) 
			lptr--;
#endif	TOOLONG
	}

	flush_all_caches();		/* flush all cache */
}


test_clash()
{
	if(go_no_go)bs_20(" cache clash");
	else 	printf("\n Testing cache clash");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < plast ; lptr++)
		twrite(lptr, lptr, 0);

	/* read cached, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(11, CWA(lptr), lptr, 0) && loop_on_errors) {
			lptr--;
		}
	
	/* read cached to cause cache clash, should be the clash address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(12, CWA(CLASH(lptr)), CLASH(lptr), 0) && loop_on_errors) {
			lptr--;
		}

	flush_all_caches();		/* flush all cache */
}


test_wa()
{
	if(go_no_go)bs_20(" write allocate");
	else 	printf("\n Testing write allocate");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < plast ; lptr++)
		twrite(lptr, lptr, 0);

	/* init phys mem with address through CWA */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(CWA(lptr), lptr, 0);

	/* read physical, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(13, lptr, lptr, 0) && loop_on_errors) {
			twrite(lptr, lptr, 0);
			twrite(CWA(lptr), lptr, 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, ~(u_long)lptr, 0);

	/* read cache, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(14, CWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			lptr--;
		}
	
	/* write cached to cause cache clash */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(CWA(CLASH(lptr)), CLASH(lptr), 0);

	/* read physical, should be the CLASH address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(15, CLASH(lptr), CLASH(lptr), 0) && loop_on_errors) {
			twrite(CWA(CLASH(lptr)), CLASH(lptr), 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(CLASH(lptr), ~(CLASH(lptr)), 0);

	/* read cache, should be the CLASH address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(16, CWA(CLASH(lptr)), CLASH(lptr), 0) && loop_on_errors) {
			twrite(CLASH(lptr), ~(CLASH(lptr)), 0);
			lptr--;
		}

	flush_all_caches();		/* flush all cache */
}


test_nwa()
{
	if(go_no_go)bs_20(" non wrt alloc");
	else printf("\n Testing no write allocate");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE;
	plast = taddr + CACHESIZE * 2;

	/* init phys mem with address*/
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < plast ; lptr++)
		twrite(lptr, lptr, 0);

	/* read cache, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(17, CNWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, lptr, 0);
			lptr--;
		}
	
	/* init phys mem with address through CNWA */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(CNWA(lptr), lptr, 0);

	/* read physical, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(18, lptr, lptr, 0) && loop_on_errors) {
			twrite(CNWA(lptr), lptr, 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, ~(u_long)lptr, 0);

	/* read cache, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(19, CNWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			lptr--;
		}
	
	/* write cached to cause cache clash */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(CNWA(CLASH(lptr)), CLASH(lptr), 0);

	/* read physical, should be the CLASH address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(20, CLASH(lptr), CLASH(lptr), 0) && loop_on_errors) {
			twrite(CWA(CLASH(lptr)), CLASH(lptr), 0);
			lptr--;
		}
	
	/* write phys mem with the address compliment */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		twrite(lptr, ~(u_long)lptr, 0);

	/* read cache, should be the address */
	for (lptr = (u_long *)first ; ((u_long)lptr + 3) < last ; lptr++)
		if (tread(21, CNWA(lptr), lptr, 0) && loop_on_errors) {
			twrite(lptr, ~(u_long)lptr, 0);
			lptr--;
		}
	
	flush_all_caches();		/* flush all cache */
}


test_wa_align()
{
	register i;

	if(go_no_go)bs_20(" non-alig'd w/a");
	else printf("\n Testing non-aligned write allocate");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE * 2;

	for (i = 0 ; i < 4 ; i++) {

		/* write CWA with the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			twrite(CWA(lptr), lptr, 0);
	
		/* read physical, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(22, lptr, lptr, 0) && loop_on_errors) {
				twrite(CWA(lptr), lptr, 0);
				lptr--;
			}

		/* read CWA, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(23, CWA(lptr), lptr, 0) && loop_on_errors) {
				twrite(CWA(lptr), lptr, 0);
				lptr--;
			}

		/* read CNWA, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(24, CNWA(lptr), lptr, 0) && loop_on_errors) {
				twrite(CWA(lptr), lptr, 0);
				lptr--;
			}
	}
	flush_all_caches();		/* flush all cache */
}


test_nwa_align()
{
	register i;

	if(go_no_go)bs_20(" non-alig'd no w/a");
	else printf("\n Testing non-aligned no write allocate");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE * 2;

	for (i = 0 ; i < 4 ; i++) {

		/* write CNWA with the address compliment */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			twrite(CNWA(lptr), lptr, 0);
	
		/* read physical, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(25, lptr, lptr, 0) && loop_on_errors) {
				twrite(CNWA(lptr), lptr, 0);
				lptr--;
			}

		/* read CWA, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(26, CWA(lptr), lptr, 0) && loop_on_errors) {
				twrite(CNWA(lptr), lptr, 0);
				lptr--;
			}

		/* read CNWA, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(27, CNWA(lptr), lptr, 0) && loop_on_errors) {
				twrite(CNWA(lptr), lptr, 0);
				lptr--;
			}
	}
	flush_all_caches();		/* flush all cache */
}


test_short()
{
	register i;

	if(go_no_go)bs_20(" non-alig'd wd acc");
	else printf("\n Testing non-aligned word access");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE * 2;

	for (i = 0 ; i < 2 ; i++) {

		/* write CWA with the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+2)<last ; sptr++)
			twrite(CWA(sptr), sptr, 1);
	
		/* read physical, should be the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+2)<last ; sptr++)
			if (tread(28, sptr, sptr, 1) && loop_on_errors) {
				twrite(CWA(sptr), sptr, 1);
				sptr--;
			}

		/* read CWA, should be the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+2)<last ; sptr++)
			if (tread(29, CWA(sptr), sptr, 1) && loop_on_errors) {
				twrite(CWA(sptr), sptr, 1);
				sptr--;
			}

		/* read CNWA, should be the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+2)<last ; sptr++)
			if (tread(30, CNWA(sptr), sptr, 1) && loop_on_errors) {
				twrite(CWA(sptr), sptr, 1);
				sptr--;
			}
	}
	flush_all_caches();		/* flush all cache */
}


test_byte()
{

	if(go_no_go)bs_20("  byte access");
	else printf("\n Testing byte access");
	flush_all_caches();		/* flush all cache */
	first = taddr;
	last = taddr + CACHESIZE * 2;

	/* write CWA with the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		twrite(CWA(cptr), cptr, 2);

	/* read physical, should be the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		if (tread(31, cptr, cptr, 2) && loop_on_errors) {
			twrite(CWA(cptr), cptr, 2);
			cptr--;
		}

	/* read CWA, should be the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		if (tread(32, CWA(cptr), cptr, 2) && loop_on_errors) {
			twrite(CWA(cptr), cptr, 2);
			cptr--;
		}

	/* read CNWA, should be the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		if (tread(33, CNWA(cptr), cptr, 2) && loop_on_errors) {
			twrite(CWA(cptr), cptr, 2);
			cptr--;
		}
	
	flush_all_caches();		/* flush all cache */
}

test_exec()
{
	register i;

	first = taddr;
	last = memsize;

	if(! go_no_go) printf("\n Execute test from 0x%x to 0x%x", first, last);

	flush_all_caches();
	new_tt.tt_ci = 0;		/* enable cache for code */
	loadmmu(MMUTT0,&new_tt);

	if(go_no_go) bs_20(" Exec: long access");
	else printf("\n   Test long access. ");

	for (i = 0 ; i < 4 ; i++) {
		/* write CWA with the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			twrite(CWA(lptr), lptr, 0);

		/* read CWA, should be the address */
		for (lptr=(u_long *)(first+i) ; ((u_long)lptr+3)<last ; lptr++)
			if (tread(34, CWA(lptr), lptr, 0) && loop_on_errors) {
				twrite(CWA(lptr), lptr, 0);
				lptr--;
			}
	}

	if(go_no_go)bs_20(" Exec: short access");
	else 	printf("\n   Test short access. ");
	for (i = 0 ; i < 2 ; i++) {
		/* write CWA with the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+1)<last ; sptr++)
			twrite(CWA(sptr), sptr, 1);

		/* read CWA, should be the address */
		for (sptr=(u_short *)(first+i) ;((u_long)sptr+1)<last ; sptr++)
			if (tread(35, CWA(sptr), sptr, 1) && loop_on_errors) {
				twrite(CWA(sptr), sptr, 1);
				sptr--;
			}
	}

	if(go_no_go)bs_20(" Exec: byte access");
	else 	printf("\n   Test byte access.  ");
	/* write CWA with the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		twrite(CWA(cptr), cptr, 2);

	/* read CWA, should be the address */
	for (cptr=(u_char *)first ; (u_long)cptr < last ; cptr++)
		if (tread(36, CWA(cptr), cptr, 2) && loop_on_errors) {
			twrite(CWA(cptr), cptr, 2);
			cptr--;
		}
}

twrite(addr, pattern, dsize)
{
	if (dsize == 0)
		*(u_long *)addr = pattern;
	else if (dsize == 1)
		*(u_short *)addr = pattern;
	else
		*(u_char *)addr = pattern;
}

tread(spot, addr, pattern, dsize)
{
	register cacr;
	char *ds, c;
	u_long actual;

	if (c = getlocal()) {
		resetmmu();
		longjmp(cache, c);
	}
	if (dsize == 0) {
		ds = "LONG";
		actual = *(u_long *)addr;
	} else if (dsize == 1) {
		ds = "SHORT";
		actual = *(u_short *)addr;
		pattern &= 0x0000ffff;
	} else {
		ds = "BYTE";
		actual = *(u_char *)addr;
		pattern &= 0x000000ff;
	}

	if (actual == pattern) return(0);
	
	if (! (run_silent))
		printf("\n%s read(%d) failed: addr=0x%x, exp=0x%x, act=0x%x",
			ds, spot, addr, pattern, actual);
    return(++error_cnt);
}

Getchar()
{
	register char buf[2];
	register char c;

	if(go_no_go)
		c = getlocal();
	else
		c = wgetlocal();
	if( isspace(c) ) return(c);
	else if(c == '' || c == ''){
		resetmmu();
		buf[0] = c;
		buf[1] = '\0';
		(* user_exit)(buf);
	}
	putchar(c);
	return(c);
}

cache_C_D(buf)
char *buf;
{
	register char c;
	
	_splx(0x2700);
	dorte = 0;				/* disable interrupts */
	rupt_disable();

	c = buf[strlen(buf)-1];
	printf("^%c\n",'A' + (c & 0x1f) -1);

	while( getlocal() );	/* flush the buffer */
	if (c == '') {		/* if ^D */
		longjmp(cache, c);
	}
	else if( c == '') {	/* must be ^C */
		putchar('');
		longjmp(cache, c); 	
	}
	else printf("Hey! What the hell?\n");
	longjmp(cache,c);
}

disp_cacr()
{
	printf("\n CACR = %s%s%s%s%s\n",
				(cacr & ICACHE_ENABLE)? "ICACHE_ENABLE " : "",
				(cacr & ICACHE_CLEAR)? "ICACHE_CLEAR  " : "",
				(cacr & DCACHE_ENABLE)? "DCACHE_ENABLE " : "",
				(cacr & DCACHE_CLEAR)? "DCACHE_CLEAR " : "",
				(cacr & DCACHE_WA)? "DCACHE_WA " : "");
	if (cacr & (DCACHE_BURST | ICACHE_BURST) ) {
		printf("       ");
		if(cacr & ICACHE_BURST) printf("ICACHE_BURST ");
		if(cacr & DCACHE_BURST) printf("DCACHE_BURST");
		putchar('\n');
	}
}

/*************************   EOF ************************/	
