/*
 * boot: main routine for boot proms.
 */
#include "saio.h"
#include "sais68k.h"
#include "../h/reboot.h"
#include <a.out.h>
#include "nvram.QX.h"

extern int	topmem;
extern int	howto;
extern int	devtp;
extern char 	*sboot;
extern char	*arguments;
extern int	autoboot;
extern int	dorte;
extern int	lsflag;

#ifdef	M68020
#ifdef	M68025
#define WFACTOR		800000
#else	M68025
#define WFACTOR		400000
#endif	M68025
#else	M68020
#define WFACTOR		100000
#endif	M68020
#define WAITAUTO	30*WFACTOR	/* seconds to wait before AUTOBOOT */
#define WAITREBO	30*WFACTOR	/* seconds to wait before AUTOREBOOT */

main()
{
	register int io, c, lastc;
	register struct devsw *ds = devsw;
	register int retry = 0;
	register int i, start;
	register char *p, *q;
	register char *line = (char *)LINEBUF;
#ifdef	VBUS
	char		*vbarg = "VBNUM=0";

	vbarg[6] += vbnum;
	DELAY(6000);
	if ((howto & RB_LOGO) && topmem)
		printf("%mM\n", topmem);
	if (vbnum != 0)
		printf("Cluster Node %d\n", vbnum);
	else
		printf("Server Node\n");
#endif	VBUS

	if (howto & RB_LOGO) {
		printf("\n\n\n\n\n\n\n\
        iii\n\
        iii\n\
    ssss   ssss \n\
   sssss   sssss\n\
   sssss   sssss\n\
   sssss       \n\
   sssssssssssss\n\
           sssss\n\
   sssss   sssss       Integrated Solutions, an NBI Company.\n\
   sssss   sssss       Copyright (c) 1987, 1988.\n\
    ssss   ssss        %i boot: %s\n\n", DATE);
	} else
		printf("Integrated Solutions %i boot\n");

	for (;;) {
	    bzero(line, LINELEN);
	    lsflag = 0;
	    printf(": ");
	    if (howto & RB_ASKNAME) {
		/*
		 * poll for the first character. If nothing is typed in WAITAUTO
		 * secs and this is the first prompt then start auto boot 
		 * procedure.
		 */
	   	for ( i=WAITAUTO; i > 0 ; i-- )
			if (line[0] = getlocal())
				break;
		if ( i==0 && !retry ) {
    bootauto:		printf("AUTOBOOT: ");
			/*
			 * loop through device switch, which is aranged in boot
			 * priority, and try to boot from each device which has
			 * a boot file specified.
			 */
			howto &= ~RB_SINGLE;	/* timeout asknames go multi */
			for (ds = devsw; ds->dv_name; ds++)
			    if (ds->dv_flags & DEV_AUTOBOOT) {
				p = line;
				q = ds->dv_name;
				while (*q) *p++ = *q++;
				q = ds->dv_bootf;
				while (*q) *p++ = *q++;
				*p = 0;
				printf("%s",line);
				autoboot = 1;
				if ((start = copyunix(line)))
					goto doboot;
				autoboot = 0;
				for (q=line;*q;q++)
					printf("\b \b");
			    }
			printf(" can't find bootable file\n: ");
	    		bzero(line, LINELEN);
			i = 0;
		} 
    manual:	retry++;
		howto |= RB_SINGLE;		/* asknames go single */

    loop:	if (i == 0 || line[0]=='\b' || line[0]=='')
			while ((line[0] = getlocal()) == 0)
				;
		if (line[0] == 0x04)
			exit();
		else if (line[0] == '\r' || line[0] == '\n') {
			putchar('\n');
			putchar('\r');
			continue;
		} else if (line[0] == 'S') {
			srecord();
			i = 0;
			goto loop;
		}
		putchar(line[0]);
		getsi(line, 1);

		/* 
		 * Look at the first character:
		 *	#address val			open/modify long access
		 *	$address val			open/modify word access
		 *	%address val			open/modify byte access
#ifdef	VQX
		 *	&address val			open/modify byte nvram
#endif	VQX
		 *	!				toggle interrupt enable
		 *	<dev(unit,part)file(args)	load image
		 *	>address			jump to location
		 *	@					autoboot
		 *	?				list directory
		 *	~				enter transparent mode
		 *					~. to exit
		 *	else load and execute "dev(unit,partition)file(args)".
		 */
		striplwhite(line);
		zerowhite(line);
		switch (line[0]) {
		    case 0:
			continue;

		    case '#':
			dobug(line+1,sizeof(long));
			break;

		    case '$':
			dobug(line+1,sizeof(short));
			break;

		    case '%':
			dobug(line+1,sizeof(char));
			break;

#ifdef	VQX
		    case '&':
			nvram(line+1,sizeof(char));
			break;
#endif	VQX
		    case '<':
			if ((start = copyunix(line+1)))
				printf("loaded\n");
			break;

		    case '>':
			if ((start = gethex(line+1)) != -1) {
				printf("jumping to %x\n",start);
				goto doboot;
			}
			break;

		    case '?':
			lsflag = 1;
			for (p = line+1; *p ; p++)
				;
			*p++ = '/'; *p++ = '.' ; *p++ = 0;
			io = open(line+1, 0);
			close(io);
			break;

		    case '@':
	    		printf(": ");
			goto bootauto;

		    case '!':
			if (dorte) {
				_splx(0x2700);
				dorte = 0;
				printf("interrupts disabled\n");
			} else {
				printf("interrupts enabled\n");
				dorte = 1;
				_splx(0x2000);
			}
			break;

		    case '{':
			/* hsmem loop forever*/
			printf("Infinite HS memory loop\n");
			chkmem();
			break;
		    case '}':
			/* shared memory loop forever */
			printf("Infinite SHARED memory loop\n");
			shdmem();
			break;
		    case '~':
			lastc = 0;
			for (;;) {
			    if ( c = getlocal() ) {
				if ( lastc == '~' && c == '.') {
					printf(".\nClosed connection.\n");
					break;
				} else if (lastc == '\r' && c == '~')
			        	wputlocal(lastc = c);
				else {
					wputremote(c);
					lastc = (c == '\r') ? c : 0;
				}
			    }
			    if ( c = getremote() )
			    	wputlocal(c);
			}
			break;

		    default:
			if ((start = copyunix(line)))
				goto doboot;
		}
	    } else {
		/*
		 * poll for the first character. If nothing is typed in WAITREBO
		 * secs then autoreboot from specified devtp.
		 */
	   	for ( i=WAITREBO; i > 0 ; i-- )
			if (line[0] = getlocal())
				goto manual;
		for (ds = devsw ; ds->dv_name ; ds++)
			if (major(ds->dv_kermajmin) == major(devtp))
				break;
		if (!ds->dv_name)
			goto autoerr;
		p = line;
		q = ds->dv_name;
		while (*p++ = *q++) ;
		*(p-1) = '(';
		*p++ = '0' + (minor(devtp) >> 3);
		*p++ = ',';
		*p++ = '0' + (minor(devtp) & 0x7);
		*p++ = ')';
		q = ds->dv_bootf;
		while (*q++ != ')') ;
		while (*p++ = *q++) ;
		printf("AUTOREBOOT: %s",line);
		autoboot = 1;
		if ((start = copyunix(line)))
			goto doboot;
		autoboot = 0;
    autoerr:	howto |= RB_ASKNAME;
		printf(" can't find auto reboot kernel\n");
	    }
	}

doboot:	
#ifdef	VBUS
	addarg(vbarg);
#endif	VBUS
	booty(start);
}

/*ARGSUSED*/
copyunix(cp)
	register char *cp;
{
	union {				/* KLUDGE: for sm block transfer */
		struct exec exec;
		char dummy[520];
	} X;
#define	x	X.exec
	register int i, io;
	register char *addr;

	if ((io = open(cp, 0)) < 0)
		goto ret0;
	i = read(io, (char *)&x, sizeof x);
	if (i != sizeof x || x.a_magic != 0407) {
		printf("file not bootable\n");
		goto ret0;
	}
	printf("%d", x.a_text);
	x.a_entry &= 0x0FFFFFFF;
	addr = (char *)x.a_entry;
	if (addr+(x.a_text+x.a_data+x.a_bss) >= sboot)
		goto nomem;
	if (read(io, addr, x.a_text) != x.a_text)
		goto shread;
	addr += x.a_text;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
	bzero(addr, x.a_bss);
	devtp = makedev(major(devsw[iob[io-3].i_ino.i_dev].dv_kermajmin),
		(iob[io-3].i_unit << 3 ) | (iob[io-3].i_fpart & 0x7) );
	close(io);
	printf(" start 0x%x", x.a_entry);
	autoboot = 0;
	printf("\n");
	if (doargs()) {
		close(io);
		return(x.a_entry);
	}
	goto ret0;

shread:	printf("short read\n");
	goto ret0;

nomem:	printf("more memory needed to load image\n");
ret0:	close(io);
	return(0);
}

doargs()
{
	register char	*p = arguments;
	register char	*t;
	register struct devsw *dp;
	register char	c;

	if (p == NULL)
		return (1);
	if (*p == '(')
		p++;
	for (t=p ; *t ; t++)
		if (*t == '=' || *t == ')')
			break;
	if (*t == '=') {
		*t++='\0';
		if (strcmp(p,"root"))
			goto bad;
		p = t;
		t = &p[2];
		c = *t;
		*t = '\0';
		for (dp = devsw; dp->dv_name; dp++)
			if (!strcmp(p, dp->dv_name))
				break;
		if (!dp->dv_name)
			goto bad;
		*t=c;
		devtp = makedev(major(dp->dv_kermajmin),
			(ctoh(t[0])<<3)+(ctoh(t[1])-0xa));
		return (1);
	}

bad:	printf("bad argument\n"); 
	return (0);
}

dobug(cp, size)
	register char *cp;
	register int size;
{
	register int c, n, num, k, count;
	register unsigned char *loc;

	if ((num = gethex(cp)) == -1) {
		printf("invalid address\n");
		return;
	}
	loc = (unsigned char *)num;
	while (*cp)
		cp++;
	count = 0;
	cp++;
	if (*cp) {
		if ((n = gethex(cp)) == -1) {
			printf("invalid value\n");
			return;
		}
		count = 1;
		c = '\r';
	}
	while (1) {
	    DELAY(3000);		/* wait for GIP to scroll */
	    if (count == 0) {
		if (size == sizeof(char))
			printf("%x| %x  ", loc, *loc);
		else if (size == sizeof(short))
			printf("%x: %x  ", loc, *(unsigned short *)loc);
		else 
			printf("%x; %x  ", loc, *(unsigned long *)loc);
		n = count = 0;
		while (c = getchar())
			if ((k = ctoh(c)) == -1)
				break;
			else {
				count++;
				n = n * 16 + k;
			}
	    }
	    if (c == '\r' || c == '\n' || c == '\\') {
		if (count) {
	    		DELAY(3000);		/* wait for GIP to scroll */
			if (size == sizeof(char))
				*loc = n;
			else if (size == sizeof(short))
				*(unsigned short *)loc = n;
			else
				*(unsigned long *)loc = n;
		}
		if (c == '\r')
			return;
		else if (c == '\\') {
			printf("\n");
			loc -= size;
		} else
			loc += size;
	    } else
		printf("bad value\n");
	    count = 0;
	}
}

#ifdef	VBUS
addarg(s)
	register char *s;
{
	register char *p = (char *)LINEBUF, *q = (char *)0;
	register int n = LINELEN - strlen(s) - 2;

	while (--n)
		if (*p++)
			q = p;
	if (q  &&  q != p)
		strcpy(q + 1, s);
}

shdmem()
{
}

#endif	VBUS

srecord()
{
#define	SRECLEN	200
	static char record[SRECLEN];
	register char *rp = record, *erp, c;
	register unsigned char *address;
	register int bc, sum, i, k;

	*rp++ = 'S';
	erp = &record[SRECLEN];
	while (c = wgetlocal())
		if (c == '\n' || c == '\r')
			break;
		else {
			if (rp > erp) {
				printf("S record too long\n");
				return;
			}
			*rp++ = c;
		}
	*rp = 0;

	switch (record[1]) {
	    case '0':			/* sign-on record */
		return;

	    case '7':			/* 8 character end-of-file record */
	    case '8':			/* 6 character end-of-file record */
	    case '9':			/* 4 character end-of-file record */
		k = ("0000000864"[record[1]&0x0F])&0x0F;
		for (address = 0, i = 0; i < k; i++) {
			if (ctoh(record[4+i]) == -1)
				goto bads;
			address = (unsigned char *)
				((((int)address) << 4) | ctoh(record[4+i]));
		}
		printf("jumping to %x\n", address);
		booty(address);
		break;

	    case '1':			/* 4 character address data record */
	    case '2':			/* 6 character address data record */
	    case '3':			/* 8 character address data record */
		if (ctoh(record[2]) == -1 || ctoh(record[3]) == -1)
			goto bads;
		bc = (ctoh(record[2]) << 4) | ctoh(record[3]);
		erp = &record[bc*2 + 2 + 2];

		k = ("0468"[record[1]&0x0F])&0x0F;
		for (address = 0, i = 0; i < k; i++) {
			if (ctoh(record[4+i]) == -1)
				goto bads;
			address = (unsigned char *)
				((((int)address) << 4) | ctoh(record[4+i]));
		}

		for (sum = 0, rp = &record[2]; rp < erp; rp += 2) {
			if (ctoh(*rp) == -1 || ctoh(*(rp+1)) == -1)
				goto bads;
			sum += (ctoh(*rp) << 4) | ctoh(*(rp+1));
		}
/* printf("address %x bc %x sum %x\n", address, bc, sum); /**/

		if ((~sum) & 0xFF) {
			printf("S record checksum error\n");
			return;
		}

		erp -= 2;
		rp = &record[((record[1]&0x0F)*2 + 2 + 4)];
		for (; rp < erp; rp += 2)
			*address++ = (ctoh(*rp) << 4) | ctoh(*(rp+1));
		return;
	}
bads:	printf("S record, illegal character\n");
}

#ifdef	VQX

nvram(cp)
	register char *cp;
{
	register int c, n, num, k, count;
	register unsigned char loc;
	static unsigned char nv_array[sizeof(struct nv_ram)];
	struct nv_ram	*nv_ram = nv_array;

	if (*cp == 's') {
		getram(nv_array);
		printf("ethernet address: %x:%x:%x:%x:%x:%x	(offset 0-5)\n",
		    nv_ram->enet_addr[0],
		    nv_ram->enet_addr[1],
		    nv_ram->enet_addr[2],
		    nv_ram->enet_addr[3],
		    nv_ram->enet_addr[4],
		    nv_ram->enet_addr[5]);
		printf("cpu number:       %d		(offset %2d)\n",
		    nv_ram->cpu_num, (int)&nv_ram->cpu_num-(int)nv_ram);
		printf("checksum:         0x%x		(offset %2d)\n",
		    nv_ram->chksum, (int)&nv_ram->chksum-(int)nv_ram);
		return;
	}
	if ((num = gethex(cp)) == -1) {
		printf("invalid address\n");
		return;
	}
	loc = num;
	while (*cp)
		cp++;
	count = 0;
	cp++;
	if (*cp) {
		if ((n = gethex(cp)) == -1) {
			printf("invalid value\n");
			return;
		}
		count = 1;
		c = '\r';
	}

	getram(nv_array);
	while (1) {
	    DELAY(3000);		/* wait for GIP to scroll */
	    if (count == 0) {
		getram(nv_array);
		printf("%x| %x  ", loc, nv_array[loc]);
		n = count = 0;
		while (c = getchar())
			if ((k = ctoh(c)) == -1)
				break;
			else {
				count++;
				n = n * 16 + k;
			}
	    }
	    if (c == '\r' || c == '\n' || c == '\\') {
		if (count) {
			nv_array[loc] = n;
			modram(nv_array, loc, n);
		}
		if (c == '\r')
			return;
		else if (c == '\\') {
			printf("\n");
			loc = (loc > 0 ? loc-1 : 0);
		} else
			loc = (loc >= sizeof(nv_array)-1 ?
			    sizeof(nv_array)-1 : loc+1);
	    } else
		printf("bad value\n");
	    count = 0;
	}
}

modram(nv_array, i, n)
	unsigned char	*nv_array;
	int             i;
	unsigned char   n;
{
	unsigned char   cksum;

	nv_array[i] = n;
	cksum = 0;
	for (i = 0; i < sizeof(struct nv_ram)-1; ++i)
		cksum += nv_array[i];
	nv_array[sizeof(struct nv_ram)-1] = cksum;
	putram(nv_array);
}
#endif	VQX
