
/*
 * boot: main routine for boot proms.
 */
#include "saio.h"
#include "sais68k.h"
#include "../h/reboot.h"
#include <a.out.h>

extern int	ignore_intr, topmem,	howto, devtp, dorte;
extern char 	*sboot, *arguments;
extern int	autoboot, lsflag;
extern	int (*user_exit)();
#ifdef	V30
extern short scr;
extern	int	enter_debug();
#endif	V30

#ifdef	M68020
#ifdef	M68025
#define WFACTOR		800000
#else	M68025
#define WFACTOR		400000
#endif	M68025
#else	M68020
#define WFACTOR		100000
#endif	M68020
#define WAITAUTO	30*WFACTOR	/* seconds to wait before AUTOBOOT */
#define WAITREBO	30*WFACTOR	/* seconds to wait before AUTOREBOOT */

main()
{
	register int io, c, lastc;
	register struct devsw *ds = devsw;
	register int retry = 0;
	register int i, start;
	register char *p, *q;
	register char *line = (char *)LINEBUF;
	static	 char *last_line[LINELEN];
#ifdef	VBUS
	char		*vbarg = "VBNUM=0";

	vbarg[6] += vbnum;
	DELAY(6000);
#ifdef V30
	putchar('\n');
#endif V30
	if ((howto & RB_LOGO) && topmem)
		printf("%mM\n", topmem);
	if (vbnum != 0)
		printf("Cluster Node %d\n", vbnum);
	else
		printf("Server Node\n");
#endif	VBUS

	if (howto & RB_LOGO) {
		printf("\n\n\n\n\n\n\
        iii\n\
        iii\n\
    ssss   ssss \n\
   sssss   sssss\n\
   sssss   sssss\n\
   sssss       \n\
   sssssssssssss\n\
           sssss\n\
   sssss   sssss       Integrated Solutions, an NBI Company.\n\
   sssss   sssss       Copyright (c) 1987, 1988.\n\
    ssss   ssss        %i boot: %s\n", DATE);
#ifdef	V30
	printf("\
      sssssss          Board REV: %X%s%s%s\n\n", afcrb(BD_HW_VER), 
		((afcrb(BD_FUNC_LEV) & BD_FUNC_16MHZ) ?", 16 Mhz" :", 25 Mhz"),
		((afcrb(BD_FUNC_LEV) & BD_FUNC_VSB) ?", VSB" :", PVSB"),
		((afcrb(BD_FUNC_LEV) & BD_FUNC_CACHE_BURST) ?", cache burst" :"")
	);
#else
	printf("      sssssss\n");
#endif	V30
	} else
		printf("Integrated Solutions %i boot");


/**/
	/* last_line[0] = '\0';
     */
	for (;;) {
		user_exit = 0;
	    bzero(line, LINELEN);
	    lsflag = 0;
	    printf("\n: ");
	    if (howto & RB_ASKNAME) {
		/*
		 * poll for the first character. If nothing is typed in WAITAUTO
		 * secs and this is the first prompt then start auto boot 
		 * procedure.
		 */
	   	for ( i=WAITAUTO; i > 0 ; i-- )
			if (line[0] = getlocal())
				break;
		if ( i==0 && !retry ) {
bootauto:
			printf("AUTOBOOT: ");
			/*
			 * loop through device switch, which is aranged in boot
			 * priority, and try to boot from each device which has
			 * a boot file specified.
			 */
			howto &= ~RB_SINGLE;	/* timeout asknames go multi */
#ifdef	V30
			nvram_boot();
#endif	V30
			for (ds = devsw; ds->dv_name; ds++)
			    if (ds->dv_flags & DEV_AUTOBOOT) {
				p = line;
				q = ds->dv_name;
				while (*q) *p++ = *q++;
				q = ds->dv_bootf;
				while (*q) *p++ = *q++;
				*p = 0;
				printf("%s",line);
				autoboot = 1;
				if ((start = copyunix(line)))
					goto doboot;
				autoboot = 0;
				for (q=line;*q;q++)
					printf("\b \b");
			    }
			printf(" can't find bootable file\n: ");
	    		bzero(line, LINELEN);
			i = 0;
		} 
	manual:	retry++;
		howto |= RB_SINGLE;		/* asknames go single */

	loop:	if (i == 0 || line[0]=='\b' || line[0]=='')
			while ((line[0] = getlocal()) == 0)
				;
		if (line[0] == '')
			exit();
		else if (line[0] == '\r' || line[0] == '\n') {
			putchar('\n');	putchar('\r');
			continue;
		} else if (line[0] == 'S') {
			srecord();
			i = 0;
			goto loop;
		}
		putchar(line[0]);
		getsi(line, 1);
		striplwhite(line);

		if(line[0] == '.') {  	/* allow a vi like repeat command */
			strcpy(line,last_line);
			printf("%s\n",line);
		} else {
			strcpy(last_line,line);
		}

		/* 
		 * Look at the first character:
		 *	h     		Help, display command list
#ifdef	V30
		 *	|			PROM diagnostic routines
		 *	^       		toggle external cache on/off
#endif	V30
		 *	# address val		open/modify long access
		 *	$ address val		open/modify word access
		 *	% address val		open/modify byte access
		 *	* address length val	open/modify long block access
		 *	= address length val	open/modify word block access
		 *	+ address length val	open/modify byte block access 
#if	(defined(QX) || (defined(V30)
		 *	& address val		open/modify byte nvram
#endif	(defined(QX) || (defined(V30)
		 *	!			toggle interrupt enable
		 *	< dev(unit,part)file(args)  load image
		 *	> address   		jump to location ie (0x8000)
		 *	@			autoboot
		 *	?			list device directory
		 *	~			enter transparent mode
		 *	~.			to exit
		 *	.			repeat last command
		 *	else load and execute "dev(unit,partition)file(args)".
		 */
		zerowhite(line);
		switch (line[0]) {
		    case 0:
			continue;

		    case 'h':		/* display command list */
			dsp_cmdlist();
			break;
#ifdef	V30
		    case '^':		/*  toggle external cache on/off */
			tog_ext_cache();
			printf("\nExternal cache %sabled",
									(scr & SCR_CACHE_ENAB)? "en" : "dis");
			break;
		    case '|':	 	/* call PROM diagnostic routines */
#ifdef	PROMDIAG
			prom_diags();
#else
			enter_debug();
#endif	PROMDIAG
			break;
#endif	V30
		    case '#':
		    case '*':		/* '*' is the block version */
			dobug(line,sizeof(long));
			break;

		    case '$':
		    case '=':		/* '=' is the block version  */
			dobug(line,sizeof(short));
			break;

		    case '%':
		    case '+':		/* '+' is the block version */
			dobug(line,sizeof(char));
			break;

#if	(defined(QX) || defined(V30))
		    case '&':
			if(nvram(line+1,sizeof(char)) == '@')
                { printf(": ");	goto bootauto; }
			break;
#endif	(defined(QX) || defined(V30))
		    case '<':
			if ((start = copyunix(line+1)))
				printf("loaded");
			break;

		    case '>':
			if ((start = gethex(line+1)) != -1) {
				start = (start) ? start: 0x8000;
				printf("jumping to %x",start);
				goto doboot;
			}
			break;

		    case '?':
			lsflag = 1;
			for (p = line+1; *p ; p++)
				;
			*p++ = '/'; *p++ = '.' ; *p++ = 0;
			io = open(line+1, 0);
			close(io);
			break;

		    case '@':
	    		printf(": ");
				goto bootauto;

		    case '!':
			if (dorte) {
#ifdef	V30
				rupt_disable();
				vme_rupt_disable();
#endif	V30				
				_splx(0x2700);
				dorte = 0;
				printf("interrupts disabled");
			} else {
				dorte = 1;
				printf("interrupts enabled");
				_splx(0x2000);
#ifdef	V30
				ignore_intr = 1;		/* ignore the first interrupt */
				rupt_enable();			/* enable on board intrpts also */
				ignore_intr = 0;		/* just in case, to accept the rest */
				vme_rupt_enable();		/* set the bit in BSR */
#endif	V30				
			}
			break;

		    case '~':
			lastc = 0;
			for (;;) {
			    if ( c = getlocal() ) {
				if ( lastc == '~' && c == '.') {
					printf(".\nClosed connection.");
					break;
				} else if (lastc == '\r' && c == '~')
			       	wputlocal(lastc = c);
				else {
					wputremote(c);
					lastc = (c == '\r') ? c : 0;
				}
			}
			if ( c = getremote() )
			    	wputlocal(c);
			}
			break;

		    default:
			if ((start = copyunix(line)))
				goto doboot;
			else	printf("\nIf you need HELP press \"h\" at the prompt.");
 		}
	    } else {
			/*
			 * poll for the first character. If nothing is typed in WAITREBO
			 * secs then auto-reboot from specified devtp.
			 */
		   	for ( i=WAITREBO; i > 0 ; i-- )
				if (line[0] = getlocal())
					goto manual;
#ifdef	V30
			nvram_boot();
#endif	V30
			for (ds = devsw ; ds->dv_name ; ds++)
				if (major(ds->dv_kermajmin) == major(devtp))
					break;
			if (!ds->dv_name)
				goto autoerr;
			p = line;
			q = ds->dv_name;
			while (*p++ = *q++) ;
			*(p-1) = '(';
			*p++ = '0' + (minor(devtp) >> 3);
			*p++ = ',';
			*p++ = '0' + (minor(devtp) & 0x7);
			*p++ = ')';
			q = ds->dv_bootf;
			while (*q++ != ')') ;
			while (*p++ = *q++) ;
			printf("AUTOREBOOT: %s",line);
			autoboot = 1;
			if ((start = copyunix(line)))
				goto doboot;
			autoboot = 0;
	autoerr:
			howto |= RB_ASKNAME;
			printf(" can't find auto reboot kernel");
		}
	}

doboot:	
#ifdef	VBUS
	addarg(vbarg);
#endif	VBUS
	booty(start);
}

/*ARGSUSED*/
copyunix(cp)
	register char *cp;
{
	union {				/* KLUDGE: for sm block transfer */
		struct exec exec;
		char dummy[520];
	} X;
#define	x	X.exec
	register int i, io;
	register char *addr;
#ifdef 	QX_QGRAPH
	register int gflag;

	{
	    extern int conon;

	    gflag = 0;
	    if (conon)
		if ((cp[0]=='q') && (cp[1]=='x')){
		    gflag = 1;
		    vid_stop ();
		}
	}
#endif 	QX_QGRAPH

	if ((io = open(cp, 0)) < 0)
		return(0);
	i = read(io, (char *)&x, sizeof x);
	if (i != sizeof x || x.a_magic != 0407) {
		printf("file not bootable");
		goto ret0;
	}
	printf("%d", x.a_text);
	x.a_entry &= 0x0FFFFFFF;
	addr = (char *)x.a_entry;
	if (addr+(x.a_text+x.a_data+x.a_bss) >= sboot)
		goto nomem;
	if (read(io, addr, x.a_text) != x.a_text)
		goto shread;
	addr += x.a_text;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
	bzero(addr, x.a_bss);
	devtp = makedev(major(devsw[iob[io-3].i_ino.i_dev].dv_kermajmin),
		(iob[io-3].i_unit << 3 ) | (iob[io-3].i_fpart & 0x7) );
	close(io);
	printf(" start 0x%x\n", x.a_entry);
	autoboot = 0;
	if (doargs()) {
#ifdef 	QX_QGRAPH
		if (gflag)
			vid_start ();
#endif  QX_QGRAPH
		close(io);
		return(x.a_entry);
	}
	goto ret0;

shread:	printf("short read");
	goto ret0;

nomem:	printf("more memory needed to load image");
ret0:	close(io);
#ifdef 	QX_QGRAPH
	if (gflag)
		vid_start ();
#endif 	QX_QGRAPH
	return(0);
}

doargs()
{
	register char	*p = arguments;
	register char	*t;
	register struct devsw *dp;
	register char	c;

	if (p == NULL)
		return (1);
	if (*p == '(')
		p++;
	for (t=p ; *t ; t++)
		if (*t == '=' || *t == ')')
			break;
	if (*t == '=') {
		*t++='\0';
		if (strcmp(p,"root"))
			goto bad;
		p = t;
		t = &p[2];
		c = *t;
		*t = '\0';
		for (dp = devsw; dp->dv_name; dp++)
			if (!strcmp(p, dp->dv_name))
				break;
		if (!dp->dv_name)
			goto bad;
		*t=c;
		devtp = makedev(major(dp->dv_kermajmin),
			(ctoh(t[0])<<3)+(ctoh(t[1])-0xa));
		return (1);
	}

bad:	printf("bad argument"); 
	return (0);
}

dobug(cp, size)
	register char *cp;
	register int size;
{
	register int c, n, num, k, count, length, block_mode, block_fill;
	register unsigned char *loc, *ploc;

	
	length = count = block_fill = block_mode = 0;
	c = *cp++;							/* get command character */

	while (! (*cp)) cp++;				/* skip the white space(s) */

	if ((num = gethex(cp)) == -1) {		/* get the starting address */
		printf("invalid address");
		return;
	}
	loc = (unsigned char *)num;
	while (*cp++);						/* skip to the next string */

	if (c == '+' || c == '=' || c == '*') {
		if (*cp)						/* get the length value */
			if ((length = gethex(cp)) == -1) {
				printf("invalid length");
				return;
			}
		block_mode = 1;
		length = (length+size-1)/size;
		c = '\r';
	}

	while (*cp++);						/* skip to the value string */
	if (*cp) {
		if ((n = gethex(cp)) == -1) {
			printf("invalid value");
			return;
		}
		count = 1;
		c = '\r';
	}
	/* if length > 0 we are in block mode
	 * if count there was an initial value given
	 */
	if (block_mode && count) block_fill = 1; 	/* indicate block_fill */
	
	while (1) {
	    if (count == 0) {
		    DELAY(3000);			/* wait for GIP to scroll */
			printf("%8X: ",loc);
			ploc = loc;			/* keep track of the header address */
nxtdata:	if (size == sizeof(char))
				printf("%2x ", *loc);
			else if (size == sizeof(short))
				printf("%4x ", *(unsigned short *)loc);
			else 
				printf("%8x ", *(unsigned long *)loc);

			if (! block_mode) {			/* if not in block mode, get data */
				n = 0;
				while (c = getchar()){	/* looking for data value */
					if ((k = ctoh(c)) == -1) break; 
					else {
						count++;
						n = n * 16 + k;
					}
				}
			}else {
				if( length <= 1 
						|| (loc + size - ploc == 16) 
						|| ((((int)loc+size) & 0xf) == 0)     
						/* it must be time to print ascii */  ) {
					printf("    ");
					do {
						n = *ploc;
						printf("%c",((n > ' ') && (n < 0x7f))? n : '.');
					} while (++ploc < loc+size);
					if((n = getlocal()) == '' || n == '') length = 0;
					/* drop through, update loc & length */
				}else { 
					if( --length > 0) {		/* still more to do */
						loc += size;	
						goto nxtdata;		/* print the nxt data */ 
					}
					length++;
				}
			}
		} /* address, data, are printed  [ and new value entered ] */
		if (c == '\r' || c == '\n' || c == '\\') {
			if (count) {			/* new data is written to address */
		   		if (! block_fill) DELAY(3000);	/* wait for GIP to scroll */
				if (size == sizeof(char) )
					*loc = n;
				else if (size == sizeof(short) )
					*(unsigned short *)loc = n;
				else
					*(unsigned long *)loc = n;
			}
		
			if (--length > 0) {  
				/* if block mode isn't finished? */
				if (getlocal() == '') {   /* should we terminate early? */
					printf("^D");       
					return;			/* ^D */
				}
				if(! block_fill) printf("\n");  /* newline and continue */
				loc += size;	
			} else {				/* if not block mode, are we done ? */
				if (c == '\r') {
					return;
				}
				else if (c == '\\')	{ /* no, go backwards with address */ 
	                printf("\n");
	       			loc -= size;
				}
				else				/* LINEFEED continues forward */
					loc += size;
				count = 0;			/* force interactive mode */
			}
		} else {					/* nothing else is accepted */
			count = 0;
			printf("bad value");
		}
    }
}

#ifdef	VBUS
addarg(s)
	register char *s;
{
	register char *p = (char *)LINEBUF, *q = (char *)0;
	register int n = LINELEN - strlen(s) - 2;

	while (--n)
		if (*p++)
			q = p;
	if (q  &&  q != p)
		strcpy(q + 1, s);
}
#endif	VBUS

srecord()
{
#define	SRECLEN	200
	static char record[SRECLEN];
	register char *rp = record, *erp, c;
	register unsigned char *address;
	register int bc, sum, i, k;

	*rp++ = 'S';
	erp = &record[SRECLEN];
	while (c = wgetlocal())
		if (c == '\n' || c == '\r')
			break;
		else {
			if (rp > erp) {
				printf("S record too long");
				return;
			}
			*rp++ = c;
		}
	*rp = 0;

	switch (record[1]) {
	    case '0':			/* sign-on record */
		return;

	    case '7':			/* 8 character end-of-file record */
	    case '8':			/* 6 character end-of-file record */
	    case '9':			/* 4 character end-of-file record */
		k = ("0000000864"[record[1]&0x0F])&0x0F;
		for (address = 0, i = 0; i < k; i++) {
			if (ctoh(record[4+i]) == -1)
				goto bads;
			address = (unsigned char *)
				((((int)address) << 4) | ctoh(record[4+i]));
		}
		printf("jumping to %x", address);
		booty(address);
		break;

	    case '1':			/* 4 character address data record */
	    case '2':			/* 6 character address data record */
	    case '3':			/* 8 character address data record */
		if (ctoh(record[2]) == -1 || ctoh(record[3]) == -1)
			goto bads;
		bc = (ctoh(record[2]) << 4) | ctoh(record[3]);
		erp = &record[bc*2 + 2 + 2];

		k = ("0468"[record[1]&0x0F])&0x0F;
		for (address = 0, i = 0; i < k; i++) {
			if (ctoh(record[4+i]) == -1)
				goto bads;
			address = (unsigned char *)
				((((int)address) << 4) | ctoh(record[4+i]));
		}

		for (sum = 0, rp = &record[2]; rp < erp; rp += 2) {
			if (ctoh(*rp) == -1 || ctoh(*(rp+1)) == -1)
				goto bads;
			sum += (ctoh(*rp) << 4) | ctoh(*(rp+1));
		}
/* printf("\naddress %x bc %x sum %x", address, bc, sum); /**/

		if ((~sum) & 0xFF) {
			printf("S record checksum error");
			return;
		}

		erp -= 2;
		rp = &record[((record[1]&0x0F)*2 + 2 + 4)];
		for (; rp < erp; rp += 2)
			*address++ = (ctoh(*rp) << 4) | ctoh(*(rp+1));
		return;
	}
bads:	printf("S record, illegal character");
}

#ifdef	QX
#include "./nvram.QX.c"
#endif	QX

/* display the help menu */
dsp_cmdlist()
{
printf("\n\n\th                  Help, display command list");
printf("\n\t# addr [val]       open/[modify] long");
printf("\n\t$ addr [val]       open/[modify] word");
printf("\n\t%% addr [val]       open/[modify] byte");
printf("\n\t* addr len [val]   view/[fill] long block");
printf("\n\t= addr len [val]   view/[fill] word block");
printf("\n\t+ addr len [val]   view/[fill] byte block");
#ifdef	QX
printf("\n\t& addr val         open/modify byte nvram");
#endif	QX
#ifdef	V30
printf("\n\t&                  nvram utilities");
#ifdef	PROMDIAG
printf("\n\t|                  PROM diagnostic routines");
#else
printf("\n\t|                  PROM DEBUG routine, destructive.");
#endif	PROMDIAG
printf("\n\t^                  toggle external cache on/off");
#endif V30
printf("\n\t!                  toggle interrupt enable");
printf("\n\t< dev(unit,part)file(args)    load image");
printf("\n\t> addr             jump to location (default = 0x8000)");
printf("\n\t@                  autoboot");
printf("\n\t?                  list device directory");
printf("\n\t~                  enter transparent mode");
printf("\n\t~.                 to exit transparent mode");
printf("\n\t.                  repeat the last command line");
printf("\n\telse load and execute \"dev(unit,partition)file(args)\".");
}

#ifdef	V30
#include "nvram.30.c"
#endif	V30
