/* 
 * bad144: standalone bad144 mapper. Find bad blocks in media and remap. 
 */

#define BSIZE 512

#include "saio.h"
#include <sys/file.h>

typedef char bool;
#define TRUE		1
#define FALSE		0
#define UPDATE		2
#define DEOF		0	/* end of disk file */

#define BADBLOCK	-1
#define ERROR		-1
#define NOINFO		-1

#define MAX_NBLOCKS 80	/* max blocks at once */

int	forbb;		/* set this to tell driver I/O is for bad blocking */
int	xbad144;	/* executing bad144, driver should disable ECC */
int	xbad144_soft;	/* executing bad144, map soft errors */
int	errno;
int	nblocks;	/* number of blocks at a time */
bool	swrrflag;	/* save/write/read/restore flag */
bool	wrflag;		/* write/read flag */
bool	verify;		/* verify data */
bool	whole;		/* set up information for whole disk */
bool	clear;		/* clear all badblock info */
bool	frstime;	/* flag for first time bad block processiing */
bool	aborted;	/* setall() aborted? */
int	fi;		/* file descriptor for device */
struct iob *io;		/* pointer to standalone io buffer structure */
int	laps;		/* repeat count for whole disk testing */
int	lapcnt;		/* number of laps so far */
int	nblk;		/* number of block */
int	lowblock;	/* starting block number */
int	hiblock;	/* ending block number */
int	nbad;		/* number of bad blocks */
int	nnewbad;	/* number of bad blocks found this time */
char	tybuf[80];	/* buffer for input to program */
char	diskname[80];	/* buffer for disk name */
extern struct dkbad dkbad;	/* bad block info for badstrat */
struct dkbad	bad144;	/* buffer for new bad block info */
struct dkbad	oldbad;	/* buffer for old bad block info */
int	badbn;

char	chbuf[MAX_NBLOCKS*BSIZE];	/* buffer for verification */
char	savebuf[MAX_NBLOCKS*BSIZE];
char	buf2[MAX_NBLOCKS*BSIZE];

daddr_t getbad();

main()
{
	printf("\n--- %i Standalone Bad144 Program ---\n\n");
	xbad144 = 1;

again:
	nnewbad = 0;
	lapcnt = 0;
	getpar();

	if (whole) {			/* set up whole disk info */
		aborted = FALSE;
		while (laps-- != 0 && !aborted) {
			lapcnt++;
			printf("begin lap %d\n", lapcnt);
			if (wrflag || swrrflag)
				setbuf();
			setall();	/* find bad blocks */
			update();
			wrhead();	/* write header info back to disk*/
			printf("end lap %d\n", lapcnt);
			prstat();	/* print job statistic */
			nnewbad = 0;
			frstime = FALSE;
		}
	} else	{			/* update specific block/s */
		update();
		wrhead();		/* write header info back in block 0 */
		prstat();		/* print job statistic */
		nnewbad = 0;
	}
	printf("\n\n");			/* clear out buffer */
	close(fi);
	goto again;
}

getpar()
{
	register int i, bad;
	int option;
	register union bt_bad *bt;

	do {
		printf("device: ");
		gets(diskname);
		fi = open(diskname, 2);
		if (fi < 0) {
			printf("Cannot open %s\n", diskname);
			continue;
		}
		io = &iob[fi-3];
		if (io->i_st.nsect > 0xFF) {
			printf("Bad144 cannot support driver with more than %d sectors per track\n", 0xFF);
			close(fi);
			continue;
		}
		if (io->i_st.ntpc > 0xFF) {
			printf("Bad144 cannot support driver with more than %d track per cylinder\n", 0xFF);
			close(fi);
			continue;
		}
		badbn = io->i_st.ncyl*io->i_st.nspc - io->i_st.nsect;
	} while (fi < 0);
	initdisk();
	while (1) {
		lowblock = 1;
		hiblock = badbn - MAXBADBLK - 1;
		clear = FALSE;
		whole = FALSE;
		printf("\nOptions are\n");
		printf("\t1) Display current bad block information\n");
		printf("\t2) Add bad blocks\n");
		printf("\t3) Do read of disk\n");
		printf("\t4) Do write/read of disk\n");
		printf("\t\t(this option destroys disk contents)\n");
		printf("\t5) Clear all bad block information\n");
		printf("\t\t(this option may cause bad blocks");
		printf(" to 'appear' on disk)\n");
		printf("\t6) Do read/write/read/restore of disk\n");
		printf("\nEnter number of desired option or (CR) to stop: ");
		gets(tybuf);
		if (!tybuf[0]) {
			close(fi);
			_rtt();
		}
		option = getnum(tybuf);
		if (option == 4 || option == 6) {
			printf("Verify data: ");
			gets(tybuf);
			if (tybuf[0] == 'y' || tybuf[0] == 'Y')
				verify = TRUE;
			else
				verify = FALSE;
		}
		if (option == 3 || option == 4 || option == 6) {
			do {
				printf("Number of blocks per access [1-%d]: ", 
					MAX_NBLOCKS);
				gets(tybuf);
				nblocks = getnum(tybuf);
			} while (nblocks < 1 || nblocks > MAX_NBLOCKS);
			printf("Map soft errors? ");
			gets(tybuf);
			if (tybuf[0] == 'y' || tybuf[0] == 'Y')
				xbad144_soft = 1;
			else
				xbad144_soft = 0;
		}

		switch(option) {
		    case 1:
			printinfo();
			break;
	
		    case 2:
			whole = FALSE;
			do {
				register long i;

				if (bad144.bt_csn == 0 || bad144.bt_flag != 0) {
					printf("Enter cartridge serial #");
					printf(" default 1000(10) :");
					gets(tybuf);
					if (tybuf[0])
						bad144.bt_csn = getnum(tybuf);
					else
						bad144.bt_csn = 1000;
				}
				printf("Enter bad block number, or (CR)");
				printf(" if all have been entered: ");
				gets(tybuf);
				if (tybuf[0]) {
					if (nbad+nnewbad >= MAXBADBLK) {
						printf("No more blocks");
						printf(" can be replaced\n");
						break;
					} else if (((i = getnum(tybuf)) > hiblock)
							|| i <= 0) {
						printf("invalid block no\n");
						break;
					}
					(void) addbad(i);
				}
			} while (tybuf[0] != 0);
			return;
					
		    case 3:
			lowblock = getlow();
			hiblock = gethigh();
			whole = TRUE;
			wrflag = FALSE;
			swrrflag = FALSE;
			getlaps();
			return;
	
		    case 4:
			lowblock = getlow();
			hiblock = gethigh();
			whole = TRUE;
			wrflag = TRUE;
			swrrflag = FALSE;
			printf("WARNING: this test destroys disk contents\n");
			printf("Do you want to proceed? (y or n) ");
			gets(tybuf);
			if (*tybuf != 'y' && *tybuf != 'Y')
				break;
			getlaps();
			return;

		    case 5:
			clearall();
			initdisk();
			break;
	
		    case 6:
			lowblock = getlow();
			hiblock = gethigh();
			whole = TRUE;
			wrflag = FALSE;
			swrrflag = TRUE;
			printf("WARNING: this test may destroy the disk\n");
			printf("Do you want to proceed? (y or n) ");
			gets(tybuf);
			if (*tybuf != 'y' && *tybuf != 'Y')
				break;
			getlaps();
			return;

		  default:
			printf("invalid option %c\n", option);
			break;
		}
	}
}

getlaps()
{
	laps = 0;
	printf("Number of laps (0 or CR means forever): ");
	gets(tybuf);
	if (tybuf[0])
		laps = getnum(tybuf);
	if (laps == 0)
		laps = -1;
}
 
getlow()
{
	int lbn;

	while (1) {
		printf("Starting block (default 1): ");
		gets(tybuf);
		if (tybuf[0]) {
			lbn = getnum(tybuf);
			if (lbn < 1 || lbn >= hiblock )
				printf("Illegal block number\n");
			else
				return(lbn);
		} else
			return 1;
	}
}

gethigh()
{
	int hbn;

	while (1) {
		printf("Ending block (default end of disk is %d): ",hiblock);
		gets(tybuf);
		if (tybuf[0]) {
			hbn = getnum(tybuf);
			if (hbn < lowblock || hbn >= hiblock)
				printf("Illegal block number\n");
			else
				return(hbn);
		} else
			return hiblock-1;
	}
}

setall()
{
	register int ntocheck,n;

	for (n = lowblock; n <= hiblock; ) {
		if (getlocal())
			aborted = TRUE;
		if (aborted) {
			nblk = n;
			break;
		}
		ntocheck = n + nblocks > hiblock ? hiblock - n + 1 : nblocks;
		if (((n-lowblock) % (nblocks*100)) == 0)
			printf("%d\r",n);
		if (ntocheck == 1 || pass1(n, ntocheck*BSIZE, 1) == BADBLOCK)
			n = pass2(n, n+ntocheck-1);
		else
			n += nblocks;
	}
}

pass2(lower, upper)
register int lower, upper;
{
	register int n;

	for (n = lower; n <= upper; n++) {
		if (getlocal()) {
			aborted = TRUE;
			break;
		}
		if (pass1(n, BSIZE, (lower == upper) ? 1 : 2) == BADBLOCK) {
			printf("block %d BAD\n", n);
			if ((addbad(n)) == ERROR) {
				aborted = TRUE;
				printf("No more bad blocks can be replaced\n");
			}
			return(n+1);
		}
	}
	return (n);			/* where to pick up with big xfers */
}

pass1(blkno, nchk, pass)		/* check if bad block */
register int blkno, nchk, pass;
{
	register int i = 0;

	forbb = 0;

	lseek(fi, blkno*io->i_st.nbsec, L_SET);

	if (wrflag) {			/* write/read operation */
		if ((pass == 1) && (i = write(fi,chbuf,nchk)) <= 0)
			return BADBLOCK;
    		lseek(fi, blkno*io->i_st.nbsec, L_SET);
		if ((i = read(fi,buf2,nchk)) <= 0) 
			return BADBLOCK;
		i = compbuf(buf2, nchk);	  
	} else if (swrrflag) {		/* save/write/read/restore operation */
		if ((i = read(fi,savebuf,nchk)) > 0) {
		    lseek(fi, blkno*io->i_st.nbsec, L_SET);
		    if ((i = write(fi,chbuf,nchk)) > 0) {
			lseek(fi, blkno*io->i_st.nbsec, L_SET);
			if ((i = read(fi,buf2,nchk)) > 0) 
				if ((i = compbuf(buf2, nchk)) > 0) {
					lseek(fi, blkno*io->i_st.nbsec, L_SET);
					i = write(fi,savebuf,nchk);
				}
		    }
		}
	} else 				/* read operation */
		i = read(fi,buf2,nchk);	 
	  
	if (i <= 0)
		return BADBLOCK;
	else
		return i;
}

compbuf(bptr, nchk)	  /* compare buffer with chbuf */
char *bptr;
register int nchk;
{
	register int *p1,*p2;
	register int n = 0;
	register int nc = nchk / sizeof(int);

	if (!verify)
		return nchk;

	p1 = (int *)bptr;
	p2 = (int *)chbuf;

	for (n = 0; n < nc; n++, p1++, p2++)
		if (*p1 != *p2)
			break;
	if (n*sizeof(int) == nchk)
		return nchk;
	else {
		printf("VERIFY DATA: %d/%d %x != %x\n", 
			n*sizeof(int), nchk, *p1, *p2);
		return BADBLOCK;
	}
}

update()
{
	int compare();

	if (nnewbad) {
		nbad += nnewbad;
		qsort(bad144.bt_bad, nbad, sizeof (struct bt_bad), compare);
		shift(fi,nbad,nbad-nnewbad);
		initbad(nbad);
	}
}

panic(cp)
char *cp;
{
	printf("\nbad144: %s\n", cp);
	close(fi);
	exit();
}

wrhead()
{
	writebad(fi,&bad144);
	close(fi);  		/* close/open to update bb info in driver */
	if ((fi = open(diskname, 2)) < 0) {
		printf("Cannot reopen %s\n", diskname);
		_rtt();
	}
	(void) getbad(fi,&bad144);
	nbad = checkbad(FALSE);
	oldbad = bad144;
}

prstat()
{
	if (whole) {
		printf("checked blocks %d through %d\n", lowblock,
			aborted?nblk-1:hiblock);
		if (wrflag)
			printf("pattern %x%x%x\n",
				chbuf[0]&0xff,chbuf[1]&0xff,chbuf[2]&0xff);
		printf("%d bad blocks this lap\n", nnewbad);
		printf("%d bad block/s on disk\n",nbad);
	} else 
		printf("%d bad block/s updated\n",nnewbad);
}

#define	NPAT 13
static char patterns[NPAT][3] =
	{
		{0xdb, 0x6d, 0xb6},
		{0x6d, 0xb6, 0xdb},
		{0xb6, 0xdb, 0x6d},
		{0x24, 0x92, 0x49},
		{0x92, 0x49, 0x24},
		{0x49, 0x24, 0x92},
		{0x55, 0x55, 0x55},
		{0xaa, 0xaa, 0xaa},
		{0,    0,    0	 },
		{0xff, 0xff, 0xff},
		{0xbe, 0xef, 0xbe},
		{0xfe, 0xed, 0xfe},
		{0x39, 0xce, 0x73},
	};

setbuf()
{
	register int i, j;
	static int counter = -1;

	counter++;
	for (j = 0 ; j < MAX_NBLOCKS; j++)
		for (i = 0; i < BSIZE; i++)
			chbuf[(j*BSIZE) + i] = patterns[counter % NPAT][i % 3];
}

clearall()
{
	register int i;

	bad144.bt_csn = 0;
	bad144.bt_flag = 0;
	bad144.bt_mbz = 0;
	for (i = 0; i < MAXBADBLK; i++) {
		bad144.bt_bad[i].bt_cyl = -1;
		bad144.bt_bad[i].bt_trksec = -1;
	}
	writebad(fi,&bad144);
	nbad = 0;
	printf("Bad block information has been cleared\n\n");
}

initdisk()
{
	register int i;

	(void) getbad(fi,&bad144);
	if ((i = checkbad(TRUE)) == NOINFO) {
		nbad = 0;
		frstime = TRUE;
		initbad(nbad);
	} else {
		nbad = i;
		frstime = FALSE;
	}
	oldbad = bad144;
}

daddr_t
getbad(f, bad)
struct dkbad *bad;
{
	register int i;
	daddr_t sn;
	char msg[80];

	forbb = 1;
	for (i = 0; i < 10; i += 2) {
		sn = badbn+i;
		if (lseek(f, sn*io->i_st.nbsec, L_SET) < 0)
			panic("lseek 1");
		if (read(f, bad, sizeof (*bad)) == sizeof (*bad)) {
			if (i > 0)
				printf("Using bad-sector file %d\n", i/2);
			forbb = 0;
			return(sn);
		}
		printf("bad144: read bad sector file at sn %d", sn);
		forbb = 0;
	}
	panic("can't read bad block info\n");
}

writebad(f, bad)
struct dkbad *bad;
{
	register int i;
	daddr_t sn;

	forbb = 1;
	if (bad->bt_csn == 0 || bad->bt_flag != 0)
		bad->bt_csn = 1000;
	for (i = 0; i < 10; i += 2) {
		sn = badbn+i;
		if (lseek(f, sn*io->i_st.nbsec, L_SET) < 0)
			panic("lseek 2");
		if (write(f, bad, sizeof (*bad)) != sizeof (*bad))
			panic("can't write bad sector info");
	}
	forbb = 0;
	dkbad.bt_csn = 0;
}

checkbad(flag)
register int flag;		/* if first read, info may be invalid */
{
	register int i;
	register struct bt_bad *bt;
	register daddr_t sn, lsn;

	if (bad144.bt_flag != 0) {
		if (flag)
			return NOINFO;
		panic("bad flag in bad-sector table");
	}
	if (bad144.bt_mbz != 0) {
		if (flag)
			return NOINFO;
		panic("bad magic number");
	}
	lsn = 0;
	bt = bad144.bt_bad;
	for (i = 0; i < MAXBADBLK; i++, bt++) {
		register int bad;

		bad = (bt->bt_cyl<<16) + bt->bt_trksec;
		if (bad < 0)
			break;
		if ((bt->bt_cyl >= io->i_st.ncyl) ||
		((bt->bt_trksec >> 8) >= io->i_st.ntpc) ||
		((bt->bt_trksec & 0xff) >= io->i_st.nsect)) {
			if (flag)
				return NOINFO;
			panic("cyl/sect/trk out of range");
		}
		sn = (bt->bt_cyl * io->i_st.ntpc +
		(bt->bt_trksec >> 8)) *
		io->i_st.nsect + (bt->bt_trksec & 0xff);
		if (sn == 0) {
			if (flag)
				return NOINFO;
			panic("invalid bad block entry");
		}
		if (sn < lsn) {
			if (flag)
				return NOINFO;
			panic("bad sector file out of order");
		}
		lsn = sn;
	}
	return i;
}

addbad(sn)
int sn;
{
	register int i;
	
	if ((i = nbad+nnewbad) >= MAXBADBLK)
		return ERROR;
	if (findbk(sn) != ERROR) {
		printf("%d already on badblock list\n",sn);
		return 0;
	}
	bad144.bt_bad[i].bt_cyl = sn / (io->i_st.nsect*io->i_st.ntpc);
	sn %= io->i_st.nsect*io->i_st.ntpc;
	bad144.bt_bad[i].bt_trksec = ((sn/io->i_st.nsect) << 8) + 
					(sn%io->i_st.nsect);
	nnewbad++;
	return 0;
}

compare(b1, b2)
register struct bt_bad *b1, *b2;
{
	if (b1->bt_cyl > b2->bt_cyl)
		return(1);
	if (b1->bt_cyl < b2->bt_cyl)
		return(-1);
	return (b1->bt_trksec - b2->bt_trksec);
}

/*
 * Move the bad sector replacements to make room for the new bad sectors.
 * new is the new number of bad sectors, old is the previous count.
 */
shift(f, new, old)
{
	daddr_t repl;

	/*
	 * First replacement is last sector of second-to-last track.
	 */
	repl = badbn - 1;
	new--; old--;
	while (new >= 0 && new != old) {
		if (old < 0 ||
		compare(&bad144.bt_bad[new], &oldbad.bt_bad[old]) > 0) {
			/*
			 * Insert new replacement here-- copy original
			 * sector if requested and possible,
			 * otherwise write a zero block.
			 */
/*			if (!blkcopy(f, badsn(&bad144.bt_bad[new]), repl - new)) */
				blkzero(f, repl - new);
		} else {
			if (blkcopy(f, repl - old, repl - new) == 0)
			printf( "Can't copy replacement sector %d to %d\n",
				repl-old, repl-new);
			old--;
		}
		new--;
	}
}

/*
 *  Copy disk sector s1 to s2.
 */
blkcopy(f, s1, s2)
daddr_t s1, s2;
{
	static char buf[512];

	forbb = 1;
	if (lseek(f, io->i_st.nbsec * s1, L_SET) < 0)
		panic("lseek 3");
	if (read(f, buf, sizeof (buf)) != sizeof (buf)) {
		forbb = 0;
		return(0);
	}
	if (lseek(f, io->i_st.nbsec * s2, L_SET) < 0)
		panic("lseek 4");
	if (write(f, buf, sizeof (buf)) != sizeof (buf)) {
		printf("bad144: can't write replacement sector %d\n", s2);
		forbb = 0;
		return(0);
	}
	forbb = 0;
	return(1);
}

char zbuf[512];

blkzero(f, sn)
daddr_t sn;
{

	forbb = 1;
	if (lseek(f, io->i_st.nbsec * sn, L_SET) < 0)
		panic("lseek 5");
	if (write(f, zbuf, sizeof (zbuf)) != sizeof (zbuf))
		panic("can't write replacement sector\n");
	forbb = 0;
}

daddr_t
badsn(bt)
register struct bt_bad *bt;
{
	return ((bt->bt_cyl*io->i_st.ntpc + (bt->bt_trksec>>8)) * 
		io->i_st.nsect + (bt->bt_trksec&0xff));
}

findbk(bn)		/* find block given block number bn */ 
register int bn;
{
	register int bad, i;
	register union bt_bad *bt;

	if (frstime)
		return ERROR;
	else {
		bt = bad144.bt_bad;
		for (i = 0; i < MAXBADBLK; i++) {
			bad = (bt->bt_cyl<<16) + bt->bt_trksec;
			if (bad < 0)
				break;
			if (badsn(bt) == bn)
				return bn;
			bt++;
		}
	}
	return ERROR;
}

printinfo()
{
	register int bad, i;
	register struct bt_bad *bt;

	if (frstime)
		printf("No bad block info\n");
	else {
		printf("  Cartridge serial number %d: \n", bad144.bt_csn);
		switch (bad144.bt_flag) {
		    case -1:
			printf("  Alignment cartridge\n");
			break;

		    default:
			printf("  bt_flag: %x\n", bad144.bt_flag);
		    case 0:
			break;
		}
		bt = bad144.bt_bad;
		for (i = 0; i < MAXBADBLK; i++) {
			bad = (bt->bt_cyl<<16) + bt->bt_trksec;
			if (bad < 0)
				break;
			if ((i % 20) == 0)
				printf("\n\tBLOCK:\t\tCYL\tTRACK\tSECTOR\n");
			printf("\t%d\t\t%d\t%d\t%d\n", badsn(bt),bt->bt_cyl,
			   bt->bt_trksec>>8,bt->bt_trksec&0xff);
			if ((i % 20) == 19) {
				printf("Hit return for more...");
				gets(tybuf);
			}
			bt++;
		}
		printf("Hit return to continue...");
		gets(tybuf);
	}
}

initbad(index)
int index;
{
	register int i;

	if (index == 0) {
		bad144.bt_csn = 0;
		bad144.bt_flag = 0;
		bad144.bt_mbz = 0;
	}
	for (i = index; i < MAXBADBLK; i++) {
		bad144.bt_bad[i].bt_cyl = -1;
		bad144.bt_bad[i].bt_trksec = -1;
	}
}
