
/*  VME 68030 Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'start' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified). 
 *
 *	Registers d6 and d7 contain reboot information.
 */

#define	MDOTS

#include "sadie.h"
#include "../h/reboot.h"
#include "../machine/m68k.h"
#include "../machine/trap.h"
#include "../machine/board.h"
#include "../dev/sioreg.h"

#define	UART_ADDR	OCTART_ADDR

#define CACHE_ON	ICACHE_CLEAR|ICACHE_ENABLE|DCACHE_CLEAR|DCACHE_WA
#define CACHE_OFF	ICACHE_CLEAR|DCACHE_CLEAR

	.text
	.globl	start
	.globl	_start
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
	.globl	__blink_errled
	.globl	__reset
	.globl	_booty
start:
_start:
#ifdef	PROMBOOT
	/* cold start PROM entry */
 	.long	NVRAM_BOOT_ARG - NVRAM_ADDR + NVRAM_RESET_ADDR -4
	.long	PROM_RESET_ADDR+(Coldboot-start) /* PROM+04 initial PC */
	.long	PROM_RESET_ADDR+(promberror-start) /* PROM+08 prom buserror */
Reboot:
	jra 	Boot				/* PROM+0xC */
	jra 	_DEBUG				/* PROM+0xE */
	.globl	_Diag_entry
_Diag_entry:
	jra 	diag_entry
promberror:					/* PROM+0x16 */
	jmp 	a4@
	.globl	Coldboot
Coldboot:					/* PROM+0x18 */
#endif	PROMBOOT

#ifdef	BOOT
	movl	#RB_ASKNAME+RB_LOGO,d7		/* Ask for name on cold start */
	movl	#-1,d6				/* flag first boot */

Boot:
	movw	#0x2700,sr			/* set priority level to 7 */
	movl	#3,d0
	movl	d0,sfc
	movl	d0,dfc
 	movl	#(ICACHE_ENABLE|ICACHE_CLEAR),d0
 	movl	d0,cac				/* clear and enable cache */
	movl	#0x0001,d0			/* let things warm up */
1:	movl	#0xFFFF,d1
2:	dbra	d1,2b
   	dbra	d0,1b

/* 
 * Initialize SIO ports
 */
#ifdef	PROMBOOT
	movw	#SEQ_OCTART_RST,d0 		/* CODE = 11 */
	movsw	d0,SCR_ADDR	
#endif	PROMBOOT

	movb	#0,d0
	movsb	d0,IMR+UART_ADDR		/* mask interrupts		*/
	movb	#OPCR_MOPB_RTSN,d0		/* MOPB is DTR for port B */
	movsb	d0,OPCR_0+UART_ADDR

	/* reset d0 = (CR_CMD_RST_{MR, RX, TX, ERR, BRK}) in channells A & B */

	lea 	pc@(sio_resets),a0
1:	movb	a0@+,d0
	movsb	d0,CR_A+UART_ADDR
	movsb	d0,CR_B+UART_ADDR
	cmpb	#CR_CMD_RST_BRK,d0		/* have we reached BRK (d0 = 5) yet ? */
	jne 	1b  					/* no - do the next on */
	jra 	1f

sio_resets:	.byte	CR_CMD_RST_MR,CR_CMD_RST_RX,CR_CMD_RST_TX,CR_CMD_RST_ERR,CR_CMD_RST_BRK
	.align	1

1:	movb	#CR_CMD_RTSN_ASSERT,d0		/* assert port B DTR */
	movsb	d0,CR_B+UART_ADDR	 	/* port A is asserted by HW */

/*
 * read configuration jumpers from 4 octart input ports 
 */
#ifdef	PROMBOOT
	movw	#SEQ_READ_BSR,d0 		/* CODE = 12 */
	movsw	d0,SCR_ADDR	
#endif	PROMBOOT

	movsb	IPR_0+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_1+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_2+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_3+UART_ADDR,d0
	rorl	#8,d0
	movl	d0,a3			/* save in a3 for later use */

#ifdef	PROMBOOT
	notl	d0
	andl	#BSR_DIAG_MODE,d0   	/* (11) get the diagnostic mode bits */
	jeq 	1f						/* no bits set, no debug modes */
	cmpl	#BSR_DIAG_DEBUG,d0  	/* (10) should the debugger be run ?? */
	jeq 	2f
	cmpl	#BSR_DIAG_MODE,d0		/* if it was (11)  */
	jeq 	1f						/* wait until after probe and configure */
	jra 	do_vbatm				/* else go init the vbatm & vdma */ 
2:	movw	#SEQ_GO_DEBUG,d0    	/* CODE = 17 */
	movsw	d0,SCR_ADDR	
	jra 	_DEBUG    				/* Yes! */
1:	movw	#SEQ_INIT_SIO,d0  		/* CODE = 13 */
	movsw	d0,SCR_ADDR	
#endif	PROMBOOT

	/* set baud rate */

	movb	#(MR1_PAR_NONE|MR1_8_BIT),d0
1:	movsb	d0,MR1_A+UART_ADDR
	movb	#CR_CMD_RST_MR, d1		/* reset pointer to M1  to read it */
	movsb	d1,CR_A+UART_ADDR
	movsb	MR1_A+UART_ADDR,d2	/* read the parity and char size back */
	movsb	d1,CR_A+UART_ADDR	/* reset M1 pointer again */
	cmpb	d0,d2 
	jne 	1b					/****  IF ERROR LOOP  code 13 *****/

	movsb	d0,MR1_A+UART_ADDR	/* access has been made to the UART */
	movsb	d0,MR1_B+UART_ADDR	/* set the parity, size, and stop bits */
	movb	#MR2_1_STOP,d0
	movsb	d0,MR2_A+UART_ADDR
	movsb	d0,MR2_B+UART_ADDR
	/* prepare to set the baud rate now */
	movb	#ACR_BRGS,d0
	movsb	d0,ACR_A+UART_ADDR
	movl	a3,d0
	andl	#BSR_BAUD,d0
	cmpl	#BSR_BAUD_1200,d0
	jne 	1f
	movb	#0x66,d0			/* 1200 */
	jra 	2f
1:	cmpl	#BSR_BAUD_19200,d0
	jne 	1f
	movb	#0xCC,d0			/* 19200 ?? */
	jra 	2f
1:	cmpl	#BSR_BAUD_2400,d0
	jne 	1f
	movb	#0x88,d0  			/* 2400 */ 		/* #0x44,d0 /* 300 */
	jra 	2f
1:	movb	#0xBB,d0			/* 9600  default */
2:	movsb	d0,CSR_A+UART_ADDR
	movsb	d0,CSR_B+UART_ADDR
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),d0
	movsb	d0,CR_A+UART_ADDR
	movsb	d0,CR_B+UART_ADDR

#ifdef	PROMBOOT
	cmpl	#-1,d6			/* have we booted before ? */
	jne 	5f  			/* if Yes ... go relocate */

/* else
 *	  Probe and configure VSB memory.
 *    Printing the base address of each card
 */
probe_mem:
	movw	#SEQ_PROBE_VSB,d0	/* CODE = 14 */
	movsw	d0,SCR_ADDR	

	lea 	pc@(imem0),a5		/* probe message */
	lea 	pc@(1f),a3  		/* return address */
	jra 	printstr

	/* configure the VSB memory
 	 * d1= base address, d5= test size
	 * a2= return address
	 */
1:	movl	sp,a6			/* save sp */
	clrl	d1  			/* base address in 4 meg units */
	movl	#VSB_MEM_SIZE_16MEG,d5
	lea 	pc@(1f),a2 		/* set the return address */
	jra 	configmem		/* for all 16 meg boards */
1:	movl	#VSB_MEM_SIZE_8MEG,d5
	lea 	pc@(1f),a2		
	jra 	configmem		/* for all 8 meg boards */
1:	movl	#VSB_MEM_SIZE_4MEG,d5
	lea 	pc@(1f),a2		
	jra 	configmem		/* for all 4 meg boards */
1:	/* d1 = total Memory found */

/*
 *  should we branch to DEBUG from here ?
 */
	movsb	IPR_0+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_1+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_2+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_3+UART_ADDR,d0
	rorl	#8,d0
	notl	d0
	andl	#BSR_DIAG_MODE,d0   	/* get the diagnostic mode bits */
	cmpl	#BSR_DIAG_MODE,d0   	/* should the debugger be run ?? */
	jne 	1f   				    /* No! */
	movw	#SEQ_GO_DEBUG,d0    	/* CODE = 17 */
	movsw	d0,SCR_ADDR	
	jra 	diag_entry
/*
 *	Initialize all of memory on first boot.
 *	Use duplicate memory address space to avoid
 *	conflict with EPROM.
 *	Printing a "." for every megabyte found.
 */
initialize_mem:
1:	movw	#SEQ_INIT_MEM,d0	/* CODE = 15 */
	movsw	d0,SCR_ADDR	
 
	lea 	pc@(imem1),a5		/* Initialize message */
	lea 	pc@(1f),a3  		/* return address */
	jra 	printstr

1:	lea 	pc@(sm_bus_err),a4	/* buss error return address */
	movl	#0,a0			/* start address in the dup space */
	jra 	size_mem

relocate_prom:
	movw	#SEQ_RELOCATE,d0	/* CODE = 16 */
	movsw	d0,SCR_ADDR	
	jra 	4f  			/* now relocate */
#endif	PROMBOOT

5: /* entry point from re-boot */
	movl	#0,a5			/* get the stack pointer */

		/* 
		 * Relocate out side of PROM (or load area) into the link space
		 * a5 =  the stack new stack pointer.
		 */
4: /* entry point from prom boot */
	lea 	pc@(1f),a0 			/* compute source address */
1:	movl	a0,d0				/* relative to current pc */
	andw	#0xf000,d0 			/* at last page boundry */
	movl	d0,a0
	lea 	start,a1			/* destination address */
	movl	#_edata+4,d0    		/* compute image size */
	subl	a1,d0
	lsrl	#2,d0				/* byte to long */
	addl	#MEM_DUP_MAP,a1  	/* in the duplicate mem space*/
	movl	a0,a2				/* save the starting address */
	movl	a1,a3				/* save the memory mapped address */
	movl	d0,d1				/* save the count */
#ifdef	PROMBOOT
	lea 	pc@(9f),a4			/* stuff a buss error return address */
#endif	PROMBOOT
1:	movl	a0@+,a1@+
	dbra	d0,1b
#ifdef	PROMBOOT
	/* compare memory to PROM */
	lea 	pc@(8f),a4			/* stuff a buss error return address */
1:	cmpl	a2@+,a3@+
	jeq 	3f
8:	movl	a6,sp  				/* restore the stack pointer */
	subl	#4,a3
	movl	a3,d5				/* compare/relocate buss error */
	lea 	pc@(imem4),a5		/* Memory error */
	lea 	pc@(2f),a3
	jra 	printstr
2:	movl	d5,d3
	lea 	pc@(2f),a3
	jra 	printhexadd			/* print the base address */
2:	jra 	diag_entry			/* DEBUG */

9:	movl	a1,a3				/* received buss error while relocating */
	jra 	8b

3:	dbra	d1,1b				/* compare the next long */
	/* get the board and functionality information */
	movw	0x3fffe,d0			/* this should get the last word of PROM */
	cmpw	#0xffff,d0			/* has the level been encoded? */
	jne 	1f
	notb 	d0					/* if not, force it to PVBS, 25Mhz, etc.. */
1:	movsw	d0,BD_HW_VER		/* if size is 64K, 128K, or 256K */
#endif	PROMBOOT
prom_cks_ok:
	movl	#1f,a0 				/* get link address of 1f */
	addl	#MEM_DUP_MAP,a0		/* in the no write alloc space*/
	jmp 	a0@
/*              |	 
 * running in du|plicate space
 *          <---'				/* CODE = 01 #/
 */									
1:	movw	#SEQ_RUN_LINK|SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0
	movsw	d0,SCR_ADDR		/* disable prom and led off */
	movl	#1f,a0			/* get link address of 1f */
	jmp 	a0@
/*              |
 * running in li|nk space
 *          <---'
 */
in_link_space:
1:
#else	BOOT
	/* the case of re-boot or just no memory reported, attempt to
	 * test memory to determine the amount that will respond.
	 */
	movl 	vb,a1			/* size memory */
	movl	#sm_bus_err,a0
	movl	a0,a1@(8)
	lea 	start-1024-0x10,sp	/* define the stack pointer */
	movl 	#_end,d0		/* size memory, start addr */
	addl	#4,d0			/* long align */
	andl	#0xFFFFFFFC,d0
	movl	d0,a0
	jra 	size_mem		/* calulate topmem and return to link_code */
#endif	BOOT

link_code:	
	/* get ready to go big time */
3:	movl	#3,d0
	movl	d0,sfc
	movl	d0,dfc
	movl	#CACHE_ON,d0
	movl	d0,cac			/* clear and enable cache */

/*	lea 	_systt,a1		/* map all memory VIRT=REAL */
/*	pmove	a1@,mmutt0		/* and cache off */

	lea 	start-1024-0x10,sp	/* define the stack pointer */
					/* it grows down from code */
					/* 1024 is reserved for    */
					/* interrupt dispatching */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
1:	movl	#tperr,a0@+
2:	cmpl	#0x3fc,a0
	jls 	1b

/* 
 * clear bss
 */
	lea 	_edata,a0
	lea 	_end,a1
1:	clrl	a0@+	
	cmpl	a0,a1
	jgt 	1b

/*
 * 	program VBMATM
 */
	movw	#SCR_LED_0x2|SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0 /* leds = 2 */
	movsw	d0,SCR_ADDR		/* disable prom, sysfail off, and seg led 2 */

do_vbatm:
	movw	#VBM_AM_SHORT,d0
	lslw	#6,d0
	orw 	#VBM_PORT_16,d0
	movl	#VBMATM_REG + VBM_SHORT_SLOT * 2,a0	
	movsw	d0,a0@+						/* (0) short 16 bit I/O */
	movw	#VBM_AM_STD,d0
	lslw	#6,d0
	orw 	#VBM_PORT_16,d0
	movsw	d0,a0@+						/* (2)standard 16 bit I/O */
	movw	#VBM_AM_EXT,d0
	lslw	#6,d0
	orw 	#VBM_PORT_16,d0
	movsw	d0,a0@+						/* (4) ext 16 bit I/O */
	andl	#~VBM_PORT_16,d0			/* remove 16_port bit */
	/* set the rest of the VBMATM_REGs through 30  to 32 bit extended 
	 * and incermently address VME by 128 Meg 
     */
1:	movsw	d0,a0@+
	addl	#0x2,d0						/* modifiy by 128 M */
	cmpl	#VBMATM_REG+30,a0
	jls 	1b

	/* initilize the VDMA, each register is incermentally addressed */
	movw	#SCR_LED_0x3|SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0 /* led = 03 */
	movsw	d0,SCR_ADDR		/* disable prom, sysfail off, and seg led 3 */

	jsr 	_getbsr				/* get bsr */
	andl	#BSR_CLA_MASK,d0	/* read cluster number */
	movl	#BSR_CLA_SHIFT-1,d1
	lsrl	d1,d0
	movl	#0xff,d1			/* start at the top and address down */
	orl 	#(VME_SHORTIO | 0xFFC0),d0 	/* move in the cluster number */
	movl	d0,a0
1:	movw	d1,a0@
	subl	#0x40,a0
	dbra	d1,1b
#ifdef	PROMBOOT
	jsr 	_getbsr				/* get bsr */
	notl	d0
	andl	#BSR_DIAG_MODE,d0
	jeq 	1f
	jra 	diag_entry	
#endif	PROMBOOT
1:	movl	#SYSV_BASE,d5			/* KLUDGE sboot */
/*
 * jump to main, never to return
 */
	movl	a5,_topmem			/* high address */
	movl	d5,_sboot			/* start of boot in physical */
	movl	d6,_devtp
	movl	d7,_howto
	movw	#SEQ_BOOT_DONE|SCR_PROM_DISAB|SCR_VME_SYSFAIL,d0
	movw	d0,_scr				/* leds = 0 */
	movsw	d0,SCR_ADDR
	jsr 	_memconfig			/* init sw copy of mem config */
	jsr 	_getbsr				/* get bsr */
	andl	#BSR_CLA_MASK,d0	/* read cluster number */
	movl	#BSR_CLA_SHIFT,d1
	lsrl	d1,d0
	movl	d0,_vbnum
	jsr 	_main
	jsr 	_exit				/* if main should return */

/**/ 
/*
 * common firmware memory configuration routine
 * finds total memory and prints a "." for each
 * board found.
 * d1 = starting base address upon entry and
 *      ending address upon exit.
 * d5 = input parameter, board size
 * a2 = return adddress
 */
configmem:
	movl	#VSB_MAX_SLOTS-1,d0
	movl	#VSB_IOAS_BASE,a1
	lea 	pc@(9f),a4 		/* set up buserr vector for prom */
1:	clrl	d2
	movsw	a1@,d2			/* read PVSBM status register */
	cmpw	#0xffff,d2
	jeq 	3f  			/* responded, but wrong siginature. */
	movl	d2,d3			/* see if board is a memory board */
	andl	#VSB_ID_MASK,d3	/* get board ID */	
	movl	#VSB_ID_SHFT,d4
	lsrl	d4,d3
	cmpl	#VSB_ID_MEM,d3
	jne 	3f
	movw	d2,d4			/* save copy of the RSR register */
	andl	#VSB_MEM_SIZE_MASK,d2	/* get memory size */
	movl	#VSB_MEM_SIZE_SHFT,d3
	lsrl	d3,d2
	cmpl	d5,d2			/* compare size with input parameter 16,8,4 */
	jne		3f

	addl	#1,d2			/* adjust for size start at 0 */
	movl	d1,d3			/* set up base offset */
	andl	#VSB_MEM_BASE_MASK,d3
	orl 	#VSB_PAR_ENAB,d3
	orw 	#(VSB_PAR_ERROR),d4
	movsw	d3,a1@			/* program base offset */
	movl	d3,a0			/* save base offset */
	movsw	a1@,d3			/* read the RSR register back and if it is not */
	cmpw	d3,d4			/* the same, then this is not a PVSB */
	jne 	3f
	lea 	pc@(imem2),a5  	/* return cursor to beginning of next line */
	lea 	pc@(2f),a3
	jra 	printstr
2:	movl	a0,a5			/* save base address */
	addl	d2,d1			/* calc base address for next board */
	movl	a1,d3			/* get the slot address */
	lea 	pc@(2f),a3
	jra 	printhexadd		/* print the slot address */
2:	movl	a5,d2			/* save base address */
	lea 	pc@(imem3),a5	/* get the spacer */
	lea 	pc@(2f),a3
	jra		printstr		/* print the spacer */
2:	movl	d2,d3			/* get the base address */
	lea 	pc@(2f),a3
	jra 	printhexwd		/* print the base address from d3 */
2:	lea 	pc@(imem3),a5	/* get the spacer */
	lea 	pc@(2f),a3
	jra		printstr		/* print the spacer */
2:	movl	d1,d3			/* get the ending base address */
	subl	#1,d3
	lea 	pc@(3f),a3
	jra 	printhexwd		/* print the base address from d3 */
9:	movl	a6,sp			/* restore the sp after a buss error */
3:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	dbra	d0,1b
	jmp 	a2@  			/* return */

/*
 * Print hex address/word
 * input data in d3, return address in a3
 * d2, d4, a0 scratch registers
 */
printhexwd:
	swap	d3
	movl	#4-1,d2				/* used as a word counter */
	jra		1f
printhexadd:
	movl	#8-1,d2				/* used as a long counter */
1:	lea 	pc@(N2C),a0
1:	movsb	SR_A+UART_ADDR,d4 	/* wait until UART is empty */
	btst	#SR_FFULL,d4
	jeq 	1b
	roll	#4,d3				/* position high order nibble */
	movl	d3,d4
	andl	#0xF,d4
	movb	a0@(0,d4:l*1),d4
	movsb	d4,THR_A+UART_ADDR	/* output char to UART */
	dbra	d2,1b
	jmp 	a3@					/* return */

/* 
 * print string in register a5 and return too address in a3
 * d3,d4 scratch, a3 return address, a5 has the data address
 */
printstr:
	movb	a5@+,d3
1:	movsb	SR_A+UART_ADDR,d4
	btst	#SR_FFULL,d4
	jeq 	1b
	movsb	d3,THR_A+UART_ADDR
2:	movb	a5@+,d3
	jne 	1b				/* loop until end of string */
	jmp 	a3@				/* return */
/* end of prom boot support routines */



/*/* service interrupts and traps */

/*
 * Trap error routine
 */
	.globl	_tperr
	.globl	tperr
_tperr:	
tperr:	
	movml	#<d0,d1,a0,a1>,sp@-
	jsr 	_traperr
	movml	sp@+,#<d0,d1,a0,a1>
	tstl	_dorte				/* if dorte return */
	jeq 	__rtt
	tstl	_ignore_intr
	jeq 	1f
	clrl	_dorte
1:	rte

/*
 * return to PROM, or SADIE
 */
__rtt:
	movl	#RB_ASKNAME,d7			/* Ask for name after exit */
	movl	#0xFFFF,d6			/* not a cold boot */
	movl	#0xF000,d0			/* let things cool down */
1:	dbra	d0,1b
	movl	SADIE_BASE-4,d0			/* check sadie_magic for */
	cmpl	#SADIE_MAGIC,d0			/* fast return to sadie! */
	jne 	1f
	jmp 	SADIE_BASE
1:	lea 	pc@(1f),a0
	addl	#MEM_DUP_MAP,a0			/* run in dup space */
	jmp 	a0@
1:	reset							/* reset on board devices */
/*	movw	#SCR_VME_RESET | SCR_LED_0x7,d1		/* reset VME */
/*	movsw	d1,SCR_ADDR
/*	movw	#0,d1
/*	movsw	d1,SCR_ADDR				/**/
	movl 	#PROM_RESET_ADDR,a0				/* start address */
	movl	a0,vb
	movl	a0@,sp
	jmp 	PROM_RESET_REBOOT

__splx:
	movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movsb	BD_FUNC_LEV,d0	/* if this is a VSB get out */
	andb	#BD_FUNC_VSB,d0
	jeq 	1f
	rts
1:	movl	#VSB_MAX_SLOTS-1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#vsbmembase,a0
1:	movw	a0@+,d1			/* get sw copy of config register */
	cmpw	#0xffff,d1		/* non-configed board read 0xffff */
	jeq 	2f
	orw 	#VSB_PAR_ENAB,d1	/* enable parity */
	movsw	d1,a1@			/* program base address */
	movw	d1,a0@(-2)
2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	dbra	d0,1b
	rts

__parityoff:
	movsb	BD_FUNC_LEV,d0	/* if this is a VSB get out */
	andb	#BD_FUNC_VSB,d0
	jeq 	1f
	rts
1:	movl	#VSB_MAX_SLOTS-1,d0
	movl	#VSB_IOAS_BASE,a1
	movl	#vsbmembase,a0
1:	movw	a0@+,d1			/* get sw copy of config register */
	cmpw	#0xffff,d1		/* non-config board read 0xffff */
	jeq 	2f
	andl	#~VSB_PAR_ENAB,d1	/* disable parity */
	movsw	d1,a1@			/* program base address */
	movw	d1,a0@(-2)
2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	dbra	d0,1b
	rts

__blink_errled:			/* blink the error led */
	movw	_scr,d0
	movw	d0,d1
	andl	#~SCR_LED_OFF,d1
	andw	#SCR_LED_OFF,d0
	eorw	#SCR_LED_OFF,d0
	orw 	d0,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	rts

	.globl	_rupt_enable
_rupt_enable:
	movw	_scr,d0
	orw 	#SCR_INTR_ENAB,d0
	jra 	load_SCR

	.globl	_rupt_disable
_rupt_disable:
	movw	_scr,d0
	andw 	#~SCR_INTR_ENAB,d0
	jra 	load_SCR

	.globl	_vme_rupt_enable
_vme_rupt_enable:
	movw	_scr,d0
	orw 	#SCR_VME_INT_ENAB,d0
	jra 	load_SCR

	.globl	_vme_rupt_disable
_vme_rupt_disable:
	movw	_scr,d0
	andw 	#~SCR_VME_INT_ENAB,d0
	jra 	load_SCR

	.globl	_set_softint
_set_softint:
	movw	_scr,d0
    orw     #SCR_SOFT_TRAP,d0
	jra 	load_SCR

	.globl	_clear_softint
_clear_softint:
	movw	_scr,d0
	andw    #~SCR_SOFT_TRAP,d0
	jra 	load_SCR

load_SCR:
    movsw   d0,SCR_ADDR
	movw	d0,_scr
	rts

__reset:
	movl    _vbnum,d0			/* if cluster 0, issue reset */
	jne 	3f
	movl	#1f,a0
	addl	#MEM_DUP_MAP,a0			/* run in dup space */
	jmp 	a0@
1:	reset
	movl	#0x0001,d0			/* let things warm up */
1:	movl	#0xFFFF,d1
2:	dbra	d1,2b
	dbra	d0,1b
	movl	#_scr,a0
	addl	#MEM_DUP_MAP,a0
	movw	a0@,d0
	movsw   d0,SCR_ADDR			/* restore scr */
3:	rts
/* 
 * external cache routines are programmed as as an unit
 */
	.globl	_enable_ext_cache
_enable_ext_cache:
	movw	_scr,d0
	andl	#~SCR_CACHE_ENAB | SCR_CACHE_CLEAR,d0
	movl	d0,d1
	orw 	#SCR_CACHE_ENAB,d1
	jra 	2f

	.globl	_disable_ext_cache
_disable_ext_cache:
	movw	_scr,d0
	jra 	1f	

	.globl	_tog_ext_cache		
_tog_ext_cache:
	movw	_scr,d0
	andw	#~SCR_CACHE_CLEAR,d0	/* reset the  clear bit */
	movw	d0,d1
	andw	#SCR_CACHE_ENAB,d1
	jne 	1f		/* jnz, if it is on, go and turn it off */
	movw	d0,d1
	orw 	#SCR_CACHE_ENAB,d1	/* set the enable bit */
	jra 	2f

1:	andl	#~SCR_CACHE_ENAB,d0
	movl	d0,d1
2:	orw 	#SCR_CACHE_CLEAR,d0
	movsw	d0,SCR_ADDR
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	rts

/*
 * read board status register from 4 octart input ports 
 */
	.globl	_getbsr	
_getbsr:
	movsb	IPR_0+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_1+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_2+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_3+UART_ADDR,d0
	rorl	#8,d0
	rts

/*
 * 	Test functioning of FPU_USE feature
 */

	.globl	_testfpuuseon
_testfpuuseon:
	movml	#<d2,d3>,sp@-
	movl	#-1,d0
	movw	_scr,d1
	orw	#SCR_FPU_USE,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	movl	vb,a0				/* get vbr */
	movl	#FPE_FLINE_VEC,d1		/* Seize the F-LINE trap */
	movl	a0@(0,d1:l*4),a1
	movl	#1f,a0@(0,d1:l*4)
	movl	#FPE_COPROC_VEC,d1		/* Seize the COOP trap */
	movl	a0@(0,d1:l*4),d2
	movl	#1f,a0@(0,d1:l*4)
	movl	sp,d3
	fnop
	clrl	d0
     1: movl	#FPE_FLINE_VEC,d1
	movl	a1,a0@(0,d1:l*4)		/* restore F-LINE vector */
	movl	#FPE_COPROC_VEC,d1
	movl	d2,a0@(0,d1:l*4)		/* restore COOP vector */
	movl	d3,sp
	movml	sp@+,#<d2,d3>
	rts


	.globl	_testfpuuseoff
_testfpuuseoff:
	movml	#<d2,d3>,sp@-
	clrl	d0
	movw	_scr,d1
	andw	#~SCR_FPU_USE,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	movl	vb,a0				/* get vbr */
	movl	#FPE_FLINE_VEC,d1		/* Seize the F-LINE trap */
	movl	a0@(0,d1:l*4),a1
	movl	#1f,a0@(0,d1:l*4)
	movl	#FPE_COPROC_VEC,d1		/* Seize the COOP trap */
	movl	a0@(0,d1:l*4),d2
	movl	#1f,a0@(0,d1:l*4)
	movl	sp,d3
	fnop
	movl	#-1,d0
     1: movl	#FPE_FLINE_VEC,d1
	movl	a1,a0@(0,d1:l*4)		/* restore F-LINE vector */
	movl	#FPE_COPROC_VEC,d1
	movl	d2,a0@(0,d1:l*4)		/* restore COOP vector */
	movl	d3,sp
	movml	sp@+,#<d2,d3>
	rts

/*
 *	Turn on FPU
 */
	.globl	_fpuon
_fpuon:
	movw	_scr,d1
	orw	#SCR_FPU_USE,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	rts

/*
 *	Turn off the FPU,  such that execution of FPU
 *	instructions will trap to 1f.
 */
	.globl	_fpuoff
_fpuoff:
	movw	_scr,d1
	andw	#~SCR_FPU_USE,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	movl	vb,a0				/* get vbr */
	movl	#FPE_FLINE_VEC,d0		/* Seize the F-LINE trap */
	movl	a0@(0,d0:l*4),fline_save	/* save vector */
	movl	#1f,a0@(0,d0:l*4)
	movl	#FPE_COPROC_VEC,d0		/* Seize the COOP trap */
	movl	a0@(0,d0:l*4),coop_save		/* save vector */
	movl	#1f,a0@(0,d0:l*4)
	rts

/*
 *	Expected F_LINE trap, enable FPU
 */
    1:	
	movml	#<d0,d1,a0,a1>,sp@-
	movw	_scr,d1
	orw	#SCR_FPU_USE,d1
	movw	d1,_scr
	movsw	d1,SCR_ADDR
	movl	vb,a0				/* get vbr */
	movl	#FPE_FLINE_VEC,d0
	movl	fline_save,a0@(0,d0:l*4)	/* restore F_LINE vector */
	movl	#FPE_COPROC_VEC,d0
	movl	coop_save,a0@(0,d0:l*4)		/* restore COOP vector */
	movml	sp@+,#<d0,d1,a0,a1>
	rte


	.globl	_set_vec
_set_vec:
	movl	sp@(4),d0			/* get vector number*/
	movl	vb,a0				/* get vbr */
	lea 	start-1024,a1			/* get dispatch table */
	movl	sp@(8),a1@(0,d0:l*4)		/* set dispatch entry */
	movl	#rupt_dispatch,a0@(0,d0:l*4)	/* patch vector */
	rts

	.globl	_getvb
	.globl	_getvbr
_getvb:
_getvbr:
	movl	vb,d0				/* get vbr */
	rts

	.globl	rupt_dispatch
rupt_dispatch:
	movml	#<d0,d1,a0,a1>,sp@-
	movw	sp@(22),d0			/* get vector and format */
	andw	#ESF_VECMSK,d0			/* isolate vector */
	lea 	start-1024,a0			/* get dispatch table */
	movl	a0@(0,d0:w*1),a1		/* get dispatch address */
	jsr 	a1@
	movml	sp@+,#<d0,d1,a0,a1>
	rte


/*
 * Test-and-set primative.
 *  Sets the high-order bit of the pointed-to byte.
 *  Returns zero (failure) if the byte had been nonzero, else 1 (success).
 *  Routine is indivisible even in multi-processor environment
 *  IF the byte is in VME memory.
 */
	.globl	_tas
_tas:
	movq	#0,d0
	movl	sp@(4),a0
	tas 	a0@
	jne 	1f
	addqw	#1,d0
1:	rts

/*
 * For 030 at 25 mhz:
 *	DELAY(100000) is one second.
 */
	.globl	_DELAY
_DELAY:
	movl	_cpuspeed,d1
1:	movl	sp@(4),d0
2:	dbf 	d0,2b
	addqw	#1,d0
	subql	#1,d0
	jge 	2b
	dbf 	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge 	1b
	rts

	.globl	_tbia
_tbia:
	pflusha
	rts

	.globl	_loadmmu
_loadmmu:
	movl	sp@(4),d0
	movl	sp@(8),a0
	cmpl	#MMUCRP,d0
	jne 	1f
	pmove	a0@,mmucrp
	rts
1:	cmpl	#MMUSRP,d0
	jne 	1f
	pmove	a0@,mmusr
	rts
1:	cmpl	#MMUTC,d0
	jne 	1f
	pmove	a0@,mmutc
	rts
1:	cmpl	#MMUSR,d0
	jne 	1f
	pmove	a0@,mmusr
	rts
1:	cmpl	#MMUTT0,d0
	jne 	1f
	pmove	a0@,mmutt0
	rts
1:	cmpl	#MMUTT1,d0
	jne 	1f
	pmove	a0@,mmutt1
2:	rts
	
	.globl	_getmmu
_getmmu:
	movl	sp@(4),d0
	movl	sp@(8),a0
	cmpl	#MMUCRP,d0
	jne 	1f
	pmove	mmucrp,a0@
	jra 	2f
1:	cmpl	#MMUSRP,d0
	jne 	1f
	pmove	mmusrp,a0@
	jra 	2f
1:	cmpl	#MMUTC,d0
	jne 	1f
	pmove	mmutc,a0@
	jra 	2f
1:	cmpl	#MMUSR,d0
	jne 	1f
	pmove	mmusr,a0@
	jra 	2f
1:	cmpl	#MMUTT0,d0
	jne 	1f
	pmove	mmutt0,a0@
	jra 	2f
1:	cmpl	#MMUTT1,d0
	jne 	1f
	pmove	mmutt1,a0@
2:	rts
	
/*
 * read/write byte/word/long to alternate function code space
 */
	.globl	_afcrb,_afcwb,_afcrw,_afcww,_afcrl,_afcwl
_afcrb:
	movl	sp@(4),a0
	clrl	d0
	movsb	a0@,d0
	rts

_afcrw:
	movl	sp@(4),a0
	clrl	d0
	movsw	a0@,d0
	rts

_afcrl:
	movl	sp@(4),a0
	movsl	a0@,d0
	rts

_afcwb:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsb	d0,a0@
	rts

_afcww:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsw	d0,a0@
	rts

_afcwl:
	movl	sp@(4),a0
	movl	sp@(8),d0
	movsl	d0,a0@
	rts

	.globl	_set_cacr
_set_cacr:
	movl	sp@(4),d0
	movl	d0,cac
	rts

	.globl	_flush_int_cache_single
_flush_int_cache_single:
	movl	sp@(4),d0
	movl	d0,caa
	movl	cac,d0
	orl	#ICACHE_CE|DCACHE_CE,d0
	movl	d0,cac
	rts

/*
 * Flush external and internal data cache
 */
	.globl	_flush_all_caches
_flush_all_caches:
	movl	cac,d0
	orl 	#DCACHE_CLEAR,d0
	movl	d0,cac
	movw	_scr,d0
	movl	d0,d1
	andl	#~SCR_CACHE_ENAB,d0
	orw 	#SCR_CACHE_CLEAR,d0
	movsw	d0,SCR_ADDR
	movsw	d1,SCR_ADDR
	rts

	/* memory is tested by writing a 0 to a longword location 
 	 * then comparing the same location to 0.
	 */
size_mem:
	movl	sp,a6
	addl	#MEM_DUP_MAP,a0		/* start address in the dup space */
	movl	#0,d0			/* clear all to zero */
	movl	#0xFFFFF,d2		/* 1MEG test value */
1:	cmpl	#MAXPHYSMEM+MEM_DUP_MAP,a0
	jge 	2f  			/* test end of loop */ 
	movl	d0,a0@			/* write 0 to memory */
	cmpl	a0@+,d0			/* check for picked bits */
	jne 	2f  			/* if not equal, it's in error */
	movl	a0,d3			/* test for 1 meg boundry */
	andl	d2,d3
	jne 	1b  			/* loop if not there yet */
	movb	#0x2e,d3		/* else print a "." */
	movsb	d3,THR_A+UART_ADDR
	jra 	1b  			/* then go check the next 1 meg */
sm_bus_err:
	movl	a6,sp			/* restore the sp after a buss error */
	/* this point is reached when end of contiguous memory is found */
2:	lea 	pc@(imem2),a5	/* terminate line with a C/R L/F */
	lea 	pc@(1f),a3		/* return address */
	jra 	printstr
1:	subl	#(MEM_DUP_MAP +4),a0
	movl	a0,a5			/* last continuous memory address ie.. stack */
#ifdef	PROMBOOT
	jra 	relocate_prom	/* now relocate form prom */
#else
	jra 	link_code		/* return for dnloaded code */
#endif

/*
 * Initialize software copy of VSB memory configuration registers
 */
	.globl	_memconfig
_memconfig:
	movml	#<d2,d3,d4,d5,d6,a2,a4,a5>,sp@-
	movl	#VSB_MAX_SLOTS-1,d0
	movl	#vsbmembase,a0
2:	movw	#0xffff,a0@+
	dbra	d0,2b
	movl	vb,a2
	movl	a2@(8),d6

	clrl	d1  			/* initialize base address */
	movl	sp,a5			/* save copy of sp */	
	movl	#VSB_MEM_SIZE_16MEG,d5
	lea 	pc@(1f),a2		/* set the return address */
	jra 	cfgmem	 		/* for all 16 meg boards */
1:	movl	#VSB_MEM_SIZE_8MEG,d5
	lea 	pc@(1f),a2		
	jra 	cfgmem			/* for all 8 meg boards */
1:	movl	#VSB_MEM_SIZE_4MEG,d5
	lea 	pc@(1f),a2		
	jra 	cfgmem			/* for all 4 meg boards */
1:
	movl	vb,a2
	movl	d6,a2@(8)		/* restore buserror vector */
	movl	#22,d0
	lsll	d0,d1			/* convert # of 4_meg bds into bytes */
	cmpl	_topmem,d1		/* which is larger */
	jge 	1f
	movl	_topmem,d1		/* if topmem is use it */
1:	movl	d1,_memsize		/* save the size of memory */
	movml	sp@+,#<d2,d3,d4,d5,d6,a2,a4,a5>
	rts

/*
 * common software memory configuration routine
 * d1 = base address
 * d5 = test size
 * a2 = return adddress
 * a5 = copy of stack pointer
 */
cfgmem:
	movl	#vsbmembase,a0
	movl	#VSB_MAX_SLOTS-1,d0
	movl	#VSB_IOAS_BASE,a1
	lea 	pc@(8f),a4
	movl	a4,8			/* set up buserr vector */
1:	clrl	d2
	movsw	a1@,d2			/* read ISVSBM status register */
	cmpw	#0xffff,d2
	jeq 	2f
	jra 	9f  			/* the board responds */
8:	movl	a5,sp			/* buserror, reset stack */
	jra 	2f
9:	movl	d2,d3			/* see if memory board */
	andl	#VSB_ID_MASK,d3		/* get board id */	
	movl	#VSB_ID_SHFT,d4
	lsrl	d4,d3
	cmpl	#VSB_ID_MEM,d3
	jne 	2f
	andl	#VSB_MEM_SIZE_MASK,d2	/* get memory size */
	movl	#VSB_MEM_SIZE_SHFT,d3
	lsrl	d3,d2
	cmpl	d5,d2
	jne 	2f
	addl	#1,d2			/* adjust for size start at 0 */
   	movl	d1,d3			/* set up base address */
	andl	#VSB_MEM_BASE_MASK,d3	
	movw	d3,a0@
	addl	d2,d1			/* calc base address for next board */
2:	addl	#VSB_IOAS_ID_INCR,a1	/* calc next board IOAS address */
	addl	#2,a0			/* update pointer to vsbmembase */
	dbra	d0,1b
	jmp 	a2@  					/* return */



/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@

	.globl	_trigger
_trigger:
	movl	sp@(4),a0
	addl	#NVRAM_ADDR,a0
	movl	sp@(8),d0
	movsl	d0,a0@
	rts

	.globl	_pushmult
_pushmult:
	movl	sp@(4),a0
	movl	sp@(8),a1
	movml	#<d2,d3,d4,d5,d6,d7,a2,a3,a4,a5>,sp@-
	movml	a0@,#<d2,d3,d4,d5,d6,d7,a2,a3,a4,a5>
	movml	#<d2,d3,d4,d5,d6,d7,a2,a3,a4,a5>,a1@
	movml	sp@+,#<d2,d3,d4,d5,d6,d7,a2,a3,a4,a5>
	rts

#ifdef	BOOT
	.globl	_enter_debug
_enter_debug:					/* enter from prom_diags routine */
	lea 	pc@(1f),a0
	addl	#MEM_DUP_MAP,a0
	jmp 	a0@  				/* jump into duplicate space */
1:	movl	#0,d0
	movsw	d0,SCR_ADDR

#ifndef	PROMBOOT 
#include	"V30/debug.h"
#endif	PROMBOOT
	jmp 	_Diag_entry		

#include "./DEBUG.c"			/* DEBUGGER ... */
#endif	Boot

	.align	1
imem0:	.asciz	"\r\nProbe and configure PVSB memory"
imem1:	.asciz	"\r\nInitialize all memory "
imem2:	.asciz	"\r\n"
imem3:	.asciz	" - "
imem4:	.asciz	"Memory error: 0x"
N2C:	.asciz "0123456789ABCDEF"
	.align	1

	.data
	.globl	_vme_short
	.globl	_vme_std
	.globl	_vme_stdio
	.globl	_vme_ext
	.globl  _vbmatm_reg
	.set	_vme_short,VME_SHORTIO
	.set	_vme_std,VME_STANDARD
	.set	_vme_stdio,VME_STANDARD
	.set	_vme_ext,VME_EXTENDED
	.set    _vbmatm_reg,VBMATM_REG

	.globl	_errno
	.globl  _cpuchip
	.globl  _cpuspeed
	.globl	is68020
	.globl	is68030
	.globl	_vbnum
	.globl  _topmem
	.globl	_dorte
	.globl	_ignore_intr
	.globl	_hadint
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
	.globl	_scr
	.globl	_memsize
_errno:		.long	0
_cpuchip:	.long	68020
/*_cpuchip:	.long	68030
 */
_cpuspeed:	.long	14
is68020:	.long	0xffffffff
is68030:	.long	0xffffffff
_vbnum:		.long	0
_topmem:	.long	0
_dorte:		.long	0
_ignore_intr:	.long	0
_hadint:	.long	0
_howto:		.long	0
_devtp:		.long	0
_sboot:		.long	0
_memsize:	.long	0
fline_save:	.long	0
coop_save:	.long	0
_scr:		.word	0
			.long	0
			.align	1
vsbmembase:	.space	VSB_MAX_SLOTS*2
/* last line of code */
