/* 
 *  VME 68020 Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'start' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified). 
 *
 *	Registers d6 and d7 contain reboot information.
 */

#define	MDOTS
#include "sadie.h"
#include "../h/reboot.h"
#include "../machine/m68k.h"
#include "../machine/trap.h"
#include "../machine/board.h"
#include "../dev/sioreg.h"

/*
 *	Debug trace skeleton and flags:
 *		TRACE(<ea>)
 *		Printn(reg, scratch_D_reg, scratch_D_reg, scratch_A_reg)
 */
#define	TXW		9: btst #2,S2681_R_SR_A; jeq 9b; /* wait for transmit */
#define	TRACE(x)	TXW; movb x,S2681_W_THR_A
#define	PN(X,Y,Z)	roll #4,X; movb X,Y; andw #0xF,Y; TRACE(Z@(0,Y:w))
#define	Printn(W,X,Y,Z) movl #N2C,X;andl #0xFFFFFFF,X;movl X,Z;movl W,X; \
			TRACE(#0x7b);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z); \
			PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);TRACE(#0x7d)

	MEMTRAP	=	0x000008	/* memory trap address */
	ILITRAP	=	0x000010	/* illegal instruction trap */
	INISTACK=	0x001000	/* initial stack pointer */

	.text
	.globl	start
	.globl	_start
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
	.globl	__blink_errled
	.globl	__cacheon
	.globl	__cacheoff
	.globl	__cacheclear
	.globl	__reset
	.globl	_booty
	.globl	_getvbr
	.globl	_chkmem
start:
_start:
#ifdef	PROMBOOT
	/* cold start PROM entry */
	.long	INISTACK			/* PROM+00 reset SSP */
	.long	PROM+(Coldboot-start)		/* PROM+04 initial PC */
Reboot:	jra	Boot				/* PROM+08 */
/*	jra	_DEBUG				/* PROM+0A */
	.globl	Coldboot
Coldboot:					/* PROM+0C */
#endif	PROMBOOT

#ifdef	BOOT
	movl	#RB_ASKNAME+RB_LOGO,d7		/* Ask for name on cold start */
	movl	#-1,d6				/* flag first boot */

Boot:	movw	#0x2700,sr			/* set priority level to 7 */
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
	movl	d0,cac				/* clear and enable cache */
	movl	#0x0001,d0			/* let things warm up */
    1:	movl	#0xFFFF,d1
    2:	dbra	d1,2b
    	dbra	d0,1b

	movb	BSR,d0
/*	andb	#BSR_DIAGNOSTIC,d0		/* FUTURE */
/*	jeq	_DEBUG				/* FUTURE */

/* 
 * Initialize SIO ports
 */
	movb	#0,S2681_W_IMR
	movb	#CR_CMD_RST_MR,S2681_W_CR_A
	movb	#CR_CMD_RST_MR,S2681_W_CR_B
	movb	#CR_CMD_RST_RX,S2681_W_CR_A
	movb	#CR_CMD_RST_RX,S2681_W_CR_B
	movb	#CR_CMD_RST_TX,S2681_W_CR_A
	movb	#CR_CMD_RST_TX,S2681_W_CR_B
	movb	#CR_CMD_RST_ERR,S2681_W_CR_A
	movb	#CR_CMD_RST_ERR,S2681_W_CR_B
	movb	#CR_CMD_RST_BRK,S2681_W_CR_A
	movb	#CR_CMD_RST_BRK,S2681_W_CR_B
#ifdef	BSR_KEY_BOARD
	movb	BSR,d0
	andb	#BSR_KEY_BOARD,d0
	cmpb	#BSR_KEY_IWS,d0
	jne	1f
    	movb	#(MR1_PAR_WITH|MR1_PAR_ODD|MR1_8_BIT),S2681_MR1_A
	jra	2f
#endif	BSR_KEY_BOARD
    1:	movb	#(MR1_PAR_NONE|MR1_8_BIT),S2681_MR1_A
    2:	movb	#(MR1_PAR_NONE|MR1_8_BIT),S2681_MR1_B
	movb	#MR2_1_STOP,S2681_MR2_A
	movb	#MR2_1_STOP,S2681_MR2_B
	movb	#ACR_BRGS,S2681_W_ACR		/* baud rate table 1 */
#ifdef	BSR_KEY_BOARD
	movb	BSR,d0
	andb	#BSR_KEY_BOARD,d0
	cmpb	#BSR_KEY_IWS,d0
	jne	1f
	movb	#0x55,d0			/* IWS keyboard, 600 baud */
	jra	2f
#endif	BSR_KEY_BOARD
    1:	movb	BSR,d0
	andb	#BSR_BAUD,d0
	cmpb	#BSR_BAUD_9600,d0
	jne	1f
	movb	#0xBB,d0			/* 9600 */
	jra	2f
    1:	cmpb	#BSR_BAUD_1200,d0
	jne	1f
	movb	#0x66,d0			/* 1200 */
	jra	2f
    1:	cmpb	#BSR_BAUD_19200,d0
	jne	1f
	movb	#0xCC,d0			/* 19200 ?? */
	jra	2f
    1:	movb	#0x44,d0			/* 300 */
/* change to 0x88 for 2400 baud */
    2:	movb	d0,S2681_W_CSR_A
	movb	d0,S2681_W_CSR_B
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),S2681_W_CR_A
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),S2681_W_CR_B

#ifdef	PROMBOOT
/*
 *	Initialize all of memory on first boot, use nontranslated addresses
 *	Print out a "." for every megabyte found.
 */
	cmpl	#-1,d6
	jne	3f

	lea	pc@(imem0),a2
	jra	2f
    1:	btst	#2,S2681_R_SR_A			/* test transmit ready */
	jeq	1b
	movb	d0,S2681_W_THR_A
    2:	movb	a2@+,d0
	jne	1b

	movl	#0,0				/* clear initial ssp location */
	movl	#0,4				/* clear initial pc location */
  	lea	MEMTRAP,a1
	lea	pc@(2f),a0
	movl	a0,a1@

	movl	#0x0,d0
	movl	#0xFFFFF,d2
	lea	MEMTRAP+4,a0			/* start addr */

    1:	movl	d0,a0@
	cmpl	a0@+,d0
	jne	2f
	movl	a0,d1
	andl	d2,d1
	jne	1b
	movb	#0x2e,S2681_W_THR_A		/* print "." */
	jra	1b

    2:	lea	pc@(imem1),a2
	jra	2f
    1:	btst	#2,S2681_R_SR_A			/* test transmit ready */
	jeq	1b
	movb	d0,S2681_W_THR_A
    2:	movb	a2@+,d0
	jne	1b
    3:	movl	a0,a5
#else	PROMBOOT
	movl	#0x01000001,a5
#endif	PROMBOOT

/* 
 * Relocate out side of PROM (or load area) into the link space
 */
  	bsr	1f				/* compute source address */
    1:	movl	sp@+,d0				/* relative to current pc */
	andw	#0xF000,d0			/* back to last page boundry */
	movl	d0,a0
	lea	start,a1			/* destination address */
	movl	#_edata+4,d0			/* compute image size */
	subl	a1,d0
	lsrl	#2,d0				/* byte to long */
    1:	movl	a0@+,a1@+
	dbra	d0,1b
	jmp	1f				/* long jump */

/* 
 * running in link space
 */
    1:	movb	#CTX_LED,d0
	movb	d0,CTX				/* extinguish led */
#else	BOOT
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
	movl	d0,cac				/* clear and enable cache */
	movl	#0x01000001,a5
#endif	BOOT
	lea	start-0x10,sp			/* define the stack pointer */
						/* it grows down from code */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
	jra	2f
    1:	movl	#tperr,a0@+
    2:	cmpl	#0x3fc,a0
	jls	1b

/* 
 * clear bss
 */
	lea	_edata,a0
	movl	#_end+4,d0
	subl	a0,d0
	lsrl	#2,d0				/* byte to long */
	movl	#0,d1
    1:	movl	d1,a0@+
	dbra	d0,1b

	movl	#0x10000000,d5			/* KLUDGE sboot */
/*
 * jump to main, never to return
 */
	movl	a5,_topmem			/* high address */
	movl	d5,_sboot			/* start of boot in physical */
	movl	d6,_devtp
	movl	d7,_howto
	movb	#CTX_LED,_ctx			/* context register state */
	jsr	_cpux				/* find out cluster number */
	movl	d0,_vbnum
	jsr	_main
	jsr	_exit				/* if main should return */

	/* servie interrupts and traps */
tperr:	movml	#0xC0C0,sp@-			/* save [da][01] */
	jsr	_traperr
	movml	sp@+,#0x0303			/* restore [da][01] */
	tstl	_dorte				/* if dorte return */
	jeq	__rtt
	tstl	_ignore_intr
	jeq	1f
	clrl	_dorte
    1:	rte

/*
 * return to PROM, or SADIE
 */
__rtt:	movl	#RB_ASKNAME,d7			/* Ask for name after exit */
	movl	#0xFFFF,d6			/* not a cold boot */
	movl	#0xF000,d0			/* let things cool down */
    1:	dbra	d0,1b
	movl	SADIE_BASE-4,d0			/* check sadie_magic for */
	cmpl	#SADIE_MAGIC,d0			/* fast return to sadie! */
	jne	1f
	jmp	SADIE_BASE
    1:	jmp	PROM_REBOOT

__splx: movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movb	_ctx,d0
	orb	#CTX_PARITY,d0
	movb	d0,_ctx
	movb	d0,CTX
	rts

__parityoff:
	movb	_ctx,d0
	andb	#~CTX_PARITY,d0
	movb	d0,_ctx
	movb	d0,CTX
	rts

__blink_errled:			/* blink the error led */
	movb	_ctx,d0
	eorb	#CTX_LED,d0
	movb	d0,CTX
	eorb	#CTX_LED,d0
	movb	d0,CTX
	rts

__cacheon:
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
	movl	d0,cac
	rts

__cacheoff:
	movl	#0x00000000,d0
	movl	d0,cac
	rts

__cacheclear:
	movl	cac,d0
	orl	#CCACHE_CLEAR,d0
	movl	d0,cac
	rts

__reset:
	movb    BSR,d0				/* if cluster 0, issue reset */
	notb	d0
	andb    #BSR_CNODE,d0
	jeq	1f
	cmpb	#BSR_CNODE,d0
	bne	3f
    1:	reset
	movl	#0x0001,d0			/* let things warm up */
    1:	movl	#0xFFFF,d1
    2:	dbra	d1,2b
    	dbra	d0,1b
    3:	rts

/*
 * Test-and-set primative.
 *  Sets the high-order bit of the pointed-to byte.
 *  Returns zero (failure) if the byte had been nonzero, else 1 (success).
 *  Routine is indivisible even in multi-processor environment
 *  IF the byte is in VME memory.
 */
	.globl	_tas
_tas:	movq	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addqw	#1,d0
    1:	rts

	.globl	_DELAY
_DELAY:	movl	_cpuspeed,d1
    1:	movl	sp@(4),d0
    2:	dbf	d0,2b
	addqw	#1,d0
	subql	#1,d0
	jge	2b
	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b
	rts
/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@

_getvbr:
	movec   vb,d0
	rts

_chkmem:
1:	lea	MEMTRAP+100,a0
	movl	#0x0,d0
2:	movl	d0,a0@
	cmpl	a0@+,d0
	addqw	#1,d0
	cmpl	#0x400,d0
	jne	1b
	jra	2b
/* won't ever get here */
	rts

/*#include "./DEBUG.c"			/* DEBUGGER ... */

	.align	1
imem0:	.asciz	"Initialize all memory "
imem1:	.asciz	"\r\n"
N2C:	.asciz "0123456789ABCDEF"
	.align	1

	.data
	.globl	_vme_short
	.globl	_vme_std
	.globl	_vme_stdio
	.globl	_vme_ext
	.set	_vme_short,VME_SHORTIO
	.set	_vme_std,VME_STANDARD
	.set	_vme_stdio,VME_STANDARD
	.set	_vme_ext,VME_EXTENDED

	.globl	_errno
	.globl  _cpuchip
	.globl  _cpuspeed
	.globl	is68020
	.globl	_vbnum
	.globl  _topmem
	.globl	_dorte
	.globl	_ignore_intr
	.globl	_hadint
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
_errno:		.long	0
_cpuchip:	.long	68020
_cpuspeed:	.long	14
is68020:	.long	0xFFFFFFFF
_vbnum:		.long	0
_topmem:	.long	0x01000001	/* Extended memory system! */
_dorte:		.long	0
_ignore_intr:	.long	0
_hadint:	.long	0
_howto:		.long	0
_devtp:		.long	0
_sboot:		.long	0
		.long	0
