#include "graphics.h"
#include "fifo.h"
#include "color.h"

extern int pgno;
extern int has_color;
int debug;

auto_test ()

{ char c[10];

  c[0]  = ' ';
  printf ("Microcode Automatic Tests\n");

  while (c[0] != 'q')
    {
    printf ("\nm> ");
    gets (c);
    if (!has_color) printf ("(writing to page %d)\n", pgno);
    switch (c[0])
      {
      case 'b' : btest();       break;
      case 'd' : bugmode();     break;
      case 'e' : erode();       break;
      case 'f' : ftest();       break;
      case 'l' : lookup();      break;
      case 'm' : mtest();       break;
      case 'n' : ntest();       break;
      case 'p' : ptest();       break;
      case 'r' : rtest();       break;
      case 's' : stest();       break;
      case 't' : ttest();       break;
      case 'v' : vtest();       break;
      case 'w' : wtest();       break;
      case 'x' : xtest();       break;
      case '?' : printf ("\nTests available are:\n");
                 printf ("   b)   blit test \n");
                 printf ("   e)   erode demo\n");
                 printf ("   f)   font test\n");
                 if (has_color)
                    printf ("   l)   color lookup test\n");
                 printf ("   m)   memory access test\n");
                 printf ("   n)   box pattern test\n");
                 printf ("   p)   paint test\n");
                 printf ("   r)   random box test\n");
                 printf ("   s)   box size test\n");
                 if (!has_color)
                    printf ("   t)   box toggle test\n");
                 printf ("   v)   vector test\n");
                 printf ("   w)   walking address test\n\n");
                 printf ("   d)   toggles debug mode\n");
                 break;
      }
    }
}





bugmode ()

{
  if (debug == 0)
    {
    printf ("turning debug mode ON.\n");
    debug = 1;
    }
  else
    {
    printf ("turning debug mode OFF.\n");
    debug = 0;
    }
}


rtest ()

{ int  base_l;
  int  x0, y0;
  int  width, height;
  int  min_x0, max_x0, min_y0, max_y0;
  int  min_w,  max_w,  min_h,  max_h;
  int  inter;
  int  delay, count;
  int  current;
  char buf[10];
  unsigned rand();

  base_l = 0;
  min_x0 = min_y0 = min_w = min_h = 2000;
  max_x0 = max_y0 = max_w = max_h = 0;
  printf ("random box test\n");
  if (debug)
    {
    printf ("base_l? ");
    stripwhite(gets(buf));
    base_l = getnum(buf);
    printf ("interactive? ");
    stripwhite(gets(buf));
    if (buf[0] == 'y')
      inter = 1;
    else 
      {
      inter = 0;
      printf ("delay? ");
      stripwhite(gets(buf));
      delay = getnum(buf);
      }
    }
  while (getlocal() != 'q')
    {
    x0     = (short)(((double)rand()/0x7ffffffe)*(BXMAX));
    y0     = (short)(((double)rand()/0x7ffffffe)*(BYMAX));
    width  = (short)(((double)rand()/0x7ffffffe)*(BXMAX-x0));
    height = (short)(((double)rand()/0x7ffffffe)*(BYMAX-y0));
    if (x0 < min_x0) min_x0 = x0;
    if (x0 > max_x0) max_x0 = x0;
    if (y0 < min_y0) min_y0 = y0;
    if (y0 > max_y0) max_y0 = y0;
    if (width < min_w) min_w = width;
    if (width > max_w) max_w = width;
    if (height < min_h) min_h = height;
    if (height > max_h) max_h = height;

    if (has_color) {
      current = (int)(((double)rand()/0x7ffffffe)*(7));
      if (current == 0) current = 1;
      set_color (current);
      }
    else {
      if (current == 0)
        {
        current = 1;
        alu_set;
        }
      else
        {
        current = 0;
        alu_clear;
        }
      }
    box (pgno, base_l, x0, y0, width, height);
    if (debug)
      {
      printf ("box (%d %d %d %d)    ", x0, y0, width, height);
      if (inter) gets(buf);
      else
        {
        count = delay;
        while (count--);
        printf("\n");
        }
      if (buf[0] == 'q')
        {
        alu_clear;
        box (pgno, base_l, x0, y0, width, height);
        goto quitit;
        }
      }
    if (getlocal() == 'q') goto quitit;
/*
    alu_clear;
    box (pgno, base_l, x0, y0, width, height);
*/
    }
quitit: printf ("quitting random test\n");
printf ("max   x0 %d   y0 %d   w %d   h %d\n", max_x0, max_y0, max_w, max_h);
printf ("min   x0 %d   y0 %d   w %d   h %d\n", min_x0, min_y0, min_w, min_h);
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}

wtest ()

{ int  x0, y0;
  int  width, height;
  char buf[10];

  printf ("walking address test for box command\n");
  while (1)
  {
  for (y0 = 0; y0 <= BYMAX-127; y0+=16)
    for (x0 = 0; x0 <= BXMAX-127; x0+=4)
      for (width = 128; width <= 128; width++)
        for (height = 128; height <= 128; height++)
          {
          alu_set;
          box (pgno, 0, x0, y0, width, height);
          if (debug)
            {
            printf ("box (%d %d %d %d)    ", x0, y0, width, height);
            gets(buf);
            if (buf[0] == 'q')
              {
              alu_clear;
              box (pgno, 0, x0, y0, width, height);
              goto outside;
              }
            }
          if (getlocal() == 'q') goto outside;
          alu_clear;
          box (pgno, 0, x0, y0, width, height);
          }
  }
outside: printf ("finished box test.\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}


stest ()

{ int  x0, y0;
  int  width;
  int  delta;
  int  howmany;
  int  start_x0, start_y0;
  int  start_width;
  int  coord [6][3];
  int  i,j;
  int  mode;
  int  current;
  char buf[10];
  unsigned rand();

  printf ("random size test\n");
  while (1)
  {
  for (i=0; i <= 5; i++)
    {
    start_width = (short)(((double)rand()/0x7ffffffe)*(700));
    start_x0    = (short)(((double)rand()/0x7ffffffe)*(BXMAX-start_width));
    start_y0    = (short)(((double)rand()/0x7ffffffe)*(BYMAX-start_width));
    if (start_width < 8) start_width = 8;
    delta = 3;
    howmany = (start_width / (delta*2))+2;
    x0    = start_x0;
    y0    = start_y0;
    width = start_width;
    coord [i][0] = x0;
    coord [i][1] = y0;
    coord [i][2] = width;

    mode = 0;
    for (j=1; j<=howmany; j++)
      {
      if (mode) 
        {
        mode = 0;
        if (alu_clear) return;
        }
      else 
        {
        mode = 1;
        if (has_color) {
          current = (int)(((double)rand()/0x7ffffffe)*(7));
          if (current == 0) current = 1;
          if (set_color (current)) return;
          }
        else alu_set;
        }
      if (box (pgno, 0, x0, y0, width, width)) return;
      x0 += delta;
      y0 += delta;
      width -= (2*delta);
      if (getlocal() == 'q') goto outofit;
      }
    if (debug)
      {
      printf ("replay? ");
      gets(buf);
      if (buf[0]=='y')
        {
        x0    = coord [i][0];
        y0    = coord [i][1];
        width = coord [i][2];
        mode = 0;
        for (j=1; j<=howmany; j++)
          {
          if (mode) 
            {
            mode = 0;
            alu_clear;
            }
          else 
            {
            mode = 1;
            alu_set;
            }
          box (pgno, 0, x0, y0, width, width);
          x0 += delta;
          y0 += delta;
          width -= (2*delta);
          if (mode) 
            printf ("set   ");
          else 
            printf ("clear ");
          printf ("box (%d %d %d %d)    ", x0, y0, width, width);
          gets(buf);
          if (buf[0] == 'q') goto outofit;
          }
        }
      else if (buf[0]=='q') goto outofit;
      }
    if (getlocal() == 'q') goto outofit;
    }
  for (i=0; i <= 5; i++)
    {
    x0 = coord [i][0];
    y0 = coord [i][1];
    width = coord [i][2];
    if (alu_clear) return;
    if (box (pgno, 0, x0, y0, width, width)) return;
    }
  }
outofit: printf ("finished box test.\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}



bsetup (x0, y0, w, h)

int x0, y0, w, h;
{
  int i;
  int sub_w;

  /* create reference source pattern */

  if (w >= 32)
    {
    sub_w = w / 7;
    alu_set;
    box (pgno, 0, x0, y0, sub_w, h);
    alu_clear;
    box (pgno, 0, x0, y0, 1, 1);		/* corner dots */
    box (pgno, 0, x0, y0+h-1, 1, 1);
    for (i=1; i<=6; i++)
      {
      load_patt (i);
      boxp (PADDR_H, PADDR_L, 0, 0, pgno, 0, x0+(i*sub_w), y0, sub_w, h);
      }
    alu_set;	/* corner dots */
    box (pgno, 0, x0+w-1, y0, 1, 1);
    box (pgno, 0, x0+w-1, y0+h-1, 1, 1);
    }
  else if (w >= 2)
    {
    load_patt (4);
    boxp (PADDR_H, PADDR_L, 0, 0, pgno, 0, x0, y0, w, h);
    alu_set;
    box (pgno, 0, x0, y0, 1, h);
    alu_clear;
    box (pgno, 0, x0+w-1, y0, 1, h);

    alu_clear;				/* corner dots */
    box (pgno, 0, x0, y0, 1, 1);
    box (pgno, 0, x0, y0+h-1, 1, 1);
    alu_set;
    box (pgno, 0, x0+w-1, y0, 1, 1);
    box (pgno, 0, x0+w-1, y0+h-1, 1, 1);
    }
  else
    {
    alu_set;
    box (pgno, 0, x0, y0, 1, 1);
    }
}

btest ()

{ int  xs, ys, x0, y0;
  int  xdir, ydir;
  int  width, height;
  int  fudge;
  int  delay;
  char ans;
  char buf[10];

  printf ("blit test\n");
  printf ("width ? ");
  stripwhite(gets(buf));
  width = height = getnum(buf);
  xdir = ydir = 1;
  xs = (short)(((double)rand()/0x7ffffffe)*(BXMAX-width-1));
  ys = (short)(((double)rand()/0x7ffffffe)*(BYMAX-height-1));
  alu_set;
  bsetup (xs, ys, width, height);
  for (delay = 0; delay <= 100000; delay++);
  x0 = xs + xdir;
  y0 = ys + ydir;

  while (1)
    {
    boxc (pgno, 0, xs, ys, pgno, 0, x0, y0, width, height);
    if (debug)
      {
      printf ("boxc (%d %d %d %d %d %d)    ", xs, ys, x0, y0, width, height);
      gets(buf);
      if (buf[0] == 'q')
        goto outside;
      }
    ans = getlocal();
    if (ans == 'q') goto outside;
    else if (ans == 'f')
      {
      printf ("Freeze motion ...  (type f to resume)\n");
      while (getlocal() != 'f');
      }
    xs = x0;
    ys = y0;
    if (x0 <= 4)
      {
      fudge = (int)(((double)rand()/0x7ffffffe)*5);
      if (fudge == 0) fudge = 1;
      xdir =  fudge;
      if (ydir == 0)
        ydir = 1;
      else
        {
        fudge = (int)(((double)rand()/0x7ffffffe)*5);
        if (fudge == 0) ydir = 0;
        }
      }
    if (x0+width-1 >= (BXMAX-4)) 
      {
      fudge = (int)(((double)rand()/0x7ffffffe)*5);
      if (fudge == 0) fudge = 1;
      xdir = -fudge;
      if (ydir == 0)
        ydir = -1;
      else
        {
        fudge = (int)(((double)rand()/0x7ffffffe)*5);
        if (fudge == 0) ydir = 0;
        }
      }
    if (y0 <= 4)
      {
      fudge = (int)(((double)rand()/0x7ffffffe)*5);
      if (fudge == 0) fudge = 1;
      ydir =  fudge;
      }
    if (y0+height-1 >= (BYMAX-4))
      {
      fudge = (int)(((double)rand()/0x7ffffffe)*5);
      if (fudge == 0) fudge = 1;
      ydir = -fudge;
      }
    x0 += xdir;
    y0 += ydir;
    }
outside: printf ("finished box test.\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}



#define minval		20              /* minimum pixel value */
#define N		5               /* number of sides in the polygon */
#define Steps		32		/* # of interpolations between poly */
#define CLEAR		0		/* draw a black vector */
#define SET             1               /* draw a white vector */
#define TOGGLE          2               /* draw a complemented vector */

struct point
  {
  int x;
  int y;
  };

struct point ring_gon [Steps][N+1];



vtest ()

{
  int  i, j;
  int  ring_pntr;
  int  current;
  int  toggle_it;
  char buf[10];
  unsigned rand();

  struct point start_gon [N];
  struct point end_gon   [N];
  struct point delta_gon [N];

  /* Continuous Birthday Plot */

  printf ("vector test\n");
  if (has_color) {
    alu_clear;
    box (pgno, 0, 0, 0, BXMAX, BYMAX);
    }
  else {
    printf ("toggle? ");
    stripwhite(gets(buf));
    if (buf[0] == 'y') 
      toggle_it = 1;
    else 
      {
      toggle_it = 0;
      alu_clear;
      box (pgno, 0, 0, 0, BXMAX, BYMAX);
      }
  }
  for (i = 0; i <= Steps-1; i++)		/* initialize ring */
    {
    for (j = 0; j <= N; j++)
      {
      ring_gon [i][j].x = 0;
      ring_gon [i][j].y = 0;
      }
    }
  ring_pntr = 0;

  for (i = 0; i <= N-1; i++)			/* fill Start Polygon */
    {
    start_gon[i].x = (short)(((double)rand()/0x7ffffffe)*(BXMAX));
    start_gon[i].y = (short)(((double)rand()/0x7ffffffe)*(BYMAX));
    }

  while (getlocal() != 'q')
    {
    for (i = 0; i <= N-1; i++)			/* fill End Polygon */
      {
      /* find next random polygon */
      end_gon[i].x = (short)(((double)rand()/0x7ffffffe)*(BXMAX));
      end_gon[i].y = (short)(((double)rand()/0x7ffffffe)*(BYMAX));
      delta_gon[i].x = (end_gon[i].x - start_gon[i].x) / Steps;
      delta_gon[i].y = (end_gon[i].y - start_gon[i].y) / Steps;
      }


    for (i = 0; i <= Steps-1; i++)
      {
      for (j = 0; j <= N-1; j++)		/* copy start_gon to ring */
        {
        ring_gon [ring_pntr][j].x = start_gon [j].x;
        ring_gon [ring_pntr][j].y = start_gon [j].y;
        }
						/* store the first point
						   as the last to form a
						   closed polygon */
      ring_gon [ring_pntr][N].x = start_gon [0].x;
      ring_gon [ring_pntr][N].y = start_gon [0].y;

      if (has_color) {
        current = (int)(((double)rand()/0x7ffffffe)*(7));
        if (current == 0) current = 1;
        set_color (current);
        }
      else
        {
        if (toggle_it) alu_toggle;
        else alu_set;
        }
      if (draw_polygon (ring_pntr)) goto quitit;

      if (ring_pntr >= Steps-1)			/* increment ring pointer */
        ring_pntr = 0;
      else
        ring_pntr++;

      if (has_color)
        set_color (BLACK);
      else {
        if (toggle_it) alu_toggle;
        else alu_clear;
        }
      if (draw_polygon (ring_pntr)) goto quitit;

      for (j = 0; j <= N-1; j++)
        {
	start_gon [j].x += delta_gon [j].x;
        start_gon [j].y += delta_gon [j].y;
        }
      }
    }
  quitit: alu_clear;
  box (pgno, 0, 0, 0, BXMAX, BYMAX);
}


draw_polygon (pntr)
  int pntr;
{
  int i;
  char c[10];

  for (i = 0; i <= N-1; i++)
    {
    if (debug)
      {
      printf ("  %d->%d   %d %d %d %d  ", pntr, i,
                                          ring_gon[pntr][i].x,
                                          ring_gon[pntr][i].y,
				          ring_gon[pntr][i+1].x,
                                          ring_gon[pntr][i+1].y);
      gets (c);
      if (c[0] == 'q') return (1);
      }
    vector (pgno, 0,
            ring_gon[pntr][i].x,   ring_gon[pntr][i].y,
            ring_gon[pntr][i+1].x, ring_gon[pntr][i+1].y);
    }
    return (0);
}




ttest ()

{ int  x0, y0;
  int  width;
  int  delta;
  int  howmany;
  int  start_x0, start_y0;
  int  start_width;
  int  coord [6][3];
  int  i,j;
  int replay;
  char buf[10];
  unsigned rand();

  printf ("random box toggle test\n");
  if (debug)
    {
    printf ("replay? ");
    gets(buf);
    if (buf[0]=='y') replay = 1;
    else replay = 0;
    }
  while (1)
  {
  for (i=0; i <= 5; i++)
    {
    start_width = (short)(((double)rand()/0x7ffffffe)*(700));
    start_x0    = (short)(((double)rand()/0x7ffffffe)*(BXMAX-start_width));
    start_y0    = (short)(((double)rand()/0x7ffffffe)*(BYMAX-start_width));
    if (start_width < 8) start_width = 8;
    delta = 3;
    howmany = (start_width / (delta*2))+2;
    x0    = start_x0;
    y0    = start_y0;
    width = start_width;
    coord [i][0] = x0;
    coord [i][1] = y0;
    coord [i][2] = width;

    for (j=1; j<=howmany; j++)
      {
      alu_toggle;
      box (pgno, 0, x0, y0, width, width);
      if (debug && replay==0)
        {
        printf ("boxc (%d %d %d %d)    ", x0, y0, width, width);
        gets(buf);
        if (buf[0] == 'q')
          goto outofit;
        }
      x0 += delta;
      y0 += delta;
      width -= (2*delta);
      if (getlocal() == 'q') goto outofit;
      }
    if (debug && replay)
      {
      x0    = coord [i][0];
      y0    = coord [i][1];
      width = coord [i][2];
      alu_clear;
      box (pgno, 0, x0, y0, width, width);
      for (j=1; j<=howmany; j++)
        {
        alu_toggle;
        box (pgno, 0, x0, y0, width, width);
        x0 += delta;
        y0 += delta;
        width -= (2*delta);
        printf ("box (%d %d %d %d)    ", x0, y0, width, width);
        gets(buf);
        if (buf[0] == 'q') goto outofit;
        }
      }
    if (getlocal() == 'q') goto outofit;
    }
  for (i=0; i <= 5; i++)
    {
    x0 = coord [i][0];
    y0 = coord [i][1];
    width = coord [i][2];
    alu_clear;
    box (pgno, 0, x0, y0, width, width);
    }
  }
outofit: printf ("finished box test.\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}


ptest ()

{
  int mx, my, mw, mh;
  int x0, y0, width, height;
  int base_l;
  int filling;
  int delay;
  char mode;
  char ans;
  char buf[10];

  printf ("paint test\n");
  base_l = 0;
  mx = 128;
  my = 600;
  printf ("width? ");
  stripwhite(gets(buf));
  mw = getnum(buf);
  mh = mw;
  x0 = 127;
  y0 = 128;
  width  = mw;
  height = mh;

  printf ("background pattern? (0 - 7 (0=black, 1=white))  ");
  stripwhite(gets(buf));
  filling = getnum(buf);
  if ((filling < 0) || (filling > 7)) filling = 0;
  switch (filling)
    {
    case 0: alu_clear;
            box (pgno, base_l, 0, 0, BXMAX-16, BYMAX/2);
            break;
    case 1: alu_set;
            box (pgno, base_l, 0, 0, BXMAX-16, BYMAX/2);
            break;
    default:load_patt(filling-2);
            boxp (PADDR_H, PADDR_L, 0, 0, pgno, 0, 0, 0, BXMAX-16, BYMAX/2);
    }
  bsetup (mx, my, mw, mh);

  alu_set;
  mode = 's';
  ans = 'x';
  while (ans != 'q')
    {
    x0++;
    if (x0 >= 256)
      {
      x0 = 128;
      y0++;
      alu_clear;
      box (pgno, base_l, mx, my, mw, mh);
      mx++;
      my++;
      bsetup (mx, my, mw, mh);
      }
    if (y0 >= BYMAX/2-mh)
      {
      y0 = 128;
      mx = 128;
      my = 600;
      bsetup (mx, my, mw, mh);
      }

    paint (0, base_l, mx, my, pgno, base_l, x0, y0, width, height);
    if (debug)
      {
      printf ("paint (%d %d %d %d %d %d)    ", mx, my, x0, y0, width, height);
      gets(buf);
      ans = buf[0];
      if (ans == 'q') goto quitit;
      }
    else
      {
      ans = getlocal();
      if (ans == 'q') goto quitit;
      delay = 5000;
      while (delay--);
      }
    switch (filling)
      {
      case 0: alu_clear;
              box (pgno, base_l, x0, y0, width, height);
              break;
      case 1: alu_set;
              box (pgno, base_l, x0, y0, width, height);
              break;
      default:load_patt(filling-2);
              boxp (PADDR_H, PADDR_L, 0, 0, pgno, 0, x0, y0, width, height);
      }
    if (ans == 's' || ans == 'c' || ans == 't') mode = ans;
    switch (mode)
      {
      case 's' : alu_set;    break;
      case 'c' : alu_clear;  break;
      case 't' : alu_toggle; break;
      }
    }
quitit: printf ("quitting paint test\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}

mtest ()

/* This tests the interaction between vme and GIP accesses to the   */
/* display memory.  If the screen results in aleternating black and */
/* white spicture, then fonts are being loaded successfully in an   */
/* interleaved fashion into the display memory.                     */
{
int curr;

printf ("memory access test\n");

if (has_color) {
  curr = 0;
  while (getlocal() != 'q')
    {
    set_color (curr++);
    box (pgno, 0, 0, 0, BXMAX, BYMAX);
    load_font ();
    }
  }
else {
  alu_toggle;
  while (getlocal() != 'q')
    {
    box (pgno, 0, 0, 0, BXMAX, BYMAX);
    load_font ();
    }
  }
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}


ftest()

/* This is different from ctest in that it uses the paint function  */
/* to draw the characters.                                          */

{
  int src_h, src_l, dst_l;
  int scr_x, scr_y, scr_w, scr_h;
  int mx, my;
  int x0, y0, w, h;
  int line;
  int chr;
  int count;
  char ans;
  char buf[10];

#define TTY_H	24
#define TTY_W	80

  printf ("font scroll test\n");
  load_font ();
  dst_l = 0;
  src_h = FADDR_H;
  src_l = FADDR_L;
  scr_x = 128;
  scr_y = 128;
  scr_w = FCDISP * TTY_W;
  scr_h = FHIGHT * TTY_H;
  line  = 0;
  chr   = 0;
  mx    = 0;
  ans = 'x';

  /* setup perimeter box */
  alu_set;
  box (pgno, dst_l, scr_x-4, scr_y-4, scr_w+8, scr_h+8);
  alu_clear;
  box (pgno, dst_l, scr_x-3, scr_y-3, scr_w+6, scr_h+6);

  src_pitch(1);

  while (ans != 'q')
    {
    x0 = scr_x;
    y0 = scr_y + (line*FHIGHT);
    w  = FWIDTH;
    h  = FHIGHT;
    alu_set;
    for (count = 1; count <= TTY_W; count++)
      {
      if (++chr > 127) chr = 0;
      my = FHIGHT*chr;
      paint (src_h, src_l, mx, my, pgno, dst_l, x0, y0, w, h);
      x0 += FCDISP;
      }
    if (line == 23)
      { 					/* scroll up a line */
      src_pitch(40);
      boxc (pgno, dst_l, scr_x, scr_y+FHIGHT,
            pgno, dst_l, scr_x, scr_y, scr_w, scr_h-FHIGHT);
      alu_clear;
      box  (pgno, dst_l, scr_x, scr_y+((TTY_H-1)*FHIGHT), scr_w, FHIGHT);
      alu_set;
      src_pitch(1);
      ans = getlocal();
      if (ans == 'q') goto quitit;
      else if (ans == 'f')
        {
        printf ("Freeze motion ...  (type f to resume)\n");
        while (getlocal() != 'f');
        }
      }
    if (line < 23) line++;
    }
quitit: printf ("finished font test\n");
src_pitch(40);
alu_clear;
box (pgno, dst_l, 0, 0, BXMAX, BYMAX);
}


ntest ()

{
  int x0, y0, width, height, xp, yp;
  char buf[10];

  printf ("Box pattern phasing test\n");
  width = height = 512;
  load_patt(6);

  while (getlocal() != 'q')
  for (x0 = 128; x0 <= 256; x0++)
    {
    y0 = x0;
    alu_set;
    box (pgno, 0, x0-2, y0-2, width+4, height+4);
    alu_clear;
    box (pgno, 0, x0-1, y0-1, width+2, height+2);

    for (xp = 0; xp <= width; xp++)
      {
      yp = xp;
      boxp (PADDR_H, PADDR_L, xp, yp, pgno, 0, x0, y0, width, height);
      if (debug)
        {
        printf ("boxp %d %d  ", xp, yp);
        gets(buf);
        if (buf[0] == 'q') goto quitit;
        }
      else if (getlocal() == 'q') goto quitit;
      }
    for (yp = 0; yp <= 32; yp++)
      for (xp = 0; xp <= 32; xp++)
        {
        boxp (PADDR_H, PADDR_L, xp, yp, pgno, 0, x0, y0, width, height);
        if (debug)
          {
          printf ("boxp %d %d  ", xp, yp);
          gets(buf);
          if (buf[0] == 'q') goto quitit;
          }
        else if (getlocal() == 'q') goto quitit;
        }
    }
quitit: printf ("quitting phasing test\n");
alu_clear;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
}

xtest ()

{
int red, green, blue, current;
int r1, r2, g1, g2, b1, b2;
int delay, count;
char buf[10];

printf("special lookup test\n");

printf ("enter frame1 color (r g b)\n");
stripwhite(gets(buf));
r1 = getnum(buf);
stripwhite(gets(buf));
g1 = getnum(buf);
stripwhite(gets(buf));
b1 = getnum(buf);

printf ("enter frame2 color (r g b)\n");
stripwhite(gets(buf));
r2 = getnum(buf);
stripwhite(gets(buf));
g2 = getnum(buf);
stripwhite(gets(buf));
b2 = getnum(buf);

printf ("delay? ");
stripwhite(gets(buf));
delay = getnum(buf);
current =15;
red = 0;
while (getlocal() != 'q')
   {
   count = delay;
   while (count--);
   red = r1;
   green = g1;
   blue = b1;
   set_lookup (red, green, blue, current);
   count = delay;
   while (count--);
   red = r2;
   green = g2;
   blue = b2;
   set_lookup (red, green, blue, current);
   }
}



lookup ()

{
int laps;
int red, green, blue;
int x0, y0;
int current;
int delay;

if (has_color) 
  printf ("Color Lookup Table Test\n");
else
  {
  printf ("Not a Color System\n");
  return;
  }
laps = 0;
current = 0;
for (x0 = 0; x0 < 1280; x0+=320)
   for (y0 = 0; y0 < 1024; y0+=256)
      {
      set_color (current++);
      box (pgno, 0, x0, y0, 320, 256);
      }
while (getlocal() != 'q')
   {
   printf ("Lap %d\n",++laps);
   for (current = 0; current <= 15; current++)
      {
      for (red=0; red<=15; red++)
         for (green=0; green<=15; green++)
            for (blue=0; blue<=15; blue++)
               {
               if (debug) printf("RGB = %d,%d,%d\n",red, green, blue);
               set_lookup (red, green, blue, current);
               if (getlocal() == 'q') goto getout;
               }
      init_color_table ();
      } 
   }
getout: init_color_table ();
}
