
#include "fifo.h"
#include "graphics.h"
extern int has_color;
int hdebug;

hardware ()
{ char c[10];
  int i;

  printf ("Hardware tests\n");
  c[0] = '0';
  hdebug = 0;


  while (c[0] != 'q')
    {
    printf ("\nh> ");
    gets (c);
    switch (c[0])
      {
#if HASWCS
      case 'c' : circulate ();  break;
      case 'e' : uc_exec ();    break;
      case 'p' : pattern ();    break;
      case 's' : snake ();      break;
      case 't' : wcs_test();    break;
      case 'w' : wcs_rw ();     break;
#endif HASWCS
      case 'b' : bar_test();    break;
      case 'd' : debugmode();   break;
      case 'f' : jamfifo ();    break;
      case 'g' : grid ();       break;
      case 'i' : int_test();    break;
      case 'l' : look ();       break;
      case 'm' : byte_mem_rw(); break;
      case 'n' : word_mem_rw(); break;
      case 'o' : long_mem_rw(); break;
      case 'r' : auto_repeat(); break;
      case 'v' : mem_test ();   break;
      case 'z' : zap_test ();   break;
      case '?' : 
                 printf ("   d) debug mode\n");
                 printf ("   f) fifo read write test\n");
                 printf ("   g) alignment grid\n");
		 printf ("   h) byte/word/long display memory test\n");
                 printf ("   i) interrupt test\n");
                 printf ("   l) look at display memory\n");
                 printf ("   m) byte memory read and write exercise\n");
                 printf ("   n) word memory read and write exercise\n");
                 printf ("   o) long memory read and write exercise\n");
                 printf ("   r) microcode auto repeat\n");
                 printf ("   q) quit and return to main prompt\n");
                 printf ("   v) vme memory access test\n");
                 printf ("   z) zap test\n");
#if HASWCS
                 printf ("\n   c) circulate snake register\n");
 		 printf ("   e) ucode run/halt test\n");
                 printf ("   p) pattern circulate in snake path\n");
                 printf ("   s) snake register read and write\n");
                 printf ("   w) wcs read and write\n");
                 printf ("   t) test wcs\n");
#endif HASWCS
                 if (has_color) printf ("\n   b) color memory bar test\n");
                 break;
      }
    }
}



debugmode ()

{
  if (hdebug == 0)
    {
    printf ("turning debug mode ON.\n");
    hdebug = 1;
    }
  else
    {
    printf ("turning debug mode OFF.\n");
    hdebug = 0;
    }
}




jamfifo ()

{ short p1;
  int delay, counter;
  int lstat, fstat;
  int readit;
  char buf[20];

  printf ("continuous fifo test\n");
  printf ("read?  ");
  stripwhite(gets(buf));
  if (buf[0] == 'y') readit = 1;
  else readit = 0;
  lstat = 7;
  p1 = 0xffff;

  if (readit == 0)
    {
    printf ("delay?  ");
    stripwhite(gets(buf));
    delay = getnum(buf);
    printf ("continuously reading the fifo for changes....\n");
    }
  else
    {
    printf ("continuously writing %x to the fifo....\n", p1);
    }

  while (getlocal() != 'q')
    {
    if (readit)
      {
      fstat = *FIFO;
      if (fstat != lstat)
        {
        printf ("fifo status  %x\n",fstat);
        lstat = fstat;
        }
      }
    else
      {
      *FIFO = p1;
      counter = delay;
      while (counter--);
      }
    }
}

#if HASWCS
snake ()

{ int i;
  int word;

  printf ("  both read and write snake register\n");
  while (getlocal() != 'q')
    {
    for (i = 0; i <= 32767; i++)
      {
      *SNAKE = (short) i;
      word = (int)*SNAKE;
      if ((i != word) && !hdebug)
        printf("  snake register returned different value!\n");
      }
    }
}

pattern ()

{ int i;

  printf ("  pattern circulate\n");
  for (i=1; i <= 96; i++)
    {
    *SNAKE = (short) 0;
    *SHIFT = 0xffff;				/* clear out snakes */
    }
  *SNAKE = (short) 0xd;
  while (getlocal() != 'q') *SHIFT = 0xffff;
}



circulate ()

/* Does both a read and write to SHIFT.  When reading SHIFT, no */
/* shifting actually occurs, but the microcode state is read.   */

{
  printf ("  shift snake registers and reading microcode state\n");
  while (getlocal() != 'q')
    {
    *SHIFT = 0xffff;
    if (*SHIFT);
    }
}

uc_exec ()

/* Tests the ucode run/halt pal on the wcs board by simulating  */
/* run, halt and singlestep commands.			        */

{
  int delay, count;
  char buf[10];

  printf ("  ucode run/halt test\n");
  printf ("  delay?  ");
  stripwhite(gets(buf));
  delay = getnum(buf);
  printf ("  singlestep ?  ");
  stripwhite(gets(buf));
 
  if (buf[0] == 'y')
    {
    *HALT = 0xffff;
    while (getlocal() != 'q')
      {
      *STEP = 0xffff;
      count = delay;
      while (count--);
      *STEP = 0xffff;
      count = delay;
      while (count--);
      }
    *RUN = 0xffff;
    }
  else
    {
    while (getlocal() != 'q')
      {
      *RUN  = 0xffff;
      count = delay;
      while (count--);
      *HALT = 0xffff;
      count = delay;
      *SNAKE = 0xffff;   /* The following should not matter */
      *SHIFT = 0xffff;
      *WCS   = 0xffff;
      while (count--);
      }
    *RUN  = 0xffff;
    }
}


wcs_rw ()

/* Just read and write from wcs */

{
  int wcs_addr;
  unsigned short *addr;
  char buf[20];

  printf ("  read and write from wcs\n");
  printf ("  address? ");
  stripwhite(gets(buf));
  wcs_addr = gethex(buf);
  addr  = WCS + wcs_addr;
  while (getlocal() != 'q')
    {
    *addr = (short) 0xffff;
    if (*addr);
    }
}



# define NPATT2 36
short tpatt[NPATT2] = {0,
			0x1, 0x2, 0x4, 0x8,
			0x10, 0x20, 0x40, 0x80,
			0x100, 0x200, 0x400, 0x800,
			0x1000, 0x2000, 0x4000, 0x8000,
			~0x1, ~0x2, ~0x4, ~0x8,
			~0x10, ~0x20, ~0x40, ~0x80,
			~0x100, ~0x200, ~0x400, ~0x800,
			~0x1000, ~0x2000, ~0x4000, ~0x8000,
                         0xffff, 0x5555, 0xaaaa};


wcs_test  ()

{ int words, i, j, pattnum, lap;
  unsigned short data, patt;
  unsigned short *addr;
  char buf[80];

printf ("  Test WCS\n");
lap = 1;

while (getlocal() != 'q')
  {
  printf ("\n  Lap %d\n", lap++);

  /* check addresses to wcs first */
  printf ("\r     write address   ");
  for (words = 0; words <= 2047; words++)
    {
    for (i=1; i <= 5; i++)
      {
      *SNAKE = (short) words;
      for (j=1; j <= 16; j++) *SHIFT = 0xffff;
      }
    addr  = WCS + words;
    *addr = (short) 0xffff;
    }
  printf ("\r     check address    ", patt);
  for (words = 0; words <= 2047; words++)
    {
    addr  = WCS + words;
    if (*addr);
    for (j=1; j <= 16; j++) *SHIFT = 0xffff;  /* dont look at PA bus */
    for (i=1; i <= 4; i++)
      {
      for (j=1; j <= 16; j++) *SHIFT = 0xffff;
      data = *SNAKE;
      patt = (short)words;
      if ((data != patt) && !hdebug) 
        printf ("\nwrote wcs[%d,%d] %x, snake returned %x",words,i,patt,data);
      }
    }


  for (pattnum = 0; pattnum <= NPATT2 - 1; pattnum++)
    {
    if (getlocal() == 'q') goto outofit;
    patt = tpatt[pattnum];
  
    printf ("\r     writing   %x    ", patt);
    /* fill up snake with test pattern */
    for (i=1; i <= 5; i++)
      {
      *SNAKE = (short) patt;
      for (j=1; j <= 16; j++) *SHIFT = 0xffff;
      }

    /* write to wcs */
    for (words = 0; words <= 2047; words++)
      {
      addr  = WCS + words;
      *addr = (short) 0xffff;
      }
  
    /* read from wcs */
    printf ("\r     verifying %x    ", patt);
    for (words = 0; words <= 2047; words++)
      {
      addr  = WCS + words;
      if (*addr);
      for (j=1; j <= 16; j++) *SHIFT = 0xffff;  /* dont look at PA bus */
      for (i=1; i <= 4; i++)
        {
        for (j=1; j <= 16; j++) *SHIFT = 0xffff;
        data = *SNAKE;
        if ((data != patt) && !hdebug) 
          printf ("\nwrote wcs[%d,%d] %x, snake returned %x",words,i,patt,data);
        }
      }
    }
  }
outofit: printf ("\n");
}
#endif HASWCS


look ()

{
  unsigned short wpatt, rpatt;
  register unsigned short *addr;
  char buf[20];

  printf ("address? ");
  stripwhite(gets(buf));
  addr = (unsigned short *)gethex(buf);

  while (1)
    {
    rpatt = *addr;
    printf ("%x = %x    ",(int)addr,rpatt);
    stripwhite(gets(buf));
    if (buf[0] == 'q') break;
    if ((buf[0] >= '0' && buf[0] <= '9') ||
        (buf[0] >= 'a' && buf[0] <= 'f'))
       {
       wpatt = gethex(buf);
       *addr = wpatt;
       }
    addr++;
    }
}


word_mem_rw ()

{
  int counter, delay;
  int alternate;
  char buf[20];
  char fromtty, wonly;
  unsigned short wpatt0, rpatt;
  register unsigned short *addr, *start, *stop;
  int current;
  int plane0, plane1, plane2, plane3;
  unsigned short wpatt1,  wpatt2,  wpatt3;
  unsigned short *start1, *start2, *start3;
  unsigned short *stop1,  *stop2,  *stop3;

  if (has_color) {
  printf ("  Access all of display memory? ");
  stripwhite(gets(buf));
  if (buf[0] == 'y')
    {
    start  = (unsigned short *)PG0_START;
    stop   = (unsigned short *)PG0_END;
    start1 = (unsigned short *)PG1_START;
    stop1  = (unsigned short *)PG1_END;
    start2 = (unsigned short *)PG2_START;
    stop2  = (unsigned short *)PG2_END;
    start3 = (unsigned short *)PG3_START;
    stop3  = (unsigned short *)PG3_END;
    }
  else
    {
    printf("  Enter hex start address: ");
    stripwhite(gets(buf));
    start = (unsigned short *)gethex(buf);
    printf("  Enter hex stop address:  ");
    stripwhite(gets(buf));
    stop = (unsigned short *)gethex(buf);
    start1 = start  + 0x20000;
    start2 = start1 + 0x20000;
    start3 = start2 + 0x20000;
    stop1  = stop   + 0x20000;
    stop2  = stop1  + 0x20000;
    stop3  = stop2  + 0x20000;
    }
  printf ("\n  Start   Stop\n");
  printf ("  %x  %x\n",(int)start, (int)stop);
  printf ("  %x  %x\n",(int)start1,(int)stop1);
  printf ("  %x  %x\n",(int)start2,(int)stop2);
  printf ("  %x  %x\n",(int)start3,(int)stop3);
  }
else {
  printf ("  Access all of display memory? ");
  stripwhite(gets(buf));
  if (buf[0] == 'y')
    {
    start = (unsigned short *)STARTADDR;
    stop  = (unsigned short *)MAXADDR;
    }
  else
    {
    printf("  Enter hex start address: ");
    stripwhite(gets(buf));
    start = (unsigned short *)gethex(buf);
    printf("  Enter hex stop address:  ");
    stripwhite(gets(buf));
    stop = (unsigned short *)gethex(buf);
    }
}


  printf ("\n  commands :   b    Do reading and writing\n");
  printf ("               r    read only\n");
  printf ("               w    write only (default)\n");
  printf ("               0    use 0000 for pattern (default)\n");
  printf ("               1    use 1111 for pattern\n");
  printf ("               5    use 5555 for pattern\n");
  printf ("               f    use ffff for pattern\n");
  printf ("               p    enter custom pattern\n");
  printf ("               a    alternate complemented pattern\n");
  printf ("               d    set delay between write and read\n");
  printf ("               e    enable writing to planes\n");
  printf ("               q    quit\n");

  delay = 0;
  fromtty = 'x';
  wonly   = 'w'; 
  wpatt0    = 0x0000;
  wpatt1    = 0x0000;
  wpatt2    = 0x0000;
  wpatt3    = 0x0000;
  plane0 = plane1 = plane2 = plane3 = 1;
  alternate = 0;
  while (fromtty != 'q')
    {
    if (alternate)
      {
      if (has_color) {
        if (plane0) wpatt0 = ~wpatt0;
        if (plane1) wpatt1 = ~wpatt1;
        if (plane2) wpatt2 = ~wpatt2;
        if (plane3) wpatt3 = ~wpatt3;
        }
      else wpatt0 = ~wpatt0;
      }
    switch (wonly)
       {
       case 'w' : if (has_color) {
                    if (plane0) 
                      for (addr = start; addr <= stop; addr++)
                      *addr = wpatt0;
                    if (plane1)
                      for (addr = start1; addr <= stop1; addr++)
                      *addr = wpatt1;
                    if (plane2)
                      for (addr = start2; addr <= stop2; addr++)
                      *addr = wpatt2;
                    if (plane3)
                      for (addr = start3; addr <= stop3; addr++)
                      *addr = wpatt3;
                    }
                  else for (addr = start; addr <= stop; addr++)
                    *addr = wpatt0;
                  break;
       case 'r' : for (addr = start; addr <= stop; addr++)
                    rpatt = *addr;
                  break;
       case 'b' : for (addr = start; addr <= stop; addr++)
                    {
                    *addr = wpatt0;
		    counter = delay;
                    while (counter--);
                    rpatt = *addr;
/*
                    if (hdebug && (rpatt != wpatt0))
                       printf ("[%x] wrote %x, read %x\n", 
		               (int)addr, wpatt0, rpatt);
*/
                    }
                  break;
       }

    switch (fromtty)
       {
       case 'b' : printf ("  now doing writing and reading.\n");
                  wonly = 'b';
                  break;
       case 'd' : printf ("  delay?  ");
 		  stripwhite(gets(buf));
                  delay = getnum(buf);
		  break;
       case 'e' : printf ("\n  enable plane 0? ");
 		  stripwhite(gets(buf));
                  plane0 = getnum(buf);
                  printf ("  enable plane 1? ");
 		  stripwhite(gets(buf));
                  plane1 = getnum(buf);
                  printf ("  enable plane 2? ");
 		  stripwhite(gets(buf));
                  plane2 = getnum(buf);
                  printf ("  enable plane 3? ");
 		  stripwhite(gets(buf));
                  plane3 = getnum(buf);
                  break;
       case 'r' : printf ("  now doing reading only.\n");
                  wonly = 'r';
                  break;
       case 'w' : printf ("  now doing writing only.\n");
                  wonly = 'w';
                  break;
       case 'p' : if (has_color) {
                  printf ("\n");
                  if (plane0) {
                    printf ("  Plane 0 pattern:  ");
                    stripwhite(gets(buf));
                    wpatt0 = gethex(buf);
                    }
                  if (plane1) {
		    printf ("  Plane 1 pattern:  ");
                    stripwhite(gets(buf));
                    wpatt1 = gethex(buf);
                    }
                  if (plane2) {
		    printf ("  Plane 2 pattern:  ");
                    stripwhite(gets(buf));
                    wpatt2 = gethex(buf);
                    }
                  if (plane3) {
		    printf ("  Plane 3 pattern:  ");
                    stripwhite(gets(buf));
                    wpatt3 = gethex(buf);
                    }
                  }
                else {
                  printf ("  Enter pattern:  ");
                  stripwhite(gets(buf));
                  wpatt0 = gethex(buf);
                  }
                  break;
       case '0' : wpatt0 = 0x0000; break;
       case '1' : wpatt0 = 0x1111; break;
       case '5' : wpatt0 = 0x5555; break;
       case 'f' : wpatt0 = 0xffff; break;
       case 'a' : if (alternate)
                    {
                    alternate = 0;
                    printf ("turning off alternate pattern\n");
                    }
                  else 
                    {
                    alternate = 1;
                    printf ("turning on alternate pattern\n");
                    }
                  break;
       }
    fromtty = getlocal ();
    }
}






long_mem_rw ()

{
  int alternate;
  char buf[20];
  char fromtty, wonly;
  unsigned long wpatt0, rpatt;
  register unsigned long *addr, *start, *stop;

  printf ("  Access all of display memory? ");
  stripwhite(gets(buf));
  if (buf[0] == 'y')
    {
    start = (unsigned long *)STARTADDR;
    stop  = (unsigned long *)MAXADDR;
    }
  else
    {
    printf("  Enter hex start address: ");
    stripwhite(gets(buf));
    start = (unsigned long *)gethex(buf);
    printf("  Enter hex stop address:  ");
    stripwhite(gets(buf));
    stop = (unsigned long *)gethex(buf);
    }

  printf ("\n  commands :   b    Do reading and writing\n");
  printf ("               r    read only\n");
  printf ("               w    write only (default)\n");
  printf ("               0    use 00000000 for pattern (default)\n");
  printf ("               1    use 11111111 for pattern\n");
  printf ("               5    use 55555555 for pattern\n");
  printf ("               f    use ffffffff for pattern\n");
  printf ("               p    enter custom pattern\n");
  printf ("               a    alternate complemented pattern\n");
  printf ("               q    quit\n");

  fromtty   = 'x';
  wonly     = 'w'; 
  wpatt0    = 0x0;
  alternate = 0;
  while (fromtty != 'q')
    {
    if (alternate)
      {
      wpatt0 = ~wpatt0;
      }
    switch (wonly)
       {
       case 'w' : for (addr = start; addr <= stop; addr++)
                    *addr = wpatt0;
                  break;
       case 'r' : for (addr = start; addr <= stop; addr++)
                    rpatt = *addr;
                  break;
       case 'b' : for (addr = start; addr <= stop; addr++)
                    {
                    *addr = wpatt0;
                    rpatt = *addr;
                    }
                  break;
       }

    switch (fromtty)
       {
       case 'b' : printf ("  now doing writing and reading.\n");
                  wonly = 'b';
                  break;
       case 'r' : printf ("  now doing reading only.\n");
                  wonly = 'r';
                  break;
       case 'w' : printf ("  now doing writing only.\n");
                  wonly = 'w';
                  break;
       case 'p' : printf ("  Enter pattern:  ");
                  stripwhite(gets(buf));
                  wpatt0 = gethex(buf);
                  break;
       case '0' : wpatt0 = 0x00000000; break;
       case '1' : wpatt0 = 0x11111111; break;
       case '5' : wpatt0 = 0x55555555; break;
       case 'f' : wpatt0 = 0xffffffff; break;
       case 'a' : if (alternate)
                    {
                    alternate = 0;
                    printf ("turning off alternate pattern\n");
                    }
                  else 
                    {
                    alternate = 1;
                    printf ("turning on alternate pattern\n");
                    }
                  break;
       }
    fromtty = getlocal ();
    }
}



byte_mem_rw ()

{
  int alternate;
  char buf[20];
  char fromtty, wonly;
  unsigned char wpatt0, rpatt;
  register unsigned char *addr, *start, *stop;

  printf ("  Access all of display memory? ");
  stripwhite(gets(buf));
  if (buf[0] == 'y')
    {
    start = (unsigned char *)STARTADDR;
    stop  = (unsigned char *)MAXADDR;
    }
  else
    {
    printf("  Enter hex start address: ");
    stripwhite(gets(buf));
    start = (unsigned char *)gethex(buf);
    printf("  Enter hex stop address:  ");
    stripwhite(gets(buf));
    stop = (unsigned char *)gethex(buf);
    }

  printf ("\n  commands :   b    Do reading and writing\n");
  printf ("               r    read only\n");
  printf ("               w    write only (default)\n");
  printf ("               0    use 00000000 for pattern (default)\n");
  printf ("               1    use 11111111 for pattern\n");
  printf ("               5    use 55555555 for pattern\n");
  printf ("               f    use ffffffff for pattern\n");
  printf ("               p    enter custom pattern\n");
  printf ("               a    alternate complemented pattern\n");
  printf ("               q    quit\n");

  fromtty   = 'x';
  wonly     = 'w'; 
  wpatt0    = 0x0;
  alternate = 0;
  while (fromtty != 'q')
    {
    if (alternate)
      {
      wpatt0 = ~wpatt0;
      }
    switch (wonly)
       {
       case 'w' : for (addr = start; addr <= stop; addr++)
                    *addr = wpatt0;
                  break;
       case 'r' : for (addr = start; addr <= stop; addr++)
                    rpatt = *addr;
                  break;
       case 'b' : for (addr = start; addr <= stop; addr++)
                    {
                    *addr = wpatt0;
                    rpatt = *addr;
                    }
                  break;
       }

    switch (fromtty)
       {
       case 'b' : printf ("  now doing writing and reading.\n");
                  wonly = 'b';
                  break;
       case 'r' : printf ("  now doing reading only.\n");
                  wonly = 'r';
                  break;
       case 'w' : printf ("  now doing writing only.\n");
                  wonly = 'w';
                  break;
       case 'p' : printf ("  Enter pattern:  ");
                  stripwhite(gets(buf));
                  wpatt0 = gethex(buf);
                  break;
       case '0' : wpatt0 = 0x00000000; break;
       case '1' : wpatt0 = 0x11111111; break;
       case '5' : wpatt0 = 0x55555555; break;
       case 'f' : wpatt0 = 0xffffffff; break;
       case 'a' : if (alternate)
                    {
                    alternate = 0;
                    printf ("turning off alternate pattern\n");
                    }
                  else 
                    {
                    alternate = 1;
                    printf ("turning on alternate pattern\n");
                    }
                  break;
       }
    fromtty = getlocal ();
    }
}



bar_test ()

{
  int i;
  unsigned short clear, wpatt;
  register unsigned short *addr, *start, *stop;

  printf ("bar test, one plane at a time....\n");
  wpatt = 1;
  clear = 0;
  while (getlocal()!= 'q')    {
  	  printf ("\rPlane 0");
	    for (i=0; i <=15; i++)
	    	for (addr =  (unsigned short *)PG0_START; 
	        		addr <= (unsigned short *)PG0_END; addr++)
	    		*addr = wpatt << i;
	    for (addr =  (unsigned short *)PG0_START; 
	        	   addr <= (unsigned short *)PG0_END; addr++)
	        	*addr = clear;
	    if (getlocal() == 'q') goto getitout;

	    printf ("\rPlane 1");
	    for (i=0; i <=15; i++)
	    	for (addr =  (unsigned short *)PG1_START; 
	        		addr <= (unsigned short *)PG1_END; addr++)
	        	*addr = wpatt << i;
	    for (addr =  (unsigned short *)PG1_START; 
	        	addr <= (unsigned short *)PG1_END; addr++)
	    	*addr = clear;
	    if (getlocal() == 'q') goto getitout;

	    printf ("\rPlane 2");
	    for (i=0; i <=15; i++)
	    	for (addr =  (unsigned short *)PG2_START; 
	      		  	addr <= (unsigned short *)PG2_END; addr++)
	      		*addr = wpatt << i;
	    for (addr =  (unsigned short *)PG2_START; 
	      			addr <= (unsigned short *)PG2_END; addr++)
	      		*addr = clear;
	    if (getlocal() == 'q') goto getitout;

	    printf ("\rPlane 3");
	    for (i=0; i <=15; i++)
	    	for (addr =  (unsigned short *)PG3_START; 
	        		addr <= (unsigned short *)PG3_END; addr++)
	        	*addr = wpatt << i;
	    for (addr =  (unsigned short *)PG3_START; 
	    		addr <= (unsigned short *)PG3_END; addr++)
	    	*addr = clear;
	}
 
getitout: printf ("\n");
}

grid ()
/* draws a grid on the screen for alignment purposes */
{
int x0, y0, x1, y1;
int grid_color;
char buf[10];

printf ("alignment grid\n");
alu_clear;
box (0, 0, 0, 0, BXMAX, BYMAX);
if (has_color) {
	grid_color = 0;
	printf ("turn on red?   ");
	stripwhite(gets(buf));
	if (buf[0] == 'y') grid_color = 1;
	printf ("turn on green? ");
	stripwhite(gets(buf));
	if (buf[0] == 'y') grid_color += 2;
	printf ("turn on blue?  ");
	stripwhite(gets(buf));
	if (buf[0] == 'y') grid_color += 4;
	set_color(grid_color);
}
else alu_set;

x0 = 0;						/* draw horizontal lines */
x1 = 1279;
for (y0 = 0; y0 <= 1023; y0+=32)  {
	y1 = y0;
	vector (0, 0, x0, y0, x1, y1);
}
vector (0, 0, x0, 1023, x1, 1023);

y0 = 0;						/* draw vertical lines */
y1 = 1023;
for (x0 = 0; x0 <= 1279; x0+=32)  {
	x1 = x0;
	vector (0, 0, x0, y0, x1, y1);
}
vector (0, 0, 1279, y0, 1279, y1);

for (x0 = 15; x0 <= 1279; x0+=32)		/* draw dots */
  for (y0 = 15; y0 <= 1023; y0+=32)
    box (0, 0, x0, y0, 1, 1);

}


int_test ()

{
  int count, delay;
  char buf[10];

  printf ("interrupt test\n");
  printf ("delay?  ");
  stripwhite(gets(buf));
  delay = getnum(buf);

  while (getlocal() != 'q')
    {
    if (*RESET);
    count = 10000;
    while (count--);
    poll (INTON);
    count = delay;
    while (count--);
    }
}




poll (param)

int param;
{
int count;

fifo_wait();
*FIFO = param;
}




zap_test()

{
  register unsigned short *addr, *start, *stop;
  int i, patt;

  printf("zap test.... (alternating setting screen and zap)\n");
  while (getlocal() != 'q')
    {
    printf("\rSetting...");
    start = (unsigned short *)STARTADDR;
    stop  = (unsigned short *)MAXADDR;
    patt = 0xffff;
    for (addr = start; addr <= stop; addr++)
      *addr = (unsigned short) patt;

    printf("\rZapping...");
    poll (INIT);
    for (i=1; i<=100000; i++);
    }
}




static int ucmd[128];

auto_repeat ()

{
int  cmd_pntr,i;
char prm;
char buf[10];

printf ("Microcode command stream auto-repeat\n");
printf ("Enter microcode command and parameters, end with q.\n\n");

prm = 'x';
cmd_pntr = 0;
while (prm != 'q')
  {
  printf ("parameter(%d) ?  ",cmd_pntr);
  stripwhite(gets(buf));
  if (buf[0] == 'q') break;
  switch (buf[0])
    {
    case 'a' : printf ("alu clear, set or toggle? ");
               stripwhite(gets(buf));
               switch (buf[0])
                 {
                 case 'c' : ucmd[cmd_pntr++] = 0x8001;	break;  /* alu_clear */
                 case 's' : ucmd[cmd_pntr++] = 0x8002;  break;  /* alu_set */
                 case 't' : ucmd[cmd_pntr++] = 0x8003;  break;  /* alu_toggle */
                 default  : printf ("invalid command\n"); break;
                 }
               break;
    case 'b' : printf ("box fill, copy or paint? ");
               stripwhite(gets(buf));
               switch (buf[0])
                 {
                 case 'f' : ucmd[cmd_pntr++] = 0x8004;	break;  /* box */
                 case 'c' : ucmd[cmd_pntr++] = 0x8005;  break;  /* box_copy */
                 case 'p' : ucmd[cmd_pntr++] = 0x8006;  break;  /* box_paint */
                 default  : printf ("invalid command\n"); break;
                 }
               break;
    case 'c' : printf ("clip parameter, active or inactive? ");
               stripwhite(gets(buf));
               switch (buf[0])
                 {
                 case 'p' : ucmd[cmd_pntr++] = 0x8007;	break;  /* clip */
                 case 'a' : ucmd[cmd_pntr++] = 0x8008;  break;  /* clip_on */
                 case 'i' : ucmd[cmd_pntr++] = 0x8009;  break;  /* clip_off */
                 default  : printf ("invalid command\n"); break;
                 }
               break;
    case 'i' : ucmd[cmd_pntr++] = 0x800A;  break;  /* init */
    case 'p' : ucmd[cmd_pntr++] = 0x800D;  break;  /* paint */
    case 'v' : ucmd[cmd_pntr++] = 0x8013;  break;  /* vector */
    case 'l' : ucmd[cmd_pntr++] = 0x8020;  break;  /* set lookup table */
    case 's' : ucmd[cmd_pntr++] = 0x8021;  break;  /* set current color */
    default  : ucmd[cmd_pntr++] = getnum(buf);
    }
  }

printf ("\nBeginning microcode execution.\n");
while (getlocal() != 'q')
  {
  for (i= 0; i < cmd_pntr; i++)
    {
    if (hdebug)
      {
      printf ("parameter (%d)   %d  0x%x",i,ucmd[i],ucmd[i]);
      gets(buf);
      if (buf[0] == 'q') goto quitit;
      }
    poll ( ucmd[i] );
    }
  }
quitit: printf ("finished.\n");
}
