#include "graphics.h"
#include "fifo.h"
#include "font.h"
#include "patt.h"
#include "color.h"

extern int use_intrp;
extern int hadint;
extern int pgno;
extern int has_color;

int clip_status;
int clip_x, clip_y;
int clip_w, clip_h;
int dst_h, dst_l;
int src_h, src_l;

graphics ()

{ char c[10];
  int filling;
  int i;
  int xs;
  int width;

  dst_h = dst_l = 0;
  src_h = src_l = 0;
  c[0]  = ' ';

  printf ("Graphic Commands\n");

/*
  load_font ();
  load_patt (4);
*/
  while (c[0] != 'q')
    {
    printf ("\ng> ");
    gets (c);
    switch (c[0])
      {
      case 'a' : get_alu();      break;
      case 'b' : get_box('b');   break;
      case 'c' : get_clip();     break;
      case 'd' : get_pitch('d'); break;
#if HAS_WCS
      case 'h' : proc_state();   break;
#endif
      case 'i' : get_intrp();    break;
      case 'l' : {
                 for (i=0; i< NO_OF_PATT; i++)
                   printf ("pattern #%d: %s\n",i,pat_name[i]);
                 printf ("\npattern ? ");
                 stripwhite(gets(c));
                 filling = getnum(c);
                 if ((filling < 0) || (filling >= NO_OF_PATT))
                   printf ("Bad pattern number!\n");
                 else
                   load_patt (filling);
                 break;
                 }
      case 'n' : get_page ();    break;
      case 'p' : get_box ('p');  break;
      case 'r' : raster_adr ();  break;
      case 's' : get_pitch('s'); break;
      case 't' : get_paint();    break;
      case 'u' : printf ("setup blit pattern\n");
                 printf ("xs?     ");
                 stripwhite(gets(c));
                 xs = getnum(c);
                 printf ("width?  ");
                 stripwhite(gets(c));
                 width = getnum(c);
                 bsetup (xs, xs, width, width);
                 break;
      case 'v' : get_vector();   break;
      case 'w' : get_clut(); break;
      case 'x' : get_color(); break;
      case 'y' : get_box ('c');  break;
      case 'z' : get_reset();    break;
      case '?' : printf ("\nCommands :  \n");
                 printf ("   a)   alu mode\n");
                 printf ("   b)   box\n");
                 printf ("   c)   clip\n");
                 printf ("   d)   destination pitch\n");
                 printf ("   h)   halt the processor\n");
                 printf ("   i)   interrupt\n");
                 printf ("   l)   load new pattern\n");
                 printf ("   n)   new page select\n");
                 printf ("   p)   pattern box\n");
                 printf ("   r)   raster addresses (dest & src)\n");
                 printf ("   s)   source pitch\n");
                 printf ("   t)   paint box\n");
                 printf ("   u)   setup reference blit pattern\n");
                 printf ("   v)   vector\n");
                 printf ("   w)   color lookup table\n");
                 printf ("   x)   current color\n");
                 printf ("   y)   copy box\n");
                 printf ("   z)   initialize\n");
                 break;
      }
    }
}



load_font ()

{ 
  int i, j;
  unsigned short *addr;

  check_mem();
/*
  printf ("loading font.\n");
*/
  addr = (unsigned short *)V_FONTADDR;
  for (i=0; i <= 127; i++)
    for (j=0; j <= 15; j++)
      {
      *addr = font [i][j];
      addr++;				/* put font in longword boundary */
      *addr = 0;
      addr++;
      }
/*
  printf ("font loaded.\n");
*/
  if (use_intrp == 0) intrp_off;
}



load_patt (filling)

int filling;

{ 
  int i;
  int plane;
  unsigned short pattern;
  unsigned short *addr;
  unsigned short *paddr;

  check_mem ();
/*
  printf ("loading pattern %d.\n",filling);
*/
  if (has_color) {
  for (plane=0; plane <=3; plane++)
    {
    addr = (unsigned short *)(V_PATTADDR + (0x40000*plane));
    paddr = (unsigned short *)patterns[filling];
    if ((filling & (1<<plane)) == 0)
      for (i=0; i <= 63; i++)
        {
        *addr = 0;
        addr++;
        }
    else
      for (i=0; i <= 63; i++)
        {
        *addr = *paddr;
        addr++;
        paddr++;
        }
    }
  }
else {
  addr = (unsigned short *)V_PATTADDR;
  paddr = (unsigned short *)patterns[filling];
  for (i=0; i <= 63; i++)
    {
    *addr = *paddr;
    addr++;
    paddr++;
    }
  }
/*
  printf ("pattern %d loaded.\n",filling);
*/
  if (use_intrp == 0) intrp_off;
}


check_mem ()

/* This procedures insures that access to display memory is ok */
/* by issueing an interrupt request and waiting til it happens. */
{
int i;

intrp_off;
fifo_wait();

/*
hadint = 0;
intrp_on;
while (hadint == 0);
hadint = 0;
*/

}


get_alu ()

{ char buf[20];

  printf ("alu mode   set, clear or toggle?  ");
  stripwhite(gets(buf));
  switch (buf[0])
    {
    case 's' : alu_set;     break;
    case 'c' : alu_clear;   break;
    case 't' : alu_toggle;  break;
    }
}

get_page ()

{ char buf[20];

  printf ("page 0 or 1?  ");
  stripwhite(gets(buf));
  if (buf[0] == '0') {
     pgno = 0;
     pgsel(0);
     }
  else {
     pgno = 1;
     pgsel(1);
     }
}

get_box (which)

char which;
{ int  x0, y0, w, h;
  int  xs, ys;
  int  pat_h, pat_l;
  char buf[20];

  if (which == 'c')
    {
    printf ("xs ?  ");
    stripwhite(gets(buf));
    xs = getnum(buf);
    printf ("ys ?  ");
    stripwhite(gets(buf));
    ys = getnum(buf);
    }
  if (which == 'p')
    {
/*
    printf ("patt_h ?  ");
    stripwhite(gets(buf));
    pat_h = getnum(buf);
    printf ("patt_l ?  ");
    stripwhite(gets(buf));
    pat_l = getnum(buf);
*/
    pat_h = PADDR_H;
    pat_l = PADDR_L;

    printf ("xp ?  ");
    stripwhite(gets(buf));
    xs = getnum(buf);
    printf ("yp ?  ");
    stripwhite(gets(buf));
    ys = getnum(buf);
    }
  printf ("x0 ?  ");
  stripwhite(gets(buf));
  x0 = getnum(buf);
  printf ("y0 ?  ");
  stripwhite(gets(buf));
  y0 = getnum(buf);
  printf ("w  ?  ");
  stripwhite(gets(buf));
  w = getnum(buf);
  printf ("h  ?  ");
  stripwhite(gets(buf));
  h = getnum(buf);
  switch (which)
    {
    case 'b' : box  (dst_h, dst_l, x0, y0, w, h);
               break;
    case 'c' : boxc (src_h, src_l, xs, ys, dst_h, dst_l, x0, y0, w, h);
               break;
    case 'p' : boxp (pat_h, pat_l, xs, ys, dst_h, dst_l, x0, y0, w, h);
               break;
    }
}



square (x,y,w,h)

int x,y,w,h;

{
  alu_set;
  box (0,0, x-2, y-2, w+4, h+4);
  alu_clear;
  box (0,0, x-1, y-1, w+2, h+2);
}




get_clip ()

{ 
  char buf[20];

  if (clip_status == 0)
    {
    printf ("clip x0 ?  ");
    stripwhite(gets(buf));
    clip_x = getnum(buf);
    printf ("     y0 ?  ");
    stripwhite(gets(buf));
    clip_y = getnum(buf);
    printf ("     w  ?  ");
    stripwhite(gets(buf));
    clip_w = getnum(buf);
    printf ("     h  ?  ");
    stripwhite(gets(buf));
    clip_h = getnum(buf);

    clipoff;
    square (clip_x, clip_y, clip_w, clip_h);
    clip   (clip_x, clip_y, clip_w, clip_h);
    clipon;
    printf ("clipping has been turned ON.\n");
    clip_status = 1;
    }
  else
    {
    printf ("clipping has been turned OFF.\n");
    clip_status = 0;
    clipoff;
    alu_clear;
    box  (dst_h, dst_l, clip_x-2, clip_y-2, clip_w+4, clip_h+4);
    }
}



get_vector ()

{ int x0, y0, x1, y1;
  char buf[80];

  printf ("vector x0 ?     ");
  stripwhite(gets(buf));
  x0 = getnum(buf);
  printf ("       y0 ?     ");
  stripwhite(gets(buf));
  y0 = getnum(buf);
  printf ("       x1 ?     ");
  stripwhite(gets(buf));
  x1 = getnum(buf);
  printf ("       y1 ?     ");
  stripwhite(gets(buf));
  y1 = getnum(buf);
  vector (dst_h, dst_l, x0, y0, x1, y1);
}

raster_adr ()

{
  char buf[10];

  printf (" destination address is now %x, %x (hex)\n", dst_h, dst_l);
  printf (" source base address is now %x, %x (hex)\n", src_h, src_l);

  printf (" dst_h? ");
  stripwhite(gets(buf));
  dst_h = getnum(buf);

  printf (" dst_l? ");
  stripwhite(gets(buf));
  dst_l = getnum(buf);

  printf (" src_h? ");
  stripwhite(gets(buf));
  src_h = getnum(buf);

  printf (" src_l? ");
  stripwhite(gets(buf));
  src_l = getnum(buf);
}


get_paint ()

{
  int mx, my, x0, y0, w, h;
  char buf[10];

  printf ("paint mx? ");
  stripwhite(gets(buf));
  mx = getnum(buf);
  printf ("      my? ");
  stripwhite(gets(buf));
  my = getnum(buf);
  printf ("      x0? ");
  stripwhite(gets(buf));
  x0 = getnum(buf);
  printf ("      y0? ");
  stripwhite(gets(buf));
  y0 = getnum(buf);
  printf ("      w ? ");
  stripwhite(gets(buf));
  w = getnum(buf);
  printf ("      h ? ");
  stripwhite(gets(buf));
  h = getnum(buf);

  paint (src_h, src_l, mx, my, dst_h, dst_l, x0, y0, w, h);
}


get_pitch (which)

char which;
{
  int width;
  char buf[10];

  switch (which)
    {
    case 'd' : printf ("destination pitch? ");
               stripwhite(gets(buf));
               width = getnum(buf);
               dst_pitch (width);
               break;
    case 's' : printf ("source pitch? ");
               stripwhite(gets(buf));
               width = getnum(buf);
               src_pitch (width);
               break;
    }
}

get_intrp ()

{
   char buf[10];
   printf ("interrupt on?  ");
   stripwhite(gets(buf));
   if (buf[0] == 'y') intrp_on;
   else intrp_off;
}

get_reset ()

{
   printf ("initialize GIP\n");
   init;
}



init_color_table ()
{
int i;

/* initialize the color table */
for (i=0; i<=15; i++) {
   switch (i) {
      case  0 : set_lookup ( 0, 0, 0, i); break;        /* black   */
      case  1 : set_lookup (15, 0, 0, i); break;        /* red     */
      case  2 : set_lookup ( 0,15, 0, i); break;        /* green   */
      case  3 : set_lookup (15,15, 0, i); break;        /* yellow  */
      case  4 : set_lookup ( 0, 0,15, i); break;        /* blue    */
      case  5 : set_lookup (15, 0,15, i); break;        /* magenta */
      case  6 : set_lookup ( 0,15,15, i); break;        /* cyan    */
      case  7 : set_lookup (15,15,15, i); break;        /* white   */
      case  8 : set_lookup (10,10,10, i); break;        /* grey 10 */
      case  9 : set_lookup (10, 0, 0, i); break;        /* red     */
      case 10 : set_lookup ( 0,10, 0, i); break;        /* green   */
      case 11 : set_lookup (10,10, 0, i); break;        /* yellow  */
      case 12 : set_lookup ( 0, 0,10, i); break;        /* blue    */
      case 13 : set_lookup (10, 0,10, i); break;        /* magenta */
      case 14 : set_lookup ( 0,10,10, i); break;        /* cyan    */
      case 15 : set_lookup (15,15,15, i); break;        /* white   */
/*    case  8 : set_lookup ( 0, 0, 0, i); break; */     /* black   */
/*    case  9 : set_lookup ( 2, 2, 2, i); break; */     /* grey 2  */
/*    case 10 : set_lookup ( 4, 4, 4, i); break; */     /* grey 4  */
/*    case 11 : set_lookup ( 6, 6, 6, i); break; */     /* grey 6  */
/*    case 12 : set_lookup ( 8, 8, 8, i); break; */     /* grey 8  */
/*    case 13 : set_lookup (10,10,10, i); break; */     /* grey 10 */
/*    case 14 : set_lookup (12,12,12, i); break; */     /* grey 12 */
/*    case 15 : set_lookup (15,15,15, i); break; */     /* white   */
      }
   }
   set_color(WHITE);
}

get_color ()

{
  char c[10];
  int color_value;

  printf ("set current color\n");
  printf ("color (0-15)?  ");
  stripwhite(gets(c));
  color_value = getnum(c);
  set_color (color_value);
}


get_clut ()

{
  int red, green, blue, addr;
  char c[10];

  printf ("set color table\n");
  printf ("dac addr?     ");
  stripwhite(gets(c));
  addr = getnum(c);
  printf ("red   (0-15)? ");
  stripwhite(gets(c));
  red = getnum(c);
  printf ("green (0-15)? ");
  stripwhite(gets(c));
  green = getnum(c);
  printf ("blue  (0-15)? ");
  stripwhite(gets(c));
  blue = getnum(c);
  set_lookup (red, green, blue, addr);
}

