
#include <stdio.h>
#include "fifo.h"
#include "graphics.h"
#include "dm_adr.h"
#if HASWCS
#include "ucode.h"
#endif HASWCS

extern int dorte;
extern int hadint;
extern int clip_status;
extern int g_init;
int revD;
int pgno;
int use_intrp;
/*
int halt_req;
*/
#if HASWCS
int running;
#endif HASWCS
int has_color;
int fore_color;
int back_color;

main ()

{ char c[10];
  int patt;

  g_init = 1;
  printf ("\nGIP Board Debugger   (4/9/86)\n");
  if (mapgip());
#if HASWCS
  printf ("%d micro code words.\n",uc_words/4);
#endif HASWCS
  printf ("type ? for help.\n");
#if HASWCS
/*
  load_wcs();
  zap ();
*/
  running = 1;                     /* microcode is running */
#endif HASWCS
/* _splx(0x2000); */               /* enable interrupts */

  back_color = 0;		   /* black */
  fore_color = 7;                  /* white */
/*
  if (has_color)
    init_color_table ();
*/
/*
  halt_req = 0;
*/
  pgno = 0;
  use_intrp = 0;                   /* initialize global variables */
  clip_status = 0;
  c[0] = '0';
  dorte = 1;
  hadint = 0;

  while (c[0] != 'q')              /* main command processor loop */
    {
    printf ("\n-> ");
    gets (c);
    switch (c[0])
      {
      case 'c' : patt = 0; 
                 clear(patt);   break;
      case 'g' : if (use_intrp) intrp_on;
                 graphics ();   
                 intrp_off;
                 break;
      case 'h' : hardware ();   break;
#if HASWCS
      case 'l' : load_wcs ();   break;
#endif HASWCS
      case 'm' : if (use_intrp) intrp_on;
                 auto_test();
                 intrp_off;
                 break;
#if HASWCS
      case 'p' : proc_state (); break;
      case 'r' : read_wcs ();   break;
#endif HASWCS
      case 's' : patt = 1;
                 clear(patt);   break;
      case 't' : toggle_int();  break;
#if HASWCS
      case 'v' : verify ();     break;
#endif HASWCS
      case 'x' : if (has_color) zct ();        break;
      case 'y' : if (has_color) show_map();    break;
      case 'z' : zap ();        break;
      case '?' : printf ("\nCommands:\n");
                 printf ("   c)  Clear screen\n");
                 printf ("   g)  Graphic commands\n");
                 printf ("   h)  Hardware tests\n");
                 printf ("   m)  Microcode tests\n");
                 printf ("   q)  Quit and return to PROM monitor\n");
                 printf ("   s)  Set screen to white\n");
                 printf ("   t)  Toggle use of interrupts\n");
                 printf ("   z)  Zap 29116 ALU\n");
#if HASWCS
                 printf ("\n   l)  Load microcode\n");
                 printf ("   p)  Change Processor Run state\n");
                 printf ("   r)  Read current microcode state\n");
                 printf ("   v)  Verify microcode in WCS\n");
#endif HASWCS
		 if (has_color) {
                   printf ("\n   x)  Initialize Color Table\n");
                   printf ("   y)  display color table\n");
                   }
                 break;
      }
    }
  _splx(0x2700);  /* turn off interrupts */
  exit ();
}



toggle_int ()

{
  if (use_intrp == 0)
    {
    printf ("enabling interrupts.\n");
    use_intrp = 1;
    }
  else 
    {
    printf ("disabling interrupts.\n");
    use_intrp = 0;
    }
}


zap ()

{
  if (*RESET);
  printf ("zapped processor to init!\n");
}

zct ()
{
  init_color_table ();
  printf ("initialized color table.\n");
}


show_map ()

{
  int current;
  int x0, y0;

  current = 0;
  for (x0 = 0; x0 < 1280; x0+=320)
     for (y0 = 0; y0 < 1024; y0+=256)
        {
        set_color (current++);
        box (0, 0, x0, y0, 320, 256);
        }
}


#if HASWCS
proc_state ()

/*  Change the processor state from running to halted and vice versa   */

{
  if (running)
    {
    printf ("processor halted.\n");
    running = 0;
    *HALT = 0xffff;
    }
  else
    {
    printf ("processor running.\n");
    running = 1;
    *RUN  = 0xffff;
    }
}
    
verify ()

/*  This function compares the contents of the writable control store  */
/*  with its own internal copy of the microcode and complains if any   */
/*  thing does not match.                                              */
{ 
  int words, i, s, data, errors;
  unsigned short *addr;

  errors = 0;
  printf ("verifying microcode\n");
  *HALT = 0xffff;    /* halt the processor */
  for (words = 0; words <= (uc_words/4)-1; words++)
    {
    addr  = WCS + words;
    if (*addr);
    for (s = 1; s <= 16; s++) *SHIFT = 0xffff;
    for (i= words*4 + 3; i >= words*4; i--)
      {
      for (s = 1; s <= 16; s++) *SHIFT = 0xffff;
      data = (int) *SNAKE;
      if (data != uc_data[i])
        { 
        errors++;
        printf ("uc_data[%d] = %x     read %x\n",i,uc_data[i],data);
        }
      }
    }
  if (errors == 0)
    printf ("verification complete, no errors.\n");
  else
    printf ("verification failed, %d errors.\n",errors);
  *RUN = 0xffff;
}



load_wcs ()

{ 
  int words, i, s;
  unsigned short *addr;

  printf ("loading microcode");
  *HALT = 0xffff;                            /* halt the processor */
  for (words = 0; words <= 2047; words++)
    {
    if (words % 256 == 0) printf(".");
    for (i= 3; i >= 0; i--)
      {
      if (words <= (uc_words/4)-1)
        *SNAKE = (short)(uc_data[words*4+i]);
      else
        *SNAKE = (short)(initial[i]);
      for (s = 1; s <= 16; s++) *SHIFT = 0xffff;
      }
    addr  = WCS + words;
    *addr = (short) 0xffff;
    }
  printf ("\nloading done.\n");
  *RUN = 0xffff;
  verify ();
}


#define FIRST_TIME	1
#define NEXT_TIME	0

read_wcs ()

/* This function continuously reads the current state of the microcode  */
/* registers and prints them out if anything was changed since the last */
/* time.  The format is:                                                */
/*        (uc addr) [PD bus data] uc_word0 uc_word1 uc_word2 uc_word3   */

{
  int  delay;
  char input;

  if (running)
    {
    printf ("halting processor.....\n");
    *HALT = 0xffff;
    }
  else printf ("processor already halted.\n");
  read_state (FIRST_TIME);
  while ((input = getlocal()) != 'q')
    {
    if (input == 's')
      {
      *STEP = 0xffff;   /* single step */
      delay = 7;        /* dummy delay */
      *STEP = 0xffff;
      delay = 7;
      read_state (NEXT_TIME);
      }
    else if (input == 'z') if (*RESET);
    }
  if (running)
    {
    printf("resuming processor execution.\n");
    *RUN = 0xffff;
    }
}


read_state (first_time)

int first_time;

/* The address read by this procedure is the one that will be */
/* executed next.  In order to line up the data, the address  */
/* is saved for one clock period.  'first_time' is true when  */
/* this procedure is called for the first time.  The saved    */
/* address is not valid, so it is printed if first_time.      */

{
  static int addr;
  static int alu_instr;
  int  word[5];
  int  i, s;
  int  pd_data;

  if (*SHIFT);
  pd_data = (int)(*SNAKE);
  for (i = 0; i <= 4; i++)
    {
    for (s = 1; s <= 16; s++) 
      *SHIFT = 0xffff;
    word[i] = (int)(*SNAKE);
    }

  if (first_time) {
     printf("(???)  [");
     alu_instr= 0;
     }
  else {
     printf ("(");
     if (addr < 0x100) printf ("0");
     if (addr < 0x10)  printf ("0");
     printf ("%x)  [", addr);
     }
  addr = word[0] & 0x7ff;
  if (pd_data < 0x1000) printf ("0");
  if (pd_data < 0x100)  printf ("0");
  if (pd_data < 0x10)   printf ("0");
  printf ("%x]  ");
  dasm   (alu_instr);
  alu_instr = word[4];
/*
  printf ("   %x %x %x %x\n",
         pd_data, word[4], word[3], word[2], word[1]);
*/
  printf ("\n");
}
#endif HASWCS



clear (patt)

int patt;

{
  register unsigned short *addr, *start, *stop;

  start = (unsigned short *)STARTADDR;
  stop  = (unsigned short *)MAXADDR;
  if (patt == 1)
    {
    printf("setting screen to white...\n");
    patt = 0xffff;
    }
  else
    {
    printf("clearing screen...\n");
    patt = 0x0;
    }
    
  for (addr = start; addr <= stop; addr++)
    *addr = (unsigned short) patt;
}

/*
 * possible graphics processor address tuples
 */

/* The first entry is different to remain compatible with the */
/* rev1 base.pal                                              */
struct gp_addr_tuple {
	unsigned short	*dm;		/* display memory */
	unsigned short	*addr;		/* gip address    */
} gp_addr[9] = {
	{(unsigned short *)0x400000, (unsigned short *)0xFE8000},
	{(unsigned short *)0x700000, (unsigned short *)0xFE0000},
	{(unsigned short *)0x800000, (unsigned short *)0xFE4000},
	{(unsigned short *)0x900000, (unsigned short *)0xFE8000},
	{(unsigned short *)0xA00000, (unsigned short *)0xFEC000},
	{(unsigned short *)0xB00000, (unsigned short *)0xFF0000},
	{(unsigned short *)0xC00000, (unsigned short *)0xFF4000},
	{(unsigned short *)0xD00000, (unsigned short *)0xFF8000},
	{(unsigned short *)0xE00000, (unsigned short *)0xFFC000},
};

mapgip()
{
	register int x, dm, i, j;
        register unsigned short *addr1, *addr2;
        unsigned short rpatt1, rpatt2;
	int xxx;
        int delay;

	STARTADDR =	0x400000;		/* four plane memory */
	MAXADDR =	0x4ffffe;
	PG0_START =	0x400000;                /* page 0 */
	PG0_END =	0x427ffe;
	UD0_START =	0x428000;		/* undisplayed area 0 */
	UD0_END =	0x43fffe;
	PG1_START =	0x440000;		/* page 1 */
	PG1_END =	0x467ffe;
	UD1_START =	0x468000;		/* undisplayed area 1 */
	UD1_END =	0x47fffe;
	PG2_START =	0x480000;                /* page 2 */
	PG2_END =	0x4a7ffe;
	UD2_START =	0x4a8000;		/* undisplayed area 2 */
	UD2_END =	0x4bfffe;
	PG3_START =	0x4c0000;		/* page 3 */
	PG3_END =	0x4e7ffe;
	UD3_START =	0x4e8000;		/* undisplayed area 3 */
	UD3_END =	0x4ffffe;
	V_PATTADDR =	0x428fc8;		/* vme pattern address */
	V_FONTADDR =	0x430000;		/* vme font address */

	for (i = 8 ; i >= 0 ; i--) {
	    	if (probe(gp_addr[i].addr, &xxx)) {
			dm = (int)gp_addr[i].dm;
			STARTADDR	= dm | (0x3FFFFF & STARTADDR );
			MAXADDR		= dm | (0x3FFFFF & MAXADDR );
			PG0_START	= dm | (0x3FFFFF & PG0_START );
			PG0_END		= dm | (0x3FFFFF & PG0_END );
			UD0_START	= dm | (0x3FFFFF & UD0_START );
			UD0_END		= dm | (0x3FFFFF & UD0_END );
			PG1_START	= dm | (0x3FFFFF & PG1_START );
			PG1_END		= dm | (0x3FFFFF & PG1_END );
			UD1_START	= dm | (0x3FFFFF & UD1_START );
			UD1_END		= dm | (0x3FFFFF & UD1_END );
			PG2_START	= dm | (0x3FFFFF & PG2_START );
			PG2_END		= dm | (0x3FFFFF & PG2_END );
			UD2_START	= dm | (0x3FFFFF & UD2_START );
			UD2_END		= dm | (0x3FFFFF & UD2_END );
			PG3_START	= dm | (0x3FFFFF & PG3_START );
			PG3_END		= dm | (0x3FFFFF & PG3_END );
			UD3_START	= dm | (0x3FFFFF & UD3_START );
			UD3_END		= dm | (0x3FFFFF & UD3_END );
			V_PATTADDR	= dm | (0x3FFFFF & V_PATTADDR );
			V_FONTADDR	= dm | (0x3FFFFF & V_FONTADDR );
/*
			if (!probe(PG0_START, &xxx)) continue;
*/
			printf("Fifo at 0x%x, Display Memory at (0x%x,0x%x)\n",
				gp_addr[i].addr,PG0_START,gp_addr[i].dm);
                        if (i == 0)
                           printf("*** You are using old PALs!! ***\n");
			FIFO = gp_addr[i].addr;
			SNAKE = FIFO + 1;
			SHIFT = FIFO + 2;
			RESET = FIFO + 3;
			FIFO2 = FIFO + 4;
			HALT  = FIFO + 5;
          		RUN   = FIFO + 6;
			STEP  = FIFO + 7;
			WCS = FIFO + 0x800;

                        /* Figure out if this is a COLOR or BW system */
                        addr1  = (unsigned short *)STARTADDR;
                        addr2  = (unsigned short *)PG2_START;
                        *addr1 = (unsigned short) 0x1234;
                        *addr2 = (unsigned short) 0x4567;
                        rpatt1 = *addr1;
                        rpatt2 = *addr2;
			if (rpatt1 == rpatt2) {
			  printf("Monochrome system\n");
			  has_color = 0;
	                  MAXADDR = 0x47fffe;
			  MAXADDR = dm | (0x3FFFFF & MAXADDR );
			}
			else {
			  printf("Color system\n");
			  has_color = 1;
			}

			if (probe(FIFO2, &xxx))
                          {
                          printf ("Rev D board in use.\n");
                          revD = 0;
/*
                          revD = 1;
*/
                          }
                        else
                          {
                          printf ("Rev C or older board in use.\n");
                          revD = 0;
                          }
			return 1;
		}
	}
	printf("No graphics processor found\n");
	return 0;
}
