#include "graphics.h"
#include "fifo.h"

#define	NX	32
#define	NY	32
#define NITER	500
#define NPASS	20	
#define XXX	0x7F
#define ZZ	(width/(NX*2))
#define	X0	(width/(NX/2))
#define	Y0	(width/(NX/2))
#define NUM_PTS 2400

short plane[NX][NY];
short rplane[NX][NY];

extern int pgno;
extern int has_color;
int stx[NUM_PTS];
int sty[NUM_PTS];
int enx[NUM_PTS];
int eny[NUM_PTS];
int     setx, sety;
int     double_buf;
short   pnt;
short	width, height;
char    buf[10];

erode()
{
	register int i, j;

        if (has_color) {
          printf ("Color system has no double buffers.\n");
          double_buf = 0;
          }
        else {
          printf ("double buffer? ");
          stripwhite(gets(buf));
          double_buf = 0;
          if (buf[0] == 'y') double_buf = 1;
          }

/*
	srandom(1);
*/
	plot_init();

        while (getlocal() != 'q')
	for (i = 0 ; i < NITER ; i ++) {
		init_plane();
		plot_plane();

		for (j = 0 ; j < NPASS ; j ++) {
			relax_plane();
			plot_plane();
                if (getlocal() =='q') goto quitit;
		}

	}
quitit: clipoff;
        alu_clear;
	pgno = 0;
        pgsel (pgno);
        box (0, 0, 0, 0, BXMAX, BYMAX);
        box (1, 0, 0, 0, BXMAX, BYMAX);

}

plot_init()
{
	width = 1000;
	height= 800;
        clip (32,32,1216, 960);
        clipon;
        pgno = 0;
        pnt = 0;
}


init_plane()
{
	register int x, y;

	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
		plane[x][y] = (random() & XXX) - (height/12);

	for (x = 0 ; x < NX/4 ; x++) 
		if (random() & 1)
			init_spike();

	relax_plane();
	relax_plane();
	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
		if (random()&1)
			plane[x][y] += (random() & XXX) - (height/12);
		else
			plane[x][y] -= (random() & XXX) - (height/12);
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
}

init_spike()
{
	register int x, y, p;

	p = random() & 1;
	while ((x = random() & 0xFF) >= NX);
	while ((y = random() & 0xFF) >= NY);
	if (p)
		plane[x][y] += random() & (XXX << 4);
	else
		plane[x][y] -= random() & (XXX << 4);
	plane[(x+1)%NX][y] = plane[x][y];
	plane[x][(y+1)%NY] = plane[x][y];
	plane[(x+1)%NX][(y+1)%NY] = plane[x][y];
	if (p)
		plane[x][y] += XXX/2;
	else
		plane[x][y] -= XXX/2;
}


plot_plane()
{
	register int x, y;


        if (double_buf)
          {
          if (pgno == 1) pgno = 0;
          else if (pgno == 0) pgno = 1;
          }
	SetPosition(X0 + 0, height - Y0);
	SaveLine(X0 + (NX-1)*ZZ, height - Y0);
	SaveLine(X0 + 2*((NX-1)*ZZ), height - (Y0 + (NY-1)*ZZ));
	SaveLine(X0 + (NX-1)*ZZ, height - (Y0 + (NY-1)*ZZ));
	SaveLine(X0 + 0, height - Y0);

	for (x = 0 ; x < NX ; x++)  {
	    register int xx =  X0 + x*ZZ;
	    SetPosition(xx, height - Y0);
	    for (y = 0 ; y < NY ; y++)
		SaveLine(xx + y*ZZ, 
                          height - (Y0 + plane[x][y] + y*ZZ));
	    SaveLine(xx + (y-1)*ZZ, height - (Y0 + (y-1)*ZZ));
	}
	for (y = 0 ; y < NY ; y++)  {
	    int yy = Y0 + y*ZZ;
	    SetPosition(yy, height - (yy));
	    for (x = 0 ; x < NX ; x++)
		SaveLine(yy + x*ZZ, height - (plane[x][y] + yy));
	    SaveLine(yy + (x-1)*ZZ, height - yy);
	}
	plot_clear();
        DumpLine ();
        pgsel (pgno);
}

SetPosition (x,y)
register int x, y;

{ 
setx = x;
sety = y;
}



SaveLine (x, y)
register int x, y;

{
  stx[pnt] = setx;
  sty[pnt] = sety;
  enx[pnt] = x;
  eny[pnt] = y;
  setx = x;
  sety = y;
  if (pnt++ > NUM_PTS) printf ("vector point buffer overflow!\n");
}


DumpLine ()

{
register int i;

for (i=0; i<pnt; i++)
   vector (pgno, 0, stx[i], sty[i], enx[i], eny[i]);
pnt = 0;
}



relax_plane()
{
	register int x, y;

	for (x = 1 ; x < NX-1 ; x++) 
	    for (y = 1 ; y < NY-1 ; y++)
			rplane[x][y] = (plane[x][y] + plane[x-1][y] + 
					plane[x+1][y] + plane[x][y+1] + 
					plane[x][y-1] ) / 5;
	for (x = 1 ; x < NX-1 ; x++) {
	    rplane[x][0] = (plane[x][0] + plane[x-1][0] + plane[x+1][0] + 
				plane[x][1]) / 4;
	    rplane[x][NY-1] = (plane[x][NY-1] + plane[x-1][NY-1] + 
				plane[x+1][NY-1] + plane[x][NY-2])/4;
	}
	for (y = 1 ; y < NY-1 ; y++) {
	    rplane[0][y] = (plane[0][y] + plane[1][y] + plane[0][y+1] + 
				plane[0][y-1] ) / 4;
	    rplane[NX-1][y] = (plane[NX-1][y] + plane[NX-2][y] + 
				plane[NX-1][y+1] + plane[NX-1][y-1])/4;
	}
	rplane[0][0] = (plane[0][0] + plane[1][0] + plane[0][1]) / 3;
	rplane[0][NY-1] = (plane[0][NY-1] + plane[1][NY-1] + plane[0][NY-2]) /3;
	rplane[NX-1][0] = (plane[NX-1][0] + plane[NX-2][0] + plane[NX-1][1]) /3;
	rplane[NX-1][NY-1] = (plane[NX-1][NY-1] + plane[NX-1][NY-2] + 
				plane[NX-2][NY-1]) / 3;
	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
			plane[x][y] = rplane[x][y];
}


plot_clear()
{
alu_set;
clipoff;
box (pgno, 0, 0, 0, BXMAX, BYMAX);
clipon;
alu_clear;
}

