
/* DEBUG revision log */
#ifndef	DEBUG_REV
#define	DEBUG_REV	"N/A.x"
#endif	DEBUG_REV
/* Rev level # implemented for first time, with the release of 5.0.
 * This is only implemented in the V30 Makefile at this time 10/31/88.
 */

#ifndef	CCX
#include "../machine/m68k.h"
#include "../machine/trap.h"
#include "../machine/board.h"
#include "../dev/sioreg.h"
#endif	CCX

/*
 * Standalone Tester:
 *
 * ram is not used in this program, subroutine accessed via: jra and ret
 *	via address in a5, or a6
 *
 * Machine Specific Routines at end of file are required for
 *	inisio:	initialize UART (d0 scratch)
 *	havec:		return 1 if input character
 *	getc:		input character into d0
 *	putc:		output the character in d0
 */
#define	dectrl 1
#define DBUG_BLOCK  0x100			/* 256 bytes */
#define	I_TRACE_BIT	15
#define	B_TRACE_BIT	14
#define	M_TRACE_BIT	13
#define	I_TRACE		0x8000 			/* bit 15  */
#define	B_TRACE		0x4000 			/* bit 14  */
#define	M_TRACE		0x2000 			/* bit 13  */

#define	PRINT(x)			/*(a0,a6),d0,d1,a5 */ \
	lea	pc@(8f),a0;						\
	lea	pc@(9f),a6;						\
	jra	print;							\
    8:	.asciz	x;							\
	.align	1;							\
    9:	
#define	CALLA5(y)			/*(d0,a5) */ \
	lea	pc@(9f),a5;						\
	jra	y;  							\
    9:
#define	CALLA6(z)							\
	lea	pc@(9f),a6;						\
	jra	z;  							\
    9:
#define	NEWLINE()			/* d0,d1,a0,a5,a6 */ \
	lea pc@(9f),a6;						\
	jra	print_nl;						\
	9:

#define	IFEQGOTO(r, v, l)						\
	cmpb v,r 							\
	jeq l

#define	DO10(x,y)	x,y; x,y; x,y; x,y; x,y; x,y; x,y; x,y; x,y; x,y

	.text
	.globl	Base
	.globl	_DEBUG

#ifdef	V30
Base:	.long	NVRAM_BOOT_ARG - NVRAM_ADDR + NVRAM_RESET_ADDR -4
#else	V30
Base:	.long	Base+0x1000			/* initial ssp */
#endif	V30

#ifdef	CCX
	.long	start_stand				/* initial reset address */
#else
	.long	_DEBUG			/*  1=04: initial reset address */
#endif	CCX
	.long	2f				/*  2=08: Bus Error */
	.long	3f				/*  3-0C: Address Error */
	.long	4f				/*  4=10: Instruction error */
	.long	1f				/*  5=14: Trap error */
	.long	1f				/*  6=18: etc ... */
	.long	1f				/*  7=1C: */
	.long	1f				/*  8=20: */
trace_trap:
	.long	trace_hdlr		/*  9=24: trace */
/* SERVICE INTERRUPTS AND TRAPS */
/* **************************************************
 * * DO NOT MOVE OR ALTER, THIS CODE FILLS 56 BYTES,*
 * * 10-23, RIGHT UP TO THE AUTO-VECTOR INTERRUPTS  *
 * **************************************************
 */
1:	PRINT(" *** Exception Trap Addr: ");
	CALLA6(print_err_addr);
	movl	pc@(Base),sp			/* reset stack */
	jra 	hello
/* ***************************************************
 * * END OF 56 BYTES, START AUTO VECTORS  24-31      *
 * ***************************************************
 */
	.long	Spurious
	.long	Auto_1
	.long	Auto_2
	.long	Auto_3
	.long	Auto_4
	.long	Auto_5
	.long	Auto_6
	.long	Auto_7
/* the rest of the exceptions, 32-255, well hope they don't happen */
/* service interrupts and traps */	
Spurious:
	PRINT("*** Spurious");
	jra 	1b
Auto_1:
	movb	#1,d0
	jra 	print_vec
Auto_2:
	movb	#2,d0
	jra 	print_vec
Auto_3:
	movb	#3,d0
	jra 	print_vec
Auto_4:
	movb	#4,d0
	jra 	print_vec
Auto_5:
	movb	#5,d0
	jra 	print_vec
Auto_6:
	movb	#6,d0
	jra 	print_vec
Auto_7:
	movb	#7,d0
print_vec:
	PRINT("*** Autovector ");
	movl	#4,d3
	CALLA6(print_byte);
	 jra 	1b	
BUSS_ERR:
2:	PRINT(" *** Buss");
	jra 	1b	
3:	PRINT(" *** Address");	
	jra 	1b	
4:	PRINT(" *** Instruction");	
	jra 	1b	

trace_hdlr:
	movml	#<d0,d1,d2,d3,a0,a5,a6>,sp@-
	bclr	#M_TRACE_BIT,d7
	movb	#'T ,d1
	CALLA5(putc);
	movl	sp@(36),a0				/* get the instruction pc */
	CALLA6(printa);
	movw	sp@(28),d0
	btst	#I_TRACE_BIT,d0
	jeq 	2f
	movb	#': ,d1
	CALLA5(putc);
1:	CALLA5(havec);
	jeq 	1b
	cmpb	#0x3,d0				/* ^C */
	jeq 	1f
	cmpb 	#0x4,d0				/* ^D */
	jne 	2f
1:	andw	#0x67FF,sp@(28)		/* reset the instruction trace */
	bclr	#I_TRACE_BIT,d7
1:	movml	sp@+,#<d0,d1,d2,d3,a0,a5,a6>
	rte
2:	NEWLINE();
	bset	#M_TRACE_BIT,d7
	jra 	1b
	
/******************************************************************
 *	            	P R O G R A M   S T A R T 					  *
 ******************************************************************
 */
_DEBUG:
#ifndef	MDOTS
	.globl	start_stand
start_stand:
	.globl	start
start:	
#endif	MDOTS
	movw	#0x2700,sr  			/* int mask 7.. no interrupt */
	CALLA5(inisio);
	.globl	diag_entry
diag_entry:
	lea 	pc@(Base),a0			/* reprogram vector base */
	movl	a0,vb
	movl	a0@,sp					/* reset stack */
	addl	#0x8,a0		
	lea 	pc@(2b),a1				/* buss error Trap vector */
	movl	a1,a0@+
	lea 	pc@(3b),a1				/* address error Trap vector */
	movl	a1,a0@+
	lea 	pc@(4b),a1 				/* instruction error Trap vector */
	movl	a1,a0@+
	lea 	pc@(1b),a1				/* other Trap vectors */
	movl	a1,a0@+					/* 5 */
	movl	a1,a0@+					/* 6 */
	movl	a1,a0@+					/* 7 */
	movl	a1,a0@+					/* 8 */
	lea 	pc@(trace_hdlr),a1
	movl	a1,a0@					/* 9 */
	movl	vb,a0
	addl	#0x60,a0				/* point to spurious exception */
	lea 	pc@(Spurious),a1
	movl	a1,a0@+
	lea 	pc@(Auto_1),a1			/* initilize the auto vectors */
	lea 	pc@(Auto_7),a3
1:	movl	a1,a0@+					
	addl	#0x6,a1
	cmpl	a3,a0
	jle 	1b  					/* loop until all Vectors are set */

/* Send out greeting message fist time and after buss_errors */
hello:
	movl	#5,d0
	movl	d0,sfc
	movl	d0,dfc
#ifdef	V30
	movl	#4,d7   				/* long word */
#else
	movl	#2,d7   	 			/* word by default */
#endif
	PRINT("\r\nPROM Based Tester.  Rev "DEBUG_REV" "DATE"  base addr: ");
	movl 	vb,a0
	CALLA6(printa);
PRINT(" - ");
	movl	#hello,a1
	movl	a1,a0
	CALLA6(printa);
menu:
	andw	#0x3FFF,sr
	bclr	#M_TRACE_BIT,d7
	NEWLINE();
#ifndef	V10
	PRINT("        a   set source/destination function codes (0-7)\r\n");
#endif	V10
#ifdef	V30
	PRINT("        b   set byte/word/LONG\r\n");
#else
	PRINT("        b   set byte/WORD/long\r\n");
#endif 	V30
	PRINT("        c   repeatedly r/w at fix location\r\n");
	PRINT("        d   look at memory locations interactively\r\n");
	PRINT("        e   simple mem test\r\n");
	PRINT("        f   full memory test\r\n");
	PRINT("        g   repeatedly w/r/v at fix location\r\n");
	PRINT("        h   run read/modify/write cycles\r\n");
#ifdef	CCX
	PRINT("        i   set up vmebus master mapping\r\n");
	PRINT("        j   test DMAC\r\n");
#endif	CCX
#ifdef	V30
	PRINT("        i   alternate space I/O word transfer\r\n");
#endif	V30
	PRINT("        k   memory fill         l   memory dump\r\n");
	PRINT("        m   memory move         n   memory compare\r\n");
	PRINT("        o   memory search       p   set pc (~0)\r\n");
#if	(defined(V20)|defined(V25)|defined(V30))
#	ifdef V30   /* temporary only V30 */
		 	PRINT("        q   toggle I-Cache      r   toggle D-Cache\r\n");
#		ifdef	V30
			PRINT("        s   set SR              t   tas test\r\n");
#	 	endif	V30

		PRINT("        u   set CACR            v   set VBR\r\n");
#	endif V30   /* temporary only V30 */
#	ifdef	V30
		PRINT("        w   walking bit         x   eXit, coldboot\r\n");
#	else V30
		PRINT("        w   walking bit\r\n");
#	endif	V30
#endif	(defined(V20)|defined(V25)|defined(V30))
#ifdef	CCX
		PRINT("        s   set SR\r\n");
		PRINT("        w   walking bit\r\n");
#endif
prompt:
	andw	#0x3FFF,sr
	bclr	#M_TRACE_BIT,d7
	PRINT("\r\nSR = ");
	movl	#4,d3
	movw	sr,d0
	orw 	d7,d0
	andw	#0xE700,d0
1:	CALLA6(print_wd);

 	PRINT("   Width = ");
	andb	#0x7,d7			/* mask it, just incase of entry by exception */
	movb	#'B ,d1
	cmpb	#1,d7
	jeq 	prompt_putc
	movb	#'W ,d1
	cmpb	#2,d7
	jeq 	prompt_putc
	movb	#'L ,d1
prompt_putc:
	CALLA5(putc);
#ifndef	V10
	PRINT("    S/DFC = ");
	movl	#4,d3
	movl	sfc,d0
	CALLA6(print_byte);
	PRINT("   VBR = ");
	movl	vb,a0
	CALLA6(printa);
	PRINT("   CACR = ");
	movl	#4,d3
 	movl	cac,d0
	CALLA6(print_wd);
#endif	V10
	movl	0,d0
	notl	0
	cmpl	0,d0				/* are they the same ?? */
	jeq 	1f
	movl	d0,0				/* no put the original back */
	PRINT("\r\nRAM resident");
1:	NEWLINE();
prompt1:
	andw	#0x3FFF,sr
	bclr	#M_TRACE_BIT,d7
1:	CALLA5(havec)			/* flush input */
	jeq 	1f
	CALLA5(getc);
	jra 	1b

1:	PRINT("\r\nDEBUG->: ");		/* differentiate from monitor */
	CALLA5(getc);
	NEWLINE();
	
	btst	#B_TRACE_BIT,d7 		/* set the trace bit in the sr */
	jeq 	1f
	orw 	#B_TRACE,sr
1:	btst	#I_TRACE_BIT,d7
	jeq 	1f
	orw 	#I_TRACE,sr
1:	bset	#M_TRACE_BIT,d7
#ifndef	V10
	IFEQGOTO(d0, #0x61, cmd_a);
#endif	V10
	IFEQGOTO(d0, #0x62, cmd_b);
	IFEQGOTO(d0, #0x63, cmd_c);
	IFEQGOTO(d0, #0x64, cmd_d);
	IFEQGOTO(d0, #0x65, cmd_e);
	IFEQGOTO(d0, #0x66, cmd_f);
	IFEQGOTO(d0, #0x67, cmd_g);
	IFEQGOTO(d0, #0x68, cmd_h);
#ifdef	CCX
	IFEQGOTO(d0, #0x69, cmd_i);
	IFEQGOTO(d0, #0x6A, cmd_j);
#endif	CCX
#ifdef	V30
	IFEQGOTO(d0, #0x69, cmd_i);
#endif	V30
	IFEQGOTO(d0, #0x6B, cmd_k);
	IFEQGOTO(d0, #0x6C, cmd_l);
	IFEQGOTO(d0, #0x6D, cmd_m);
	IFEQGOTO(d0, #0x6E, cmd_n);
	IFEQGOTO(d0, #0x6F, cmd_o);
	IFEQGOTO(d0, #0x70, cmd_p);
#if	(defined(V20)|defined(V25)|defined(V30))
#ifdef	V30   /* temporary only V30 */
	IFEQGOTO(d0, #0x71, cmd_q);
	IFEQGOTO(d0, #0x72, cmd_r);
	IFEQGOTO(d0, #0x73, cmd_s);
#ifdef	V30
	IFEQGOTO(d0, #0x74, cmd_t);
#endif	V30
	IFEQGOTO(d0, #0x75, cmd_u);
	IFEQGOTO(d0, #0x76, cmd_v);
	IFEQGOTO(d0, #0x77, cmd_w);
#ifdef V30
	IFEQGOTO(d0, #0x78, diag_coldboot);
#endif	V30
#endif	V30   /* temporary only V30 */
#endif	(defined(V20)|defined(V25)|defined(V30))
#ifdef	CCX
	IFEQGOTO(d0, #0x73, cmd_s);
	IFEQGOTO(d0, #0x77, cmd_w);
#endif	CCX
	jra	menu

#if (defined(V30))
#ifndef PROMBOOT
#include "V30/debug.h"
#endif	PROMBOOT
zero:	.long	0
diag_coldboot:
	lea 	pc@(zero),a0
	pmove	a0@,mmutc		/* not needed if mapping is not set in M.V30 */
	pmove	a0@,mmutt0
	pmove	a0@,mmutt1

	lea 	pc@(end_diag_cb),a1
	lea 	pc@(1f),a0 
	subl	a0,a1
	movl	a1,d0			/* the count of bytes to relocate */
	rorl	#2,d0
	movl	a0,a1			/* the relocation (from) address */
	addl 	#MEM_DUP_MAP,a0
	movl	a0,a3			/* save the goto address */
2:	movl	a1@+,a3@+
	dbra	d0,2b
	jmp 	a0@
1:	reset	
	movl 	#PROM_RESET_ADDR,a0				/* start address */
	movl	a0,vb
	movl	a0@,sp
	jmp 	Coldboot
end_diag_cb:
#endif	(defined(V30))

#ifndef	V10
/* set sfc/dfc */
cmd_a:
	PRINT(" Function Code:    ");
	CALLA5(getc);
	cmpb	#0x30,d0
	jlt 	prompt1
	cmpb 	#0x37,d0
	jgt 	cmd_a
	andl	#7,d0
	movl	d0,sfc
	movl	d0,dfc
	jra 	prompt
#endif	V10

/* set byte word long mode */
cmd_b:
 	PRINT(" Width (B/W/L):    ");		/* READ */
	CALLA5(getc);
	NEWLINE();
	andb	#0xdf,d0				/* accept upper and lower case */
	IFEQGOTO(d0, #0x4C, 3f);		/* Long */
	IFEQGOTO(d0, #0x57, 2f);		/* Word */
	IFEQGOTO(d0, #0x42, 1f);		/* Byte */
	jra 	prompt1
1:	movb	#1,d7
	jra 	prompt
2:	movb	#2,d7
	jra 	prompt
3:	movb	#4,d7
	jra 	prompt

/* look at a fixed location repeatedly read/write */
cmd_c:
	lea 	pc@(1f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
1:	PRINT(" Read/Write (R/W): ");
	CALLA5(getc);
	NEWLINE();
	andb	#0xdf,d0				/* accept upper and lower case */
	IFEQGOTO(d0, #0x52, 1f);		/* Read */
	IFEQGOTO(d0, #0x57, 4f);		/* Write */
	jra 	cmd_c

1:	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	DO10(movsb	a4@,d0);
	CALLA5(havec)
	jeq 	1b
	jra 	prompt1
2:	DO10(movsw	a4@,d0);
	CALLA5(havec)
	jeq 	2b
	jra 	prompt1
3:	DO10(movsl	a4@,d0);
	CALLA5(havec)
	jeq 	3b
	jra 	prompt1

4:	PRINT(" Value:            ");		/* WRITE */
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	cmd_c
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	DO10(movsb	d3,a4@);
	CALLA5(havec)
	jeq 	1b
	jra 	prompt1
2:	DO10(movsw	d3,a4@);
	CALLA5(havec)
	jeq 	2b
	jra 	prompt1
3:	DO10(movsl	d3,a4@);
	CALLA5(havec)
	jeq 	3b
	jra 	prompt1

/* look at memory location interactively */
cmd_d:
	lea 	pc@(7f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
7:	movl	a4,a0
	CALLA6(printa);
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	a4@,d0			/* display value */
	jra 	4f
2:	movsw	a4@,d0			/* display value */
	jra	4f
3:	movsl	a4@,d0			/* display value */
4:	CALLA6(printn);
	CALLA6(gethex);
	cmpb	#0,d1			/* illegal */
	jne 	1f  			/* not illegal */

	cmpb	d3,d7			/* check for ^B in word mode, could be a branch */
	jne 	7b				/* if not, it is illegal */
	movsw	a4@,d0			/* get the current data word */
	movw	d0,d1	
	andl	#0xFF,d1		/* capture the input offset */
	andw	#0xFF00,d0		/* strip offset from command */
	movl	a4,d3
	addl	#2,d3			
	subb	d3,d1			/* get the difference */
	orb 	d1,d0			/* put the true offset in the command */
	movsw	d0,a4@
	addl	#2,a4
	jra 	7b  			/* go get data go the next location */
	
1:	cmpb	#1,d1
	jne 	5f
	cmpb	#4,d7			/* '\' */
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	subl	#1,a4			/* else decrement to next */
	jra 	7b
2:	subl	#2,a4			/* else decrement to next */
	jra 	7b
3:	subl	#4,a4			/* else decrement to next */
	jra 	7b

5:	cmpb	#2,d1
	jeq 	cmd_d			/* if <cr> then exit */
	cmpb	#3,d1
	jne 	5f
    cmpb	#4,d7			/* <lf> */
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	addl	#1,a4			/* else increment to next */
	jra 	7b
2:	addl	#2,a4			/* else increment to next */
	jra 	7b
3:	addl	#4,a4			/* else increment to next */
	jra 	7b

5:	cmpb	#4,d7			/* #<cd> or #<lf> */
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	d3,a4@			/* got a number, write value */
	jra 	4f
2:	movsw	d3,a4@			/* got a number, write value */
	jra 	4f
3:	movsl	d3,a4@			/* got a number, write value */
4:	cmpb	#4,d1
	jeq 	7b			/* if <cr> then redisplay */

   	cmpb	#4,d7			/* #<lf> */
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	addl	#1,a4			/* else increment to next */
	jra 	7b
2:	addl	#2,a4			/* else increment to next */
	jra 	7b
3:	addl	#4,a4			/* else increment to next */
	jra 	7b

/*	simple memory test */
cmd_e:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,a3			/* save ending address	*/

	PRINT("\r\n  Setting memory to 00 ");
	movl	a4,a0
	movl	#0x0000,d5
1:	CALLA5(4f);	
	cmpl	a3,a0
	jle 	1b
    
	PRINT("\r\n  Setting memory to 5a ");
	movl	a4,a0
	movl	#0x5A5A5A5A,d5
1:	CALLA5(4f);	
	cmpl	a3,a0
	jle 	1b
    
	PRINT("\r\n  Setting memory to a5 ");
	movl	a4,a0
	movl	#0xA5A5A5A5,d5
1:	CALLA5(4f);	
	cmpl	a3,a0
	jle 	1b
	jra	prompt

4:	/* compare the data read to what was written */
	movl	a0,a2
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7		/* determine B/W/L */
	jeq 	2f
1:	movsb	d5,a0@
	movsb	a0@+,d4
	cmpb	d5,d4
	jne 	5f
	jmp 	a5@
2:	movsw	d5,a0@
	movsw	a0@+,d4
	cmpw	d5,d4
	jne 	5f
	jmp 	a5@
3:	movsl	d5,a0@
	movsl	a0@+,d4
	cmpl	d5,d4
	jne 	5f
	jmp 	a5@


/* full memory test */
cmd_f:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,a3
/*
 *	now starting address is in a4, ending address is in a3
 *	ready for memory test.
 */
   	movl	#0,d1			/* starts with a seed #=0 */
   	movl	d1,d6			/* save start/end seed */
cmd_f_loop:
	CALLA5(havec);
	jne 	prompt
	movl	d1,a2			/* save it temporaryly */
	PRINT("\rWriting  ");
	movl	a2,d0
	CALLA6(printn);
	movl	a2,d1			/* get the current data number back */

	/* write */
	movl	d1,d0			/* use the seed number	*/
	movl	a4,a0
7:	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	d0,a0@+
	jra	4f
2:	movsw	d0,a0@+
	jra 	4f
3:	movsl	d0,a0@+
4:	addl	#1,d0			/* increment d0 */
	cmpl	a3,a0			/* fill till end */
	jle 	7b

	/* read verify */
	movl	d1,a2
	PRINT(" Verifying  ");
	movl	a2,d1
	movl	d1,d0			/* getback seed number	*/
	movl	a4,a0			/* a4 is the address to be verify */
7:  movl   	d0,d5			/* save value writen */
	movl    a0,a2			/* save the address for varifying */
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	a0@+,d4			/* save value read */
	cmpb	d4,d0			/* check if they are the same	*/
	jne 	5f
	jra 	4f
2:	movsw	a0@+,d4			/* save value read */
    cmpw	d4,d0			/* check if they are the same	*/
	jne 	5f
	jra 	4f
3:	movsl	a0@+,d4			/* save value read */
	cmpl	d4,d0			/* check if they are the same	*/
	jne 	5f
4:	addl	#1,d0
	cmpl	a3,a0
	jle 	7b
3:	addl	#1,d1			/* increment seed number */
	cmpl	d6,d1			/* do all seed values */
	jne 	cmd_f_loop
	jra 	prompt

5:  PRINT("*** ERROR: ADDRESS WROTE READ\r\n    ");
	movl    a2,a0			/* print error address */
	CALLA6(printa);
    movl    d5,d0			/* data wrote */
	CALLA6(printn);
	movl   d4,d0			/* data read */
	CALLA6(printn);
	jra 	prompt

/* write/read/verify at a fixed location data value */
cmd_g:
	lea 	pc@(1f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
1:	PRINT(" Value:            ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	movl	d3,d4
7:	CALLA5(havec);
	jne 	prompt1
    cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1: 	movsb	d4,a4@			/* write */
	movsb	a4@,d5			/* read */
	cmpb	d4,d5			/* verify */
	jra 	4f
2: 	movsw	d4,a4@			/* write */
	movsw	a4@,d5			/* read */
	cmpw	d4,d5			/* verify */
	jra 	4f
3: 	movsl	d4,a4@			/* write */
	movsl	a4@,d5			/* read */
	cmpl	d4,d5			/* verify */
4:	jeq 	7b
	PRINT("   WROTE ");
    movl    d4,d0			/* data wrote */
	CALLA6(printn);
	PRINT("  READ ");
	movl    d5,d0			/* data read */
	CALLA6(printn);
	NEWLINE();
	jra 	7b

/* read modify write loop */
cmd_h:
	lea 	pc@(1f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
1:	CALLA5(havec);
	jne 	prompt
	tas 	a4@
	jra 	1b

#ifdef	V30
/* Altenate I/O space word write */
cmd_i:
	lea 	pc@(1f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
1:	PRINT(" Value:            ");	
	CALLA6(gethex);
	cmpb	#2,d1				/* if escape, goto prompt */
	jlt		prompt1
	movl	sfc,d4				/* save the function code */
	movl	#3,d0
	cmpb	#4,d1				/* if there is no data read */
	jlt 	1f
	movl	d0,dfc
	movsw	d3,a4@				/* else write it */
	movl	d4,dfc
	jra 	prompt
1:	/* read data */
	movl	d0,sfc
	movsw	a4@,d0
	movl	#4,d3
	CALLA6(print_wd);
	movl	d4,sfc
	jra 	prompt

#endif	V30

/*	simple memory fill */
cmd_k:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,d4			/* save ending address	*/
	PRINT(" Value:            ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	cmd_k
	movl	d3,d1			/* save pattern in d1 */
7:	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	d1,a4@+
	jra 	4f
2:	movsw	d1,a4@+
	jra 	4f
3:	movsl	d1,a4@+
4:	cmpl	d4,a4
	jle 	7b
	jra	prompt

/*	simple memory dump */
cmd_l:
	PRINT(" Start address:    ");
	CALLA6(gethex);
	cmpb	#0,d1
	jeq 	prompt1			/* (0) takes case of 0 */
	cmpb	#4,d1
	jge  	4f				/* (4,5) if # and c/r, l/f OK */
	cmpb	#2,d1
	jeq 	3f				/* must be a c/r */
	movl	a1,d3			/* then get the default */
	cmpb	#3,d1			/* look for a 'l/f' */
	jeq 	1f
	subl	#DBUG_BLOCK,d3	/* must be (1,/) dec last value */
	jra 	2f
1:	addl	#DBUG_BLOCK,d3	/* (3,l/f) incerment last value */
2:	movl	d3,a1  			/* save the new default */
3:	movl	d3,a4			/* save new starting address	*/
	jra 	3f
4:	movl	d3,a4			/* save starting address	*/
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jge 	1f				/* if # and c/r, l/f OK */
	cmpb	#0,d1			/* (0) is no good */
	jeq 	1b  			/* no good */
	cmpb	#1,d1
	jeq 	1b				/* c/r. l/f = normal termination */
3:	movl	#DBUG_BLOCK,d3	/* (2,3) add block to start addr */
	addl	a4,d3
1:	cmpl	a4,d3			/* if ending address is < starting */
	jcs 	cmd_l
	movl	d3,d4			/* save ending address	*/
	movl	#0,d6
	movl	a4,a3			/* save starting address */
7:	movl	d6,d0
	andl	#0x0f,d0
	jne 	2f
	NEWLINE();
	movl	a4,a0
	CALLA6(printa);
2: 	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	a4@+,d5
	addl	#1,d6
	jra 	4f
2:	movsw	a4@+,d5
	addl	#2,d6
	jra 	4f
3:	movsl	a4@+,d5
	addl	#4,d6
4:	movl	d5,d0
	CALLA6(printn);
	cmpl	d4,a4
	jcc 	4f
	movl	d6,d0
	andl	#0x0f,d0
	jne 	1f
4:	PRINT("   ");
3:	movsb	a3@+,d1			/* get the char to print */
	cmpb	#0x20,d1
	jle 	5f   			/* eq to or less than space */
	cmpb	#0x7f,d1
	jlt 	6f				/* exchange it for a '.' */
5:	movb	#'. ,d1			/* print '.' */
6:	CALLA5(putc);
	cmpl	a4,a3
	jlt 	3b				/* loop untill all chars are printed */
1:	cmpl	d4,a4
	jcc 	prompt
	jra 	7b


/*	simple memory move */
cmd_m:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,d4			/* save ending address	*/
1:	PRINT(" To address:       ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	movl	d3,a3			/* save to address	*/
7:	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	a4@+,d1
	movsb	d1,a3@+
	jra 	4f
2:	movsw	a4@+,d1
	movsw	d1,a3@+
	jra 	4f
3:	movsl	a4@+,d1
	movsl	d1,a3@+
4:	cmpl	d4,a4
	jle 	7b
	jra 	prompt

/*	simple memory compare */
cmd_n:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,d4			/* save ending address	*/
1:	PRINT(" To address:       ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	movl	d3,a3			/* save to address	*/
7:	
   	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:
	movsb	a4@,d5
	movsb	a3@,d6
	cmpb	d5,d6
	jne 	5f
	jra 	4f
2:
	movsw	a4@,d5
	movsw	a3@,d6
	cmpw	d5,d6
	jne 	5f
	jra 	4f
3:
	movsl	a4@,d5
	movsl	a3@,d6
	cmpl	d5,d6
	jne 	5f
4:
   	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:
	addl	#1,a4
	addl	#1,a3
	jra 	4f
2:
	addl	#2,a4
	addl	#2,a3
	jra 	4f
3:
	addl	#4,a4
	addl	#4,a3
4:
	cmpl	d4,a4
	jle 	7b
	jra 	prompt
5:
	PRINT("\r\n MISCOMPARE: ");
	PRINT("content of ");
	movl	a4,a0
	CALLA6(printa);
	PRINT("= ")
	movl	d5,d0
	CALLA6(printn);
	PRINT(" : content of ");
	movl	a3,a0
	CALLA6(printa);
	PRINT("= ")
	movl	d6,d0
	CALLA6(printn);
	jra 	prompt

/*	jump to */
cmd_p:
	PRINT(" PC");
	lea 	pc@(1f),a3
	jra 	Get_addr
1:	tstl	d3
	jeq 	menu
	jmp 	a4@

/*	search memory */
cmd_o:
	lea 	pc@(1f),a3			/* print the start address message */
	jra 	Get_start			/* and return with it in a4 */
1:	PRINT(" End address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	1b
	cmpl	a4,d3			/* if ending address is < starting */
	jle 	1b
	movl	d3,d4			/* save ending address	*/
	PRINT(" Value:            ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	cmd_o
	movl	d3,d5			/* save pattern in d5 */
7:	movl	a4,a0			/* save current address */
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
1:	movsb	a4@+,d1
	cmpb	d1,d5
	jeq 	prt_cmp_addr
	jra 	4f
2:	movsw	a4@+,d1
	cmpw	d1,d5
	jeq 	prt_cmp_addr
	jra 	4f
3:	movsl	a4@+,d1
	cmpl	d1,d5
	jne 	4f
prt_cmp_addr:
	CALLA6(printa);
1:	CALLA5(havec);
	jeq 	1b
	cmpb	#3,d0
	jeq 	prompt
	cmpb	#4,d0
	jeq 	prompt
	NEWLINE();
4:	CALLA5(havec);				/* when do we stop ? */
	jne 	prompt
	cmpl	d4,a4
	jle 	7b
	jra 	prompt


#if	(defined(V20)|defined(V25)|defined(V30))

#ifdef V30   /* temporary only V30 */
/*	Toggle I-Cache  on/off */
cmd_q:
	movl	cac,d0
	btst	#0,d0
	jeq 	1f
	andl	#~(ICACHE_ENABLE|ICACHE_CLEAR),d0		/* disable */
	jra 	2f
1:	orl 	#ICACHE_ENABLE|ICACHE_CLEAR,d0			/* enable */
2:	movl	d0,cac
	jra 	prompt

/*	Toggle D-Cache */
cmd_r:
	movl	cac,d0
	btst	#8,d0
	jeq 	1f
	andl	#~(DCACHE_ENABLE|DCACHE_CLEAR),d0		/* disable */
	jra 	2f
1:	orl 	#DCACHE_ENABLE|DCACHE_CLEAR,d0			/* enable */
2:	movl	d0,cac
	jra 	prompt

#ifdef	V30

/* test and set at fix location */
cmd_t:
	lea 	pc@(1f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
1:	clrb	a4@
	movl	#1000,d0
2:	subl	#1,d0
	jne 	2b
   	PRINT(" Seizeing semaphore\r\n");
3:	CALLA5(havec)
	jne 	prompt1
	tas 	a4@
	jne 	3b
   	PRINT(" Got semaphore --");
	movl	#100000,d0
4:	subl	#1,d0
	jne 	4b
   	PRINT(" Free semaphore --");
	jra 	1b
#endif	V30

/*	Set CACR */
cmd_u:
	PRINT(" CACR:             ");
	CALLA6(gethex);
	cmpb	#2,d1
	jlt 	cmd_u
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,cac
	jra 	prompt

/* Set Vector Base Register */
cmd_v:
	PRINT(" VBR:             ");
	CALLA6(gethex);
	cmpb	#2,d1
	jlt 	cmd_v
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,vb
	jra 	prompt

#endif V30   /* temporary only V30 */
#endif	(defined(V20)|defined(V25)|defined(V30))

/* Set Status Register */
cmd_s:
	PRINT(" SR:             ");
	CALLA6(gethex);
	cmpb	#2,d1
	jlt 	cmd_s
	cmpb	#4,d1
	jlt 	prompt1
	andw	#0xE7FF,d3	
	andl	#0x0F,d7  		/* clear the trace flags */
	bclr	#B_TRACE_BIT,d3	/* is the branch trace on ? */
	jeq 	1f
	bset	#B_TRACE_BIT,d7
	bclr	#I_TRACE_BIT,d3		/* you cann't have both */
1:	bclr	#I_TRACE_BIT,d3	
	jeq 	1f	
	bset	#I_TRACE_BIT,d7
1:	movw	d3,sr
	jra 	prompt

/* walking one bit, walks a one through the address or data,
 * enabled through a mask.
 */
cmd_w: 
	PRINT("Walk thru (a)ddr or (d)ata: ");
	CALLA5(getc);
	movl	#0,d5
	cmpb	#'a ,d0
	jeq 	1f
	movl	#1,d5
   	cmpb 	#'d ,d0
	jne 	prompt1
1:	NEWLINE();
	lea 	pc@(2f),a3			/* print the address message */
	jra 	Get_addr			/* and return with it in a4 */
2:	PRINT(" Data:             ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	2b   				/* get a proper value */
	movl	d3,d4				/* save the input data value */
2:	PRINT(" Inclusive Mask:   ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	2b    				/* get a proper value */
	movl	d3,d6				/* save the input mask data value */
	movb	#0,d2				/* precondition for single step */
	tstb	d5					/* is this a data or address job ? */
	jeq 	addr_job			/* ripple through the address */
	/* data job */
7:	CALLA5(havec)
	jeq	1f
	cmpb	#0x20,d0    		/* test for single walk */
	jne 	prompt1 
	andb	d0,d2
	jne 	1f  				/* if not a "1", not first time through */ 
	movb	d0,d2
1:	cmpb	#4,d7				/* ? long word */
	jeq 	3f
	cmpb	#2,d7				/* ? short */
	jeq 	2f
1:	movb	d5,d1				/* byte loop */
	andb 	d6,d1
	orb 	d4,d1
	movsb	d1,a4@	
	eorb	d2,d0
	jne 	7b
 	rolb	#1,d5
	jra 	7b
2:	movw	d5,d1				/* short loop */
	andw	d6,d1
	orw 	d4,d1
	movsw	d1,a4@	
	eorb	d2,d0
	jne 	7b
	rolw	#1,d5
	jra 	7b
3:	movl	d5,d1				/* long loop */
	andl 	d6,d1
	orl 	d4,d1
	movsl	d1,a4@	
	eorb	d2,d0
	jne 	7b
	roll	#1,d5
	jra 	7b

	/* address job */
addr_job:
	movl	#1,d5
7:	CALLA5(havec)
	jeq 	1f					/* nothing there */
	cmpb	#0x20,d0			/* look for a space */
	jne 	prompt1
	andb	d0,d2
	jne 	1f  				/* if not a "1", not first time through */ 
	movl	#1,d5				/* reset the  LSB address */
	movb	d0,d2				/* save the single step code */
1:	movl	d5,d3				/* move the walking address bit into tmp */
	andl 	d6,d3				/* and the mask it */
	jne 	1f					/* if there is no address go back */
	roll	#1,d5
	jra 	7b
1:	movl	a4,d1				/* move current address */
	orl 	d3,d1				/* or in the masked address bit */
	movl	d1,a0				/* ready the effective address */
	eorb	d2,d0				/* hold the shift ? */
	jne 	1f
	roll	#1,d5				/* modify the address modifier bit */

1:	cmpb	#4,d7				/* ? long word */
	jne 	2f
	movsl	d4,a0@
	jra 	7b
2:	cmpb	#2,d7				/* ? short */
	jne 	1f
	movsw	d4,a0@
	jra 	7b
1:	movsb	d4,a0@
	jra 	7b

/*
 * read a string: stop when cr or "/"entered, convert to number stored in d3
 *	d1 stores the flag
 *		0	illegal
 *		1	\			
 *		2	<cr>	
 *		3	<lf>
 *		4	# and <cr>
 *		5	# and <lf>
 * return via a6;  a5,d0,d1,d2,d3,d6 destroyed
 */
gethex:
	andw	#0x3FFF,sr
1:	movl	a6,d6			/* save the return address */
	movl	#0,d3
	movb	d3,d2			/* number of digit=0	*/
	CALLA5(getc);
	movb	#0,d1			/* set flag for default */
	cmpb	#2,d0			/* check for ^B */
	jne 	1f
	movb	d0,d3			/* allow to be returned */
	jra 	4f  			/* use normal return with ^B */
1:	cmpb	#0x1B,d0
	jeq  	prompt			/* <esc>, back to square one */
	movb	#1,d1
	cmpb	#'\\ ,d0		/* '\' */
	jeq  	4f
	movb	#2,d1			/* <cr> */
	cmpb	#'\r ,d0
	jeq  	5f
	movb	#3,d1			/* <lf> */
	cmpb	#'\n ,d0
	jeq  	5f

1:	cmpb	#'x ,d0			/* 'x' use default in a1 */
	jeq  	1f
	cmpb	#'s ,d0
	jne 	3f
	movl	sp,a2
	jra 	2f
1:	movl	a1,a2			/* print the default data */
2:	movl	a2,a0
	CALLA6(crterase);
	CALLA6(printa)
	movl	#'\b ,d1
	CALLA5(putc);
	movl	#8,d2			/* indicate maximun characters */
	movl	a2,d3			/* load with the default data */
2:	CALLA5(getc);
	cmpb	#'\r ,d0
	jne  	1f
	movb	#4,d1			/* # <cr> */
	jra  	5f
1:	cmpb	#'\n ,d0
	jne  	1f
	movb	#5,d1			/* # <lf> */
	jra  	5f
1:	cmpb	#'x ,d0			/* check for x on input */
	jne  	3f
	CALLA6(crterase);
	movl	d3,a1			/* save current value as default */
	movl	#4,d1			/* fake a c/r */
	jra  	4f

3:	movw	d0,d1			/* save for echo back */
	cmpb	#'\b ,d0		/* bs=8	*/
	jne  	1f
	cmpb	#0,d2			/* if digits have been entered, then */
	jeq  	3f  			/* backspace over the last one */
	subb	#1,d2
	andl	#0xfffffff0,d3
	rorl	#4,d3
   	CALLA6(char_del);
	jra  	2b  			/* GO GET ANOTHER */
3:	movl	#'  ,d1
	CALLA5(putc)			/* space over a backspace */
	jra 	2b				/* GO GET ANOTHER */

1:	cmpb	#7,d2			/* can only accept 8 digits */
	jle  	1f
 	CALLA6(crterase);
	jra  	2b			/* ignore character bs over it */
1:	movb	d0,d1
	subb	#0x30,d0		/* only allow 0 to f */
	jlt  	2f
	cmpb	#9,d0			/* check for 0 to 9 */
	jle  	1f
	movb	d1,d0			/* get the original again */
	andb	#0x1F,d0		/* check for A|a to hex F|f */
	jeq 	2f  			/* cann't be '@ `' */
	addb	#9,d0
	cmpb	#0x0F,d0
	jgt 	2f
1:	addb	#1,d2			/* update digit count */
	roll	#4,d3
	orb 	d0,d3
	jra  	2b  			/* GO GET ANOTHER */

2:	movl	#0,d1			/* non-hex digit */
4:	movl	d1,d0
	movb	#'\n ,d1		/* put out \n */
	CALLA5(putc);
	movb	#'\r ,d1
	CALLA5(putc);
	movl	d0,d1
5:	movl	d6,a6
A6ret:
	btst	#M_TRACE_BIT,d7
	jeq 	2f
	btst	#I_TRACE_BIT,d7
	jeq 	1f
	orw 	#I_TRACE,sr
	jmp 	a6@				/* get out, leave, quit, stop, etc.. */
1:	btst	#B_TRACE_BIT,d7
	jeq 	2f
	orw 	#B_TRACE,sr
2:	jmp 	a6@  			/* get out, leave, quit, stop, etc.. */

crterase:
	/* print back space and a space ie.. rubout */
   	movb	#'\b ,d1
	CALLA5(putc);
char_del:
	movb	#'  ,d1
	CALLA5(putc);
	movb	#'\b ,d1	/* bs again */
	CALLA5(putc);
	jmp 	a6@

/*
 * print:  print a message
 *	a0 points to message's address, return via a6
 * printa: print address
 *	output content of all 8 hex digits in a0, followed by blank
 * printn: print number
 *	output content of lower 4 hex digits in d0, followed by blank
 */
print:
	andw	#0x3FFF,sr
	movb	a0@+,d1
	jeq 	1f
	CALLA5(putc)
	jra 	print
1:	jra 	A6ret

printa:
	andw	#0x3FFF,sr
	movw	#7,d2			/* # of digits  */
	movl	a0,d0
	movl	#4,d3			/* 4bits per digit */
7:	roll	d3,d0
	movl	d0,a0
	andb	#0x0F,d0		/* only want one digit	*/
	addb	#0x30,d0		/* change the digit to ascii	*/
	cmpb	#0x3a,d0		/* fill in the 9-A gap	*/
	jlt 	1f
	addb	#7,d0
1:	movb	d0,d1
	CALLA5(putc);
	movl	a0,d0
	dbra	d2,7b
	movb	#0x20,d1
	CALLA5(putc);
	jra 	A6ret			/* return via address in a6 */

printn:	
	andw	#0x3FFF,sr
	movl	#4,d3			/* 4bits per digit */
	cmpb	#4,d7
	jeq 	3f
	cmpb	#2,d7
	jeq 	2f
print_byte:
	andw	#0x3FFF,sr
	movl	#1,d2			/* # of digits 2 for byte */
	roll	d3,d0
	roll	d3,d0
	jra 	1f  			/* use part of print_wd to rotate te reset */
print_wd:
2:	andw	#0x3FFF,sr
	movl	#3,d2			/* # of digits 4 for shorts */
1:	roll	d3,d0
	roll	d3,d0
	roll	d3,d0
	roll	d3,d0
	jra 	7b
print_long:
3:	andw	#0x3FFF,sr
	movl	#7,d2			/* # of digits 8 for longwords */
	jra 	7b

print_err_addr:
	andw	#0x3FFF,sr
	movl	a6,d4			/* save the return address */
	movl	sp@(2),a0
	CALLA6(printa);			/* print the stack value */
	PRINT("sp: ");
	movl	sp,a0
	CALLA6(printa);			/* print the stack address */
	movl	d4,a6
	jra 	A6ret

print_nl:
	lea 	pc@(8f),a0
	jra 	print
8:	.asciz	"\n\r"
	.align	1

/* 
 * Print the messages "Address " and "Start address" then gets
 * the HEX value fo the address returns the data in a4,
 * the return address is in a3
 */
Get_addr:
	PRINT(" Address:          ");
1:	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,a4
	jmp 	a3@
Get_start:
	PRINT(" Start address     ");
	jra 	1b

#ifndef	CCX

#if	( defined(QX) | defined(V10))
/* NOT IMPLEMENTED */
inisio:
havec:
getc:
putc:	jmp	a5@
#else	( defined(QX) | defined(V10))


#if	(defined(V20) | defined(V25))
#define	UART_ADDR	S2681_ADDR
#define	MR1_A		0x00
#define	MR2_A		0x00
#define	CSR_A		0x02
#define	SR_A		0x02
#define	CR_A		0x04
#define	THR_A		0x06
#define	RHR_A		0x06
#define	ACR_A		0x08
#define	IMR 		0x0A
#define	MR1_B		0x10
#define	MR2_B		0x10
#define	CSR_B		0x12
#define	SR_B		0x12
#define	CR_B		0x14
#define	THR_B		0x16
#define	RHR_B		0x16
#else
#define	UART_ADDR	OCTART_ADDR
#endif
	/* VMEbus 68020, 68025 and 68030 */

/**** INISIO ****/
inisio:
	movl	sfc,d0
	movl	d0,usp
#if	(defined(V20) | defined(V25))
	movl	#5,d0
#else
	movl	#3,d0
#endif
	movl	d0,sfc
	movl	d0,dfc
#ifdef	MDOTS
	movl	#0x7ffff,d0		/* give any previous SIO time to settle */
1:	dbra	d0,1b
#endif	MDOTS
	movb	#0,d0
	/* reset d0 = (CR_CMD_RST_{MR, RX, TX, ERR, BRK}) in channells A & B */
	lea 	pc@(dio_resets),a0
1:	movb	a0@+,d0
	movsb	d0,CR_A+UART_ADDR
	movsb	d0,CR_B+UART_ADDR
	cmpb	#CR_CMD_RST_BRK,d0		/* have we reached BRK (d0 = 5) yet ? */
	jne 	1b  					/* no - do the next on */
	jra 	1f

dio_resets:	.byte	CR_CMD_RST_MR,CR_CMD_RST_RX,CR_CMD_RST_TX,CR_CMD_RST_ERR,CR_CMD_RST_BRK
			.align	1

1:	movb	#(MR1_PAR_NONE|MR1_8_BIT),d0
	movsb	d0,MR1_A+UART_ADDR
	movsb	d0,MR1_B+UART_ADDR
	movb	#MR2_1_STOP,d0
	movsb	d0,MR2_A+UART_ADDR
	movsb	d0,MR2_B+UART_ADDR
	movb	#ACR_BRGS,d0
	movsb	d0,ACR_A+UART_ADDR
#if	(defined(V20) | defined(V25))
	movb	BSR,d0				/* read status	*/
#else		 /* for the V30 read the Horne way */
	movsb	IPR_0+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_1+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_2+UART_ADDR,d0
	rorl	#8,d0
	movsb	IPR_3+UART_ADDR,d0
	rorl	#8,d0
#endif
	andl	#BSR_BAUD,d0
	cmpl	#BSR_BAUD_9600,d0
	jne  	1f
	movb	#0xBB,d0
	jra  	2f
1:	cmpl	#BSR_BAUD_1200,d0
	jne  	1f
	movb	#0x66,d0
	jra  	2f
1:	cmpl	#BSR_BAUD_19200,d0
	jne  	1f
	movb	#0xCC,d0
	jra  	2f
1:	movb	#0x88,d0		/* 0x44 is for 300, 0x88 is 2400 baud */
2:	movsb	d0,CSR_A+UART_ADDR
	movsb	d0,CSR_B+UART_ADDR
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),d0
	movsb	d0,CR_A+UART_ADDR
	movsb	d0,CR_B+UART_ADDR

	movl	#0x7FFF,d0			/* SPIN */
1:	nop
	dbra	d0,1b
	movl	usp,d0
	movl	d0,sfc
	movl	d0,dfc
	jmp	a5@
#endif ( defined(QX) | defined(V10))


#else  ifdef	CCX
/*
/* MACHINE SPECIFIC CODE...
 *	inisio: initialize serial channel
 *	putc:	send one char
 *	havec:	see if there is a character
 *	getc:	loop till one char is read, echo character.
 */
#define	WCRA		0x200000
#define	SCC1_B_CMD	0xE00000
#define	SCC1_B_DATA	0xE00004

#define	UART_ADDR	0xE00000
#define	SR_A	0x0
#define	RHR_A	0x04
#define	THR_A	0x04

#define	wbr(a,b)							\
	movb	#(a),SCC1_B_CMD 					\
	movb	#(b),SCC1_B_CMD
			
inisio:
	movw	#1,WCRA			/* reset SCC1 */
	movw	#0,WCRA
	movl	#0x7FFF,d0
1:	dbra	d0,1b

	tstb	SCC1_B_CMD		/* reset register pointer */
	wbr(9,0x4d) /* b01001101*/	/* WR9=reset chan B */
	wbr(4,0x46) /* b01000110*/	/* WR4= 16X, 1 stop, no parity */
	wbr(9,0x0d) /* b00001101*/	/* WR9=release chan B */
	wbr(10,0x00) /* b00000000*/	/* WR10=NRZ */
	wbr(11,0x52) /* b01010010*/	/* WR11=BRGEN */
	wbr(12,(14 &0xff))		/* WR12,WR13=TC9600 */
	wbr(13,((14 >>8)&0xff))  
	wbr(14,0x03) /* b00000011*/	/* WR14=BRGEN from PCLK */
	wbr(15,0)			/* WR15=no interrupts */

	wbr(3,0xc1) /* b11000001*/	/* WR3=8 bits, RX enabled */
	wbr(5,0X68) /* b01101000*/	/* WR5=8 bits, TX enabled */
	wbr(1,0x60) /* b01100000*/	/* WR1=no interrupts or DMA */
	tstb	SCC1_B_CMD		/* reset register pointer */
	movl	#0x7FFF,d0		/* SPIN */
1:	dbra	d0,1b
	jmp	a5@

/* setup vme window */
cmd_i:
 	PRINT(" VME Address:      ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,d4
	movl	#21-13,d3
	lsrl	d3,d4
	PRINT(" Address Modifier: ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	andl	#0x3F,d3
	orl 	d3,d4
	movw	d4,0x200002
	movl	#16,d3
	lsrl	d3,d4
	movw	d4,0x200004

	movw	0x200008,d3
	btst	#8,d3
	jne 	1f
	PRINT(" Already Have Bus ...");
	jra	prompt
	
1:	PRINT(" Requesting Bus ...  ");
	movw	0xa00000,a0
1:	movw	0x200008,d0
	btst	#8,d0
	jeq 	1f
	CALLA6(printn);
	jra 	1b
1:	PRINT(" Granted");
	jra 	prompt

/* DMAC test */
cmd_j:	
	movb	#0x00,0x400007			/* CCR = no operations pending */
	movb	#0x80,0x400004			/* OCR = Cycle Steal &Hold */
	movb	#0x11,0x400005			/* DCR = xfer mem-dev, auto reg */
	movb	#0x05,0x400006			/* SCR = addr's count up */
	PRINT(" SRC Address:       ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,0x40000C				/* MAR */
	PRINT(" SRC Function Code: ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movw	d3,0x400028				/* MFC */
	PRINT(" DST Address:       ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movl	d3,0x400014				/* DAR */
	PRINT(" DST Function Code: ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movw	d3,0x400030				 /* DFC */
	PRINT(" Byte Count Code:   ");
	CALLA6(gethex);
	cmpb	#4,d1
	jlt 	prompt1
	movw	d3,0x40000A				/* MTC = byte count */

	movb	#0x80,0x400007			/* CCR = Start operation */
	PRINT(" Done");
	jra 	prompt

#endif	ifndef CCX

/*
/**** HAVEC ****/
#ifndef	VQX

havec:	
#ifndef	CCX
#	if	(defined(V30))
		movl	#3,d0
#	else
		movl	#5,d0
#	endif
		movl	d0,sfc
#else
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
	movsb	SR_A+UART_ADDR,d0
	btst	#0,d0
	jeq 	1f  			/* no characterr waiting */
	movsb	RHR_A+UART_ADDR,d0	/* yes, see what it is */
	andl	#0x7f,d0			/* strip parity, make it none parity */
	cmpb	#0x13,d0			/* ignore ^S, ^Q */
	jeq 	1f
	cmpb	#0x11,d0  			/* ^Q */
	jeq 	1f
	/*movl	#1,d0
	 */
	jra 	2f
1:	movl	#0,d0
#ifndef	CCX
2:	movl	d0,usp			/* save answer in usp */
	movl	dfc,d0
	movl	d0,sfc
	movl	usp,d0			/* return answer */
#endif
2:	jmp 	a5@

/**** GETC ****/
getc:	
	andw	#0x3FFF,sr
#ifndef	V10
	movl	sfc,d0
	movl	d0,msp
#if	(defined(V30))
	movl	#3,d0
#else
	movl	#5,d0
#endif
	movl	d0,sfc
	movl	d0,dfc
#endif	V10
#ifdef	CCX
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
1:	movsb	SR_A+UART_ADDR,d0
	btst	#0,d0
	jeq 	1b
	movsb	RHR_A+UART_ADDR,d0
	andb	#0x7f,d0				/* strip parity, make it none parity */
	movl	d0,usp					/* save it for the return */
	cmpb	#0x0D,d0
	jeq 	1f
	cmpb	#0x0A,d0
	jne 	3f
#ifdef	CCX
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
1:	movsb	SR_A+UART_ADDR,d0		/* it was a <cr> or <L/F> */
	btst	#2,d0					/* wait until xmiter is ready */
	jeq 	1b
	movl	usp,d0
	cmpb	#0x0D,d0				/* which character to output */
	jeq 	1f
	movb	#0x0D,d0
	jra 	2f
1:	movb	#0x0A,d0
2:	movsb	d0,THR_A+UART_ADDR		/* output the opposite character */
	jra 	1f
3:	cmpb	#0x1B,d0				/* don't echo escape characters */
	jeq 	2f
#ifdef	CCX
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
1:	movsb	SR_A+UART_ADDR,d0		/* is the xmitter ready to output? */
	btst	#2,d0
	jeq 	1b
	movl	usp,d0
	movsb	d0,THR_A+UART_ADDR		/* echo the character */
#ifndef	V10
2:	movl	msp,d0
	movl	d0,sfc
	movl	d0,dfc
#endif	V10
2:	movl	usp,d0
	jmp 	a5@

/**** PUTC ****/
putc:
	andw	#0x3FFF,sr
	movl	d0,usp
#ifndef	V10
	movl	sfc,d0
	movl	d0,msp
#	if	(defined(V30) )
		movl	#3,d0
#	else
		movl	#5,d0
#	endif
	movl	d0,sfc
	movl	d0,dfc
#endif	V10
#ifdef	CCX
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
1:	movsb	SR_A+UART_ADDR,d0
	btst	#0,d0
	beq 	5f
	movsb	RHR_A+UART_ADDR,d0
	cmpb	#0x3,d0				/* ^C */
	jeq 	6f
	cmpb 	#0x4,d0				/* ^D */
	jeq 	6f
	cmpb	#0x13,d0			/* ^S stop */
	jne 	5f
#ifdef	CCX
	tstb	SCC1_B_CMD		/* reset register pointer */
#endif	CCX
2:	movsb	SR_A+UART_ADDR,d0
	btst	#0,d0
	jeq 	2b
	movsb	RHR_A+UART_ADDR,d0
	cmpb	#0x11,d0			/* ^Q start */
	jne 	2b
5:	btst	#2,d0
	jeq 	1b
	movsb	d1,THR_A+UART_ADDR
#ifndef	V10
	movl	msp,d0
	movl	d0,sfc
	movl	d0,dfc
#endif	V10
	movl	usp,d0
	jmp	a5@
#ifndef	V10
6:	movl	msp,d0
	movl	d0,sfc
	movl	d0,dfc
#endif	V10
	movl	usp,d0
6:	jra 	prompt

#endif not VQX
/*******/
