#define	VBPHYS0	&vme_std[0xF00000]	/* physical address of message area */
#define	VBSIZE0	0x040000		/* MAX size of message area */
#define	VBINTRBASE	0xC000		/* base interprocessor intr register */
#define	VBINTRLEN	0x4000		/* length, oink, oink */
#ifdef M68020
#define	VBINTVECTOR	28		/* auto vector level 4 */
#define	VBINTLEVEL	4
#endif	M68020
#ifdef M68030
#define	VBINTVECTOR	27		/* auto vector level 3 */
#define	VBINTLEVEL	3
#endif	M68030

/*
 * Message area configuration constants, MAX values must be power of 2
 */
#define	MAXCPU	32		/* max # of clusters supported by protocol */ 
#define	NCPU	9		/* number of clusters currently used */
#define	MAXRING	32		/* max # of rings per cluster */
#define	NRING	32		/* number of rings per cluster currently used */
#define MAXCPURING	256	/* MAXCPU * MAXRING */
#define	BCBBUFSIZE	((8 * 1024) + 128 + 64)

/*
 * Message area structure:
 * Defines the format of interprocessor communication message area. 
 * Addresses in structure are NOT physical or virtual addresses, they must 
 * ALWAYS be kept relative to the beginning of the message area. 
 * [KI]to[IK]{v} macros below should be used for conversions.
 */
struct ma {				/* message area */
    /* control header */
    struct	icpu {
	/*
	 * The active byte for cluster zero is set to VB_ACTIVE on clock
	 * interrupts after the message area is initialized. Other clusters
	 * set ic_active[0] to VB_INACTIVE and wait (VB_DELAY) for it to become
	 * VB_ACTIVE, indicating that the message area can be used, and then
	 * set their own ic_active to IC_ACTIVE.
	 */
	u_char	ic_active[MAXCPU];
#define		VB_DELAY	200000
#define		VB_INACTIVE	0x00
#define		VB_RESERVED	0x80	/* via tas */
#define		VB_ACTIVE	0xFF
	u_char	ic_tickle;		/* read increment write verify */ 
	char	ic_ncpu;		/* number of clusters attached */ 
	char	ic_ethaddr[6];		/* fudged ethernet address for */
					/* interface, last byte is cluster # */
#define		VB_EADDR	{ 0x70, 0x01, 0x00, 0x7F, 0xFF, 0x00 }
#define		VB_EADDRX	5
#define		ICPUX(p) (((struct ether_header *)(p))->ether_dhost[VB_EADDRX])
	struct ring *ic_freeringp;	/* pointer to ring of free buffers */
	struct ring *ic_inputringp[MAXCPU];/* pending input buffers */
	u_short	*ic_intrinfo[MAXCPU];	/* short io address of inetrprocessor */
					/* interrupt register IPI for cluster */
    }				ma_icpu;

    /* free ring, shared by all */
#ifdef	GOOD_CPP
    struct ring/**/MAXCPURING	ma_freering;
#else	GOOD_CPP
    struct ring256	ma_freering;
#endif	GOOD_CPP

    /* pending input rings */
#ifdef	GOOD_CPP
    struct ring/**/MAXRING	ma_inputring[NCPU];
#else	GOOD_CPP
    struct ring32	ma_inputring[NCPU];
#endif	GOOD_CPP

    /* buffers, to end of ram ... */
    struct bufs {			/* buffers, to end of message area */
	struct bcb {			/* buffer control block */
	    struct bcb	*b_link;
	    short	b_stat;
	    short	b_len;
	    char	*b_addr;
	    short	b_msglen;
	    short	b_reserved;
	}		buf_head;
	char		buf[BCBBUFSIZE];/* data */
    }				ma_bufs[1];
};

/*
 * The following structure is initialized by cluster 0
 * for host resident shared memory.
 * It resides at LOC 0 & 4 of the cluster 0 memory.
 */
struct hmmagic {
	u_int	hm_base;		/* pointer to hm communication area */
	u_int	hm_magic;		/* magic number */
};

#define HMMAGIC 0xDEADBEEF

/*
 * convert addresses 'p' between kernel virtual and message area.
 */
#define	KtoIv(p, type, kvbase)	((type)((int)(p) - (int)(kvbase)))
#define	ItoKv(p, type, kvbase)	((type)((int)(p) + (int)(kvbase)))

/*
 * redefine mapping of variable 'p' from/to kernel virtual to/from message area.
 */
#define	KtoI(p, type, kvbase)	((p) = KtoIv(p, type, kvbase))
#define	ItoK(p, type, kvbase)	((p) = ItoKv(p, type, kvbase))

/*
 * Address of interprocessor interrupt register
 */
#if	defined(M68020) || defined(M68030)
#define	VBINTADDR(i)	((u_short *)(VBINTRBASE + 0x20 +(2 * i)))
#else	M68020
#define	VBINTADDR(i)	0
#endif	M68020
