/*	VME Network Card Token Ring driver header file */

#define TRBUFLEN	4096		/* max size of Token Ring packet */
#define TRSIZE		0x20		/* Size of board space */
#define	TRPKLEN		(TOKENMTU - 32 - 4)
#define	TRPKBURST	4
#define VME_CODE	(u_short)0xf400	/* VME addr modifier 3D-Std/Sup/Data */
#define	RXBUFS		32
#define	TXBUFS		8
#define	TRTXTIMO	600		/* TRTXTIME/60 seconds */

#define TRLOADMMR(addr) ((u_short)(((u_long)(addr) & 0xffc00000)>>22)|VME_CODE);
/*
 * Macros for fast min/max.
 */

#define	TRMIN(a,b) (((a)<(b))?(a):(b))
#define	TRMAX(a,b) (((a)>(b))?(a):(b))

/*
 *	Description of Proteon Token Ring Network Card
 */

typedef struct {
	u_short	mmr0;				/* memory management reg. 0 */
	u_short	mmr1;				/* memory management reg. 1 */
	u_short	mmr2;				/* memory management reg. 2 */
	u_short	mmr3;				/* memory management reg. 3 */
	u_short	csr;				/* CSR reg. */
	u_short	unused0;
	u_short	unused1;
	u_short	unused2;
	u_short sif_data;			/* SIF data reg. */
	u_short sif_data_inc;			/* SIF data with increment */
	u_short sif_addr;			/* SIF address reg. */
	u_short sif_intr;			/* SIF interrupt reg. */
	u_short	unused3;
	u_short	unused4;
	u_short	unused5;
	u_short	unused6;
} Trdevice;

/*
**  CSR Bit definitions
*/
#define	RESET	0x0001				/* SIF Reset */
#define	INTENA	0x0002				/* Interrupt Enable */
#define	DMAENA	0x0004				/* DMA Enable */
#define	LED	0x0008				/* LED (1 == on) */


/*
** MMR defines
*/
#define	SIF_MMR0	0x00
#define	SIF_MMR1	0x40
#define	SIF_MMR2	0x80
#define	SIF_MMR3	0xc0

/*
** SIF Interrupt register definitions.	 (TI page 4-66)
*/
#define	SIFI_INTA	0x8000			/* Interrupt Adapter */
#define	SIFI_RST	0x4000			/* Adapter Reset */
#define	SIFI_SSBCL	0x2000			/* SSB Clear */
#define	SIFI_EXE	0x1000			/* Execute */
#define	SIFI_SCBRQ	0x0800			/* SCB Request */
#define	SIFI_RECC	0x0400			/* Receive Continue */
#define	SIFI_RECV	0x0200			/* Receive Valid */
#define	SIFI_XMTV	0x0100			/* Transmit Valid */
#define	SIFI_RSI	0x0080			/* Reset System Interrupt */
#define	SIFI_INTS	0x0080			/* Interrupt System */
#define	SIFI_INIT	0x0040			/* Initialize */
#define	SIFI_TEST	0x0020			/* Test */
#define	SIFI_ERR	0x0010			/* Error */
#define	SIFI_ICODE	0x000e			/* Interrupt code */
#define	SIFI_ERCODE	0x000f			/* Error code */

/*
**  Interrupt codes. (TI page 4-70)
*/
#define	ICODE_CHECK	0x0			/* Adapter check */
#define	ICODE_RNGSTAT	0x4			/* Ring Status */
#define ICODE_SCBCLR	0x6			/* SCB Clear */
#define	ICODE_CMDSTAT	0x8			/* Command Status */
#define	ICODE_RCVSTAT	0xa			/* Receive Status */
#define	ICODE_XMTSTAT	0xc			/* Transmit Status */

/*
**  Initialization Block
*/
struct	init_blk {
	u_short	ib_iopts;			/* Initialization Options */
	u_char	ib_cmd_vec;			/* Command interrupt vector */
	u_char	ib_xmt_vec;			/* Transmit interrupt vector */
	u_char	ib_rcv_vec;			/* Receive interrupt vector */
	u_char	ib_rng_vec;			/* Ring interrupt vector */
	u_char	ib_scb_vec;			/* SCB Clear interrupt vector */
	u_char	ib_chk_vec;			/* Adapter Check intr vec.*/
	u_short	ib_rburst;			/* Receive burst size */
	u_short	ib_tburst;			/* Transmit burst size */
	u_short	ib_abthresh;			/* DMA Abort threshold */
	u_short	ib_scbaddr_hi;			/* SCB addr, high byte */
	u_short	ib_scbaddr_lo;			/* SCB addr, low word */
	u_short	ib_ssbaddr_hi;			/* SSB addr, high byte */
	u_short	ib_ssbaddr_lo;			/* SSB addr, low word */
};

/*
**  System Command Block
*/
struct scb {
	u_short	scb_cmd;		/* Command word */
	u_short	scb_addrh;		/* Address high, bits 0-7 */
	u_short	scb_addrl;		/* Address Low word */
};

/*
** Adapter commands	 (TI p. 4-84)
*/
#define	CMD_OPEN	0x0003		/* Open */
#define	CMD_XMIT	0x0004		/* Transmit */
#define	CMD_XHLT	0x0005		/* Transmit Halt */
#define	CMD_RECV	0x0006		/* Receive */
#define	CMD_CLOSE	0x0007		/* Close */
#define	CMD_SGA		0x0008		/* Set Group Address */
#define	CMD_SFA		0x0009		/* Set Functional Address */
#define	CMD_REL 	0x000A		/* Read Error Log */
#define	CMD_RAB 	0x000B		/* Read Adapter Buffer */

/*
**  System Status Block
*/
struct ssb {
	u_short	ssb_cmd;		/* Command word */
	u_short	ssb_stat0;		/* Address high, bits 0-7 */
	u_short	ssb_stat1;		/* Address Low word */
	u_short	ssb_stat2;		/* Address Low word */
};

/*
**  Status Command Definitions  (Others are same as commands)
*/
#define	SSB_RING	0x0001		/* Ring Status */
#define	SSB_RJCT	0x0002		/* Command Reject */

/*
** Ring Status definitons. (TI p. 4-79)
*/
#define	RS_LOSS		0x8000		/* Signal loss */
#define	RS_HARD		0x4000		/* Hard error */
#define	RS_SOFT		0x2000		/* Soft error */
#define	RS_BEACON	0x1000		/* Transmit beacon */
#define	RS_LOBE		0x0800		/* Lobe wire fault */
#define	RS_AREM		0x0400		/* Auto-remove error */
#define	RS_REMR		0x0100		/* Remove received */
#define	RS_CNTO		0x0080		/* Counter overflow */
#define	RS_SINGLE	0x0040		/* Single Station */
#define	RS_RCVRY	0x0020		/* Ring Recovery */

/*
**  Various status bit definitions. 
*/
#define CMD_CMPLT	0x8000		/* Command Complete */
#define XMIT_FCOM	0x4000		/* Frame Complete */
#define XMIT_LERR	0x2000		/* List error */
#define	OPEN_OK		0x8000		/* Open completed ok. */
#define	OPEN_ADDR	0x4000		/* Node address error */
#define	RECV_FCOM	0x8000		/* Rx frame complete */
#define	RECV_SUSPND	0x4000		/* Recv command suspended */

/*
** Command reject reasons. (TI p. 4-81)
*/
#define	RJ_ILLEGAL	0x8000		/* Illegal command */
#define	RJ_ADDRERR	0x4000		/* Address error */
#define	RJ_ADOPEN	0x2000		/* Adapter is open */
#define	RJ_ADCLOSE	0x1000		/* Adapter is closed */
#define	RJ_SAME		0x0800		/* Command in progress */

/*
**  Buffer list definitions (TI p 4-95)
**	Only 14 byte bufs used.
*/
struct	trbuflist {
	u_char	*bl_link;		/* Forward pointer */
	u_short	bl_cstat;		/* Completion status */
	u_short	bl_flen;		/* Frame length */
	u_short	bl_len;			/* Buffer length */
	u_char	*bl_addr;		/* Data pointer */
	struct trbuflist  *bl_next;	/* local use buflist pointer */
	struct pkbuf	  *bl_data;	/* local use data pointer */
};

/*
**  Board communications area
*/

struct trcomm {
	struct	scb	scb;			/* Sys command block */
	struct	ssb	ssb;			/* Sys status block */
	struct	trbuflist  *tbl;		/* Transmit buffer ptr */
	struct	trbuflist  *rbl;		/* Receive buffer ptr */
	struct	trbuflist  tblhead[TXBUFS];	/* Transmit buffer list */
	struct	trbuflist  rblhead[RXBUFS];	/* Receive buffer list */
};

/*
**  Buffer CSTAT definitions	 (TI pp. 4-97, 99, 107)
*/
#define	TBL_VALID	0x8000		/* list valid */
#define	TBL_COMPLETE	0x4000		/* Frame complete */
#define	TBL_SOF		0x2000		/* Start of Frame */
#define	TBL_EOF		0x1000		/* End of Frame */
#define	TBL_INTR	0x0800		/* Interrupt when done with frame */
#define	TBL_ERROR	0x0400		/* Frame error */
#define	TBL_FS		0x00ff		/* FS strip */
#define	RBL_VALID	0x8000		/* list valid */
#define	RBL_COMPLETE	0x4000		/* Frame complete */
#define	RBL_SOF		0x2000		/* Start of Frame */
#define	RBL_EOF		0x1000		/* End of Frame */
#define	RBL_INTR	0x0800		/* Interrupt when done with frame */
#define	RBL_WAIT	0x0400		/* Interframe wait */
#define	RBL_FS		0x00fc		/* FS strip */

/*
**  Read Adapter Buffer parameter block.
*/
union rab {
	struct {
	    u_short	run_count;
	    u_short	run_addr;
	} rab_st;
	u_short	rab_buf[128];
#define	rab_count	rab_st.run_count
#define	rab_addr	rab_st.run_addr
};

/*
** RAB Address definitions.
*/
#define	RAB_BIA		0x0a00		/* Burned in address pointer */
#define	RAB_SWL		0x0a02		/* Software level pointer */
#define	RAB_ADDRS	0x0a04		/* Node Address pointer */

/*
** Debug flags 
*/
#define	TRDBG_RX		0x00000001
#define	TRDBG_TX		0x00000002
#define	TRDBG_INIT		0x00000004
#define	TRDBG_INTR		0x00000008
#define	TRDBG_DUMP		0x00000010
#define	TRDBG_RS		0x00000020
#define	TRDBG_BUFS		0x00000040
#define	TRDBG_TRFS		0x00000080
