/* if_qxreg.h - network interface SEEQ8003/Torch header file */

struct qxdevice {
	char sq_stataddr[6];
	char sq_rxstcm;		/* rx read status, write command register */

#define SQ_RX_OLD	0x80
#define SQ_RX_RCV_DSBL	0x00	/* disable receiver */
#define SQ_RX_RCV_ALL	0x40	/* rx all frames */
#define SQ_RX_RCV_SEL	0x80	/* rx selected station and broadcast frames */
#define SQ_RX_RCV_SMLT	0xc0	/* rx station, broadcast and multicast frames */

#define	SQ_RX_GOOD_FRM	0x20
#define	SQ_RX_END_FRAME	0x10
#define	SQ_RX_SHORT	0x08
#define SQ_RX_DRIBBLE	0x04
#define SQ_RX_CRC	0x02
#define SQ_RX_OVFL	0x01

	char sq_txstcm;		/* tx read status, write command register */

#define SQ_TX_OLD	0x80
#define	SQ_TX_SUCCESS	0x08
#define SQ_TX_16_ATMPT	0x04
#define SQ_TX_COLL	0x02
#define SQ_TX_UNDERFLW	0x01
};

/* 
 * The SEEQ_ADDR should have an equivelent define in the config.h file,
 * which is used as a parameter to  qxattach when called from usrConfig.c
 */

#define	SEEQ_ADDR	((struct qxdevice *)OBIO(0x1000168))
#define	SEEQ_DMA	((char *)OBIO(0x1000160))


/* Interface defines */

#define	NQXRXDESC	8
#define	NQXTXDESC	8

/* OpenChip Ethernet descriptor struct */

struct eth_desc {
	unsigned char *et_dptr;
	struct eth_desc *et_next;
	short et_bufsiz;	/* size of buffer */
	short et_datsiz;	/* number of data bytes */
	short et_flags;
};


#define ET_OWN	0x0001	/* set for MPU ownership, reset otherwise */
#define	ET_STP	0x0002	/* start of frame */
#define	ET_ENP	0x0004	/* end of frame */

/*
 * These error bits are extracted from an Ethernet chip receive status
 * byte but shifted over by 4 bits. The ET_SHRT error may also appear for a
 * transmit frame if the MPU attempts to transmit a frame less than 60 bytes
 * in length.
 */
#define	ET_OVFL	0x0008	/* receive buffer to small to hold received frame */
#define ET_OVER	0x0010	/* overflow on received frame */
#define ET_CRC	0x0020	/* received frame had CRC error */
#define ET_NOCT	0x0040	/* received frame didn't end with a complete octet */
#define ET_SHRT	0x0080	/* undersized frame */

#define ET_UNDR	0x0100	/* underrun on transmit */
#define ET_COLL	0x0200	/* collision on transmit */
#define ET_TX16	0x0400	/* 16 transmission attempts */

/*
 * There is a problem with the Ethernet in that the buffers must be a multiple
 * of 8 if there is to be no overflow and the maximum Ethernet frame size is
 * 1514 bytes. Therefore make the buffer size up to the nearest multiple of
 * 8.
 */
#define	OPE_BUFSIZE	1520
