/*
 * ISI Liberator/SEEQ8003 network interface
 */
#define	QXMTU	ETHERMTU	/* QXMAXMTU */

#define NQX 1

#if NQX > 0
#include "../machine/pte.h"
#include "../machine/board.h"

#include "param.h"
#include "systm.h"
#include "mbuf.h"
#include "buf.h"
#include "protosw.h"
#include "ioctl.h"
#include "socket.h"
#include "vmmac.h"
#include "errno.h"
#include "time.h"
#include "kernel.h"
#include "syslog.h"
#include "uio.h"
#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"

#ifdef	INET
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/in_var.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#endif	INET

#ifdef	NS
#include "../netns/qs.h"
#include "../netns/ns_if.h"
#endif	NS

#ifdef	TRFS
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#define	PKLEN		(qxmtu - 32 - 4)
#define	PKBURST		10
#endif	TRFS

#ifdef	APPLETALK
#include "../netddp/atalk.h"
#include "../netddp/katalk.h"
#include "../netddp/aarp.h"
#endif	APPLETALK

#ifdef	ENETFILTER
#include "../is68kif/enet.h"
#endif	ENETFILTER

#include "../is68kif/if_qb.h"
#include "../is68kif/if_pkbuf.h"
#include "../is68kif/if_ring.h"
#include "../is68kif/if_qxreg.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/openchip.h"
#include "../is68kdev/nvram.h"

/* I kept this here because it only works in "link" space	*/
#define	ptosv(X)	((((unsigned long)X)-PHYSMEMBASE)+SYSV_BASE)

int			qxmtu = QXMTU;

int	qxprobe(), qxattach(), qxintr(), qxslave();
int	qxinit(), qxioctl(), qxoutput(), qxreset(), qxwatch(), qxringput();
#ifdef	TRFS
int	qx_xmit(), qx_relse();
#endif	TRFS
struct	mbuf *if_rqbget();
u_short	qxdata();
struct	qb_device *qxinfo[NQX];

/* we give out the address of the microcode version register because we	*/
/* have to give something and it is harmless, but a kludge		*/
u_short	*qxstd[NQX+1] = { (u_short *) &(OPENCHIP->op_version), 0 };
struct	qb_driver QXdriver = 
	{ qxprobe, qxslave, qxattach, 0, qxstd, "qx", qxinfo, "QX", 0};

/*
 * Ethernet software status per interface.
 * Each interface is referenced by a network interface structure,
 * qs_if, which the routing code uses to locate the interface.
 */
struct	qx_softc {
	struct	arpcom	qs_ac;		/* common ethernet structures */
#define qs_if		qs_ac.ac_if	/* network-visible interface */
#define qs_addr		qs_ac.ac_enaddr	/* hardware ethernet address */
	struct	pkbuf	*qs_pkhead;	/* TRFS: "packet" output buffers */
	struct	pkbuf	*qs_pktail;	/* TRFS: "packet" tail ptr */
#define				mult_collisions		0
#define				collision		1
#define				silo_underrun		2
#define				crc_err			3
#define				dribble_err		4
#define				silo_overrun		5
#define				short_frame_err		6
#define				rcv_toobig		7
#define				xmt_short_frame		8
#define				NUMBER_OF_STATS		9
	u_int		qs_sstat[NUMBER_OF_STATS]; /* saved soft statistics */
	u_int		qs_stat[NUMBER_OF_STATS]; /* soft statistics */
#define		QXSTATREPORT_MASK	(	\
		    (1<<silo_underrun) | (1<<crc_err) | (1<<dribble_err) | \
		    (1<<short_frame_err) | (1<<rcv_toobig) | \
		    (1<<xmt_short_frame) /* | (1<<silo_overrun) */ )
/* NOTE: openchip gets overrun too often to report it all the time	*/
/*	 also, we don't report collisions, as they are a fact of life	*/
/*	 we do, however, count overruns in the input errors column	*/
#define		QXSTAT_IERRORS(x)	x[crc_err] + x[dribble_err] + \
					x[short_frame_err] + x[rcv_toobig] + \
					x[silo_overrun]
#define		QXSTAT_OERRORS(x)	x[xmt_short_frame] + x[silo_underrun]
#define		QXSTAT_CERRORS(x)	x[mult_collisions] + x[collision]
#define		QXSTAT_BITS 	\
"\20\11XMTSHORT\10RCVBIG\7SHRTFRAME\6OVERRUN\5DRIBBLE\4CRC\
\3UNDERRUN\2COLLISION\1MRETRY"
	short		qs_enetunit;	/* ENET: unit number for filtering */
	short		qs_enetinit;	/* ENET: interface is initialized */
	unsigned char	qs_ix;		/* TRFS: */
	unsigned char	qs_atnode;	/* APPLETALK: assigned node number */
	struct eth_desc *eth_rxptr;	/* current position in ring */
	struct eth_desc *eth_txptr;	/* current position in ring */

	struct qxdevice	*qs_qxdev;	/* device address struct */
/*
 * Since the OpenChip Ethernet descriptors must exist on a 16 byte 
 * boundary, a character array is declared which should be at least:
 *
 * 	(NQXRXDESC + NQXTXDESC) * sizeof (struct eth_desc) + 14 bytes
 */

	char ethdesc[(NQXRXDESC+NQXTXDESC) * 16 + 14];

/*
 * Each data buffer must be able to hold a max sized Ethernet packet
 * without FCS i.e. 1514 bytes. The OpenChip microcode requires
 * that each buffer start on a 4 byte boundary, ethbuf must be at least:
 *
 *	(NQXRXDESC + NQXTXDESC) * (OPE_BUFSIZE (==1520)) + 2 bytes
 */
	char ethbuf[(NQXRXDESC+NQXTXDESC) * (OPE_BUFSIZE) + 2];
}	qx_softc;

#define	QXWATCHINTERVAL	30		/* qxwatch once every 30 seconds */

#ifdef	RFS
extern struct ifqueue rfsintrq;
#endif	RFS

/* Probe for device */
qxprobe(qxp, unit)
	struct qxdevice *qxp;
	int unit;
{
	register struct qx_softc *qs = &qx_softc;
	register int i;
	struct eth_desc *txptr;
	char *buf_ptr;

	if(unit != 0)
		return(0);	/* only one on-board ethernet		*/

	get_ethernum(qx_softc.qs_addr);	/* qxresetchip() expects this	*/
	/* generate interrupt as best we can, qxreset leaves enabled	*/
	qxresetchip();		/* reset & start up the enet controller	*/

	/* hand-craft a single transmit descriptor			*/
	txptr  = (struct eth_desc *)(((long)qs->ethdesc + 15) & ~0x0f);
	buf_ptr = (unsigned char *)(((long)qs->ethbuf + 3) & ~3);
	txptr->et_datsiz = 1;	/* illegal length gets interrupt	*/
	txptr->et_next = 0;
	txptr->et_dptr = (char *)svtop(buf_ptr);
	txptr->et_flags = 0;	/* buffer belongs to microcode		*/
	OPENCHIP->op_ethtx = (struct eth_desc*) svtop(txptr);

	for(i=100000; i && ((OPENCHIP->op_ethtstat & OP_ETH_EVNT)==0);i--){
		DELAY(10);	/* don't keep openchip TOO busy		*/
	}
	if(OPENCHIP->op_ethtstat & OP_ETH_EVNT) {	/* finished	*/
		/* clear error and interrupt enable, and turn off rcvr	*/
		OPENCHIP->op_ethtstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
		OPENCHIP->op_ethrstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
		txptr->et_flags = ET_OWN;	/* take back buffer	*/
		/* we will do another qxreset before we are up		*/
	} else {
		return(0);
	}

	clevmax = clev_impmax;
	clev_imp = MAX(clev, clev_imp);
	return(sizeof (u_short));
}

qxslave()
{
	return (1);
}

qxattach(qi)
	register struct qb_device *qi;
{
	extern struct qx_softc;
	register struct ifnet *ifp = &qx_softc.qs_if;
	int i;

	if(qi->qi_unit != 0) {
		return;
	}
	ifp->if_unit = 0;
	ifp->if_name = "qx";
	ifp->if_mtu = qxmtu;
	ifp->if_flags = IFF_BROADCAST;
	ifp->if_init = qxinit;
	ifp->if_ioctl = qxioctl;
	ifp->if_output = qxoutput;
	ifp->if_reset = qxreset;
	if_attach(ifp);
	get_ethernum(qx_softc.qs_addr);
	printf("	(%e)", qx_softc.qs_addr);
	if(qx_softc.qs_pkhead || qx_softc.qs_pktail) {
		panic("qxattach, packet list not empty\n");
	}
	qx_softc.qs_qxdev = SEEQ_ADDR;
#ifdef	TRFS
	qx_softc.qs_ix = IfaceAttach(ifp->if_unit, qx_xmit, qx_relse,
		PKLEN, PKBURST, etherbroadcastaddr, sizeof(qx_softc.qs_addr));
#endif	TRFS
#ifdef	RFS
	RfsAttach(ifp, &qx_softc.qs_ac);
#endif	RFS
}

/* Reset of interface. */
qxreset(unit)
	int unit;
{
	register struct qb_device *qi;
	register struct qx_softc *qs = &qx_softc;
	int s;

	if (unit != 0 || (qi = qxinfo[unit]) == 0 || qi->qi_alive == 0) {
		return;
	}
	qxresetchip();
	s = splimp();
	/*
	 * Kludge alert!!!  We will just have to skip this until
	 * Sarito fixes this thing being zero..
	 */
	if (qs->eth_rxptr != NULL) {
		OPENCHIP->op_ethrx = (struct eth_desc*) svtop(qs->eth_rxptr);
	}
	qs->qs_if.if_flags &= ~IFF_RUNNING;
	splx(s);
}

/* Reset openchip ethernet controller. */

qxresetchip()
{
	register struct qx_softc *qs = &qx_softc;
	int i,s;

	bzero(qs->qs_stat, sizeof (qs->qs_stat));
	bzero(qs->qs_stat, sizeof (qs->qs_sstat));

	s = splimp();
	OPENCHIP->op_ethrstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
	OPENCHIP->op_ethtstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;

	/* Reset chip and make pulse last for at least 10msecs */
	Q_OP_PORT2 = OP2_RES_ETHER;
	for(i=0;i<30;i++);
	Q_OP_PORT2 = OP2_SET_ETHER;

	/*
	 * We must program this board's physical ethernet address;
	 * we do so before putting it on line and starting receive requests.
	 */
	for(i=0; i<sizeof qs->qs_addr; i++) {
		SEEQ_ADDR->sq_stataddr[i] = qs->qs_addr[i];
	}

	/* Reset OpenChip Ethernet registers and 8003 registers */
	OPENCHIP->op_ethrstat = OP_ETH_INEA;
	OPENCHIP->op_ethtstat = OP_ETH_INEA;

	SEEQ_ADDR->sq_txstcm = SQ_TX_SUCCESS | SQ_TX_16_ATMPT | SQ_TX_COLL | 
			   SQ_TX_UNDERFLW;
	SEEQ_ADDR->sq_rxstcm = SQ_RX_RCV_SEL | SQ_RX_GOOD_FRM | 
			SQ_RX_DRIBBLE | SQ_RX_CRC | SQ_RX_OVFL;
	splx(s);
}

/* Initialization of interface; clear pending operations. */
qxinit(unit)
	int unit;
{
	register struct qx_softc *qs = &qx_softc;
	register struct ifnet *ifp = &qs->qs_if;
	struct eth_desc *desc_ptr;
	unsigned char *buf_ptr;
	unsigned int i;


	/* Check for resources already allocated */
	if(ifp->if_flags & IFF_RUNNING)	{
		return;
	}

	/* Initialize OpenChip Ethernet descriptor bufs */

	desc_ptr = (struct eth_desc *)(((long)qs->ethdesc + 15) & ~0x0f);
	buf_ptr = (unsigned char *)(((long)qs->ethbuf + 3) & ~3);

	qs->eth_rxptr = desc_ptr;

	for (i = 0; i < NQXRXDESC; i++) {
		desc_ptr->et_dptr = (char *)svtop(buf_ptr);
		if (i != (NQXRXDESC - 1)) 
			desc_ptr->et_next = 
				(struct eth_desc *)((char *)desc_ptr + 16);
		else 
			desc_ptr->et_next = qs->eth_rxptr;
		desc_ptr->et_flags = 0;
		desc_ptr->et_bufsiz = OPE_BUFSIZE;
		desc_ptr->et_datsiz = 0;
		buf_ptr += OPE_BUFSIZE;
		desc_ptr = (struct eth_desc *)((char *)desc_ptr + 16);
	}
	qs->eth_txptr = desc_ptr;

	for (i = 0; i < NQXTXDESC; i++) {
		desc_ptr->et_dptr = (char *)svtop(buf_ptr);
		if (i != (NQXTXDESC - 1)) 
			desc_ptr->et_next = 
				(struct eth_desc *)((char *)desc_ptr + 16);
		else 
			desc_ptr->et_next = qs->eth_txptr;
		desc_ptr->et_flags = ET_OWN;
		buf_ptr += OPE_BUFSIZE;
		desc_ptr = (struct eth_desc *)((char *)desc_ptr + 16);
	}
	/* Reset the chip and mark the interface as running */
	qxreset(unit);
	ifp->if_flags |= IFF_RUNNING;
	
#ifndef	TRFS
	/* not yet, if address still unknown */
	if (ifp->if_addrlist == (struct ifaddr *)0) {
		return;
	}
#endif	TRFS

	ifp->if_watchdog = qxwatch;
	ifp->if_timer = QXWATCHINTERVAL;
	ifp->if_flags |= IFF_RUNNING;
	/* If there's something to transmit, start it */
	i = splimp();
	if(ifp->if_snd.ifq_head)
		qxstart();
	splx(i);
#ifdef	TRFS
	IfaceUp(qs->qs_ix);
#endif	TRFS
#ifdef	ENETFILTER
	if (!qs->qs_enetinit) {
		struct endevp enp;

		qs->qs_enetinit++;
		enp.end_dev_type = ENDT_10MB;
		enp.end_addr_len = sizeof(qs->qs_addr);
		enp.end_hdr_len = sizeof(struct ether_header);
		enp.end_MTU = qxmtu;
		bcopy(qs->qs_addr, enp.end_addr, sizeof(qs->qs_addr));
		bcopy(etherbroadcastaddr,enp.end_broadaddr,sizeof(qs->qs_addr));
		qs->qs_enetunit = enetattach(ifp, &enp);
	}
#endif	ENETFILTER
}

/* Ethernet interface interrupt. */
qxintr()
{
	unsigned char tmp;
	register struct qx_softc *qs = &qx_softc;


	/* If receive interrupt, perform qxread */
	tmp = OPENCHIP->op_ethrstat;
	OPENCHIP->op_ethrstat = (tmp & (OP_ETH_EVNT | OP_ETH_ERR)) 
				| OP_ETH_INEA;
	if(tmp & OP_ETH_EVNT) {
		qxread();
	}
	/* If transmit interrupt, perform qxstart */
	tmp = OPENCHIP->op_ethtstat;
	OPENCHIP->op_ethtstat = (tmp & (OP_ETH_EVNT | OP_ETH_ERR)) 
				| OP_ETH_INEA;
	if(tmp & OP_ETH_EVNT) {
		qxstart();
	}
	return;
}

qxread()
{
	register struct qx_softc *qs = &qx_softc;
	register struct ifnet *ifp = &qs->qs_if;
	register struct ether_header *eh;
	register struct mbuf *m;
	int len, off, resid, s;
	register struct ifqueue *inq;

	char *pData;
	short stat;
	struct eth_desc *rxptr;

	rxptr=qs->eth_rxptr;
	do {
		stat = rxptr->et_flags;
		if ( ! (stat & ET_OWN) )
			continue;
		/* Update packets received */
		qs->qs_if.if_ipackets++;	

		/* Check for errors - if errors release descriptor entry */
		if(stat & (ET_OVFL | ET_OVER | ET_CRC | ET_NOCT | ET_SHRT)) {
			rxptr->et_flags = 0;
			if(stat&ET_OVFL) {
				qs->qs_stat[rcv_toobig]++;
			}
			if(stat&ET_OVER) {
				qs->qs_stat[silo_overrun]++;
			}
			if(stat&ET_CRC) {
				qs->qs_stat[crc_err]++;
			}
			if(stat&ET_NOCT) {
				qs->qs_stat[dribble_err]++;
			}
			if(stat&ET_SHRT) {
				qs->qs_stat[short_frame_err]++;
			}
			continue;
		}

		len = rxptr->et_bufsiz - rxptr->et_datsiz;
		eh = (struct ether_header *) ptosv(rxptr->et_dptr);

		eh->ether_type = ntohs((u_short)eh->ether_type);
#ifdef	TRFS
		if (eh->ether_type == ETHERTYPE_WIPC) {
			qx_recv(rxptr);	/* clears rxptr->et_flags	*/
			continue;
		}
#endif	TRFS
		/* 
		 * Deal with trailer protocol: if type is trailer
		 * get true type from 1st 16-bit word past data.
		 * Remember type was trailer by setting off.
		 */

/**/
		pData = ((char *) eh) + (sizeof (struct ether_header));
		if(eh->ether_type >= ETHERTYPE_TRAIL &&
		   eh->ether_type < ETHERTYPE_TRAIL + ETHERTYPE_NTRAILER) {
			off = (eh->ether_type - ETHERTYPE_TRAIL) * 512;
			if(off > ETHERMTU) {
				rxptr->et_flags = 0;
				continue;
			}
			eh->ether_type = ntohs(*(u_short *) (pData + off));
			resid = ntohs(*(u_short *) (pData+off+sizeof(u_short)));
			if(off + resid > len) {
				rxptr->et_flags = 0;
				continue;
			}
			len = off + resid;
		} else 
			off = 0;	
		if (len == 0) {
			rxptr->et_flags = 0;
			continue;
		}
/**/

		/*
		 * Pull packet off interface. Off is nonzero if packet has
		 * trailing header; if_rqbget will force this header info
		 * to be at the front, but we will still have to drop
		 * the type and length which are at the front of any
		 * trailer data.
		 */

		m = if_rqbget(eh, len-sizeof(struct ether_header), off,
				sizeof(struct ether_header),
				(struct ifnet *) &qs->qs_if);
		rxptr->et_flags = 0;

		if(m == 0)
			continue;
		if (off) {
			m->m_off += 2 * sizeof(u_short);
			m->m_len -= 2 * sizeof(u_short);
		}

/**/
		s = splimp();
		switch(eh->ether_type) {
#ifdef INET
		case ETHERTYPE_IP:
			schednetisr(NETISR_IP);
			inq = &ipintrq;
			if (IF_QFULL(inq)) {
				IF_DROP(inq);
				m_freem(m);
			} else {
				IF_ENQUEUE(inq, m);
			}
			break;

		case ETHERTYPE_ARP:
			s = splimp();
			arpinput(&qs->qs_ac, m);
			splx(s);
			break;
#endif
#ifdef NS
		case ETHERTYPE_NS:
			schednetisr(NETISR_NS);
			inq = &nsintrq;
			if (IF_QFULL(inq)) {
				IF_DROP(inq);
				m_freem(m);
			} else {
				IF_ENQUEUE(inq, m);
			}
			break;

#endif
#ifdef	RFS
	  	case ETHERTYPE_RFS:
			schednetisr(NETISR_RFS);
			inq = &rfsintrq;
			if (IF_QFULL(inq)) {
				IF_DROP(inq);
				m_freem(m);
			} else {
				IF_ENQUEUE(inq, m);
			}
			break;
#endif
#ifdef	APPLETALK
		case ETHERTYPE_AARP:
			s = splimp();
			aarpinput(&qs->qs_ac, m);
			splx(s);
			break;

		case ETHERTYPE_APPLETALK:
			if (qs->qs_atnode) {
				ddp_setifp(ifp, qs->qs_atnode);
				schednetisr(NETISR_DDP);
				inq = &ddpintq;
				if (IF_QFULL(inq)) {
					IF_DROP(inq);
					m_freem(m);
				} else {
					IF_ENQUEUE(inq, m);
				}
				break;
			}
		/* fall thru */
#endif	APPLETALK
	    default:
#ifdef	ENETFILTER
		if (qs->qs_enetinit && qs->qs_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all. Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				/* undo the swap done earlier */
				eh->ether_type = htons((u_short)eh->ether_type);
				bcopy((struct ether_header*)eh->ether_dhost,
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				/* remove interface pointer */
				m->m_len -= sizeof(ifp);
				m->m_off += sizeof(ifp);
				mtop->m_next = m;
				enetFilter(qs->qs_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				break;
			}
		}
#endif	ENETFILTER
			m_freem(m);
			break;
		}
/**/
	} while ((rxptr=rxptr->et_next) != qs->eth_rxptr );
	qs->eth_rxptr = rxptr;
	OPENCHIP->op_ethrx = (struct eth_desc*) svtop(rxptr);
}

/*
 * Net output routine. Encapsulate a packet of type family for the local net.
 * Use trailer local net encapsulation if enough data in first packet leaves 
 * a multiple of 512 bytes of data in remainder. If destination is this 
 * address or broadcast, send packet to loop device to kludge around the fact 
 * that most interfaces can't talk to themselves.
 */
qxoutput(ifp, m0, dst)
	struct ifnet *ifp;
	struct mbuf *m0;
	struct sockaddr *dst;
{
	register struct qx_softc *qs = &qx_softc;
	register struct mbuf *m = m0;
	register struct ether_header *eh;
	register int off;
	int type, error;
	u_char edst[6];
	struct in_addr idst;
	int usetrailers;
	int s;
#ifdef	RFS
	extern struct ifnet loif;
	extern int useloopback;
#endif
#ifdef	APPLETALK
	struct mbuf *mcopy = (struct mbuf *)0;
	struct sockaddr_at *dat = (struct sockaddr_at *)dst;
	struct lap *lap;
	struct a_addr *appleaddr;
	int ltype, dnode;
#endif	APPLETALK

	switch( dst->sa_family ) {
#ifdef INET
	    case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&qs->qs_ac, m, &idst, edst, &usetrailers))
			return 0;	/* if not yet resolved */
		off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if (usetrailers && off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERTYPE_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof(u_short);
			m->m_len += 2 * sizeof(u_short);
			*mtod(m, u_short *) = htons((u_short)ETHERTYPE_IP);
			*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
			goto gottrailertype;
		}
		type = ETHERTYPE_IP;
		off = 0;
		goto gottype;
#endif
#ifdef NS
	    case AF_NS:
		type = ETHERTYPE_NS;
		bcopy((caddr_t)&(((struct sockaddr_ns *)dst)->sns_addr.x_host),
			edst, sizeof (edst));
		off = 0;
		goto gottype;
#endif
#ifdef	RFS
		/*
		 * Normally we would call arpresolve directly.  But when
		 * out source and destination are the same arpresolve will
		 * pass the mbuf onto the loopback driver changing the
		 * sa_family type to AF_INET.  So we do the check here and
		 * call looutput if necessary.
		 */
	      case AF_RFS:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (idst.s_addr == qs->qs_ac.ac_ipaddr.s_addr && useloopback) {
			(void) looutput (&loif, m, dst);
			return (0);
		} else if (!arpresolve(&qs->qs_ac, m, &idst, edst, 
					&usetrailers))
			return (0);	/* if not yet resolved */
		type = ETHERTYPE_RFS;
		off = 0;
		goto gottype;
#endif
#ifdef	APPLETALK
	    case AF_APPLETALK:
		if (qs->qs_atnode == 0) {
			error = ENETUNREACH;
			goto bad;
		}
		lap = mtod(m, struct lap *);
		lap->src = qs->qs_atnode;
		ltype = lap->type & 0xff;
		if (ltype == LT_DDP) { /* remote net - send it to the bridge */
			appleaddr = ddp_getaddr(ifp);
			if (appleaddr->at_Net)
				lap->dst = dnode = appleaddr->at_Abridge & 0xff;
			else
				lap->dst = dnode = dat->at_node;
		} else		/* local net - lap->dst already filled in */
			dnode = lap->dst & 0xff;

		idst.s_addr = 0L;
		/* fake out arpresolve */
		((char *)(&idst))[3] = dnode;

		if (dnode == 0xff) {		/* broadcast */
			if ((mcopy = m_copy(m, 0, M_COPYALL)) == NULL) {
				error = ENOBUFS;
				goto bad;
			}
			bcopy((caddr_t)etherbroadcastaddr, edst, sizeof(edst));
		} else {
			/* can't send long ddp's to one's self */
			if ((dnode == qs->qs_atnode)&&(ltype == LT_SHORTDDP)) {
				mcopy = m;
				goto gotlocal;
			} else if (!aarpresolve(&qs->qs_ac, m, &idst,
			    edst, &usetrailers))
				return (0);	/* if not yet resolved */
		}
		type = ETHERTYPE_APPLETALK;
		goto gottype;
#endif APPLETALK
	    case AF_IMPLINK:
		eh = mtod(m, struct ether_header *);
		goto gotheader;

	    case AF_UNSPEC:
		eh = (struct ether_header *)dst->sa_data;
		bcopy(eh->ether_dhost, edst, sizeof (edst));
		type = eh->ether_type;
		goto gottype;

	    default:
		log(LOG_WARNING, "qx%d: can't handle af%d\n", ifp->if_unit,
			dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottrailertype:
	/* trailer: move first packet (control information) to end of chain. */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;

gottype:
	/* Add local net header. If no space in mbuf, allocate another */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof(struct ether_header) > m->m_off) {
		MGET(m, M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof(struct ether_header);
	} else {
		m->m_off -= sizeof(struct ether_header);
		m->m_len += sizeof(struct ether_header);
	}
	eh = mtod(m, struct ether_header *);
	eh->ether_type = htons((u_short)type);
	bcopy(edst, eh->ether_dhost, sizeof (edst));

gotheader:
	bcopy(qs->qs_addr, eh->ether_shost, sizeof(qs->qs_addr));

	/* Queue msg on interface and start output */
	s = splimp();
	if(IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return(ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	qxstart();
	splx(s);
#ifdef	APPLETALK
gotlocal:
	return(mcopy ? looutput(&loif, mcopy, dst) : 0);
#else	APPLETALK
	return 0;
#endif	APPLETALK

bad:	m_freem(m0);
	return error;
}

/* Watchdog routine, maintain controller statistics. */
qxwatch(unit)
	int unit;
{
	register struct qx_softc *qs = &qx_softc;
	register struct ifnet *ifp = &qs->qs_if;
	register int i, msk;
	
	/* our hardware doesn't keep these, qx_softc has two copies of	*/
	/* these statistics so we can compare them			*/
	/* report change in condition, and update condition */
	for (i = 0, msk = 0; i < NUMBER_OF_STATS; i++)
		if (qs->qs_stat[i] != qs->qs_sstat[i]) {
			msk |= 1<<i;
			qs->qs_sstat[i] = qs->qs_stat[i];
		}
	msk &= QXSTATREPORT_MASK;
	if (msk)
		log(LOG_WARNING, "qx%d: condition %b\n", 
			unit, msk, QXSTAT_BITS);
	ifp->if_ierrors = QXSTAT_IERRORS(qs->qs_stat);
	ifp->if_oerrors = QXSTAT_OERRORS(qs->qs_stat);
	ifp->if_collisions = QXSTAT_CERRORS(qs->qs_stat);
	ifp->if_timer = QXWATCHINTERVAL;
}


/*
 * Process an ioctl request.
 */
qxioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	int cmd;
	caddr_t data;
{
	register struct ifaddr *ifa = (struct ifaddr *)data;
	struct qx_softc *qs = &qx_softc;
	int s = splimp(), error = 0;

	switch (cmd) {
	    case SIOCSIFADDR:
		ifp->if_flags |= IFF_UP;
		qxinit(ifp->if_unit);

		switch (ifa->ifa_addr.sa_family) {
#ifdef INET
		    case AF_INET:
			((struct arpcom *)ifp)->ac_ipaddr =
				IA_SIN(ifa)->sin_addr;
			arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
#ifdef	APPLETALK
			if (qs->qs_atnode)
				ddp_deleteifp(qs->qs_atnode);
			qs->qs_atnode = getatnode(&qs->qs_ac);
#endif	APPLETALK
			break;
#endif
#ifdef NS
		    case AF_NS:
		    {
			register struct qs_addr *ina = &(IA_SNS(ifa)->sns_addr);
			
			if (qs_nullhost(*ina))
				ina->x_host = *(union qs_host *)(qs->qs_addr);
			else
				qx_setaddr(ina->x_host.c_host,ifp->if_unit); /**/
			break;
		    }
#endif
		}
		break;

/* TODO: local QX_RUNNING!! (this comment came from borrowed code)*/
	    case SIOCSIFFLAGS:
		if (ifp->if_flags & IFF_UP) {
			qxinit(ifp->if_unit);
		}
#ifdef	TRFS
		else
			IfaceDown(qs->qs_ix);
#endif	TRFS
		break;

	    default:
		error = EINVAL;
	}
	splx(s);
	return error;
}

#ifdef	TRFS
qx_xmit(unit, naddr, p, len, fp0, fp1)
	int unit;
	struct ether_addr *naddr;
	struct packet *p;
	register unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct ether_header *eh;
	register struct qx_softc *qs = &qx_softc;
	register struct pkbuf *pkb;
	register struct pkbuf *pp;
	int s;

	if ((pkb = GetPkBuf()) == (struct pkbuf *)0) {
		log(LOG_WARNING, "qx_xmit: TRFS: no xmit packet buffers\n");/**/
		return EBUSY;
	}
	pkb->pkb_mbuf = (struct mbuf *)0;
	eh = (struct ether_header *)pkb->pkb_buffer;
	bcopy((caddr_t)naddr, (caddr_t)eh->ether_dhost,
		sizeof (eh->ether_dhost));
	bcopy((caddr_t)qs->qs_addr, (caddr_t)eh->ether_shost,
		sizeof (eh->ether_shost));
	eh->ether_type = ETHERTYPE_WIPC;

	len = (sizeof(struct pklink) - sizeof(struct packet)) +
		pkbuild(&((struct pklink *)eh)->packet, p, len, fp0, fp1);
	if (len - sizeof(struct ether_header) < ETHERMIN)
		len = ETHERMIN + sizeof(struct ether_header);
	pkb->pkb_len = len;

	s = splimp();
	pp = qx_softc.qs_pktail;
	if(pp) {
		qx_softc.qs_pktail->pkb_next = pkb;
		qx_softc.qs_pktail = pp;
	} else {
		qx_softc.qs_pkhead = qx_softc.qs_pktail = pkb;
	}
	qxstart();
	splx(s);
	return 0;
}

qx_recv(rxptr)		/* called only from interrupt routine	*/
	struct eth_desc *rxptr;
{
	register struct pklink *dp = (struct pklink *)ptosv(rxptr->et_dptr);
	register struct pklink *p;
	register struct pkbuf  *pb;
	register int len;

	if ((pb = GetPkBuf()) == (struct pkbuf *)0) {
		rxptr->et_flags = 0;	/* rcv buf back to ether firmware */
		log(LOG_WARNING, "qx_rcv: no packet bufs\n");
		return;
	}
	p = (struct pklink *)pb->pkb_buffer;
	len = rxptr->et_bufsiz - rxptr->et_datsiz;
	bcopy(dp, p, len);		/* data out of rcv buf	*/
	rxptr->et_flags = 0;	/* rcv buf back to ether firmware	*/
	bcopy(((struct ether_header *)p)->ether_shost, p->netaddr, 6);
	p->buflen = qxmtu;
	p->prelen = 0;
	p->ix = qx_softc.qs_ix;
	p->handle = (int)pb;
	/* life would be so much easier if ReceivePacket had a comment	*/
	/* in it that said that what its return value means.		*/
	if(ReceivePacket(p)){	/* It seems to indicate whether it has	*/
		FreePkBuf(pb);	/* taken responsibility for the pkbuf	*/
	}			/* or not (non-zero means no).		*/
}

qx_relse(unit, p)
	int unit;		/* not used, but passed in by TRFS	*/
	struct pklink *p;
{
	FreePkBuf(p->handle);		/* give back the packet buffer	*/
}
#endif	TRFS

qx_setaddr(physaddr, unit)
	u_char *physaddr;
	int unit;
{
	register struct qx_softc *qs = &qx_softc;
	
	bcopy((caddr_t)physaddr, (caddr_t)qs->qs_addr, sizeof qs->qs_addr);
	qxinit(unit);
}

/*
 *
 * qxstart - start output
 *
 */

qxstart()		/* always called at splimp()	*/
{
	unsigned char *bp;
	short len;
	int s;
	struct qx_softc *qs;
	struct eth_desc *txptr;
	struct mbuf *m, *mp;
	struct ether_header *eh;
	struct pkbuf *pkb;
	short stat;

	qs = &qx_softc;
	for(txptr = qs->eth_txptr;txptr->et_flags & ET_OWN;txptr = txptr->et_next) {
		/* Check Tx status of last packet sent */
		stat = txptr->et_flags;
		if(stat & (ET_UNDR|ET_SHRT)) {
			if(stat & ET_SHRT) {
				qs->qs_stat[xmt_short_frame]++;
			}
			if(stat & ET_UNDR) {
				qs->qs_stat[silo_underrun]++;
			}
		}
		if(stat & ET_COLL) {
			qs->qs_stat[collision]++;
			if(stat & ET_TX16) {
				qs->qs_stat[mult_collisions]++;
			}
		}
		txptr->et_flags = ET_OWN;

		if(qs->qs_pkhead) {	/* if some TRFS output	*/
			pkb = qs->qs_pkhead;
			qs->qs_pkhead = pkb->pkb_next;
			if(! qs->qs_pkhead) {	/* if list now empty	*/
				qs->qs_pktail = (struct pkbuf *) 0;
			}
			len = pkb->pkb_len;
			if(len > OPE_BUFSIZE || len < 0) {
				panic("qxstart: pkbuf len %x bytes\n", len);
			}
			bcopy(pkb->pkb_buffer, ptosv(txptr->et_dptr),
				pkb->pkb_len);
			len = MAX(ETHERMIN + sizeof(struct ether_header),
				pkb->pkb_len);
			FreePkBuf(pkb);
		} else {
			IF_DEQUEUE(&qs->qs_if.if_snd,m);
			if(m == 0)
				break;
			mp = m;
			len = 0;
			/* Copy packet to write buffer */
			for(bp = (char *)ptosv(txptr->et_dptr); mp;
			    mp = mp->m_next) {
				if(mp->m_len == 0)
					continue;	
				bcopy(mtod(mp, unsigned char *), bp,
					(int)mp->m_len);
				bp += mp->m_len;
			}
			m_freem(m);
			len = MAX(ETHERMIN + sizeof(struct ether_header),
					bp-((char *)ptosv(txptr->et_dptr)));
		}

		txptr->et_datsiz = len;
		txptr->et_flags = 0;
		OPENCHIP->op_ethtx = (struct eth_desc*) svtop(txptr);
		qs->qs_if.if_opackets++;
			
	}
	qs->eth_txptr = txptr;
}
#endif

get_ethernum(enaddr)
	char *enaddr;
{
	struct nv_ram nv_ram;

	if (nvram_get(&nv_ram) == 0) {
		panic("qx: Could not get ethernet address from NVRAM\n");
	} else {
		*enaddr++ = nv_ram.enet_addr[0];
		*enaddr++ = nv_ram.enet_addr[1];
		*enaddr++ = nv_ram.enet_addr[2];
		*enaddr++ = nv_ram.enet_addr[3];
		*enaddr++ = nv_ram.enet_addr[4];
		*enaddr = nv_ram.enet_addr[5];
	}
}

/* debugging support	*/
#ifdef	QXTRACE
#define QXTBSIZE 2048
struct qxtb {
	unsigned long where;
	unsigned long what;
	unsigned long what2;
	unsigned long count;
} qxtbuf[QXTBSIZE];

struct qxtb *qxtp = qxtbuf;

qxtrace(l1,l2,l3)	/* trace into memory buffer */
unsigned long l1,l2,l3;
{
	int s;

	s = spl7();
	if(qxtp->where == l1 && qxtp->what == l2 && qxtp->what2 == l3) {
		qxtp->count++;
		splx(s);
		return;
	}
	if(qxtp == &qxtbuf[QXTBSIZE-1]) {
		qxtp = qxtbuf;
	} else {
		qxtp++;
	}
	qxtp->where=l1;
	qxtp->what = l2;
	qxtp->what2 = l3;
	qxtp->count = 1;
	splx(s);
}
#endif	QXTRACE
