#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/cmap.h"
#include "../h/vmmac.h"
#include "../h/socket.h"

#include "../net/if.h"

#include "../is68kdev/qbvar.h"

/*
 * Pull read data off a interface. Len is length of data without local 
 * net header, hlen is length of interface header. Off0 is non-zero if a trailer
 * protocol was used, and gives the offset of the trailer information.
 * We copy the trailer information and then all the normal data into mbufs.
 * Prepend a pointer to the interface structure, so that protocols can 
 * determine where incoming packets arrived.  
 * Note: we may be called to receive from a transmit buffer by some devices.
 */
struct mbuf *
if_rqbget(ifu, totlen, off0, hlen, ifp0)
	register u_char *ifu;
	register int totlen, hlen;
	struct ifnet *ifp0;
{
	register struct mbuf *m;
	struct mbuf *top = 0, **mp = &top;
	register struct ifnet *ifp = ifp0;
	register int offt = off0;
	register u_char *cp = ifu + hlen + offt;
	register int len;

	while (totlen > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0) {
			m_freem(top);
			top = 0;
			break;
		}
		len = totlen - offt;

		/* if requested, leave room for interface pointer */
		if (ifp) {
			ifp = 0;
			m->m_len = MIN(MLEN - sizeof(ifp), len);
			m->m_off += sizeof(ifp);
		} else
			m->m_len = MIN(MLEN, len);

		bcopy(cp, mtod(m, u_char *), m->m_len);
		cp += m->m_len;

		/* if no trailers simple, else watch for end of trailer */
		if (offt == 0)
			totlen -= m->m_len;
		else if ((offt += m->m_len) == totlen) {
			offt = 0;
			totlen = off0;
			cp = ifu + hlen;
		} else if (offt > totlen)
			goto bad;
		*mp = m;
		mp = &m->m_next;
	}

 	/* drop the type and length which are at the front of any trailers */
	if (top && off0) {
		top->m_len -= 2 * sizeof (u_short);
		top->m_off += 2 * sizeof (u_short);
	}

	/* prepend interface pointer */
	if (top && ifp0) {
		top->m_len += sizeof(ifp);
		top->m_off -= sizeof(ifp);
		*(mtod(top, struct ifnet **)) = ifp0;
	}
	return (top);

bad:	m_freem(top);				/* corrupt packet */
	printf("if_qbget: trailer corrupt\n");	/**/
	return 0;
}

/*
 * Map a chain of mbufs onto a network interface in preparation for an 
 * i/o operation.  The argument chain of mbufs includes the local network
 * header which is copied to be in the mapped, aligned i/o space.
 */
if_wqbput(ifu, m0, padeven)
register u_char *ifu;
register struct mbuf *m0;
{
	register struct mbuf *m = m0;
	register u_char *cp = ifu;

	while (m) {
		bcopy(mtod(m, u_char *), cp, m->m_len);
		cp += m->m_len;
		m = m->m_next;
	}
	m_freem(m0);
	if (padeven && ((int)cp & 1))
		*cp++ = 0;
	return (cp - ifu);
}
