#include "../is68kif/if_pkbuf.h"
#include "../machine/pte.h"
#include "../machine/board.h"

struct pkbuf	*pkbuf_free;		/* free list of packet buffers */
int		pkbuf_nfree = NPKBUFS;	/* number of free packet buffers */
struct pkbuf	pkbufs[NPKBUFS];	/* packet buffer headers */

char		pkbuf_bufs[NPKBUFS * PKBUFSIZE];        /* space */

InitPkBuf()
{
	register struct pkbuf *pkb;
        register char *p = &pkbuf_bufs[0];
	register unsigned long vdma;

	vdma = iopballoc(p, NPKBUFS * PKBUFSIZE); 
	cache_inhibit(p, NPKBUFS * PKBUFSIZE); 
	for (pkbuf_free = pkb = pkbufs;  pkb < &pkbufs[NPKBUFS];  pkb += 1) {
		pkb->pkb_next = pkb + 1;
		pkb->pkb_len = 0;
		pkb->pkb_mbuf = 0;
		pkb->pkb_buffer = (char *)(CACHE_INHIBIT(p));
		pkb->pkb_dma_buffer = (char *)vdma;
		p += PKBUFSIZE;
		vdma += PKBUFSIZE;
	}
	pkbufs[NPKBUFS - 1].pkb_next = (struct pkbuf *)0;
}

struct pkbuf *
GetPkBuf()
{
	register int s = splimp();
	register struct pkbuf *pkb;

	if ((pkb = pkbuf_free) && (pkbuf_nfree > 0)) {
		pkbuf_free = pkb->pkb_next;
		pkbuf_nfree--;
		pkb->pkb_next = 0;
		pkb->pkb_len = 0;
		pkb->pkb_mbuf = 0;
	}
	splx(s);
	return pkb;
}

FreePkBuf(pkb)
	struct pkbuf *pkb;
{
	register int s = splimp();
	register struct pkbuf *pf = pkbuf_free;

	/* make shure pkb points to a packet buffer */
	if (pkb < &pkbufs[0] || pkb > &pkbufs[NPKBUFS-1])
		panic("FreePkBuf non pkbuf");

	/* make shure it is not already on the free list */
	while (pf) {
		if (pf == pkb)
			panic("double FreePkBuf");
		else
			pf = pf->pkb_next;
	}

	/* add to free list */
	pkb->pkb_next = pkbuf_free;
	pkb->pkb_len = 0;
	pkb->pkb_mbuf = 0;
	pkbuf_free = pkb;
	pkbuf_nfree++;
	splx(s);
}

NFreePkBuf()
{
	return pkbuf_nfree;
}

IsPkBuf(pkb)
	register struct pkbuf *pkb;
{
	if (pkb < &pkbufs[0] || pkb > &pkbufs[NPKBUFS-1])
		return 0;
	return 1;
}
