/*
 * Interlan Ethernet Communications Controller interface
 */

#include "il.h"

#if	NIL > 0
#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "mbuf.h"
#include "buf.h"
#include "protosw.h"
#include "socket.h"
#include "time.h"
#include "kernel.h"
#include "syslog.h"
#include "vmmac.h"
#include "ioctl.h"
#include "errno.h"

#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"

#ifdef INET
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/in_var.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#endif INET

#ifdef NS
#include "../netns/ns.h"
#include "../netns/ns_if.h"
#endif

#ifdef	TRFS
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#define	PKLEN		(ETHERMTU - 32 - 4)
#define	PKBURST		1
#endif

#ifdef	ENETFILTER
#include "../is68kif/enet.h"
#endif	ENETFILTER

#ifdef	M68030
#include "../machine/board.h"
#endif	M68030

#include "../is68kif/if_qb.h"
#include "../is68kif/if_pkbuf.h"
#include "../is68kif/if_ilreg.h"
#include "../is68kdev/qbvar.h"

int	ilprobe(), ilslave(), ilattach(), ilrint(), ilcint();
#ifdef	TRFS
int	il_xmit(), il_relse();
#endif	TRFS
struct	qb_device *ilinfo[Nil];
u_short *ilstd[] = {
#ifdef  QBUS
                (u_short *)0x3FE800,
                (u_short *)0x3FE810,
                (u_short *)0x3FE820,
                (u_short *)0x3FE830,
#else   QBUS
                (u_short *)&vme_stdio[0xFF0000],
                (u_short *)&vme_stdio[0xFE0000],
                (u_short *)&vme_stdio[0xFF7FE0],
                (u_short *)&vme_stdio[0xFE7FE0],
#endif  QBUS
                0 };
struct	qb_driver ILdriver =
	{ ilprobe, ilslave, ilattach, 0, ilstd, "il", ilinfo, "IL"};
int	ilinit(),iloutput(),ilioctl(),ilreset(),ilwatch();
#define	ILUNIT(x)	minor(x)

/*
 * Ethernet software status per interface: Each interface is referenced by a 
 * network interface structure, is_if, which the routing code uses to locate the
 * interface. This structure contains the output queue for the interface, and 
 * its address.
 */
struct	il_softc {
	struct arpcom	is_ac;		/* Ethernet common part */
#define		is_if	is_ac.ac_if	/* network-visible interface */
#define		is_addr	is_ac.ac_enaddr	/* hardware Ethernet address */
	int		is_flags;
#define		IL_OACTIVE	0x01	/* output is active */
#define		IL_HACTIVE	0x02	/* active hanging buffers */
#define		IL_RCVPENDING	0x04	/* start rcv in ilcint */
#define		IL_STATPENDING	0x08	/* stat cmd pending */
#define		IL_RUNNING	0x10	/* board is running */
#define		IL_SETADDR	0x20	/* physical address is changed */
	short		is_hung;	/* number of hung recieve buffers */
/*#define		IL_NHUNG	10 /**/
#define		IL_NHUNG	1
	short		is_lastcmd;	/* can't read csr, so must save it */
	short		is_scaninterval;/* interval of stat collection */
#define		ILWATCHINTERVAL	60	/* once every 60 seconds */
	struct pkbuf	*is_rbuf;	/* reciever buffer chain */
	struct pkbuf	*is_tbuf;	/* transmit buffer chain */
	short		is_enetunit;	/* ENET: unit number for filtering */
	short		is_enetinit;	/* ENET: inetrface is initialized */
	u_char		is_ix;		/* TRFS: Attached slot */
	struct		il_stats is_stats;/* holds on-board statistics */
	struct		il_stats is_sum;/* summation over time */
	struct il_softc *is_vdma;
} il_softc[Nil];

ilprobe(iladdr)
	struct ildevice *iladdr;
{
	register int i, cv;

	if (iladdr->il_csr == 0)
		return (0);
	cv = cvec;
	iladdr->il_csr = ILC_OFFLINE|IL_CIE;
	DELAY(20000);				/* wait for interupt */
	i = iladdr->il_csr;			/* clears {CR}DONE */
	if (cvec != cv)
		cvec -= 4;
	clevmax = clev_impmax;
	clev_imp = MAX(clev, clev_imp);
	return (sizeof(struct ildevice));
}

ilslave(qi)
	struct qb_device *qi;
{
	return (1);
}

ilattach(qi)
	struct qb_device *qi;
{
	register struct il_softc *is
		= (struct il_softc *)(CACHE_INHIBIT(&il_softc[qi->qi_unit])):
	register struct ifnet *ifp = &is->is_if;
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;

        cache_inhibit(is, sizeof(*is));
        is->is_vdma = (struct il_softc *)(IOPB_STD(iopballoc(is, sizeof(*is)),vbnum));
	ifp->if_unit = qi->qi_unit;
	ifp->if_name = "il";
	ifp->if_mtu = ETHERMTU;
	ifp->if_flags = IFF_BROADCAST;

	/* Reset the board and map the statistics buffer */
	iladdr->il_csr = ILC_RESET;
	(void)ilwait(qi, "reset");
        iladdr->il_bar = (int)(&is->is_vdma->is_stats);
	iladdr->il_bcr = sizeof (struct il_stats);
        iladdr->il_bae = ((int)(&is->is_vdma->is_stats)) >> 16;
	iladdr->il_csr = ILC_STAT;
	(void)ilwait(qi, "status");
	byterev(&is->is_stats, sizeof(struct il_stats));
	bcopy(is->is_stats.ils_addr, is->is_addr, sizeof(is->is_addr));
	printf("	(%e) %s %s", is->is_addr,
		is->is_stats.ils_module, is->is_stats.ils_firmware);
	ifp->if_init = ilinit;
	ifp->if_output = iloutput;
	ifp->if_ioctl = ilioctl;
	ifp->if_reset = ilreset;
	if_attach(ifp);
#ifdef	TRFS
	is->is_ix = IfaceAttach(ifp->if_unit, il_xmit, il_relse,
		PKLEN, PKBURST, etherbroadcastaddr, sizeof(is->is_addr));
#endif	TRFS
}

ilwait(qi, op)
	struct qb_device *qi;
	char *op;
{
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	register short csr, rdone = 0;

	while (((csr = iladdr->il_csr)&IL_CDONE) == 0)	/* clears {CR}DONE */
		;
	if (csr&IL_STATUS) {
		printf("il%d: %s failed, csr=%b\n", 
			qi->qi_unit, op, csr, IL_BITS);
		return (0);
	}
	return (csr);
}

/* Reset of interface. */
ilreset(unit)
	int unit;
{
	register struct qb_device *qi;
	register struct ildevice *iladdr;

	if (unit >= Nil || (qi = ilinfo[unit]) == 0 || qi->qi_alive == 0 )
		return;
	iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	iladdr->il_csr = ILC_RESET;
	(void)ilwait(qi, "reset");
	il_softc[unit].is_if.if_flags &= ~IFF_RUNNING;
	il_softc[unit].is_flags &= ~IL_RUNNING;
}

/* Initialization of interface; clear recorded pending operations. */
ilinit(unit)
	int unit;
{
	register struct il_softc *is
		= (struct il_softc *)(CACHE_INHIBIT(&il_softc[unit])):
	register struct qb_device *qi = ilinfo[unit];
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	register struct ifnet *ifp = &is->is_if;
	register struct pkbuf *pkb;
	register int s;
	int i;

#ifndef	TRFS
	/* not yet, if address still unknown */
	if (ifp->if_addrlist == (struct ifaddr *)0)
		return;
#endif	TRFS
	if (is->is_flags & IL_RUNNING)
		return;

	ifp->if_watchdog = ilwatch;
	is->is_scaninterval = ILWATCHINTERVAL;
	ifp->if_timer = is->is_scaninterval;

	/*
	 * Turn off source address insertion (it's faster this way),
	 * and set board online.
	 */
	s = splimp();
	iladdr->il_csr = ILC_RESET;

	/* Free up pending packets */
	for (pkb = is->is_rbuf; pkb; pkb = pkb->pkb_next)
		FreePkBuf(pkb);
	for (pkb = is->is_tbuf; pkb; pkb = pkb->pkb_next)
		FreePkBuf(pkb);
	is->is_rbuf = is->is_tbuf = 0;
	is->is_hung = 0;

	if (!ilwait(qi, "diag")) {
    err:	is->is_if.if_flags &= ~IFF_UP;
 		splx(s);
 		return;
 	}
	iladdr->il_csr = ILC_CISA;
	if (!ilwait(qi, "cisa"))
		goto err;

	/*
	 * If we must reprogram this board's physical ethernet address (as 
	 * for secondary XNS interfaces), we do so before putting it on line, 
	 * and starting receive requests. If you try this on an older 1010 
	 * board, it will total wedge the board.
	 */
	if (is->is_flags & IL_SETADDR) {
		bcopy((caddr_t)is->is_addr, (caddr_t)&is->is_stats,
							sizeof is->is_addr);
		byterev(&is->is_stats, sizeof(struct il_stats));
                iladdr->il_bar = (int)(is->is_vdma->is_addr);
		iladdr->il_bcr = sizeof (is->is_addr);
                iladdr->il_bae = ((int)(is->is_vdma->is_addr)) >> 16;
		iladdr->il_csr = ILC_LDPA;
		if (!ilwait(qi, "ldpa"))
			goto err;
                iladdr->il_bar = (int)(&is->is_vdma->is_stats);
		iladdr->il_bcr = sizeof (struct il_stats);
                iladdr->il_bae = ((int)(&is->is_vdma->is_stats)) >> 16;
		iladdr->il_csr = ILC_STAT;
		if (!ilwait(qi, "statldpa"))
			goto err;
		byterev(&is->is_stats, sizeof(struct il_stats));
		if (bcmp((caddr_t)is->is_stats.ils_addr, (caddr_t)is->is_addr,
						sizeof (is->is_addr)) != 0) {
			printf("il%d: setaddr didn't work\n", qi->qi_unit);
			goto err;
		}
	}
	/*
	 * Set board online. Hang receive buffer and start any pending
	 * writes by faking a transmit complete. Receive bcr is not a 
	 * multiple of 8 so buffer chaining can't happen.
	 */
	iladdr->il_csr = ILC_ONLINE;
	if (!ilwait(qi, "online"))
		goto err;
	ifp->if_flags |= IFF_RUNNING;
	is->is_flags = IL_RCVPENDING|IL_OACTIVE|IL_RUNNING;
#ifdef	TRFS
	IfaceUp(is->is_ix);
#endif	TRFS
	ilcint(unit);
	splx(s);
#ifdef	ENETFILTER
	if (!is->is_enetinit) {
	    	struct endevp enp;
	    
		is->is_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(is->is_addr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		bcopy((caddr_t)is->is_addr, (caddr_t)enp.end_addr,
			sizeof(is->is_addr));
		bcopy((caddr_t)etherbroadcastaddr, (caddr_t)enp.end_broadaddr,
			sizeof(is->is_addr));
	    	is->is_enetunit = enetattach(&is->is_if, &enp);
	}
#endif	ENETFILTER
}

/* hang recieve packet buffers */
ilhang(qi, is, iladdr)
	register struct qb_device *qi;
	register struct il_softc *is;
	register struct ildevice *iladdr;
{
	register struct pkbuf *pkb = is->is_rbuf, *npkb;
	short csr = 0, rdone = 0;
	int i;

	if (is->is_flags & (IL_HACTIVE|IL_OACTIVE)) {
		is->is_flags |= IL_RCVPENDING;
		return;
	}
	is->is_flags |= IL_HACTIVE;

	/* find last hung */
	while (pkb && pkb->pkb_next)
		pkb = pkb->pkb_next;

	/* hang new ones */
	while (is->is_hung < IL_NHUNG) {
		if ((npkb = GetPkBuf()) == 0) {
			printf("il%d: no recv packet buffers\n", qi->qi_unit);
			is->is_flags &= ~IL_HACTIVE;
			return;
		}
		if (pkb)
			pkb->pkb_next = npkb;
		else
			is->is_rbuf = npkb;
		is->is_hung++;
		pkb = npkb;
		
		/* mark as unused, and hang buffer */
		((struct il_rheader *)pkb->pkb_buffer)->ilr_length = ILFLEN_CLEAN;
		i = (int)(IOPB_STD(pkb->pkb_dma_buffer,vbnum));
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof(struct il_rheader) + ETHERMTU + 6;
		iladdr->il_bae = hiword(i);
		iladdr->il_csr = ILC_RCV|IL_RIE;
		while ((csr&IL_CDONE) == 0)
		    if ((csr=iladdr->il_csr)&IL_RDONE)	/* clears {CR}DONE */
			rdone++;
	}
	if (rdone)
{
/*printf("r");/**/
/*		ilrint(qi->qi_unit); /**/
}
	is->is_flags &= ~(IL_HACTIVE|IL_RCVPENDING);
}

/*
 * Start output on interface. Get another datagram to send off of the interface
 * queue, and map it to the interface before starting the output.
 */
ilstart(unit)
{
        int len;
	struct qb_device *qi = ilinfo[unit];
	register struct il_softc *is
		= (struct il_softc *)(CACHE_INHIBIT(&il_softc[unit])):
	register struct ildevice *iladdr =(struct ildevice *)qi->qi_mi->qm_addr;
	register struct pkbuf *pkb;
	struct mbuf *m;
	int i;

	IF_DEQUEUE(&is->is_if.if_snd, m);
	if (m == 0) {
		if (ilxmit(is, iladdr) || (is->is_flags & IL_STATPENDING) == 0)
			return;
		is->is_flags &= ~IL_STATPENDING;
/* modify this to get stats in a pkbuf */
                i = (int)(&is->is_vdma->is_stats);
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof (struct il_stats);
		iladdr->il_bae = hiword(i);
		is->is_lastcmd = ILC_STAT;
		iladdr->il_csr = ILC_STAT|IL_RIE|IL_CIE;
		is->is_flags |= IL_OACTIVE;
		return;
	}
	if ((pkb = GetPkBuf()) == 0) {
		ilxmit(is, iladdr);
		printf("il%d: no xmit packet buffers\n", unit);
		IF_ENQUEUE(&is->is_if.if_snd, m);
		return;
	}

	/*
	 * Ensure minimum packet length. This makes the safe assumption that 
	 * there are no virtual holes after the data. For security, it might be
	 * wise to zero out the added bytes, but we're mainly interested in 
	 * speed at the moment.
	 */
	pkb->pkb_len = if_wqbput(pkb->pkb_buffer, m, 1);
	if (pkb->pkb_len - sizeof(struct ether_header) < ETHERMIN)
		pkb->pkb_len = ETHERMIN + sizeof(struct ether_header);
	ilxappend(is, pkb);
	ilxmit(is, iladdr);
}

/* add new packet to end of pending packets */
ilxappend(is, npkb, len)
	register struct il_softc *is;
	register struct pkbuf *npkb;
{
	register struct pkbuf *pkb = is->is_tbuf;

	while (pkb && pkb->pkb_next)
		pkb = pkb->pkb_next;
	if (pkb)
		pkb->pkb_next = npkb;
	else
		is->is_tbuf = npkb;
}

/* transmit packet at head of pending queue */
ilxmit(is, iladdr)
	register struct il_softc *is;
	register struct ildevice *iladdr;
{
	register struct pkbuf *pkb = is->is_tbuf;
	int i;

	if (pkb) {
		byterev(pkb->pkb_buffer, pkb->pkb_len);
		i = (int)(IOPB_STD(pkb->pkb_dma_buffer,vbnum));
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = pkb->pkb_len;
		iladdr->il_bae = hiword(i);
		is->is_lastcmd = ILC_XMIT;
		iladdr->il_csr = ILC_XMIT|IL_RIE|IL_CIE;
		is->is_flags |= IL_OACTIVE;
		return(1);
	}
	return(0);
}

/* Command done interrupt.  */
ilcint(unit)
	int unit;
{
	register struct il_softc *is = &il_softc[unit];
	register struct ifnet *ifp = &is->is_if;
	struct qb_device *qi = ilinfo[unit];
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	register struct pkbuf *pkb;
	short csr = iladdr->il_csr;		/* clears {CR}DONE */
	int i;

	if ((is->is_flags & IL_OACTIVE) == 0) {
		printf("il%d: stray xmit interrupt csr=%b\n",unit,csr,IL_BITS);
		return;
	}
	is->is_flags &= ~IL_OACTIVE;
	if (is->is_flags & IL_RCVPENDING)
		ilhang(qi, is, iladdr);
	csr &= IL_STATUS;
	switch (is->is_lastcmd) {
	    case ILC_XMIT:
		ifp->if_opackets++;
		if (pkb = is->is_tbuf) {
			is->is_tbuf = pkb->pkb_next;
			FreePkBuf(pkb);
		} else
			printf("il%d: transmit sync\n", unit);
		if (csr > ILERR_RETRIES)
			ifp->if_oerrors++;
		break;

	    case ILC_STAT:
		byterev(&is->is_stats, sizeof (struct il_stats));
		if (csr == ILERR_SUCCESS)
			iltotal(is);
		break;
	}
	ilstart(unit);
}

/*
 * Ethernet interface receiver interrupt. If input error just drop packet.
 * Otherwise examine packet to determine type. If can't determine length from 
 * type, then have to drop packet. Othewise decapsulate packet based on type 
 * and pass to type specific higher-level input routine.
 */
ilrint(unit)
	int unit;
{
	register struct il_softc *is = &il_softc[unit];
	register struct qb_device *qi = ilinfo[unit];
	register struct ifnet *ifp = &is->is_if;
	struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	register struct pkbuf *pkb;
	register struct il_rheader *eh;
	register struct ifqueue *inq;
	int len, off, resid;
    	struct mbuf *m;
	int i, freepkb = 0, s;
	short csr = iladdr->il_csr;	/* clears {CR}DONE */


setup:	if (freepkb)
		FreePkBuf(pkb);
	freepkb = 1;
	if ((pkb = is->is_rbuf) == 0) {
hang:		ilhang(qi, is, iladdr);
		return;
	}
	eh = (struct il_rheader *)pkb->pkb_buffer;
	if (eh->ilr_length == ILFLEN_CLEAN)
		goto hang;
	is->is_rbuf = pkb->pkb_next;
	is->is_hung--;

	ifp->if_ipackets++;
	byterev((caddr_t)eh->ilr_dhost, eh->ilr_length);
	len = eh->ilr_length - sizeof(struct il_rheader);
	if ((eh->ilr_status&(ILFSTAT_L|ILFSTAT_A|ILFSTAT_C)) || len < 46 ||
	    len > ETHERMTU) {
		ifp->if_ierrors++;
		goto setup;
	}

	eh->ilr_type = ntohs((u_short)eh->ilr_type);
#define	ildataaddr(eh, off, type)	((type)(((caddr_t)((eh)+1)+(off))))
	if (eh->ilr_type >= ETHERTYPE_TRAIL &&
	    eh->ilr_type < ETHERTYPE_TRAIL+ETHERTYPE_NTRAILER) {
		if ((off = (eh->ilr_type - ETHERTYPE_TRAIL)*512) >= ETHERMTU)
			goto setup;			/* sanity */
		eh->ilr_type = ntohs(*ildataaddr(eh, off, u_short *));
		resid = ntohs(*(ildataaddr(eh, off+2, u_short *)));
		if (off + resid > len)
			goto setup;			/* sanity */
		len = off + resid;
	} else
		off = 0;
	if (len == 0)
		goto setup;

#ifdef	TRFS
	if (eh->ilr_type == ETHERTYPE_WIPC) {
		freepkb = il_recv(is - il_softc, pkb);
		goto setup;
	}
#endif	TRFS

	/*
	 * Pull packet off interface. Off is nonzero if packet has trailing 
	 * header; if_rqbget will then force this header information to be at 
	 * the front and drop the type and length at the head of trailers.
	 */
	if ((m = if_rqbget(eh, len, off, 
		sizeof(struct il_rheader), ifp)) == 0)
			goto setup;

	switch (eh->ilr_type) {
#ifdef INET
	    case ETHERTYPE_IP:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;

	    case ETHERTYPE_ARP:
		arpinput(&is->is_ac, m);
		goto setup;
#endif
#ifdef NS
	    case ETHERTYPE_NS:
		schednetisr(NETISR_NS);
		inq = &nsintrq;
		break;

#endif
	    default:
#ifdef	ENETFILTER
		if (is->is_enetinit && is->is_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all. Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				/* undo the swap done earlier */
				eh->ilr_type = htons((u_short)eh->ilr_type);
				bcopy((struct il_rheader*)eh->ilr_dhost,
					mtod(mtop, struct il_rheader *),
					sizeof(struct il_rheader));
				mtop->m_len = sizeof(struct il_rheader);
				/* remove interface pointer */
				m->m_len -= sizeof(ifp);
				m->m_off += sizeof(ifp);
				mtop->m_next = m;
				enetFilter(is->is_enetunit, mtop,
					(len + sizeof(struct il_rheader)) );
				goto setup;
			}
		}
#endif	ENETFILTER
		m_freem(m);
		goto setup;
	}

	s = splimp();
	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
	} else
		IF_ENQUEUE(inq, m);
	splx(s);
	goto setup;
}

/*
 * Ethernet output routine. Encapsulate a packet of type family for the local 
 * net. Use trailer local net encapsulation if enough data in first packet 
 * leaves a multiple of 512 bytes of data in remainder.
 */
iloutput(ifp, m0, dst)
	register struct ifnet *ifp;
	struct mbuf *m0;
	struct sockaddr *dst;
{
	int type, s, error;
	u_char edst[6];
	struct in_addr idst;
	register struct il_softc *is = &il_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *eh;
	register int off;
	int usetrailers;

	switch (dst->sa_family) {
#ifdef INET
	    case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&is->is_ac, m, &idst, edst, &usetrailers))
			return (0);	/* if not yet resolved */
		off = ntohs((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if (usetrailers && off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERTYPE_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof (u_short);
			m->m_len += 2 * sizeof (u_short);
			*mtod(m, u_short *) = htons((u_short)ETHERTYPE_IP);
			*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
			goto gottrailertype;
		}
		type = ETHERTYPE_IP;
		off = 0;
		goto gottype;
#endif
#ifdef NS
	    case AF_NS:
		type = ETHERTYPE_NS;
 		bcopy((caddr_t)&(((struct sockaddr_ns *)dst)->sns_addr.x_host),
		(caddr_t)edst, sizeof (edst));
		off = 0;
		goto gottype;
#endif
	    case AF_IMPLINK:
		eh = mtod(m, struct ether_header *);
		goto gotheader;

	    case AF_UNSPEC:
		eh = (struct ether_header *)dst->sa_data;
		bcopy((caddr_t)eh->ether_dhost, (caddr_t)edst, sizeof (edst));
		type = eh->ether_type;
		goto gottype;

	    default:
		log(LOG_WARNING, "il%d: can't handle af%d\n", ifp->if_unit,
			dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet (control information)
	 * to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;

gottype:
	/* Add local net header. If no space in first mbuf, allocate another. */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof (struct ether_header);
	} else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	eh = mtod(m, struct ether_header *);
	eh->ether_type = htons((u_short)type);
 	bcopy((caddr_t)edst, (caddr_t)eh->ether_dhost, sizeof (edst));

gotheader:
 	bcopy((caddr_t)is->is_addr, (caddr_t)eh->ether_shost,
	    sizeof(eh->ether_shost));

	/* Queue message on interface, start output if not yet active */
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);

	if ((is->is_flags & IL_OACTIVE) == 0)
		ilstart(ifp->if_unit);
	splx(s);
	return (0);
bad:
	m_freem(m0);
	return (error);
}

/*
 * Watchdog routine, request statistics from board.
 */
ilwatch(unit)
	int unit;
{
	register struct il_softc *is = &il_softc[unit];
	register struct ifnet *ifp = &is->is_if;
	int s;

	if (is->is_flags & IL_STATPENDING) {
		ifp->if_timer = is->is_scaninterval;
		return;
	}
	s = splimp();
	is->is_flags |= IL_STATPENDING;
	if ((is->is_flags & IL_OACTIVE) == 0)
		ilstart(ifp->if_unit);
	splx(s);
	ifp->if_timer = is->is_scaninterval;
}

/* Total up the on-board statistics. */
iltotal(is)
	register struct il_softc *is;
{
	register u_short *interval, *sum, *end;

	interval = &is->is_stats.ils_frames;
	sum = &is->is_sum.ils_frames;
	end = is->is_sum.ils_fill2;
	while (sum < end)
		*sum++ += *interval++;
	is->is_if.if_collisions = is->is_sum.ils_collis;
}

/* Process an ioctl request. */
ilioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	int cmd;
	caddr_t data;
{
	register struct ifaddr *ifa = (struct ifaddr *)data;
	register struct il_softc *is = &il_softc[ifp->if_unit];
	struct ildevice *iladdr = 
			(struct ildevice *)ilinfo[ifp->if_unit]->qi_mi->qm_addr;
	int s = splimp(), error = 0;

	switch (cmd) {
	    case SIOCGHDADDR: {
		struct ifreq *ifr = (struct ifreq *)data;
		bcopy (is->is_addr, ifr->ifr_hdaddr, 6);
		break;
	    }

	    case SIOCSIFADDR:
                ifp->if_flags |= IFF_UP;
                ilinit(ifp->if_unit);

                switch (ifa->ifa_addr.sa_family) {
#ifdef INET
		    case AF_INET:
			((struct arpcom *)ifp)->ac_ipaddr =
				IA_SIN(ifa)->sin_addr;
			arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
			break;
#endif
#ifdef NS
		    case AF_NS:
		    {
			register struct ns_addr *ina = &(IA_SNS(ifa)->sns_addr);
			
			if (ns_nullhost(*ina))
				ina->x_host = *(union ns_host *)(is->is_addr);
			else
				il_setaddr(ina->x_host.c_host,ifp->if_unit);
			break;
		    }
#endif
		}
		break;

	    case SIOCSIFFLAGS:
		if ((ifp->if_flags & IFF_UP) == 0 && is->is_flags & IL_RUNNING) {
			is->is_flags &= ~IL_RUNNING;
#ifdef	TRFS
			IfaceDown(is->is_ix);
#endif	TRFS
		}
		break;

	    default:
		error = EINVAL;
	}
	splx(s);
	return (error);
}

il_setaddr(physaddr, unit)
	u_char *physaddr;
	int unit;
{
	register struct il_softc *is = &il_softc[unit];
	
	if (! (is->is_flags & IL_RUNNING))
		return;
		
	bcopy((caddr_t)physaddr, (caddr_t)is->is_addr, sizeof is->is_addr);
	is->is_flags &= ~IL_RUNNING;
	is->is_flags |= IL_SETADDR;
	ilinit(unit);
}

#ifdef	TRFS
il_xmit(unit, naddr, p, len, fp0, fp1)
	int unit;
	struct ether_addr *naddr;
	struct packet *p;
	unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct ether_header *eh;
	register struct il_softc *is = &il_softc[unit];
	register struct pkbuf *pkb;
	int s = splimp();

	if ((pkb = GetPkBuf()) == (struct pkbuf *)0) {
		if ((is->is_flags & IL_OACTIVE) == 0)
			ilstart(unit);
		splx(s);
		printf("il%d: TRFS: no xmit packet buffers\n", unit);
		return EBUSY;
	}
	eh = (struct ether_header *)pkb->pkb_buffer;
	bcopy((caddr_t)naddr, (caddr_t)eh->ether_dhost, sizeof (eh->ether_dhost));
	bcopy((caddr_t)is->is_addr, (caddr_t)eh->ether_shost, sizeof (eh->ether_shost));
	eh->ether_type = ETHERTYPE_WIPC;
	len = (sizeof(struct pklink) - sizeof(struct packet)) +
		pkbuild(&((struct pklink *)eh)->packet, p, len, fp0, fp1);
	if (len - sizeof(struct ether_header) < ETHERMIN)
		len = ETHERMIN + sizeof(struct ether_header);
	pkb->pkb_len = len;
	ilxappend(is, pkb);
	if ((is->is_flags & IL_OACTIVE) == 0)
		ilstart(unit);
	splx(s);
	return 0;
}

il_recv(unit, pkb)
	int unit;
	register struct pkbuf *pkb;
{
	register struct il_softc *is = &il_softc[unit];
	register struct qb_device *qi = ilinfo[unit];
	struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	register struct pklink *p;

	/* skip the interlan recieve header */
	p = (struct pklink *)((int)pkb->pkb_buffer + 
		((int)&(((struct il_rheader *)0)->ilr_dhost[0])));
	ovbcopy(((struct ether_header *)p)->ether_shost, p->netaddr, 6);
	p->buflen = PKBUFSIZE;
	p->prelen = (int)&(((struct il_rheader *)0)->ilr_dhost[0]);
	p->ix = il_softc[unit].is_ix;
	p->handle = (int)pkb;
	return ReceivePacket(p);
}

il_relse(unit, p)
	int unit;
	struct pklink *p;
{
	int s = splimp();

	FreePkBuf((struct pkbuf *)p->handle);
	splx(s);
}
#endif	TRFS
#endif	NIL > 0
