/*	if_ddareg.h		V1.0		27 March 1986		*/

struct ddadevice {	/* ACC 5250 */	
	u_short	csr;			/* control and status register */
#define		  CSR_BIT15	0x8000
#define		  CSR_BIT14	0x4000	/*    0 */
#define		  CSR_MAINT	0x2000	/*    maintance board not attached */
#define		  CSR_HALT	0x1000	/*    if 1 the ACP is not halted */
#define		  CSR_IBPEND	0x0800	/*    interrupt b pending */
#define		  CSR_IAPEND	0x0400	/*    interrupt a pending */
#define		  CSR_IBREQ	0x0200	/*    interrupt b request */
#define		  CSR_IAREQ	0x0100	/*    interrupt a request */
#define		  CSR_BIT7	0x0080
#define		  CSR_BIT6	0x0040	/*    0 */
#define		  CSR_INTRB	0x0020	/*    ACP CPU Interrupt A request */
#define		  CSR_INTRA	0x0010	/*    ACP CPU Interrupt B request */
#define		  CSR_IENB	0x0008	/*    enable interrupt b   */
#define		  CSR_IENA	0x0004	/*    enable interrupt a   */
#define		  CSR_DMAEN	0x0002	/*    ACP can do DMA */
#define		  CSR_RESET	0x0001	/*    reset ACP 5250 */ 

					/* I/O request mailbox */
	u_short req_chan;		/*   FDX channel number */
	u_char	req_flags;		/*   mailbox flags */
#define 	  FLAGS_RDY	0x80	/*     indicates ready */
#define 	  FLAGS_DON	0x40	/*     indicates done */
#define 	  FLAGS_DIR	0x20	/*     indicates write (host to ACP) */
	u_char	req_adx;		/*   address bits 17-16 */
	u_short req_addr;		/*   address bits 15-00 */
	u_short req_cnt;		/*   byte count */
	u_char	req_sbf;		/*   I/O subfunction */
	u_char	req_func;		/*   I/O function */
#define		  DDARDB	0x01	/*     read from ACP */
#define		  DDAWRT	0x02	/*     write to ACP */
#define		  DDAABT	0x04	/*     abort flag */
#define		  DDASTR	0x10	/*     stream flag */
#define		  DDAEOS	0x30	/*     end of stream flag */
#define		  DDAXFR	0x40	/*     issue Transfer Request data */
#define		  DDASWP	0x80	/*     Swap host bytes */

					/* I/O completion mailbox */
	u_short cmp_chan;		/*   FDX channel number */
	u_char	cmp_flags;		/*   mailbox flags */
	u_char	cmp_unused;		/*   address bits 17-16 */
	u_short cmp_cnt;		/*   byte count */
	u_char	cmp_sbst;		/*   I/O substatus */
	u_char	cmp_stat;		/*   I/O status */
#define		  DDAIOCOK	0x01	/*     successful */
#define		  DDAIOCOKP 	0x02	/*     successful, more data */
#define		  DDAIOCABT 	0xff	/*     i/o aborted */
#define		  DDAIOCERR 	0xfe	/*     program error */
#define		  DDAIOCOVR 	0xfd	/*     overrun error */
#define		  DDAIOCUBE 	0xfc	/*     Transfer count = 0 */
#define		  DDAIODMAE 	0xfb	/*     DMA completion error */
#define		  DDAIOLCOL 	0xfa	/*     Listen Collision */
#define		  DDAIOFUNC 	0xf9	/*     Invalid function */
#define		  DDAIODPN  	0xf8	/*     Invalid DPN */
					/*     Transfer request mailbox */
	u_short xfr_chan;		/*   FDX channel number */
	u_char	xfr_flags;		/*   mailbox flags */
	u_char	xfr_adx;		/*   address bits 17-16 */
	u_short xfr_addr;		/*   address bits 15-00 */
	u_short xfr_cnt;		/*   byte count */

					/* System status mailbox */
	u_char	sys_id;			/*   system identification */
	u_char	sys_vers;		/*   system version number */
	u_char  sys_stat;		/*   system status */
#define		  DDASTAT_OK	0x00	/*     system status OK */
	u_char	sys_vect;		/*   interrupt vector base */
};
