/*
 * spaninfo.h - ioctl inormation structure for disk spanning driver.
 */

#define Nsp_segs	8	/* Max number of partitions per spaned disk.
				 * Note that if this is changed both sp.c and
				 * spconfig.y and spconfig.c must be
				 * recompiled */

struct spaninfo {
	int	sp_nsegs;		/* number of segments */
	dev_t	sp_dev[Nsp_segs] ;
	int	sp_size[Nsp_segs] ;
};

#ifndef	_IOCTL_
#include <sys/ioctl.h>
#endif

#define GSPANINFO	(IOC_OUT | 0 | (sizeof(struct spaninfo)<<16))
#define SSPANINFO	(IOC_IN  | 1 | (sizeof(struct spaninfo)<<16))
