
/*
 * This is a header file for the SCN68562 Dual Universal Serial Communications
 * Controller (DUSCC). Each DUSCC is made up of two channels. Each channel
 * corresponds to the structure given below.
 * Written March 1987, C M Bowley, Torch Computers Ltd.
 */

#ifndef	LOCORE
struct dusccchan {
	unsigned char du_cmr1;	/* channel mode register 1 */
	unsigned char du_cmr2;	/* channel mode register 2 */
	unsigned char du_s1r;	/* SYN 1/Secondary address 1 */
	unsigned char du_s2r;	/* SYN 2/Secondary address 2 */
	unsigned char du_tpr;	/* transmitter parameter register */
	unsigned char du_ttr;	/* transmitter timing register */
	unsigned char du_rpr;	/* receiver parameter register */
	unsigned char du_rtr;	/* receiver timing register */
	unsigned char du_ctprh;	/* counter/timer preset register high */
	unsigned char du_ctprl;	/* counter/timer preset register low */
	unsigned char du_ctcr;	/* counter/timer control register */
	unsigned char du_omr;	/* output and miscellaneous register */
	unsigned char du_cth;	/* counter/timer high, read only */
	unsigned char du_ctl;	/* counter/timer low, read only */
	unsigned char du_pcr;	/* pin configuration register */
	unsigned char du_ccr;	/* channel command register */
	unsigned char du_txfifo;	/* transmitter FIFO, write only */
	unsigned char du_pad1[3];	/* transmitter FIFO is accessible at 4 bytes */
	unsigned char du_rxfifo;	/* receiver FIFO, read only */
	unsigned char du_pad2[3];	/* Receiver FIFO is accessible at 4 bytes */
	unsigned char du_rsr;	/* receiver status register */
	unsigned char du_trsr;	/* transmitter and receiver status register */
	unsigned char du_ictsr;	/* input and counter/timer status register */
	unsigned char du_gsr;	/* general status register */
	unsigned char du_ier;	/* interrupt enable register */
	unsigned char du_pad3;
	/*
	 * The next location is the interrupt vector register. When accessed
	 * in channel 0 it is  unmodified and in channel 1 it is modified. This
	 * register is read only in channel 1.
	 */
	unsigned char du_ivr;	/* interrupt vector, chan 0 unmodified, chan 1 modified
	/*
	 * The next register is the interrupt control register. It is only
	 * available in channel 0.
	 */
	unsigned char du_icr;
};
#endif	LOCORE


/*
 * bit positions for Channel mode register 1 (du_cmr1).
 */
#define DU_CMR1_NRZ	0x00		/* data encoding */
#define	DU_CMR1_NRZI	0x40
#define	DU_CMR1_FM0	0x80
#define	DU_CMR1_FM1	0xc0

#define	DU_CMR1_PRTY_EVEN	0x00	/* even/odd parity selection */
#define	DU_CMR1_PRTY_ODD	0x20

#define	DU_CMR1_EBCDIC		0x00	/* BISYNC comparison mode */
#define	DU_CMR1_ASCII		0x20

#define	DU_CMR1_EXT1	0x00		/* one/two octet control field */
#define	DU_CMR1_EXT2	0x20

#define	DU_CMR1_PRTY_NONE	0x00	/* parity mode */
#define	DU_CMR1_PRTY_WITH	0x10
#define	DU_CMR1_PRTY_FRCE	0x18

#define	DU_CMR1_ADDR_8		0x00	/* address mode */
#define	DU_CMR1_ADDR_EXT	0x08
#define	DU_CMR1_ADDR_16		0x10
#define	DU_CMR1_ADDR_16GROUP	0x18

#define	DU_CMR1_BOP_PRIMARY	0x00	/* channel protocol mode */
#define	DU_CMR1_BOP_SECONDARY	0x01
#define	DU_CMR1_BOP_LOOP	0x02
#define	DU_CMR1_BOP_LP_NADDR	0x03
#define	DU_CMR1_COP_DUAL_SYN	0x04
#define	DU_CMR1_COP_BISYNC	0x05
#define	DU_CMR1_COP_ONE_SYN	0x06
#define	DU_CMR1_ASYNC		0x07


/*
 * bit positions of channel mode register 2 (du_cmr2)
 */
#define	DU_CMR2_CONN_NORM	0x00	/* channel connection */
#define	DU_CMR2_CONN_ECHO	0x40
#define	DU_CMR2_CONN_LOOP	0x80

#define	DU_CMR2_HALF_S_DMA	0x00	/* data transfer interface */
#define	DU_CMR2_HALF_D_DMA	0x08
#define	DU_CMR2_FULL_S_DMA	0x10
#define	DU_CMR2_FULL_D_DMA	0x18
#define	DU_CMR2_WAIT_RX		0x20
#define	DU_CMR2_WAIT_TX		0x28
#define	DU_CMR2_WAIT_RX_TX	0x30
#define	DU_CMR2_POLLED		0x38

#define	DU_CMR2_NO_FCS		0x00	/* frame check sequence select */
#define	DU_CMR2_LRC8_P0		0x02
#define	DU_CMR2_LRC8_P1		0x03
#define	DU_CMR2_CRC16_P0	0x04
#define	DU_CMR2_CRC16_P1	0x05
#define	DU_CMR2_CCITT_P0	0x06
#define	DU_CMR2_CCITT_P1	0x07

/*
 * bit positins for the pin configuration register (du_pcr). Note that bit 7
 * is only used in channel 0.
 */
#define	DU_PCR_X2_CRYS		0x00	/* crystal/daisy chain on X2/IDC pin */
#define	DU_PCR_IDC		0x80

#define	DU_PCR_GPO2		0x00	/* GP output or RTS */
#define	DU_PCR_GP_RTS		0x40

#define	DU_PCR_SYNOUT		0x00	/* SYNOUT or RTS */
#define	DU_PCR_SY_RTS		0x20

#define	DU_PCR_RTxC_INPUT	0x00	/* use of RTxC pin */
#define	DU_PCR_RTxC_C_T		0x08
#define	DU_PCR_RTxC_TxCLK	0x10
#define	DU_PCR_RTxC_RxCLK	0x18

#define	DU_PCR_TRxC_INPUT	0x00	/* use of TRxC pin */
#define	DU_PCR_TRxC_XTAL_2	0x01
#define	DU_PCR_TRxC_DPLL	0x02
#define	DU_PCR_TRxC_C_T		0x03
#define	DU_PCR_TRxC_16TxCLK	0x04
#define	DU_PCR_TRxC_16RxCLK	0x05
#define	DU_PCR_TRxC_1xTxCLK	0x06
#define	DU_PCR_TRxC_1xRxCLK	0x07

/*
 * bit positions in the transmitter parameter register (du_tpr).
 */
#define	DU_TPR_FCS_IDLE		0x00	/* underrun control (COP) */
#define	DU_TPR_MARK		0x80
#define	DU_TPR_SYN		0xc0

#define	DU_TPR_FCS_FLAG_IDLE	0x00	/* underrun control (BOP) */
#define	DU_TPR_ABRT_MARK	0x80
#define	DU_TPR_ABRT_FLAG	0xc0

#define	DU_TPR_IDLE_MARK	0x00	/* Idle (COP, BOP) */
#define	DU_TPR_IDLE_SYN		0x20	/* COP */
#define	DU_TPR_IDLE_FLAG	0x20	/* BOP */

#define	DU_TPR_TEOM_ZCNT_DNE	0x10	/* TEOM on zero count or done */

#define	DU_TPR_1STOP		0x70	/* 1 stop bit for 6, 7 or 8 bit chars */
#define	DU_TPR_1STOP5		0x00	/* approx. 1 stop bit for 5 bit chars */
#define	DU_TPR_2STOP		0xf0	/* 2 stop bits for all chars */

#define	DU_TPR_TX_RTS		0x08	/* Tx RTS control */
#define	DU_TPR_TX_CTS		0x04	/* CTS enable Tx */

#define	DU_TPR_TX_5BITS		0x00	/* bits per character for Tx */
#define	DU_TPR_TX_6BITS		0x01
#define	DU_TPR_TX_7BITS		0x02
#define	DU_TPR_TX_8BITS		0x03

/*
 * bit positions for the transmitter timing register (du_ttr).
 */
#define	DU_TTR_XTSRC_RTxC	0x00	/* external source */
#define	DU_TTR_XTSRC_TRxC	0x80

#define	DU_TTR_CLK_1EXT		0x00	/* transmitter clock select */
#define	DU_TTR_CLK_16EXT	0x10
#define	DU_TTR_CLK_DPLL		0x20
#define	DU_TTR_CLK_BRG		0x30
#define	DU_TTR_CLK_2xOTH_CT	0x40
#define	DU_TTR_CLK_32xOTH_CT	0x50
#define	DU_TTR_CLK_2xOWN_CT	0x60
#define	DU_TTR_CLK_32xOWN_CT	0x70

#define	DU_TTR_BRS_MASK		0x0f	/* bit rate select from BRG mask */

/*
 * bit positions for the receiver parameter register (du_rpr).
 */
#define	DU_RPR_SYN_STRIP	0x80	/* SYN strip in COP mode */
#define	DU_RPR_FCS_TO_FIFO	0x40	/* BISYNC and BOP only */
#define	DU_RPR_AUTO_HUNT	0x20	/* BISYNC only */

#define	DU_RPR_OVR_HUNT		0x00	/* BOP overrun mode */
#define	DU_RPR_OVR_CONT		0x20

#define	DU_RPR_RX_RTS		0x10	/* Rx RTS control, ASYNC */
#define	DU_RPR_EXT_SYNC		0x10	/* External Sync, COP */

#define	DU_RPR_STRIP_PRTY	0x08	/* strip parity for 5-7 bit, COP and ASYNC */
#define	DU_RPR_ALL_ADDR		0x08	/* all party address in BOP */

#define	DU_RPR_DCD_ENBL_RX	0x04	/* DCD enables Rx */

#define	DU_RPR_RX_5BITS		0x00	/* receiver character length */
#define	DU_RPR_RX_6BITS		0x01
#define	DU_RPR_RX_7BITS		0x02
#define	DU_RPR_RX_8BITS		0x03

/*
 * Receiver Timing Register (du_rtr)
 */
#define	DU_RTR_XTSRC_RTxC	0x00	/* external source */
#define	DU_RTR_XTSRC_TRxC	0x80

#define	DU_RTR_CLK_1EXT		0x00	/* transmitter clock select */
#define	DU_RTR_CLK_16EXT	0x10
#define	DU_RTR_CLK_BRG		0x20
#define	DU_RTR_CLK_CT		0x30
#define	DU_RTR_CLK_D_64CLK	0x40
#define	DU_RTR_CLK_D_32EXT	0x50
#define	DU_RTR_CLK_D_32BRG	0x60
#define	DU_RTR_CLK_D_32CT	0x70

#define	DU_RTR_BRS_MASK		0x0f	/* bit rate select from BRG mask */

/*
 * Output and Miscellaneous Register (du_omr). Notice that the bits of the
 * residual count are one less than the actual numbe of bits in the residual
 * count.
 */
#define	DU_OMR_TxRES_MASK	0xe0	/* mask of residual count */

#define	DU_OMR_TxRDY_NFULL	0x00	/* TxRDY activate */
#define	DU_OMR_TxRDY_EMPTY	0x10

#define	DU_OMR_RxRDY_NEMPT	0x00	/* RxRDY activate */
#define	DU_OMR_RxRDY_FULL	0x08

#define	DU_OMR_GPOUT2		0x04
#define	DU_OMR_GPOUT1		0x02
#define	DU_OMR_RTS		0x01

/*
 * counter / timer control register (du_ctcr)
 */
#define	DU_CTCR_0_DTCT_ENBL	0x80	/* zero detect interrupt enable */

#define	DU_CTCR_0_DTCT_CONT	0x40	/* zero detect control, preset/cont */
#define	DU_CTCR_0_DTCT_PRESET	0x00

#define	DU_CTCR_OP_SQUARE	0x00	/* output control, square or pulse */
#define	DU_CTCR_OP_PULSE	0x20

#define	DU_CTCR_1_SCALE		0x00	/* prescaler */
#define	DU_CTCR_16_SCALE	0x08
#define	DU_CTCR_32_SCALE	0x10
#define	DU_CTCR_64_SCALE	0x18

#define	DU_CTCR_RTxC		0x00	/* clock source */
#define	DU_CTCR_TRxC		0x01
#define	DU_CTCR_4CLK		0x02
#define	DU_CTCR_4CLK_GTD	0x03
#define	DU_CTCR_RX_BRG		0x04
#define	DU_CTCR_TX_BRG		0x05
#define	DU_CTCR_RX_CHARS	0x06
#define	DU_CTCR_TX_CHARS	0x07

/*
 * Receiver Status Register (du_rsr).
 */
#define	DU_RSR_CNT_CMPR		0x80	/* character count or compare, ASYNC */
#define	DU_RSR_CNT_EOM		0x80	/* char count or EOM, COP,BOP, LOOP */

#define	DU_RSR_RTS_NGTD		0x40	/* RTS negated, ASYNC */
#define	DU_RSR_PAD_ERR		0x40	/* PAD error, COP */
#define	DU_RSR_ABORT		0x40	/* ABORT detected, BOP */
#define	DU_RSR_ABORT_EOP	0x40	/* ABORT or EOP, LOOP */

#define	DU_RSR_OVERRUN		0x20	/* overrun error, all modes */

#define	DU_RSR_SHRT_FRM		0x10	/* short frame, BOP, LOOP */

#define	DU_RSR_BRK_END		0x08	/* break end detect, ASYNC */
#define	DU_RSR_IDLE_DTCT	0x08	/* idle detect, BOP */
#define	DU_RSR_TURNAROUND	0x08	/* turn around detect, LOOP */

#define	DU_RSR_BRK_START	0x04	/* break start, ASYNC */
#define	DU_RSR_SYN_DTCT		0x04	/* sync detect, COP */
#define	DU_RSR_FLAG_DTCT	0x04	/* flag detect, BOP, LOOP */

#define	DU_RSR_FRM_ERR		0x02	/* framing error, ASYNC */
#define	DU_RSR_CRC_ERR		0x02	/* CRC error, COP, BOP, LOOP */

#define	DU_RSR_PRTY_ERR		0x01	/* parity error, ASYNC, COP */
#define	DU_RSR_RCL_NOT0		0x01	/* residual count !0, BOP, LOOP */

/*
 * Transmitter and Receiver Status Register (du_trsr).
 */
#define	DU_TRSR_TX_EMPTY	0x80	/* transmitter empty */

#define	DU_TRSR_CTS_UNDRN	0x40	/* CTS underrun, ASYNC, COP, BOP */
#define	DU_TRSR_LOOP_SND	0x40	/* loop sending, LOOP */

#define	DU_TRSR_FRM_CMPLT	0x20	/* frame complete, COP, BOP, LOOP */

#define	DU_TRSR_SND_BRK_ACK	0x10	/* send break ack., ASYNC */
#define	DU_TRSR_SND_SOM_ACK	0x10	/* send SOM ack., COP */
#define	DU_TRSR_SND_SOM_ABRTACK	0x10	/* send SOM/abort ack., BOP, LOOP */

#define	DU_TRSR_DPLL_ERR	0x08	/* DPLL error, all modes */

#define	DU_TRSR_RX_HUNT		0x02	/* Rx in hunt mode, COP */
#define	DU_TRSR_RX_TRNSPRNT	0x01	/* Rx in transparent mode, COP */

#define	DU_TRSR_RX_RCL_MASK	0x07	/* Rx residual character length, BOP, LOOP */

/*
 * Input and Counter/Timer Status Register (du_ictsr).
 */
#define	DU_ICTS_CT_RUNNG	0x80	/* C/T running */
#define	DU_ICTS_CT_ZERO		0x40	/* C/T zero count */
#define	DU_ICTS_DLTA_DCD	0x20	/* delta (change in) DCD */
#define	DU_ICTS_DLTA_CTS_LC	0x10	/* delta CTS (ASYNC, COP, BOP) or LC (LOOP) */
#define	DU_ICTS_DCD		0x08
#define	DU_ICTS_CTS_LC		0x04
#define	DU_ICTS_GPI2		0x02
#define	DU_ICTS_GPI1		0x01

/*
 * Interrupt Enable Register (du_ier).
 */
#define	DU_IER_DCD_CTS		0x80
#define	DU_IER_TXRDY		0x40
#define	DU_IER_TSR7_3		0x20
#define	DU_IER_RXRDY		0x10
#define	DU_IER_RSR7_6		0x08
#define	DU_IER_RSR5_4		0x04
#define	DU_IER_RSR3_2		0x02
#define	DU_IER_RSR1_0		0x01

/*
 * General Status Register (du_gsr). Note that this register reads the same
 * from both channels.
 */
#define	DU_GSR_B_EXT_C_T	0x80
#define	DU_GSR_B_RX_TX		0x40
#define	DU_GSR_B_TXRDY		0x20
#define	DU_GSR_B_RXRDY		0x10
#define	DU_GSR_A_EXT_C_T	0x08
#define	DU_GSR_A_RX_TX		0x04
#define	DU_GSR_A_TXRDY		0x02
#define	DU_GSR_A_RXRDY		0x01

/*
 * Interrupt Control Register (du_icr).
 */
#define	DU_ICR_PRI_A		0x00	/* channel A/B interrupt priority */
#define	DU_ICR_PRI_B		0x40
#define	DU_ICR_INTLV_A		0x80
#define	DU_ICR_INTLV_B		0xc0

#define	DU_ICR_VCTR0		0x00	/* vector mode */
#define	DU_ICR_VCTR1		0x10
#define	DU_ICR_VCTR2		0x20
#define	DU_ICR_NOT_VCTRD	0x30

#define	DU_ICR_MDFY_2_0		0x00	/* bits to modify in the vector */
#define	DU_ICR_MDFY_4_2		0x08

#define	DU_ICR_VIS		0x04	/* vector includes status */
#define	DU_ICR_A_INT_ENBL	0x02	/* channel A master interrupt enable */
#define	DU_ICR_B_INT_ENBL	0x01	/* channel B master interrupt enable */

/*
 * Channel Command Register (du_ccr).
 */
#define	DU_CCR_RST_TX		0x00	/* reset Tx */
#define	DU_CCR_RST_TX_CRC	0x01	/* reset Tx CRC */
#define	DU_CCR_ENBL_TX		0x02	/* enable Tx */
#define	DU_CCR_DISABL_TX	0x03	/* disable Tx */
#define	DU_CCR_TX_SOM		0x04	/* transmit SOM */
#define	DU_CCR_TX_SOM_PAD	0x05	/* transmit SOM with PAD */
#define	DU_CCR_TX_EOM		0x06	/* transmit EOM */
#define	DU_CCR_TX_ABRT_BRK	0x07	/* transmit ABORT or BREAK */
#define	DU_CCR_TX_DLE		0x08	/* transmit DLE */
#define	DU_CCR_ACTV_ON_POLL	0x09	/* go active on poll */
#define	DU_CCR_RST_ACTV_POLL	0x0a	/* reset go active on poll */
#define	DU_CCR_ON_LOOP		0x0b	/* go on-loop */
#define	DU_CCR_OFF_LOOP		0x0c	/* go off-loop */
#define	DU_CCR_EXCLD_CRC	0x0d	/* exclude from CRC */

#define	DU_CCR_RST_RX		0x40	/* reset Rx */
#define	DU_CCR_ENBL_RX		0x42	/* enable Rx */
#define	DU_CCR_DISABL_RX	0x43	/* disable Rx */

#define	DU_CCR_CT_START		0x80	/* start counter/timer */
#define	DU_CCR_CT_STOP		0x81	/* stop counter/timer */
#define	DU_CCR_CT_FFFF		0x82	/* preset counter/timer to 0xffff */
#define	DU_CCR_CT_PRST		0x83	/* preset counter/timer from counter/tiomer preset registers */

#define	DU_CCR_DPLL_SEARCH	0xc0	/* enter DPLL search mode */
#define	DU_CCR_DISABL_DPLL	0xc1	/* disable DPLL */
#define	DU_CCR_DPLL_FM		0xc2	/* set DPLL FM mode */
#define	DU_CCR_DPLL_NRZI	0xc3	/* set DPLL NRZI mode */
