/*
 * Signetics 2698 Duart device registers.
 */
#define	NSIO		8
#define NBLOCKS		4
#define NCPB		(NSIO/NBLOCKS)		/* number of chans per block */

#ifndef LOCORE
struct siochan {
	u_char	chan_mr12;
	u_char	chan_sr_csr;
	u_char	chan_cr;
	u_char	chan_rhr_thr;
};

/*
 * S2698 block registers
 */
struct sioblock {
	struct siochan	blk_chana;
	u_char		blk_ipcr_acr;
	u_char		blk_isr_imr;
	u_char		blk_ctu;
	u_char		blk_ctl;
	struct siochan	blk_chanb;
	u_char		blk_dummy;
	u_char		blk_ipr_opcr;
	u_char		blk_ct_go;
	u_char		blk_ct_stop;
};

struct s2698device {
	struct sioblock s2698_block[NBLOCKS];
};

#endif LOCORE

/* 		chan_mr1 mode register definitions: */
#define	MR1_RX_RTS_YES		0x80
#define	MR1_RX_INT_FULL		0x40
#define	MR1_ERR_BMODE		0x20
#define	MR1_PAR_MULTIDRP	0x18
#define	MR1_PAR_NONE		0x10
#define	MR1_PAR_FORCE		0x08
#define	MR1_PAR_WITH		0x00
#define	MR1_PAR_ODD		0x04
#define	MR1_PAR_EVEN		0x00
#define	MR1_8_BIT		0x03
#define	MR1_7_BIT		0x02
#define	MR1_6_BIT		0x01
#define	MR1_5_BIT		0x00

/*		chan_mr2 mode register definitions: */
#define	MR2_CM_NORM		0x00
#define	MR2_CM_AUTOECHO		0x40
#define	MR2_CM_L_LOOP		0x80
#define	MR2_CM_R_LOOP		0xC0
#define	MR2_TX_RTS		0x20
#define	MR2_TX_CTS		0x10
#define	MR2_1_STOP		0x07
#define	MR2_15_STOP		0x08
#define	MR2_2_STOP		0x0F

/*		chan_sr_csr status register definitions: */
#define	SR_RCVED_BRK		0x80
#define	SR_FRAME_ERR		0x40
#define	SR_PARITY_ERR		0x20
#define	SR_OVERRUN_ERR		0x10
#define	SR_ERROR		\
		(SR_RCVED_BRK|SR_FRAME_ERR|SR_PARITY_ERR|SR_OVERRUN_ERR)
#define	SR_TXEMT		0x08
#define	SR_TXRDY		0x04
#define	SR_FFULL		0x02
#define	SR_RXRDY		0x01

/*		chan_sr_csr status register definitions: */
#define	CSR_RX_CLK		0xf0
#define	CSR_TX_CLK		0x0f

/*		chan_cr command register definitions: */
#define	CR_CMD_RST_MR		0x10
#define	CR_CMD_RST_RX		0x20
#define	CR_CMD_RST_TX		0x30
#define	CR_CMD_RST_ERR		0x40
#define	CR_CMD_RST_BRK		0x50
#define	CR_CMD_START_BRK	0x60
#define	CR_CMD_STOP_BRK		0x70
#define	CR_CMD_RTSN_ASSERT	0x80
#define	CR_CMD_RTSN_NEGATE	0x90
#define	CR_DISABLE_TX		0x08
#define	CR_ENABLE_TX		0x04
#define	CR_DISABLE_RX		0x02
#define	CR_ENABLE_RX		0x01

/*		s2698_ipcr_acr Aux control register definitions: */
#define	ACR_MPI0A_INT		0x01
#define	ACR_MPI1A_INT		0x02
#define	ACR_MPI0B_INT		0x04
#define	ACR_MPI1B_INT		0x08
#define	ACR_CNTR_MPI		0x00
#define	ACR_CNTR_MPI_DIV_16	0x10
#define	ACR_CNTR_TXC		0x20
#define	ACR_CNTR_CLK_DIV_16	0x30
#define	ACR_TIMER_MPI		0x40
#define	ACR_TIMER_MPI_DIV_16	0x50
#define	ACR_TIMER_CLK		0x60
#define	ACR_TIMER_CLK_DIV_16	0x70
#define	ACR_BRGS		0x80

/*		s2698_isr_imr interrupt status register definitions: */
#define	ISR_MPI_PORT_CHANGE	0x80
#define	ISR_CHANB_RCV_BRK	0x40
#define	ISR_CHANB_RXRDY		0x20
#define	ISR_CHANB_TXRDY		0x10
#define	ISR_CNTR_READY		0x08
#define	ISR_CHANA_RCV_BRK	0x04
#define	ISR_CHANA_RXRDY		0x02
#define	ISR_CHANA_TXRDY		0x01

/*		s2698_isr_imr interrupt mask register definitions: */
#define	IMR_MPI_PORT_CHANGE	0x80
#define	IMR_CHANB_RCV_BRK	0x40
#define	IMR_CHANB_RXRDY		0x20
#define	IMR_CHANB_TXRDY		0x10
#define	IMR_CNTR_READY		0x08
#define	IMR_CHANA_RCV_BRK	0x04
#define	IMR_CHANA_RXRDY		0x02
#define	IMR_CHANA_TXRDY		0x01

/*		s2698_ipr_opcr output control register definitions: */
#define	OPCR_MOPB_RTSN		0x00
#define	OPCR_MOPB_CTO		0x10
#define	OPCR_MOPB_TXC		0x20
#define	OPCR_MOPB_TXC_16X	0x30
#define	OPCR_MOPB_RXC		0x40
#define	OPCR_MOPB_RXC_16X	0x50
#define	OPCR_MOPB_TXRDY		0x60
#define	OPCR_MOPB_RXRDY		0x70
#define	OPCR_POWER_DOWN_ON	0x08
#define	OPCR_MOPA_RTSN		0x00
#define	OPCR_MOPA_CTO		0x01
#define	OPCR_MOPA_TXC		0x02
#define	OPCR_MOPA_TXC_16X	0x03
#define	OPCR_MOPA_RXC		0x04
#define	OPCR_MOPA_RXC_16X	0x05
#define	OPCR_MOPA_TXRDY		0x06
#define	OPCR_MOPA_RXRDY		0x07

/* 
 * IPR configuration
 */
#define CHANADCD		0x01	/* MPI0a -> DCD for channel a */
#define CHANBDCD		0x04	/* MPI0b -> DCD for channel b */

/*
 * IPCR defines
 */
#define IPCR_DELTA_MPI0A	0x10	/* MPI0a -> DCD for channel a */
#define IPCR_DELTA_MPI0B	0x40	/* MPI0b -> DCD for channel b */


#define CLOCKPERIOD (((3686400/60)/2))  /* 60 HZ */
#define RTCOUNTER	0		/* counter 0 -> real time clock */
#define CLKCOUNTER	1		/* counter 1 -> clock counter */
#define CMCOUNTER	2		/* counter 2 -> cache miss counter */
#define CHCOUNTER	3		/* counter 3 -> cache hit counter */


/* offsets for assembly progs */
#define	MR1_A		0x00
#define	MR2_A		0x00
#define	CSR_A		0x01
#define	SR_A		0x01
#define	CR_A		0x02
#define	THR_A		0x03
#define	RHR_A		0x03
#define	ACR_A		0x04
#define	IMR		0x05
#define	MR1_B		0x08
#define	MR2_B		0x08
#define	CSR_B		0x09
#define	SR_B		0x09
#define	CR_B		0x0A
#define	THR_B		0x0B
#define	RHR_B		0x0B
#define	IPR_0		0x0D
#define	IPR_1		0x1D
#define	IPR_2		0x2D
#define	IPR_3		0x3D
#define	OPCR_0		0x0D
#define	OPCR_1		0x1D
#define	OPCR_2		0x2D
#define	OPCR_3		0x3D
