/* GENERIC SCSI DEFINITIONS */

union	scsi_cdb {		/* SCSI command block */
    struct    cdb_0 {		    /* COMMAND GROUP 0 */
/* 0*/	u_char	cdb_0_cmd;		/* command code */
#define		  CMD_TESTREADY	0x00	/*   test unit ready */
#define		  CMD_REZERO	0x01	/*   rezero unit */
#define		  CMD_SENSE	0x03	/*   request sense */
#define		  CMD_FORMAT	0x04	/*   format unit */
#define		  CMD_BLKLIM	0x05	/*   read block limits */
#define		  CMD_REASSIGN	0x07	/*   re-assign blocks */
#define		  CMD_READ 	0x08	/*   read data */
#define		  CMD_WRITE	0x0A	/*   write data */
#define		  CMD_SEEK 	0x0B	/*   seek */
#define		  CMD_FILEMARK 	0x10	/*   write file mark */
#define		  CMD_SPACE 	0x11	/*   space */
#define		  CMD_INQUIRY	0x12	/*   inquiry */
#define		  CMD_MSELECT	0x15	/*   mode select */
#define		  CMD_RESERVE	0x16	/*   reserve */
#define		  CMD_RELEASE	0x17	/*   release */
#define		  CMD_ERASE	0x19	/*   erase tape */
#define		  CMD_S_DIAG	0x1C	/*   send diagnostic */
#define		  CMD_R_DIAG	0x1D	/*   receive diagnostic rslt */
#define		  CMD_MSENSE	0x1A	/*   mode sense */
#define		  CMD_STARTSTOP	0x1B	/*   start/stop unit */
#define		  CMD_PREVENT	0x1E	/*   prevent medium release */
#define		  CMD_LOADCART	0xCF	/*   load/unload cartridge */
/* 1*/	u_char	cdb_0_lun	: 3;	/* logical unit number */
	u_char	cdb_0_lba_h	: 5;	/* high part of address */
/* 2*/	u_char	cdb_0_lba_m;		/* middle part of address */
/* 3*/	u_char	cdb_0_lba_l;		/* low part of address */
/* 4*/	u_char	cdb_0_len;		/* block count */
/* 5*/	u_char			: 6;	/* reserved */
	u_char  cdb_0_fr	: 1;	/* flag request */
	u_char  cdb_0_link	: 1;	/* link */
    }		cdb_0;
#define	SET_CDB_0(cdb, cmd, lun, lba, len, fr, link)		{	\
		bzero(cdb, sizeof (struct cdb_0));			\
		(cdb)->cdb_0.cdb_0_cmd = cmd;				\
		(cdb)->cdb_0.cdb_0_lun = lun;				\
		SCSI_HML_SET((cdb)->cdb_0.cdb_0_lba, lba);		\
		(cdb)->cdb_0.cdb_0_len = len;				\
		(cdb)->cdb_0.cdb_0_fr = fr;				\
		(cdb)->cdb_0.cdb_0_link = link;			}
    struct    cdb_1 {		    /* COMMAND GROUP 1 */
/* 0*/	u_char	cdb_1_cmd;		/* command code */
#define		  CMD_RCAPAC	0x25	/*   read capacity */
#define		  CMD_XREAD	0x28	/*   extended read data */
#define		  CMD_XWRITE	0x2A	/*   extended write data */
#define		  CMD_XSEEK	0x2B	/*   extended seek */
#define		  CMD_VERIFY	0x2F	/*   verify data */
#define		  CMD_RDDEFECT	0x37	/*   read defect list */
/* 1*/	u_char	cdb_1_lun	: 3;	/* logical unit number */
	u_char			: 4;	/* reserved */
	u_char	cdb_1_reladr	: 1;	/* relative address */
/* 2*/	u_int	cdb_1_lba;		/* (4 bytes) logical block address */
/* 6*/	u_char			: 8;	/* reserved */
/* 7*/	u_char	cdb_1_len_h;		/* length (high) */
/* 8*/	u_char	cdb_1_len_l;		/* length (low) */
/* 9*/	u_char			: 6;	/* reserved */
	u_char  cdb_1_fr	: 1;	/* flag request */
	u_char  cdb_1_link	: 1;	/* link */
    }		cdb_1;
#define	SET_CDB_1(cdb, cmd, lun, reladr, lba, len, fr, link)	{	\
		bzero(cdb, sizeof (struct cdb_1));			\
		(cdb)->cdb_1.cdb_1_cmd = cmd;				\
		(cdb)->cdb_1.cdb_1_lun = lun;				\
		(cdb)->cdb_1.cdb_1_reladr = reladr;			\
		(cdb)->cdb_1.cdb_1_lba = lba;				\
		SCSI_HL_SET((cdb)->cdb_1.cdb_1_len, len);		\
		(cdb)->cdb_1.cdb_1_fr = fr;				\
		(cdb)->cdb_1.cdb_1_link = link;			}
    struct    cdb_7 {		    /* COMMAND GROUP 7 */
/* 0*/	u_char	cdb_7_cmd;		/* command code */
#define		CMD_RESET	0xF0	/*   ISI reset device or ctlr */
#define		CMD_INIT 	0xF1	/*   ISI reinit controller */
#define		CMD_STATUS	0xF2	/*   ISI return status */
#define		CMD_VERSION	0xF3	/*   ISI return firmware vers */
#define		CMD_DUMPREG	0xF4	/*   ISI dump reg states */
/* 1*/	u_char			: 6;	/* reserved */
	u_char  cdb_7_fr	: 1;	/* flag request */
	u_char  cdb_7_link	: 1;	/* link */
    };
    u_char	cdb_raw[16];		/* pad to 16 bytes for gsreg.h */
};

/* defines for scsi completion status byte */
#define	SCSI_STATUS_PARITY	0x01
#define	SCSI_STATUS_CHECK	0x02
#define	SCSI_STATUS_CM		0x04
#define	SCSI_STATUS_BUSY	0x08
#define	SCSI_STATUS_INTER	0x10
#define	SCSI_STATUS_BITS	"\20\5INTER\4BUSY\3CM\2CHECK\1PARITY"

union	scsi_sns {		/* data returned by CMD_SENSE */
	struct sns_06 {		/* non-extended sense data format */
	    u_char sns_06_lbav	: 1;	/* logical block is valid */
	    u_char sns_06_class	: 3;	/* error class (0-6) */
	    u_char sns_06_code	: 4;	/* error code */
	    u_char sns_06_lba_h;	/* high logical block address */
	    u_char sns_06_lba_m;	/* middle logical block address */
	    u_char sns_06_lba_l;	/* low logical block address */
	}	sns_06;
	struct sns_7 {		/* extended sense data format */
/* 0*/	    u_char sns_7_valid	: 1;	/* sense data is valid */
	    u_char sns_7_class	: 3;	/* error class (7) */
	    u_char 		: 4;	/* not used */
/* 1*/	    u_char sns_7_seg_num;	/* segment number */
/* 2*/	    u_char sns_7_fil_mk	: 1;	/* file mark on device */
	    u_char sns_7_eom	: 1;	/* end of media */
	    u_char sns_7_ili	: 1;	/* incorrect length indicator */
	    u_char	 	: 1;	/* reserved */
	    u_char sns_7_key	: 4;	/* sense key */
#define		SNS_7_KEY_NO_SENSE	0x0
#define		SNS_7_KEY_RECOVERED	0x1
#define		SNS_7_KEY_NOT_READY	0x2
#define		SNS_7_KEY_MEDIUM_ERROR	0x3
#define		SNS_7_KEY_HW_ERROR	0x4
#define		SNS_7_KEY_ILL_REQUEST	0x5
#define		SNS_7_KEY_UNIT_ATTN	0x6
#define		SNS_7_KEY_DATA_PROTECT	0x7
#define		SNS_7_KEY_BLANK_CHECK	0x8
#define		SNS_7_KEY_VU		0x9
#define		SNS_7_KEY_COPY_ABORTED	0xa
#define		SNS_7_KEY_ABORT_CMD	0xb
#define		SNS_7_KEY_EQUAL		0xc
#define		SNS_7_KEY_VOL_OVERFLOW	0xd
#define		SNS_7_KEY_MISCOMPARE	0xe
#define		SNS_7_KEY_RESERVED	0xf
/* 3*/	    u_char sns_7_info_h;	/* information */
/* 4*/	    u_char sns_7_info_mh;	/* information */
/* 5*/	    u_char sns_7_info_ml;	/* information */
/* 6*/	    u_char sns_7_info_l;	/* information */
/* 7*/	    u_char sns_7_add_len;	/* number of additional bytes */
/* 8*/	    u_char sns_7_xxx[4];	/* reserverd for copy search cmd */
/*12*/	    u_char sns_7_err;		/* extended sense error codes */
#define		SNS_7_ERR_
	}	sns_7;
};

struct	scsi_inq {		/* data returned by CMD_INQUIRY */
/* 0*/	u_char	inq_pdtype;		/* Peripheral Device Type */
#define		  INQ_PDT_DISK	0x00	/*   Direct-access device */
#define		  INQ_PDT_TAPE	0x01	/*   Sequential-access device */
#define		  INQ_PDT_PRINT	0x02	/*   Printer device */
#define		  INQ_PDT_PROC	0x03	/*   Processor device */
#define		  INQ_PDT_WORM	0x04	/*   Write-once read-multiple device */
#define		  INQ_PDT_RO	0x04	/*   Read only device */
#define		  INQ_PDT_RAT	0x10	/*   Random Access Tape device */
#define		  INQ_PDT_NOLUN	0x7f	/*   Logical unit not present */
/* 1*/	u_char	inq_removable	: 1;	/* removable */
	u_char	inq_dtypeq	: 7;	/* device type qualifier */
/* 2*/	u_char	inq_isov	: 2;	/* ISO version */
	u_char	inq_emcav	: 3;	/* EMCA version */
	u_char	inq_ansiiv	: 3;	/* ANSII version */
/* 3*/	u_char	inq_rdf;		/* response data format */
/* 4*/	u_char	inq_addlen;		/* additional length */
/* 5*/	u_char	inq_vu[3];		/* pad vender unique data */
/* 8*/	u_char	inq_vendor[8];		/* vendor name ASCII */
/*16*/	u_char	inq_product[16];	/* vendor product name ASCII */
/*32*/	u_char	inq_rev[4];		/* vendor product revision ASCII */
};

struct	blk_desc {		/* block descriptor: CMD_MSENSE, CMD_MSELECT */
	u_char	bd_density;	/*   block descriptor density */
	u_char	bd_nb_h;	/*   high number of blocks */
	u_char	bd_nb_m;	/*   mid number of blocks */
	u_char	bd_nb_l;	/*   low number of blocks */
	u_char		: 8;	/*   reserved */
	u_char	bd_bl_h;	/*   high block length */
	u_char	bd_bl_m;	/*   mid block length */
	u_char	bd_bl_l;	/*   low block length */
};

struct	pag_desc {		/* page descriptor: CMD_MSENSE, CMD_MSELECT */
    u_char	pd_save		: 1;	/*   parameter savable */
    u_char			: 1;	/*   reserved */
    u_char	pd_code		: 6;	/*   page code */
#define		  PD_ERROR	0x01	/*	Error Recovery Parameters */
#define		  PD_DISRE	0x02	/*	Disconnect Reconnect Params */
#define		  PD_FORMAT	0x03	/*	Format Parameters Parameters */
#define		  PD_GEOMETRY	0x04	/*	Drive Geometry Parameters */
#define		  PD_ALL	0x3F	/*	All Pages */
    u_char	pd_len;			/*   page length */
    union	pd_pg {
	struct pg_err {			/*   ERROR PAGE */
	    u_char	err_awre	: 1;	/* auto write reallocation */
	    u_char	err_arre	: 1;	/* auto read reallocation */
	    u_char	err_tb		: 1;	/* transfer block on error */
	    u_char	err_rc		: 1;	/* read continuous */
	    u_char	err_ecc		: 1;	/* enable early correction */
	    u_char	err_per		: 1;	/* post errors (report soft)*/  
	    u_char	err_dte		: 1;	/* disable transfer on error */
	    u_char	err_dcr		: 1;	/* disable correction */
	    u_char	err_retries;		/* retry count */
	    u_char	err_cspan;		/* correction span */
	    u_char	err_hoffset;		/* head offset */
	    u_char	err_dsoffset;		/* data strobe offset */
	    u_char	err_tlimit;		/* recovery time limit */
	}	pg_err;
	struct pg_dis {			/*   DISCONNECT RECONNECT PAGE */
	    u_char	dis_bfulr;		/* buffer full ratio */
	    u_char	dis_beulr;		/* buffer empty ratio */
	    u_short	dis_bil;		/* bus inactivity limit */
	    u_short	dis_distime;		/* disconnect time limit */
	    u_short	dis_retime;		/* reconnect time limit */
	    u_short	dis_xxx;		/* reserved */
	}	pg_dis;
	struct pg_fmt {			/*   FORMAT PAGE */
	    u_short	fmt_tpz;		/* tracks/zone */
	    u_short	fmt_alt_spz;		/* alternate sectors/zone */
	    u_short	fmt_alt_tpz;		/* alternate tracks/zone */
	    u_short	fmt_alt_tpv;		/* alternate tracks/volume */
	    u_short	fmt_spt;		/* sectors/track */
	    u_short	fmt_bps;		/* bytes/sector */
	    u_short	fmt_interleave;		/* interleave factor */
	    u_short	fmt_t_skew;		/* track skew factor */
	    u_short	fmt_c_skew;		/* cylinder skew factor */
	    u_char	fmt_ssec	: 1;	/* soft sector formatting */
	    u_char	fmt_hsec	: 1;	/* hard sector formatting */
	    u_char	fmt_rmb		: 1;	/* removable */
	    u_char	fmt_surf	: 1;	/* surface lba allocation */
	    u_char	fmt_ins		: 1;	/* inhibit save */
	    u_char			: 3;
	}	pg_fmt;
	struct	pd_geo {		/*   GEOMETRY PAGE */
	    u_char	geo_cyl_h;		/* number of cylinders */
	    u_char	geo_cyl_m;
	    u_char	geo_cyl_l;
	    u_char	geo_heads;		/* number of heads */
	    u_char	geo_cyl_wp_h;		/* start write precomp cyl */
	    u_char	geo_cyl_wp_m;
	    u_char	geo_cyl_wp_l;
	    u_char	geo_cyl_rw_h;		/* start reduced write cyl */
	    u_char	geo_cyl_rw_m;
	    u_char	geo_cyl_rw_l;
	    u_short	geo_step_rate;		/* step rate */
	    u_char	geo_cyl_ld_h;		/* landing zone cylinder */
	    u_char	geo_cyl_ld_m;
	    u_char	geo_cyl_ld_l;
	    u_char	geo_rsvd[3];
	}	pg_geo;
    }	pd_pg;
};

struct	scsi_msen {		/* data returned by CMD_MSENSE */
	u_char	msen_len;		/* sense data length */
	u_char	msen_mtype;		/* medium type */
	u_char	msen_wprot	: 1;	/* write protected if 1 */
	u_char	msen_rsvd	: 7;	/* reserved */
	u_char	msen_bdl;		/* block descriptor length */
	struct	blk_desc msen_bd;	/* block descriptor */
	struct	pag_desc msen_pd;	/* page descriptor */
};

struct	scsi_msel {		/* data returned by CMD_MSELECT */
	u_char			: 8;	/* reserved */
	u_char	msel_mtype;		/* medium type */
	u_char			: 8;	/* reserved */
	u_char	msel_bdl;		/* block descriptor length */
	struct	blk_desc msel_bd;	/* block descriptor */
	struct	pag_desc msel_pd;	/* page descriptor */
};

struct	scsi_rcap {		/* data returned by CMD_RCAPAC */
	u_int	rcap_lba;		/* logical block address */
	u_int	rcap_bl;		/* block length */
};

struct	scsi_blklim {		/* data returned by CMD_BLKLIM */
	u_long	blklim_max;
	u_short	blklim_min;
};

/* pick up (set) 2 byte "_h _l" field in (from) an int */
#define	SCSI_HL(x)		((x/**/_h<<8)|(x/**/_l))
#define	SCSI_HL_SET(x, v)	{ x/**/_h=v>>8; x/**/_l=v;}

/* pick up (set) 3 byte "_h _m _l" field in (from) an int */
#define	SCSI_HML(x)		((x/**/_h<<16)|(x/**/_m<<8)|(x/**/_l))
#define	SCSI_HML_SET(x, v)	{ x/**/_h=v>>16; x/**/_m=v>>8; x/**/_l=v;}

/* pick up (set) 4 byte "_h _mh _ml _l" field in (from) an int */
#define	SCSI_HMML(x)		\
		    ((x/**/_h<<24)|(x/**/_mh<<16)|(x/**/_ml<<8)|(x/**/_l))
#define	SCSI_HMML_SET(x, v)	\
		    { x/**/_h=v>>24; x/**/_mh=v>>16; x/**/_ml=v>>8; x/**/_l=v;}

#ifdef	ASCII_SNS_7_KEY
char	*ascii_sns_7_key[] = {
		"NO SENSE", "RECOVERED", "NOT READY", "MEDIUM ERROR",
		"HARDWARE ERROR", "ILLEGAL REQUEST", "UNIT ATTENTION",
		"DATA PROTECT", "BLANK CHECK", "VENDOR UNIQUE", "COPY ABORTED",
		"ABORT COMMAND", "EQUAL", "VOLUME OVERFLOW", "MISCOMPARE",
		"RESERVED",
};
#else	ASCII_SNS_7_KEY
extern char	*ascii_sns_7_key[];
#endif	ASCII_SNS_7_KEY
#ifdef	ASCII_PDTYPE
char	*ascii_pdtype[] = {
		"DISK", "TAPE", "PRINTER", "PROCESSOR", "WORM"
};
#else	ASCII_PDTYPE
extern char	*ascii_pdtype[];
#endif	ASCII_PDTYPE
