/*
 $Header: screg.h,v 1.2 88/10/19 17:05:19 root Exp $
 */
/*
 * from exosreg.h
 */

/* 
	Changes:
	22.05.87 ws: define EXOSINIO
	22.07.87 ws: comments
	07.08.87 ws: NO debug-level
*/

#include "/usr/sys/h/ioctl.h"

/* #define	DEBUG_LEVEL	0	 delete this line and no debug code */
				/* will be generated.		      */

#ifdef	DEBUG_LEVEL

int	exos_debug = DEBUG_LEVEL;

#define	DEBUG0(l, t)		{if (exos_debug >= l) printf(t);}
#define	DEBUG1(l, t, a1)	{if (exos_debug >= l) printf(t, a1);}
#define	DEBUG2(l, t, a1, a2)	{if (exos_debug >= l) printf(t, a1, a2);}
#define	DEBUG3(l, t, a1, a2, a3){if (exos_debug >= l) printf(t, a1, a2, a3);}

#else	DEBUG_LEVEL

#define	DEBUG0(l, t)		/* no debug */
#define	DEBUG1(l, t, a1)	/* no debug */
#define	DEBUG2(l, t, a1, a2)	/* no debug */
#define	DEBUG3(l, t, a1, a2, a3)/* no debug */

#endif	DEBUG_LEVEL

#define	MAXTRANSFER	280	/* max length of a message  */

#define EXOS_DEFTIMO    50	/* default timeout in ticks */
				/* (60ticks ~ 1 second) */
				/* don't make it too small !!! */
				/* cf. comment in sccmd of sc.c !!!*/

#ifdef	ETIMEDOUT		/* which error should timout return? */
#define	EXOS_TIMEOUT	ETIMEDOUT
#else
#define	EXOS_TIMEOUT	EIO
#endif	ETIMEDOUT

/*
 * commands we give to the EXOS board via Port B
 */
#define	EXOS_INIT	0 	   /* busy transfer of buffer address */
#define	EXOS_OPEN	1          /* information about open system call */
#define	EXOS_CLOSE	2          /* information about close system call */
#define	EXOS_READ	3          /* xfer from board to unix */
#define	EXOS_WRITE	4          /* xfer from unix to board */
#define	EXOS_IOCTL	5          /* some kind of ioctl call */

/*
 * registers of the EXOS board
 */
struct exosdevice
{
	char	pad_a;
	char 	port_a;
	char	pad_b;
	char	port_b;
};
/* status bits (port B) */
#define	EXOS_STATUS	0x01	/* status of the board */
#define	EXOS_BUSY	0x08	/* port B not yet read by exos-software */


/*  
 * commands for the ioctl routine 
 */
#define IOEXOS_STIMO 	0000000 	/* set timeout */
#define IOEXOS_LOAD 	0000000  	/* downloading of software */
#define IOEXOS_PUT  	0000000  	/* set parameters on the board */
#define IOEXOS_GET  	_IOR(x,0,char)	/* see ioctl.h, get status byte */
#define IOEXOS_INIT 	0000001  	/* give INIT and buf ptr to board */
#define	IOEXOS_JINT	0000002		/* interrupt prom loader telling it
					   ok to jump to MBP's code */

#define FROM_EXOS 1      /* some kind of read */
#define TO_EXOS   2      /* some kind of write */
#define EXCHANGE  3	 /* read after write */

struct exos_lioctl
{
	int	code;
	u_short	dlen;
	u_short dir;
};


struct exos_lioctl exos_lioctl[] =
{
	{ IOEXOS_STIMO,  sizeof(short),	TO_EXOS	  },
	{ IOEXOS_LOAD,	256,		TO_EXOS   },
	{ IOEXOS_PUT,	256,		TO_EXOS	  },
	{ 0,       	0,		0         },
};

struct exos_softc
{
	short		   exos_state;	/* internal state of driver */
	caddr_t		   exos_tcount;	/* number of active timeout */
	long		   exos_timeout;/* timeout for interrupt in 1/50 sec */
	caddr_t		  exos_buf;	/* address of transfer buffer */
	caddr_t		  exos_vdma;	/* vdma address of transfer buffer */
	struct exosdevice *exos_addr;	/* pointer to Port A / Port B */
} exos_softc;

/*
 * definitions for exos_state field
 */
#define ISOPEN   0x01
#define ACTIVE   0x02
#define TIMEOUT  0x04
#define EXOSINIO 0x08

/*
 * definations for the status byte (from the IOEXOS_GET ioctl call)
 * set by the PROM loader
 */
#define	GOOD_STAT	0	/* only 2 low order bits */
#define	BAD_CS		1	/* bad checksum */
#define	BAD_TYPE	2	/* invalid type sent to PROM loader */
#define BAD_CMD		3	/* bad command (INIT, OPEN, & WRITE are legal) */
#define NOT_GOOD	3	/* one of the low 2 bits are set */
#define RED_LED		4	/* 0 = ON */
#define	INT_PENDING	8
