/*
 $Header: sc.c,v 1.2 89/04/07 12:00:35 root Exp $
 */
#include	"sc.h"
#if NSC > 0 || Nsc > 0

/*
 * Driver for the
 * Front-End Processor the DISOSS Process
 *
 * Authors: Klaus Eckhoff, Ralf Nolting
 * Version 0.1
 * Date:   85/11/18

 12.05.1987 ws: change BUSY_WAIT as in telefax from NBI of 11.5.1987
 22.05.1987 ws: use untimeout in sccmd, check for ACTIVE in sctimer
 22.05.1987 ws: wait for result in sccmd & scioctl!
 30.07.1987 ws: 1) buffer will no longer cross a 64K border
		2) simultaneous read / write implemented
		3) read will try several times
 07.08.1987 ws: scprobe changed so that it returns 0 immediately when the
		board does not react to EXOS_INIT
 18.08.1987 ws: scprobe with one return only
		scioctl changed (wait longer, spl4 earlier)
 15.09.1987 ws: correct call of verminderen in scread

*/


#include	"../machine/pte.h"
#include	"param.h"
#include	"systm.h"
#include	"buf.h"
#include	"dir.h"
#include	"conf.h"
#include	"user.h"
#include	"file.h"
#include	"map.h"
#include	"vm.h"
#include	"ioctl.h"
#include	"cmap.h"
#include	"uio.h"
#include	"kernel.h"

#include	"../is68kdev/qbvar.h"
#include	"../machine/board.h"
#include	"../is68kdev/screg.h"
#include	"../is68kdev/xc.h"


/* 
 * Driver VMEbus interface routines
 */
int	scprobe(), scslave(), scattach(), scintr(), sctimer();
int	scrtim();

struct qb_ctlr		*exoscinfo[NSC];
struct qb_device	*exosdinfo[NSC];

extern u_short		*SCstd[];

struct qb_driver SCdriver =
{
	scprobe,
	scslave,
	scattach,
	0,
	SCstd, 
	"sc",
	exosdinfo,
	"SC",
	exoscinfo
};

BOOLEAN	cardlock;	/* locks the card against concurrent read/write */
			/*   and exos_softc.exos_buf, too		*/
int	scdelay;	/* for sleeping in scread only */

#ifndef	EXOS_TRANSFERBUF
char	exos_transferbuf[MAXTRANSFER+MAXTRANSFER];
#else
 You should never do that! ws, 16.7.87
#endif


#define	BUSY_WAIT(sec, bed)	{ long i,j; \
		for (i = 0; i < (sec) && !(bed); ++i) \
			for (j = 0; j < 250000 && !(bed); ++j) \
				; }

/*
 * scprobe:
 * Determine if there is an EXOS board at the specified address.
 * Must cause an interrupt to allow the auto configuration software
 * to find the interrupt vector
 */
scprobe(exosaddr)
register struct exosdevice *exosaddr;
{
	caddr_t		ct2;
	int		maske, hi1, hi2;
	int		ret_value;

	cardlock	= FALSE;	/* init semaphore */

	DEBUG1(9, "scprobe(%lx)\n", exosaddr);
	exos_softc.exos_addr = exosaddr;
	exos_softc.exos_timeout = EXOS_DEFTIMO;
	exos_softc.exos_state = 0;
#ifdef	EXOS_TRANSFERBUF
	exos_softc.exos_buf	= EXOS_TRANSFERBUF;
#else
	exos_softc.exos_buf	= (caddr_t) exos_transferbuf;
#endif	EXOS_TRANSFERBUF

	/* align so that buffer doesn't cross a 64k border	*/
	/*  (this is a software kludge to a hardware kludge):	*/

	ct2	= exos_softc.exos_buf + MAXTRANSFER;
	maske	= (~(0xFFFF));
	hi1	= ((int) exos_softc.exos_buf)	& maske;
	hi2	= ((int) ct2)			& maske;
	If hi1 NE hi2 Then
	   exos_softc.exos_buf	= ct2;
	Fi;
	exos_softc.exos_vdma = 
		(caddr_t)(IOPB_STD(iopballoc(exos_softc.exos_buf,MAXTRANSFER),vbnum));
	exos_softc.exos_buf = (caddr_t)(CACHE_INHIBIT(exos_softc.exos_buf));
	DEBUG1
	(
		3, 
		"\n---> scprobe(): addr of transferbuffer = %lx <---\n", 
		exos_softc.exos_buf
	);

#ifdef	EXOS_SOFTRESET
	exos_softc.exos_addr->port_a = 1;
	BUSY_WAIT(10, exos_softc.exos_addr->port_b & EXOS_STATUS);
#endif	EXOS_SOFTRESET

	DEBUG0(5, "scprobe(): EXOS_INIT\n");
	exos_softc.exos_addr->port_b = EXOS_INIT;
	BUSY_WAIT(30, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);
	If (exos_softc.exos_addr->port_b & EXOS_BUSY) Then
	   ret_value	= 0;
	Else
	   DEBUG0(5, "scprobe(): Bits 0-7\n");
	   exos_softc.exos_addr->port_b = (long) exos_softc.exos_vdma & 0xFF;
	   BUSY_WAIT(30, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);

	   DEBUG0(5, "scprobe(): Bits 8-15\n");
	   exos_softc.exos_addr->port_b = 
				((long) exos_softc.exos_vdma >> 8) & 0xFF;
	   BUSY_WAIT(30, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);
   
	   DEBUG0(5, "scprobe(): Bits 16-21\n");
	   exos_softc.exos_addr->port_b = 
				((long) exos_softc.exos_vdma >> 16) & 0xFF;
	   BUSY_WAIT(30, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);

	   BUSY_WAIT(10, FALSE);
	   ret_value	= (sizeof(struct exosdevice));
	Fi;
	return(ret_value);
}



/*
 * scslave:
 * We support only one board per driver, check for qi_slave == 0
 */

scslave(qi, reg)
struct qb_device	*qi;
caddr_t			reg;
{
	DEBUG2(9, "scslave(%lx, %lx)\n", qi, reg);
	if (qi->qi_slave != 0)
		return (0);
	return (1);
}


/*
 * scattach
 */

scattach(qi)
struct qb_device	*qi;
{
	DEBUG1(9, "scattach(%lx)\n", qi);
	return (1);
}


/*
 * scopen:
 * open the device
 * DON'T check exclusive access
 */

scopen(dev, flag)
dev_t	dev;
int	flag;
{
	register int			exosunit;
	register struct qb_device	*qi;
	register struct exos_softc	*sc;

	DEBUG2(9, "scopen(%x, %d)\n", dev, flag);
	exosunit = minor(dev);
	if ( exosunit >= NSC ||
	    (qi = exosdinfo[exosunit]) == 0 ||
	    qi->qi_alive == 0) {
		return (ENXIO);
	}

	If exos_softc.exos_state & ISOPEN Then
		return(0);
	Else
		exos_softc.exos_state = ISOPEN;
		If sccmd(EXOS_OPEN) == 0 Then
			return (0);
		Else
			exos_softc.exos_state = 0;
			return (EXOS_TIMEOUT);
		Fi;
	Fi;
}

/*
 * scclose: close the device
 */
scclose(dev, flag)
register dev_t	dev;
register int	flag;
{
	DEBUG2(9, "scclose(%x, %d)\n", dev, flag);
	exos_softc.exos_state = 0;
	sccmd(EXOS_CLOSE);
	return (0);
}

/*
 * sccmd:
 * issue a command on port B
 * wait for completion of command
 *          or timeout after specified period (in ticks of the clock)
 * return   0 if command was completed via interrupt, i.e. without an error
 *         -1 if a timeout occured
 */
sccmd(cmd)
register short int cmd;
{
	int	s, timout;

	DEBUG1(8, "sccmd(%d)\n", cmd);
	DEBUG1(9, "sccmd: timeout(%d)\n", exos_softc.exos_timeout);
	If cmd NE EXOS_WRITE Then
	   proeven();			/* P(card && buffer) */
	Fi;				/* otherwise done before */
	s = spl4();
	/* No need to lockout clock because exos_timeout seems big enough, ws */
	timeout(sctimer, (caddr_t) exos_softc.exos_tcount,
		exos_softc.exos_timeout);
	exos_softc.exos_state |= (ACTIVE | EXOSINIO);
	exos_softc.exos_addr->port_b = cmd;
	while( (exos_softc.exos_state & EXOSINIO) != 0)
	   sleep((caddr_t) &exos_softc.exos_state, PRIBIO);
/*
 * wakeup will occur either through sctimer() or through scintr()
 */
	timout = (exos_softc.exos_state & TIMEOUT ? -1 : 0);
   	if( timout == 0 )
	  untimeout(sctimer, (caddr_t) exos_softc.exos_tcount);
	++exos_softc.exos_tcount;
	exos_softc.exos_state &= ~ACTIVE;
	splx(s);
	If cmd NE EXOS_READ Then
	   verminderen();			/* V(card && buffer) */
	Fi;					/* otherwise done later */
	DEBUG0(9, "sccmd: return from sleep()\n");
	return(timout);
}

/*
 * sctimer:
 * check if the current timeout has been reached
 * (or any other from former actions)
 * and wakeup sleeping process, if this is the case
 */
sctimer(tcount)
caddr_t tcount;
{
	DEBUG1(8, "sctimer(%lx)\n", tcount);
	if (tcount == exos_softc.exos_tcount)
	{
	  if ( (exos_softc.exos_state & EXOSINIO) == 0){
		printf("SC %lx: unexpected timer\n", tcount);
	  }else{
		exos_softc.exos_state |= TIMEOUT;
		exos_softc.exos_state &= ~(EXOSINIO);
		DEBUG0(9, "sctimer: TIMEOUT -> wakeup()\n");
		wakeup((caddr_t) &exos_softc.exos_state);
	  };
	};
}

/*
 * scintr:
 * check if we were expecting an interrupt
 * wakeup sleeping process
 */
scintr(ctlr)
int	ctlr;
{
	DEBUG1(8, "scintr(%d)\n", ctlr);
	if ( (exos_softc.exos_state & EXOSINIO) == 0)
		printf("SC %d: unexpected interrupt\n", ctlr);
	else
	{
		DEBUG0(9, "scintr: wakeup()\n");
		exos_softc.exos_state &= ~(EXOSINIO);
		wakeup((caddr_t) &exos_softc.exos_state);
	}
}

/*
 * scread: read system call
 *
 * The hardware will not tolerate unsolicited I/O from the comm. card
 * (at least when ISS & card interrupt simultaneously). Therefore I must use
 * a polling technique with sleeping during read. This is just another 
 * example of the beauty of 7/8-duplex interfaces. Here, again:
 * Kludge to a kludge.
 * "So hilft uns denn in allen Lebensdingen
 *  der edle Ritter ...			    "
 */

#define	MAXDELAY 15
			/* wait at most 1+2+4+8 ticks in read	*/
			/* i.e 0.25 seconds			*/
scread(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct iovec	*iov = uio->uio_iov;
	register int		l1, l2, lenrd;
	BOOLEAN			erfolg;
	int			len, s;

	DEBUG2(9, "scread(%x, %lx)\n", dev, uio);
	if (exos_softc.exos_state & TIMEOUT)
		return (EXOS_TIMEOUT);

	while (uio->uio_iovcnt > 0)
	{
		if 
		(
			(len = iov->iov_len) > MAXTRANSFER
			||
			useracc
			(
				iov->iov_base, 
				(u_int) len, 
				B_WRITE
			) == NULL
		)
			return(EFAULT);

		erfolg		= FALSE;
		scdelay	= 0;	/* 0 <==> first attempt to READ */
		While NOT (erfolg OR (scdelay GT MAXDELAY)) Do
		   If scdelay GT 0 Then	/* NOT first time in loop */
			verminderen();
			/* AFTER the first time, V(card && buffer) here. */
			s	= spl7();	/* must lockout clock here   */
			/* to avoid (timeout, clock schedules other process, */
			/*  wakeup by timeout, ... schedule this process and */
			/*  sleep indefinitely) !!!	     		     */
			timeout(scrtim, (caddr_t) &scdelay, scdelay);
			sleep((caddr_t) &scdelay, PRIBIO);
			splx(s);
			scdelay	= (scdelay << 1);
		   Else			/* first time in loop*/
			scdelay	= 1;
		   Fi;

		   If sccmd(EXOS_READ) < 0 Then
			verminderen();		/* V(card && buffer) */
			return (EXOS_TIMEOUT);
		   Fi;
		   erfolg = (((exos_softc.exos_buf)[4]) & 0x0FF) NE 0x20;
				/* A1 tested against null message */
		Od;
		l1 	= ((((exos_softc.exos_buf)[1]) << 8) & 0x0FF00) ;
		l2	= ( ((exos_softc.exos_buf)[0])       & 0x000FF) ;
		lenrd	= l1 + l2 + 2;
		If lenrd LE len Then	/* len LE MAXTRANSFER checked above */
		   len	= lenrd;
		Fi;

		DEBUG3(	9,
			"scread(): copout(%lx, %lx, %d)\n",
			exos_softc.exos_buf,
			iov->iov_base,
			len
		);

		copyout(exos_softc.exos_buf, iov->iov_base, len);
		verminderen();			/* V(card && buffer) */
		uio->uio_resid -= len;
		uio->uio_offset += len;
		uio->uio_iov++;
		uio->uio_iovcnt--;
	}
	return (0);
}



/*
 * scrtim: timer for wakeup after sleeping in read 
 */
scrtim(what)
caddr_t		what;
{
wakeup(what);
}

/*
 * scwrite: write system call
 */
scwrite(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct iovec	*iov = uio->uio_iov;
	register int		len;

	DEBUG2(9, "scwrite(%x, %lx)\n", dev, uio);
	if (exos_softc.exos_state & TIMEOUT)
	{	
		DEBUG0(0, "scwrite - TIMEOUT #1\n");
		return (EXOS_TIMEOUT);
	}

	while (uio->uio_iovcnt > 0)
	{
		if 
		(
			(len = iov->iov_len) > MAXTRANSFER
			||
			useracc
			(
				iov->iov_base, 
				(u_int) len, 
				B_READ
			) == NULL
		)
		{
			DEBUG0(0, "scwrite - EFAULT\n");
			return (EFAULT);
		}

		DEBUG3
		(
			9,
			"scwrite(): copyin(%lx, %lx, %d)\n",
			iov->iov_base,
			exos_softc.exos_buf,
			len
		);
		proeven();		/* P(card && buffer) */
		copyin(iov->iov_base, exos_softc.exos_buf, len);

		if (sccmd(EXOS_WRITE) < 0)
		{	
			DEBUG0(0, "scwrite - TIMEOUT #2\n");
			return (EXOS_TIMEOUT);
		}

		uio->uio_resid -= len;
		uio->uio_offset += len;
		uio->uio_iov++;
		uio->uio_iovcnt--;
	}
	return (0);
}

/*
 * scioctl:
 * transfer data according to lioctl-table
 */
scioctl(dev, cmd, data, flag)
dev_t	dev;
int	cmd;
caddr_t	data;
int	flag;
{
   register struct exos_lioctl	*op;
   int				s, timout, ret_value;
   long				orig_timeout;

   DEBUG2(9, "scioctl(%d, %lx)\n", cmd, data);

   Case cmd In
   When(IOEXOS_GET)		 	/* read status byte from board */
         *data = exos_softc.exos_addr->port_b;
         DEBUG2(9, "scioctl, cmd, *data =(%d, %lx)\n", cmd, *data);
         ret_value	= 0;

   Bwhen(IOEXOS_JINT)			/* interrupt board (ok to jump to code) */
         DEBUG0(5, "scioctl: IOEXOS_JINT\n");
         exos_softc.exos_addr->port_b = EXOS_INIT;
         ret_value	= 0;

   Bwhen(IOEXOS_INIT)			/* give init cmd and buf ptr */
         DEBUG0(5, "scioctl: writing EXOS_INIT\n");
	 BUSY_WAIT(3, FALSE);
         exos_softc.exos_addr->port_b = EXOS_INIT;
         BUSY_WAIT(10, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);
      
         DEBUG0(5, "scioctl: writing Bits 0-7\n");
         exos_softc.exos_addr->port_b = (long) exos_softc.exos_vdma & 0xFF;
         BUSY_WAIT(10, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);
      
         DEBUG0(5, "scioctl: writing Bits 8-15\n");
         exos_softc.exos_addr->port_b = ((long) exos_softc.exos_vdma >> 8) & 0xFF;
         BUSY_WAIT(10, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);

         DEBUG0(5, "scioctl: writing Bits 16-21\n");
         s = spl4();
         exos_softc.exos_addr->port_b = ((long) exos_softc.exos_vdma >> 16) & 0xFF;
         BUSY_WAIT(10, (exos_softc.exos_addr->port_b & EXOS_BUSY) == 0);

         /*
          *  wait for interrupt from the now running mbp code
          */
   
	 orig_timeout = exos_softc.exos_timeout;  /* save timeout */
	 exos_softc.exos_timeout = 1000;

         DEBUG1(5, "scioctl: timeout(%d)\n", exos_softc.exos_timeout);
         timeout(sctimer, (caddr_t) exos_softc.exos_tcount, 
		exos_softc.exos_timeout);
	 exos_softc.exos_state |= (ACTIVE | EXOSINIO);
	 while( (exos_softc.exos_state & EXOSINIO) != 0)
	   sleep((caddr_t) &exos_softc.exos_state, PRIBIO);
         /*
          * wakeup will occur either through sctimer() or through scintr()
          */
	 timout = (exos_softc.exos_state & TIMEOUT ? -1 : 0);
   	 if( timout == 0 )
	  untimeout(sctimer, (caddr_t) exos_softc.exos_tcount);
         ++exos_softc.exos_tcount;
	 exos_softc.exos_state &= ~ACTIVE;
         splx(s);
         DEBUG0(5, "scioctl: return from sleep()\n");
	 exos_softc.exos_timeout = orig_timeout;  /* restore timeout */
         ret_value	= timout;

   Others
	 ret_value	= ENXIO;
   Esac;
   return(ret_value);
}

/*
 *	proeven / verminderen (from dutch test/try / decrement/diminish):
 *	P / V operation for semaphore cardlock (copyright EWD at THE)
 *
 *	Known Fact(s):
 *	 1) process scheduling takes place even when a process is in
 *	    the driver (i.e. in Supervisor state): => must use spl7.
 *	    This may be different under other versions of 4.2 BSD, 
 *	    and then spl7/splx are no longer needed.
 *	Assumptions:
 *	 1) Wakeup will 'gracefully do nothing'. This seems correct as
 *	    checked by inspecting sys/kern_synch.c 6.1 83/07/29 of 4.2BSD.
 *
 *	The semaphore protects both card I/O AND the exos_softc.exos_buf !!!
 *	Therefore P is used in scwrite and sccmd 
 *	      and V is used in sccmd   and scread !!!
 */

proeven()	/* P operation for semaphore cardlock */
{
	int	s;

	s		= spl7();	/* do not disturb */
	If cardlock Then
		sleep((caddr_t) &cardlock, PRIBIO);
	Fi;
	cardlock	= TRUE;
	splx(s);
}


verminderen()	/* V operation for semaphore cardlock */
{
	int	s;

	s		= spl7();	/* do not disturb */
	cardlock	= FALSE;
	wakeup((caddr_t) &cardlock);
	splx(s);
}

#endif	NSC > 0
