/* Hardware Ports:
 *	The Rimfire 3200 is seen as a 512 byte area in the 16 bit
 *	address space.  There are four registers in this space,
 *	each on an 8 byte boundary.  The registers are defined below.
 */
struct rfdevice {
	u_short	rf_abp;			/* Address Buffer Port (write only)*/
#define	rf_abp_ctlam	rf_abp		/*   1st write (control, addr mod)*/
#define		ABP_CTLAM_SET	0x8000	/*     apply controls to command */
#define		ABP_CTLAM_WID	0x0400	/*     data width, 0=16, 1=32 bit */
#define		ABP_CTLAM_WSW	0x0200	/*     word swap, 0=no swap, 1=swap */
#define		ABP_CTLAM_BSW	0x0100	/*     byte swap, 0=no swap, 1=swap */
#define	rf_abp_pb_msb	rf_abp		/*   2nd write (address of pb) */
#define	rf_abp_pb_lsb	rf_abp		/*   3rd write (address of pb) */
	u_char	rf_pad_0[6];
	u_short	rf_atn;			/* Channel Attention Port (write only)*/
#define		ATN_TYPE0	0
	u_char	rf_pad_1[6];		/*   write command list # (0-7) */
	u_short	rf_status;		/* Board Status Port (read only) */
#define		STATUS_BSY	0x0001	/*   board is busy */
#define		STATUS_RDY	0x0002	/*   board is ready (initialized) */
#define		STATUS_MERR	0x0010	/*   parameter block memofy error */
#define		STATUS_MERR_MSK	0x00E0	/*   attention port with error */
#define		STATUS_EMASK	0x00FC	/*   mask for diagnostic error field */
#define		STATUS_ESHFT	2	/*   shift for diagnostic error field */
#define		STATUS_EBITS	\
"\20\10CATTN\7CHAN\6FIFO\5DSEQ\4SRAM\3DRAM\2CSUM\1PROCESSOR"
#define		STATUS_BMASK	0xFF00	/*   board id mask */
#define		STATUS_B3200	0x0000	/*   Rimfire 3200 Controller */
#define		STATUS_B3400	0x0100	/*   Rimfire 3400 Controller */
	u_char	rf_pad_2[6];
	u_short	rf_reset;		/* Controller Reset Port (write only) */
#define		RF_RESET	1
};

struct rf_pb {				/* Generic Parameter Block */
    u_int		pb_id;			/* unique command identifier */
    u_char		pb_addrmod;		/* AM to VME memory */
#define	PB_ADDRMOD_STD			0x39	/*   Standard Normal Data */
#define	PB_ADDRMOD_EXT			0x09	/*   Extended Normal Data */
    u_char		pb_unit;		/* unit */
#define	PB_UNIT_NODISK			0x00	/*   Non-disk command */
#define	PB_UNIT(x)			((x&0x7)+1)
    u_char		pb_control;		/* I/O control group */
#define	PB_CONTROL_IOCG_MASK		0x0f
#define	PB_CONTROL_IOCG_0		0
#define	PB_CONTROL_IOCG_1		1
    u_char		pb_command;		/* command to execute */
						/* 33 Support    */
 						/* 24            */
 						/* 00            */
 						/* 00 DEFINITION */
#define	PB_COMMAND_SETUPCL		0x01	/* xx setup command list */
#define	PB_COMMAND_STOPCL		0x02	/* xx stop command list */
#define	PB_COMMAND_IDENT		0x05	/* xx identify */
#define	PB_COMMAND_STATS		0x06	/* xx board statistics */
#define	PB_COMMAND_GOPT			0x07	/* xx general options */
#define	PB_COMMAND_SETIOCG		0x08	/* xx init IO control group */
#define	PB_COMMAND_DIAG			0x09	/* xx board selftest */
#define	PB_COMMAND_SETCONF		0x10	/* xx configure disk */
#define	PB_COMMAND_SETDPARAM		0x11	/* xx define disk params */
#define	PB_COMMAND_GETCONFIG		0x12	/* xx return disk config */
#define	PB_COMMAND_INTERROGATE		0x13	/* x  interrogate SMD disk */
#define	PB_COMMAND_GESDICONF		0x13	/*  x return ESDI config */
#define	PB_COMMAND_TAGSTATUS		0x14	/* x  do tag/return status */
#define	PB_COMMAND_VSTATUS		0x14	/*  x return vendor status */
#define	PB_COMMAND_SERIALCMD		0x17	/*  x issue ESDI serial */
#define	PB_COMMAND_READ			0x18	/* xx read */
#define	PB_COMMAND_WRITE		0x19	/* xx write */
#define	PB_COMMAND_SREAD		0x1A	/* xx scatter read */
#define	PB_COMMAND_GWRITE		0x1B	/* xx gather write */
#define	PB_COMMAND_FORMAT		0x20	/* xx format tracks */
#define	PB_COMMAND_VERIFY		0x21	/* xx verify */
#define	PB_COMMAND_SLIPSEC		0x22	/* xx slip sector */
#define	PB_COMMAND_MAPSEC		0x23	/* xx map sector */
#define	PB_COMMAND_MAPTRACK		0x24	/* xx map track */
#define	PB_COMMAND_RDEFECT		0x25	/* xx read defect data */
#define	PB_COMMAND_IGNOREID		0x28	/* x  ignore id read data */
#define	PB_COMMAND_READLONG		0x29	/* xx read long */
#define	PB_COMMAND_WRITELONG		0x2A	/* xx write long */
#define	PB_COMMAND_READID		0x2B	/* xx read a single id */
#define	PB_COMMAND_READTID		0x2C	/* xx read a track of id's */
#define	PB_COMMAND_REZERO		0x2D	/* xx rezero */
#define	PB_COMMAND_SEEK			0x2E	/* xx perform a seek */
#define	PB_COMMAND_START		0x30	/*  x start spindle motor */
#define	PB_COMMAND_STOP			0x31	/*  x stop spindle motor */
#define	PB_COMMAND_WRITEMAP		0x38	/* xx write defect map */
#define	PB_COMMAND_READMAP		0x39	/* xx read defect map */
#define	PB_SET(pb, command, unit, control, id)			{\
		bzero((caddr_t)(pb), sizeof(struct rf_pb));	\
		(pb)->pb_command	= command;		\
		(pb)->pb_control	= control;		\
		(pb)->pb_unit		= unit;			\
		(pb)->pb_id		= id;			}
    union pb {
	struct pb_std {			/* Standard Command */
	    u_int	std_daddr;		/* starting sector # */
	    u_int	std_vmeaddr;		/* VME address to read/write */
	    u_char	std_pad_0[2];
	    u_short	std_blkcnt;		/* # of blocks to read/write */
	}		pb_std;
	struct pb_setup {		/* 0x01: Setup Command */
	    u_char	setup_pad_0[2];
	    u_short	setup_dint;		/* done interrupt */
	    struct rf_clst *setup_clst;		/* command list start address */
	    u_char	setup_pad_1[3];
	    u_char	setup_list;		/* command list # (1-7) */
	}		pb_setup;
	struct pb_stop {		/* 0x02: Stop Command */
	    u_char	stop_pad_0[11];
	    u_char	stop_list;		/* command list # (1-7) */
	}		pb_stop;
	struct pb_stat {		/* 0x06: Board Statistics */
	    u_char	stat_pad_0[4];
	    struct rf_stats *stat_stats;	/* where to put stat data */
	    u_char	stat_pad_1[3];
	    u_char	stat_clear;		/* clear statistics != 0 */
	}		pb_stat;
	struct pb_gopt {		/* 0x07: General Options */
#define	    gopt_throttle	pb_addrmod	/* KLUDGE */
#define		GOPT_THROTTLE	8		/* 32 bytes- size of bus fifo */
	    u_short	gopt_sbintr;		/* status block interrupts */
#define		GOPT_SB_WDL	0x01		/*   3200: Write Data Loaded */
#define		GOPT_SB_DTE	0x02		/*   Retries and Corrections */
#define		GOPT_SB_IDE	0x04		/*   ID/interface errors */
#define		GOPT_SB_VST	0x10		/*   3400: vendor status */
	    u_short	gopt_sbenable;		/* status block enables */
	    u_char	gopt_pad_0[8];
	}		pb_gopt;
	struct pb_iocg {		/* 0x08: Initialize IOCG */
	    u_short	iocg_cache;		/* cache control */
#define		IOCG_CACHE_SEA		0x0001	/*   search cache */
#define		IOCG_CACHE_CRD		0x0002	/*   save read data in cache */
#define		IOCG_CACHE_RAP		0x0004	/*   read ahead priority */
#define		IOCG_CACHE_CWT		0x0008	/*   save write data in cache */
#define		IOCG_CACHE_SRD		0x0010	/*   sort reads */
#define		IOCG_CACHE_SWT		0x0020	/*   sort writes */
#define		IOCG_CACHE_ZLI		0x0080	/*   inhibit zero latency */
#define		IOCG_CACHE_XHD		0x0100	/*   read ahead across head */
#define		IOCG_CACHE_XCY		0x0200	/*   read ahead across cyl */
#define		IOCG_CACHE_BITS 	\
			"\20\12XCY\11XHD\10ZLI\6SWT\5SRD\4CWT\3RAP\2CRD\1SEA"
	    u_char	iocg_rahead;		/* read ahead */
	    u_char	iocg_rcvry;		/* recovery */
#define		IOCG_RCVRY_IGE		0x01	/*   ignore ECC */
#define		IOCG_RCVRY_COR		0x02	/*   disable error correction */
#define		IOCG_RCVRY_EXT		0x04	/*   apply trk/data separator */
#define		IOCG_RCVRY_BITS		"\20\3EXT\2COR\1IGE"
	    u_char	iocg_pad_0[2];
	    u_char	iocg_dretry;		/* maximum data retries */
	    u_char	iocg_ndretry;		/* maximum non-data retries */
	    u_char	iocg_pad_1[4];
	}		pb_iocg;
	struct pb_confd {		/* 0x10: Configure Disk */
	    u_short	confd_nbps;		/* bytes per sector */
	    u_short	confd_ncyl;		/* cylinders per disk */
	    u_char	confd_nspares;		/* # of spare sectors per trk */
	    u_char	confd_nspt;		/* sectors per track */
	    u_char	confd_nhead;		/* heads per cylinder */
	    u_char	confd_shead;		/* 3200: 1st head for volume */
	    u_char	confd_pad_0[3];		/* reserved */
	    u_char	confd_flags;		/* 3200: drive info */
#define		CONFD_FLAGS_SSP		0x01	/*   short sector present */
#define		CONFD_FLAGS_EAD		0x02	/*   1 => SMD-E interface */
#define		CONFD_FLAGS_MSK		0x03
#define		CONFD_FLAGS_BITS	"\20\2SMDE\1SSP"
	}		pb_confd;
	struct pb_dparam {		/* 0x11: Define Disk Parameters */
	    u_char	dparam_intlv;		/* interleave factor to use */
	    u_char	dparam_hdskew;		/* head skew to use */
	    u_char	dparam_cyskew;		/* cylinder skew to use */
	    u_char	dparam_hgskew;		/* 3400: Head group skew */
	    u_short	dparam_rcvry;		/* 3200: data recovery */
#define		DPARAM_RCVRY_DBV	0x03ff	/*   Data bus value */
#define		DPARAM_RCVRY_TAG	(4<<12)	/*   tag # (1 to 6) */
	    u_char	dparam_gap1;		/* 3200: ID preamble length */
	    u_char	dparam_gap2;		/* 3200: data preamble length */
	    u_char	dparam_pad_0[4];
	}		pb_dparam;
	struct pb_itrs {		/* 0x14: Tag/Return Status (3200) */
	    u_char	itrs_pad_0[2];
	    u_short	itrs_data;		/* data to send */
	    u_char	itrs_pad_1[2];
	    u_short	itrs_tag;		/* tag # */
	    u_char	itrs_pad_2[4];
	}		pb_itrs;
	struct pb_fmtv {		/* 0x20,0x21: Format and Verify */
	    u_int	fmtv_sector;		/* starting sector # */
	    u_char	fmtv_pad_0[4];
	    u_int	fmtv_nsector;		/* # of blocks */
	}		pb_fmtv;
	struct pb_smap {		/* 0x22-0x24: Slip/Map Sector/Trk */
	    u_int	smap_baditem;		/* bad track or sector */
	    u_int	smap_alternate;		/* alternate track or sector */
	    u_char	smap_pad_0[2];		/* reserved */
	    u_short	smap_rcvry;		/* recover data in error? */
#define		SMAP_RECOVER_NO		0x00	/*   no */
#define		SMAP_RECOVER_NOTERR	0x01	/*   if no error */
#define		SMAP_RECOVER_ONERR	0x01	/*   with error */
	}		pb_smap;
    }	pb;
};

union rf_sb {			/* Status Block */
    struct sb {
	u_int	sb_id;			/* command identifier */
	u_short	sb_dstatus;		/* drive error information */
#define		SB_DSTATUS_BITS_3200	\
"\20\20SEC\17IND\16ADM\15WRP\14DRF\13SER\12ONC\11RDY\5WRP\4FLT\3SER\2ONC\1RDY"
#define		SB_DSTATUS_BITS_3400	\
"\20\17RMNP\16RMWP\15WPFM\12STOPED\11PRESET\10CPARITY\7IFAULT\6CFAULT\5SFAULT\4WGATE\3VUSTAT\2WFAULT\1CMEDIA"
	u_char	sb_error;		/* errr/retry/status condition code */
#define	SB_ERROR_ID(e)			\
((e==0x25)|(e==0x26)|(e==0x29)|(e==0x2A)|(e==0x2B)|(e==0x2C))
#define	SB_ERROR_SOFT(e)	((e==0x24))
	u_char	sb_flag;		/* type of status block and results */
#define		SB_FLAG_CC	0x80	/*   Command complete, last block */
#define		SB_FLAG_ERR	0x40	/*   Error, check error code */
#define		SB_FLAG_RTY	0x20	/*   Retry required */
#define		SB_FLAG_COR	0x10	/*   Correction required */
#define		SB_FLAG_CON	0x04	/*   3400: Continuation status block */
#define		SB_FLAG_BITS	"\20\10CC\7ERR\6RETRY\5CORR\3CON"
	u_int	sb_daddr;		/* disk address of errr/retry/status */
#define		SB_ERRDATA_UNDEF -1	/*   undefined */
    }		sb;
    struct sb_ident { 		/* 0x05: Identify */
	u_int	ident_id;		/* identifier */
	u_char	ident_fwrev;		/* firmware revision level */
	u_char	ident_engrev;		/* Engineering revision level */
	u_char	ident_error;		/* error code */
	u_char	ident_status;		/* status */
	u_char	ident_flags;		/* configuration of board */
#define 	  IDNDRIV 0x01		/*   3200: 1 = 4-drive , 0 = 2-drive */
	u_char	ident_day;		/* day the firmware was generated */
	u_char	ident_month;		/* month the firmware was generated */
	u_char	ident_year;		/* year the firmware was generated */
    }		sb_ident;
    struct sb_itrs {
	u_int	itrs_id;		/* identifier */
	u_char	itrs_pad_0[2];
	u_char	itrs_error;		/* error code */
	u_char	itrs_status;		/* status */
	u_char	itrs_pad_1[3];
	u_char	itrs_data;		/* drive data */
    }		sb_itrs;
};

/* Extended (type-0 channel attention) Parameter Block */
struct rf_xpb {
	struct rf_pb	xpb_pb;		/* standard parameter block */
#define	XPB_SET(xpb, command, unit, control, id)		{\
		bzero((caddr_t)(xpb), sizeof(struct rf_xpb));	\
		(xpb)->xpb_pb.pb_command	= command;	\
		(xpb)->xpb_pb.pb_control	= control;	\
		(xpb)->xpb_pb.pb_unit		= unit;		\
		(xpb)->xpb_pb.pb_id		= id;		}
	u_char		xpb_pad_0[2];
	u_short		xpb_dint;	/* done interrupt */
#define	DINT_LEV_SHFT		8
#define	DINT_SID_MSK		0x00FF
	u_char		xpb_pad_1[4];
	union rf_sb	xpb_sb;		/* status block */
};


/* Command list */
#define NPBMASK	0x3f		/* mask for valid parameter block index */
#define	NSBMASK	0x7f		/* mask for valid status block index */
struct rf_clst {
	u_int		clst_pbin;	/* parameter block in pointer */
	u_int		clst_pbout;	/* parameter block out pointer */
	u_int		clst_sbin;	/* status block in pointer */
	u_int		clst_sbout;	/* status block out pointer */
	u_int		clst_pbsize;	/* paramter block area size */
	u_int		clst_sbsize;	/* status block area size */
	u_int		clst_resv1;
	u_int		resv2;
#define	RF32NPB	0x40				/* Max. # of parameter blocks */
	struct rf_pb	clst_pb[RF32NPB];	/* parameter blocks */
#define	RF32NSB	0x80				/* Max. # of status blocks */
	union rf_sb	clst_sb[RF32NSB];	/* status blocks */
};

/* Statistics Data Block */
struct rf_stats {
	u_int	stats_commands;		/* total # of commands */
	u_int	stats_reads;		/* # of disk reads */
	u_int	stats_diskrd;		/* sectors read from disk */
	u_int	stats_cacherd;		/* sectors read from cache */
	u_int	stats_writes;		/* # of disk writes */
	u_int	stats_diskwr;		/* sectors written to disk */
	struct 	rf_stats_d {		/* per drive stats */
	    u_short	d_seek;		/* drive n: # seek errors */
	    u_short	d_iferr;	/* drive n: # interface errors */
	    u_short	d_ecccor;	/* drive n: # ecc corrections */
	    u_short	d_nonecc;	/* drive n: # non-ecc data errors */
	    u_short	d_altseek;	/* drive n: # alternate seeks */
	    u_short	d_corfail;	/* drive n: # ecc correction failures */
	}	stats_d[4];
};

/* Return Drive Configuration Data Block */
struct rf_dconf {
	u_short	dconf_bytsec;		/* bytes per sector */
	u_short	dconf_cyldsk;		/* cylinders per disk */
	u_char	dconf_nspares;		/* # of spare sectors per track */
	u_char	dconf_sectrk;		/* sectors per track */
	u_char	dconf_headcyl;		/* heads per cylinder */
	u_char	dconf_bhead;		/* head offset for this volume */
	u_char	dconf_zero1[3];		/* zeros */
	u_char	dconf_flags;		/* 3200: as in configure */
	u_int	dconf_secdsk;		/* # of logical sectors per disk */
	u_char	dconf_intlv;		/* interleave factor */
	u_char	dconf_hdskew;		/* head skew factor */
	u_char	dconf_cyskew;		/* cylinder skew factor */
	u_char	dconf_hgskew;		/* 3400: Head group skew */
	u_short	dconf_rcvry;		/* 3200: data recovery */
	u_char	dconf_idpre;		/* 3200: id preamble length */
	u_char	dconf_datapre;		/* 3200 data preamble length */
	u_int	dconf_zero3;		/* zero */
	u_int	dconf_zero4;		/* zero */
};

/* Return Configuration of ESDI drive Data Block */
struct rf_esdiconf {
	u_short	esdiconf_gc;		/* general configuration */
#define		ESDICONF_GC_TAPE	0x8000	/* Tape drive */
#define 	ESDICONF_GC_TOLGAP	0x4000	/* Format speed gap req */
#define 	ESDICONF_GC_TRKOFF	0x2000	/* Track offset option avail */
#define 	ESDICONF_GC_DATAOFF	0x1000	/* Data strobe offset avail */
#define 	ESDICONF_GC_SPEEDTOL	0x0800	/* RPM speed tolerance > 0.5% */
#define 	ESDICONF_GC_XFER10	0x0400	/* Transfer > 10MHz */
#define 	ESDICONF_GC_XFER510	0x0200	/* Transfer > 5MHz, <= 10MHz */
#define 	ESDICONF_GC_XFER5	0x0100	/* Transfer <= 5MHz */
#define 	ESDICONF_GC_REMOV	0x0080	/* Removable cartridge drive */
#define 	ESDICONF_GC_FIXED	0x0040	/* Fixed drive */
#define 	ESDICONF_GC_MOTORCTL	0x0020	/* Spindle motor control ok */
#define 	ESDICONF_GC_HDSWLONG	0x0010	/* Head switch time > 15 uS */
#define 	ESDICONF_GC_RLL		0x0008	/* RLL encoded (not MFM) */
#define 	ESDICONF_GC_CTLSOFT	0x0004	/* Controller soft-sectored */
#define 	ESDICONF_GC_DRVHARD	0x0002	/* Drive hard-sectored */
#define 	ESDICONF_GC_CTLHARD	0x0001	/* Controller hard-sectored */
	u_short	esdiconf_fixcyl; 	/* # of fixed cylinders */
	u_short	esdiconf_remcyl;	/* # of removable cylinders */
	u_char	esdiconf_remhead;	/* # of removable heads */
	u_char	esdiconf_fixhead;	/* # of fixed heads */
	u_short	esdiconf_minbytrk;	/* min unformatted bytes per track */
	u_short	esdiconf_bytesec;	/* unformatted bytes per sector */
	u_char	esdiconf_resv0;		/* reserved */
	u_char	esdiconf_sectrk;	/* sectors per track */
	u_char	esdiconf_isgbyte;	/* isg bytes after index */
	u_char 	esdiconf_minisg;	/* minimum isg bytes */
	u_char	esdiconf_spare;		/* spare */
	u_char	esdiconf_plosync;	/* bytes in plo sync */
	u_short	esdiconf_nwords;	/* # of words of vendor-unique status */
	u_short	esdiconf_resv[5];	/* reserved */
	u_char	esdiconf_vendid;	/* vendor id */
	u_char	esdiconf_vendmodel;	/* vendor model */
	u_short	esdiconf_statbits;	/* general drive status bits */
#define		ESDICONF_DS_NOREMOV	0x4000	/* non-removable media */
#define 	ESDICONF_DS_WPREM	0x2000	/* Write prot, removable */
#define 	ESDICONF_DS_WPFIX	0x1000	/* Write prot, fixed */
#define 	ESDICONF_DS_SPINDWN	0x0200	/* Spindle motor stopped */
#define 	ESDICONF_DS_POR		0x0100	/* Power on reset exist */
#define 	ESDICONF_DS_CMDPARITY	0x0080	/* Command data parity fault */
#define 	ESDICONF_DS_INTFLT	0x0040	/* Interface fault */
#define 	ESDICONF_DS_INVCMD	0x0020	/* Invalid/unimp cmd fault */
#define 	ESDICONF_DS_SEEKFLT	0x0010	/* Seek fault */
#define 	ESDICONF_DS_TOFLT	0x0008	/* Write gate fault */
#define 	ESDICONF_DS_STATAVAIL	0x0004	/* Vendor-unique status avail */
#define 	ESDICONF_DS_WRTFLT	0x0002	/* Write fault */
#define 	ESDICONF_DS_MEDIACHG	0x0001	/* Removable media changed */
	u_short	esdiconf_resv1;		/* reserved */
};


/* Structure for the scatter/gather descriptor entry */
struct rf_scat {
    struct rf_scat	*scat_next;
    struct scat_desc {
	u_char		desc_addrmod;
	u_char		desc_lenh;
	u_short		desc_len;
	u_int		desc_vmeaddr;
    }			scat_desc[8];
};

/* SMD disk manfacturer defect structure */
struct rf_smd_defect {
	u_char	smd_defect_zero1;	/* zero */
	u_char	smd_defect_x19;		/* Constant (0x19) */
	u_short	smd_defect_cylinder;	/* cylinder # */
	u_char	smd_defect_head;	/* head # */
	u_char	smd_defect_zero2;	/* zero */
	u_short	smd_defect_pos1;	/* position 1 */
	u_short	smd_defect_len1;	/* length 1 */
	u_short	smd_defect_pos2;	/* position 2 */
	u_short	smd_defect_len2;	/* length 2 */
	u_short	smd_defect_pos3;	/* position 3 */
	u_short	smd_defect_len3;	/* length 3 */
	u_short	smd_defect_pos4;	/* position 4 */
	u_short	smd_defect_len4;	/* length 4 */
	u_char	smd_defect_zero3;	/* zero */
	u_char	smd_defect_xf0;		/* Constant (0xf0) */
};

/* track of id's */
struct rf_trkid {
	u_short	trkid_cyl;
	u_char	trkid_sec;
#define	TRKID_SEC_SHORT		0xFD
#define	TRKID_SEC_SPARE		0xFE
#define	TRKID_SEC_SLIP		0xFF
        u_char	trkid_head;
	u_char	trkid_alt;
#define	TRKID_ALT_NORMAL	0xFF
	u_char	trkid_flag;
#define	TRKID_FLAG_NORMAL	0xAA
#define	TRKID_FLAG_DEF_TRK	0xC3
#define	TRKID_FLAG_ALT_TRK	0x3C
#define	TRKID_FLAG_BAD_TRK	0x33
#define	TRKID_FLAG_DEF_SEC	0x5A
#define	TRKID_FLAG_ALT_SEC	0xA5
#define	TRKID_FLAG_BAD_SEC	0x35
};

/* seek to specific head/cylinder */
struct rf_look {
	u_short	look_cyl;
	u_char	look_head;
	u_char	look_sec;
};

#define	MAX_RF_BSIZE	1024*63
 
union rf_uib {
    struct uib {
	u_short		uib_cksum;
	u_short		uib_magic;
#define	RF_UIB_MAGIC	0xC37B
	char		uib_label[19];
	char		uib_pad_0;
	u_short		uib_confd_nbps;
	u_short		uib_confd_ncyl;
	u_short		uib_confd_nspares;
	u_short		uib_confd_nspt;
	u_char		uib_confd_shead;
	u_char		uib_confd_nhead;
	u_char		uib_confd_shead1;
	u_short		uib_confd_flags;
	u_short		uib_dparam_intlv;
	u_short		uib_dparam_hdskew;
	u_short		uib_dparam_cyskew;
	u_short		uib_dparam_hgskew;
	u_short		uib_dparam_rcvry;
	u_short		uib_dparam_gap1;
	u_short		uib_dparam_gap2;
	u_short		uib_iocg_cache;
	u_short		uib_iocg_rahead;
	u_short		uib_iocg_rcvry;
	u_short		uib_iocg_dretry;
	u_short		uib_iocg_ndretry;
	u_short		uib_cyl_offset;
	u_int		uib_pnbs;
    }		uib;
    char	uib_pad[512];
};
