#include "qp.h"
#if	NQP > 0

#include "../machine/pte.h"

#include "param.h"
#include "conf.h"
#include "user.h"
#include "proc.h"
#include "ioctl.h"
#include "tty.h"
#include "map.h"
#include "buf.h"
#include "vm.h"
#include "ioctl.h"
#include "../is68kdev/qbvar.h"

#include "../machine/board.h"

#include "../dev/openchip.h"
#include "../dev/video.h"
#include "console.h"
#include "imsg170.h"
#include "qbit1p.h"
#include "qbit2p.h"
#include "qbit4p.h"

#define DEBUG

#define PALETTE		((struct imsg170 *)(IO_ADRS_PALETTE))
/* parameters for the graphics monitor */



#undef	PRATE
#undef	DEFPLANES

/*****************************************************************************/

#define GENERIC_MONITOR		/**/
/*#define MULTISYNC_MONITOR	/**/
/* #define COTRON_MONITOR	/**/
/* #define SONY_MONITOR		/**/

/*****************************************************************************/

#ifdef	MULTISYNC_MONITOR

char	montype = 'a';

#define	N_C_SYNC_ON_V_AND_H		/* -ve composite sync on vert + horiz */

#define	PRATE		32		/* 32MHz pixel rate */

#define	X_PIXELS	736
#define	Y_PIXELS	512

#define	HTIME		(1000/32)	/* uSecs (32kHz line rate) */
#define	HSYNC_0		2		/* uSecs */
#define	HSYNC_1		3		/* uSecs */

#define	VSYNC_0		10		/* lines */
#define	VSYNC_1		4		/* lines */
#define	VSYNC_2		30		/* lines */

#endif	MULTISYNC_MONITOR

/*---------------------------------------------------------------------------*/

#ifdef	COTRON_MONITOR

char	montype = 'b';

#define	C_SYNC_ON_GREEN			/* composite green sync */

#define	PRATE		32		/* 32MHz pixel rate */

#define	X_PIXELS	736
#define	Y_PIXELS	512

#define	HTIME		(1000/32)	/* uSecs (32kHz line rate) */
#define	HSYNC_0		1		/* uSecs */
#define	HSYNC_1		1		/* uSecs */

#define	VSYNC_0		1		/* lines */
#define	VSYNC_1		2		/* lines */
#define	VSYNC_2		(600/HTIME - 3)	/* lines */

#endif	COTRON_MONITOR

/*---------------------------------------------------------------------------*/

#ifdef	SONY_MONITOR

char	montype = 'c';

#define	N_SYNC_ON_V_AND_H		/* -ve separate syncs */

#define	PRATE		16		/* 16MHz pixel rate */

#define	X_PIXELS	736
#define	Y_PIXELS	272

#define	HTIME		(1000/16)	/* uSecs (16kHz line rate) */
#define	HSYNC_0		6		/* uSecs */
#define	HSYNC_1		6		/* uSecs */

#define	VSYNC_0		6		/* lines */
#define	VSYNC_1		4		/* lines */
#define	VSYNC_2		30		/* lines */

#endif	SONY_MONITOR

/*---------------------------------------------------------------------------*/

#ifdef	GENERIC_MONITOR

char	montype = 'd';

#define	N_C_SYNC_ON_V_AND_H		/* -ve composite sync on vert + horiz */

#define	PRATE		32		/* 32MHz pixel rate */

#define	X_PIXELS	736
#define	Y_PIXELS	512

#define	HTIME		(1000/32)	/* uSecs (32kHz line rate) */
#define	HSYNC_0		2		/* uSecs */
#define	HSYNC_1		3		/* uSecs */

#define	VSYNC_0		10		/* lines */
#define	VSYNC_1		4		/* lines */
#define	VSYNC_2		30		/* lines */

#endif	GENERIC_MONITOR
/*****************************************************************************/

#ifndef	DEFPLANES
#define	DEFPLANES		4
#endif	!DEFPLANES

int planes	= DEFPLANES;		/* Number of bitplanes in use */

addrptr strptr;
addrptr owptr;
addrptr glyphp;

font sysfont =
{
    FIXED, 32, 127, 7, 1, 8, 8,
    {&glyphp, 0, 0, 760, 8, 48, 0, DEFPLANES, 0},
    &strptr,
    &owptr,
};

mon_info monitor = {
    PRATE,				/* video pixel rate */
#ifdef	C_SYNC_ON_GREEN
    {
        {ACTIVE_LOW, DISABLED},		/* VSYNC */
        {ACTIVE_LOW, DISABLED},		/* HSYNC */
        {ACTIVE_HIGH, COMP_SYNC}	/* PSYNC */
    },
#endif	C_SYNC_ON_GREEN
#ifdef	N_C_SYNC_ON_V_AND_H
    {
        {ACTIVE_LOW, COMP_SYNC},	/* VSYNC */
        {ACTIVE_LOW, COMP_SYNC},	/* HSYNC */
        {ACTIVE_LOW, DISABLED}		/* PSYNC */
    },
#endif	N_C_SYNC_ON_V_AND_H
#ifdef	N_SYNC_ON_V_AND_H
        {ACTIVE_LOW, VERT_SYNC},	/* VSYNC */
        {ACTIVE_LOW, HORIZ_SYNC},	/* HSYNC */
        {ACTIVE_LOW, DISABLED}		/* PSYNC */
#endif	N_SYNC_ON_V_AND_H
#ifdef	INTERLACED
    1,				/* interlaced picture */
#else
    0,				/* non-interlaced picture */
#endif
    (HTIME * PRATE) / 32,		/* total scan line width */
    X_PIXELS / 32,			/* off to horizontal blank */
    (X_PIXELS + HSYNC_0 * PRATE) / 32,	/* off to horizontal sync start */
    (X_PIXELS + (HSYNC_0 + HSYNC_1) * PRATE) / 32,	/* to h sync end */
    Y_PIXELS + VSYNC_0 + VSYNC_1 + VSYNC_2,	/* scan lines per frame */
    Y_PIXELS,				/* offset to vertical blank */
    Y_PIXELS + VSYNC_0,			/* offset to vertical sync start */
    Y_PIXELS + VSYNC_0 + VSYNC_1	/* offset to vertical sync end */
};

/****** begin UNIX stuff ******/

extern int toqg;

int	qpprobe(),	qpslave(),	qpattach(),	qpintr();
struct	qb_ctlr		*qpcinfo[NQP];
struct	qb_device	*qpdinfo[Nqp];

u_short *QPstd[NQP+1];			/* qpdevice addresses */
u_char	*QPstd_dm[NQP + 1];		/* display memory addresses */
struct	qb_driver QPdriver =
	{ qpprobe, qpslave, qpattach, 0, QPstd, "qp", qpdinfo, "QP", qpcinfo };

/****** end UNIX stuff ******/


/* -------Forward declarations----------------------- */

raster_line    *AddScreen();
vid_sync       *AddSection();
vid_sync       *AddSync();
raster_line    *AddFlags();
byte            SyncBits();

/* -------Constants and macros----------------------- */

/* Constants to represent the states of the sync signals */

#define HSYNC_ON        -1
#define HSYNC_OFF       0
#define VSYNC_ON        -1
#define VSYNC_OFF       0

/* Mask for the address part of a video list data pointer */
#define	VDATA_SHIFT	24
#define ADDR_MASK       (~((~0L) << VDATA_SHIFT))

/* maximum sync repeat count length. For efficiency in OpenChip, use */
/* multiples of 32 when the count will not fit into a single byte */
#define	MAXSYNCLEN	(256 - 32)

typedef struct {
	char	red;
	char	green;
	char	blue;
	char	spare;
} colsave;

/* -------Imported variables/functions---------------*/

form screenform;
int planes;		/* from monparms.c */

/* -------Exported variables/functions---------------*/

raster_line *video_list;	/* -> the video list in memory */
raster_line **line_addr;	/* table of pointers to raster line info */
mon_info *monptr;		/* -> to monitor def being used */

/* space for the video memory. This is allocated n*128 bytes per raster line */
/* of display, up to a maximum of 512 lines. The array is declared 128 bytes */
/* bigger than this so we can ensure that it is 128 byte aligned, in order to */
/* make sure that the OpenChip burst mode RAM access will be ok. The pointer */
/* vidmem is set to the 128 byte aligned video memory by routine vid_mode */

#define	MAXPLANES	4
#define MAXRASTERS	512
#define MAXRASTSIZE	RASTSIZE(736,MAXPLANES)
#define VIDMEMSIZE	(MAXRASTERS * MAXRASTSIZE)

#define	RASTSIZE(w,p)	((((w)+15)/16*sizeof(word)*(p)+127L)&~127L)

int vidmemsize = VIDMEMSIZE;

extern char _vidmem[];
extern int _vidmemmap[];
addrptr vidmem;
raster_line *rastptrs [MAXRASTERS];
raster_line _vidlist [1000];		/* should be plenty big enough */
colsave palsave[256];		/* space to store the palette information */




#define CLEAR   2
#define INVERT  3

int             conon = 0;	/* console is initialized */
int             obgpresent = 0; /* on-board graphics are being used */
form            screenform;	/* Current screen form */
point           pen;		/* The pen position */

word            zerobits[16];	/* Zero bit map */

/******* Start of font declaration ********/

/******* End of font declaration ********/



/******* Start of kernel stuff   *******/

qpprobe(qp_addr)
struct qpdevice *qp_addr;
{
#ifdef notdef
	printf("qpprobe(qp_addr: %a\n", qp_addr);
#endif notdef
}

qpslave(qi, qp_addr)
register struct qb_device	*qi;
register struct qpdevice	*qp_addr;
{
#ifdef notdef
	printf("qpslave(qb_device: %a, qpdevice: %a\n", qi, qp_addr );
#endif notdef
	return(1);
}
	
qpattach(qi)
register struct qb_device	*qi;
{
#ifdef notdef
	printf("qpattach(qb_device: %a\n", qi);
#endif notdef
}


/******* Start of graphics stuff   *******/
int             cursorlevel = 1;
int             cursorphase = 1;

HideCursor()
{
    /*
     * must increment cursorlevel BEFORE inverting it so that the recursive
     * calls within InvCursor() work correctly 
     */
    if (cursorlevel++ == 0 && cursorphase == 1)
	InvCursor();
}

ShowCursor()
{
    /*
     * must decrement cursorlevel AFTER inverting it so that the recursive
     * calls within InvCursor() work correctly 
     */
    if (cursorlevel == 1 && cursorphase == 1)
	InvCursor();

    if (cursorlevel)
	cursorlevel--;
}

/*
 * Invert the cursor.                                                         
 */
InvCursor()
{
    rectangle       rect;

    rect.x = pen.x;
    rect.y = pen.y - sysfont.ascent;
    rect.width = sysfont.maxwidth;
    rect.height = sysfont.glyphs.height;
    RectOp(INVERT, &rect);
}

/*
 * Clear the screen.                                                          
 */
cls()
{
    RectOp(CLEAR, &screenform.x);
    MoveCTo(0, 0);
}

/*
 * BITBLT 
 *
 * interface to the BitBlT routine.                                     
 */
bitblt(cps)
CopyStruct     *cps;
{
    HideCursor();
    blit(cps);
    ShowCursor();
}

unsigned int pvidmem;
obginit(fa)
unsigned int fa;
{
	/*
	 * If the keyboard doesn't exist then don't 
	 * initialize the graphics subsystem.
	 */
	if (InitKey() == -1){
		setbustmo(1000);
		return(0);
	}
	setbustmo(120);
	pvidmem = (unsigned int)ptob(fa - btop(PHYSMEMBASE));
	mapin(_vidmemmap, btop(_vidmem), fa, btoc(VIDMEMSIZE), PG_V|PG_KW);
	obgpresent = 1;
	coninit(0);
	return(btoc(VIDMEMSIZE));
}

/*
 * Initialize the console variables.                                          
 */
coninit(nplanes)
int nplanes;
{
    extern mon_info monitor;
    register int fg, col, clear;

    if (!obgpresent)
	return;
	
    conon = 1;
    clear = 0;


    if (nplanes == 0){
	nplanes = DEFPLANES;
	clear = 1;
    }
    planes = nplanes;

    switch (planes){
	case 4:
	    strptr = strike4;
	    owptr = ow4;
	    glyphp = glyphs4;
	    sysfont.glyphs.planes = 4;
	    break;
	case 2:
	    strptr = strike2;
	    owptr = ow2;
	    glyphp = glyphs2;
	    sysfont.glyphs.planes = 2;
	    break;
	case 1:
	default:
	    strptr = strike1;
	    owptr = ow1;
	    glyphp = glyphs1;
	    sysfont.glyphs.planes = 1;
    }
	
    QPstd[0] = (u_short *)_vidmem;

    vid_stop();
    /* initialize the OpenChip to produce a display */
    vid_mode(&monitor);

    pal_default ();

    col_set (0,0,0,0,40);

    if (clear)
	cls();
    MoveCTo(0, 60);
    ShowCursor();
}

int rectdeb = 0;

/*
 * Perform one of two graphical ops on a rectangle...                     
 */
RectOp(op, rect)
register        op;
register rectangle *rect;
{
    register CopyStruct cps;

    cps.destform = (form *) & screenform;
    cps.sourceform = 0;
    cps.destrect = cps.srcrect = rect;
    cps.cliprect = (rectangle *) & screenform.x;
    cps.cindex = 0;

    HideCursor();		/* for efficiency when framing rectangles */

    if (op == CLEAR) {
	cps.htoneform = &zerobits[0];
	cps.mode = M_COPY;
    } 
    else {		/* op == INVERT */
	cps.htoneform = 0;
	cps.mode = M_NDST;
    }

    bitblt(&cps);
    ShowCursor();  /**/
}

/*
 * ScrollUp only for values of dv >= 0, no horizontal scrolling 
 */
ScrollUp(dv)
register        dv;
{
    rectangle       destrect;
    CopyStruct      copyparms;
    register CopyStruct *cps = &copyparms;
    register rectangle *drect = &destrect;
    register rectangle *rect;

    rect = (rectangle *) & screenform.x;

    cps->sourceform = cps->destform = &screenform;
    cps->htoneform = 0;
    cps->srcrect = cps->cliprect = rect;
    cps->destrect = drect;
    cps->mode = M_COPY;

    drect->width = rect->width;
    drect->height = rect->height;
    drect->x = rect->x;
    drect->y = rect->y - dv;

    /* Move the data */

    bitblt(cps);

    /* Now clear the remaining parts */

    cps->sourceform = 0;
    cps->htoneform = &zerobits[0];
    drect->x = rect->x;

    /* assume dv >= 0 */
    drect->y = rect->y + rect->height - dv;
    drect->height = dv;
    drect->width = rect->width;

    bitblt(cps);
}

#define STRIKE(f,o)	((*(f)->strike)[o])
#define OW(f,o)		((*(f)->ow)[o])

/*
 * Draw a character                                                           
 */
DChar(value)
register byte   value;
{
    rectangle       destrect, srcrect;
    CopyStruct      cstruct;
    register font  *fptr = &sysfont;

    if (value < fptr->firstchar || value > fptr->lastchar)
	return;

    value -= fptr->firstchar;

    /*
     * Set up destrect as the rectangle in the layer where the char is to go 
     */

    destrect.x = pen.x + ((OW(fptr, value) >> 8) & 0xff);
    destrect.y = pen.y - fptr->ascent;

    srcrect.x = STRIKE(fptr, value);
    srcrect.y = 0;
    srcrect.width = destrect.width = STRIKE(fptr, value + 1) - STRIKE(fptr, value);
    srcrect.height = destrect.height = fptr->glyphs.height;

    cstruct.sourceform = &fptr->glyphs;
    cstruct.destform = &screenform;
    cstruct.htoneform = 0;
    cstruct.srcrect = &srcrect;
    cstruct.destrect = &destrect;
    cstruct.cliprect = (rectangle *) & screenform.x;
    cstruct.cindex = 0;
    cstruct.mode = M_COPY;

    bitblt(&cstruct);
}


/*
 * g_putc 
 *
 * character put routine for the console driver. 
 */
con_putc(value)
char            value;
{

    if (!conon)
	return 0;

    HideCursor();		/* since we may be changing its position */

    switch (value) {
    case CURLEFT: CLeft(); break;
    case CR: pen.x = 0; break;
    case CURDOWN: CDown(); break;
    case LF: CDown(); pen.x = 0; break;
    case CURRIGHT: CRight(); break;
    case BCKSPACE: CLeft(); DChar(' '); break;
    default: DChar(value); CRight(); break;
    }

    ShowCursor();

    return (value);
}


/*
 * Absolute text cursor move                                                  
 */
MoveCTo(x, y)
{
    pen.x = x * sysfont.maxwidth;
    pen.y = y * sysfont.leading + sysfont.ascent;
}

/*
 * CLEFT     CRIGHT    CDOWN 
 */
CLeft()
{
    pen.x -= sysfont.maxwidth;
    if (pen.x < 0)
	pen.x = screenform.width - sysfont.maxwidth;
}

CRight()
{
    pen.x += sysfont.maxwidth;
    if (pen.x >= screenform.width) {
	pen.x = 0;
	CDown();
    }
}

CDown()
{
    pen.y += sysfont.leading;

    /*
     * if the next character will appear partly or completely below the edit
     * area, then we must scroll up a line. 
     */

    if (pen.y > screenform.height - sysfont.descent) {
	ScrollUp(sysfont.leading, 0);
	pen.y -= sysfont.leading;
    }
}

/* Code to create a video list */



/*                                                          *****************
                                                            *               *
                                                            * MAKEVIDEOLIST *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Generate the video list used by the OpenChip. This routine uses the       |
| monitor information structure set up by GetMonInfo(), and will work for   |
| interlaced or non-interlaced displays with any kind of sync which it is   |
| possible to generate with the OpenChip.                                   |
|                                                                           |
| The screen is divided into four areas vertically:                         |
|       1. Displayed scan lines.                                            |
|       2. Scan lines which are blanked before the vertical sync pulse.     |
|       3. Scan lines during the vertical sync pulse.                       |
|       4. Scan lines which are blanked after the vertical sync pulse.      |
|                                                                           |
-----------------------------------------------------------------------------
*/
MakeVideoList(video_data, data_delta)
int data_delta;		/* The offset from one line of video data
				   to the next (in long words) */
lword *video_data;	/* -> the first long word of video data */
{
    register raster_line *vl = video_list;

    if (monptr->interlaced) {
        vl = AddScreen(video_data, 2 * data_delta, 1, vl);
        vl = AddScreen(video_data + data_delta, 2 * data_delta, 2, vl);
    }
    else
        vl = AddScreen(video_data, data_delta, 0, vl);
}

/*
                                                            *****************
                                                            *               *
                                                            *   ADDSCREEN   *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Generate one screen of the video list. If the display is interlaced, it   |
| will comprise two of these screens, one displaying the even raster lines, |
| the other the odd raster lines. This will be generated by two calls to    |
| this routine. The value returned by this routine is a pointer to the next |
| free entry in the video list.                                             |
|                                                                           |
| The screen is divided into four areas vertically:                         |
|       1. Displayed scan lines.                                            |
|       2. Scan lines which are blanked before the vertical sync pulse.     |
|       3. Scan lines during the vertical sync pulse.                       |
|       4. Scan lines which are blanked after the vertical sync pulse.      |
|                                                                           |
-----------------------------------------------------------------------------
*/
static raster_line *
AddScreen(dataptr, data_delta, interlaced, vl)
register lword *dataptr;	/* -> the first raster line to be displayed */
register int data_delta;	/* dataptr increment between each line */
register int interlaced;	/* 0 for non-interlaced, 1 for the first
                                   screen of an interlaced picture and
                                   2 for the second screen. */
register raster_line *vl;	/* -> the video list */
{
    raster_line tline;
    register raster_line *line = &tline;
    register vid_sync *vsptr;	/* -> sync patterns during vertical sync */
    register int i;
    register int line_delta;
    register int line_num;
    register int vis_width;

    /* Calculate the total width of the visible part of a raster line */
    vis_width = monptr->h_blank * planes;

    /* Calculate the initial line number */
    line_num = (interlaced == 2) ? 1 : 0;

    /* If this is an interlaced picture, skip every other line */
    line_delta = (interlaced != 0) ? 2 : 1;

    /* The video list entries for the scan lines which contain visible data
       are all the same except for the data pointer. To set this part of
       the table up, the constant parts of the entry are set up in a
       structure, which is modified and appended to the end of the video list
       for each visible line (except the last - see below). */

    /* Initialise the constant parts of the entry for a visible scan line. */
    /* front_porch and back_porch are adjusted for delay of 1 long word
       time over the BLANK and data signals */

    line->front_porch.vs_count =
		((monptr->h_sync_start - monptr->h_blank) * planes - 1);
    line->front_porch.vs_flags =
		OP_VID_BLANK | SyncBits(HSYNC_OFF, VSYNC_OFF);

    line->h_sync.vs_count =
		((monptr->h_sync_end - monptr->h_sync_start) * planes);
    line->h_sync.vs_flags =
		OP_VID_BLANK | SyncBits(HSYNC_ON, VSYNC_OFF);

    line->back_porch.vs_count =
		((monptr->line_width - monptr->h_sync_end) * planes + 1);
    line->back_porch.vs_flags =
		OP_VID_BLANK | SyncBits(HSYNC_OFF, VSYNC_OFF);

    line->flags.vs_count = 0;       /* repeat count of 0, no action flags */
    line->flags.vs_flags = 0;

    /* Insert the video list entries for all of the visible scan
       lines except the last one */
    for (i = line_num + line_delta; i < monptr->v_blank; i += line_delta) {
	/* Calculate the address and length of the data */
        line->data = (lword *) (((unsigned long) dataptr & ADDR_MASK) | (vis_width << VDATA_SHIFT));

	/* Point to the data for the next line */
        dataptr += data_delta;

	/* Save the address of this raster line descriptor */
	line_addr[line_num] = vl;
	line_num += line_delta;

	/* Copy this descriptor into the video list */
        *vl++ = *line;
    }

    /* the entry for the last scan line is slightly different because
       we don't want the zero word to terminate the list of sync patterns
       since the sync pattern list will be extended to contain the three
       vertical blanking sections. */
    line->data = (lword *) (((unsigned long) dataptr & ADDR_MASK)
				| (vis_width << VDATA_SHIFT));
    /* re-correct for line with vertical sync not BLANK */
    line->back_porch.vs_count -= 1;
    line_addr[line_num] = vl;
    *vl = *line;

    /* The rest of the video list is divided into three sections which
       are almost the same. The regular horizontal sync signal continues
       through all three sections. The first and last sections do not have
       the vertical sync asserted, the middle section does. There is some
       minor messing about to get the vertical sync offset by half a scan
       line for an interlaced picture, but each of the three sections is
       basically the same, so they are dealt with in turn by the routine
       AddSection(). */

    /* Add the entries for the part of vertical blanking before the
       vertical sync pulse. The use of (interlaced == 2) here ensures
       that the vertical blanking signal is delayed by half a scan
       line before the start of the first screen of an interlaced picture
       so that the first scan takes place 1/2 a line above the second */

    vsptr = AddSection(&vl->flags, VSYNC_OFF,
    		monptr->v_sync_start - monptr->v_blank,
    		0,
 		(monptr->scan_lines - monptr->v_sync_start) == 0);

    /* Add the entries for the vertical sync part of the frame. */
    vsptr = AddSection(vsptr, VSYNC_ON,
    		monptr->v_sync_end - monptr->v_sync_start,
 		interlaced == 2,
 		(monptr->scan_lines - monptr->v_sync_end) == 0);

    /* Add the entries for the part of the frame after the vertical
       sync pulse. */
    vsptr = AddSection(vsptr, VSYNC_OFF,
    		monptr->scan_lines - monptr->v_sync_end,
 		interlaced == 2,
 		1);

    /* the end of the screen so next line will be a raster */
    /* if half way through an interlaced picture, we need a null sync word
       here to get the OpenChip to treat the next entry as a pointer to
       video data. */
    return(AddFlags(vsptr, (interlaced == 1) ? 0 : OP_VIDL_RSTRT));
}

/*
                                                            *****************
                                                            *               *
                                                            *  ADDSECTION   *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Add a section (as described above) of the screen to the video list. The   |
| first line of the section will be half started if we are doing the first  |
| screen of an interlaced display. The vertical sync pulse will have been   |
| delayed by half a raster line to cause the interlacing. The value         |
| returned by this routine is the new video list pointer.                   |
-----------------------------------------------------------------------------
*/
static vid_sync *
AddSection(vsptr, v, nlines, half_line, data_next)
register vid_sync *vsptr;	/* -> into the video list */
short v;			/* vertical sync on/off */
short nlines;			/* number of scan lines in this section */
short half_line;		/* TRUE if half line of -ve vertical sync */
short data_next;		/* TRUE if the next scan line contains data */
{
    register int i;
    register int length;
    register int on_hsync, off_hsync;

    if (nlines <= 0)
       return;

    /* precompute the two sync patterns required */
    off_hsync = SyncBits(HSYNC_OFF, v) | OP_VID_BLANK;
    on_hsync = SyncBits(HSYNC_ON, v) | OP_VID_BLANK;

    if (half_line)
    {
    	/* make the first half of the scan line have inverted vertical sync */
	length = monptr->line_width / 2;
      	vsptr = AddSync(vsptr, planes * length, SyncBits(HSYNC_OFF, v ^ (VSYNC_ON ^ VSYNC_OFF)) | OP_VID_BLANK);
	length = monptr->h_sync_start - length;
    }
    else
        length = monptr->h_sync_start;

    vsptr = AddSync(vsptr, planes * length, off_hsync);

    for (i = nlines - 1; i > 0; i--) {
        vsptr = AddSync(vsptr, planes * (monptr->h_sync_end - monptr->h_sync_start), on_hsync);
        vsptr = AddSync(vsptr, planes * (monptr->line_width - (monptr->h_sync_end - monptr->h_sync_start)), off_hsync);
    }

    vsptr = AddSync(vsptr, planes * (monptr->h_sync_end - monptr->h_sync_start), on_hsync);

    /* add an extra long word time if the next line contains data
       to correct for sync propogation delay */
    return(AddSync(vsptr, planes * (monptr->line_width - monptr->h_sync_end) + (data_next ? 1 : 0), off_hsync));
}

/*
                                                            *****************
                                                            *               *
                                                            *    ADDFLAGS   *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Add a word of flag information into the video list. The updated video     |
| list pointer is returned as the result of this function. Each word of     |
| flag information is composed of a 0 and a flag byte. This flag byte is    |
| passed as f to this routine.						    |
-----------------------------------------------------------------------------
*/
static raster_line *AddFlags(vsptr, f)
register vid_sync *vsptr;	/* current video list pointer */
byte f;				/* flags for the word */
{
    vsptr->vs_count = 0;	/* mark as a flag entry */
    vsptr->vs_flags = f;	/* save the flags value */

    vsptr = NEXTVIDSYNC(vsptr);

    /* next entry will be a raster address so ensure it is aligned */

    return(RASTERALIGN(vsptr));
}

/*
                                                            *****************
                                                            *               *
                                                            *    ADDSYNC    *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Add a word of sync information into the video list. The updated video     |
| list pointer is returned as the result of this function. Each word of     |
| sync information is composed of a count and a flag byte. These are passed |
| separately as n and s to this routine.                                    |
| AddSync is only ever called after a previous sync pattern has been added  |
| to the video list in AddSection() or AddScreen() so we can optimise the   |
| size and speed of stepping through it by amalgamating with the previous   |
| entry wherever possible!						    |
-----------------------------------------------------------------------------
*/
static vid_sync *AddSync(vsptr, n, f)
register vid_sync *vsptr;	/* current video list pointer */
register int n;			/* repeat count for the sync word */
register byte f;		/* flags for the sync word */
{
    register vid_sync *pvsptr = PREVVIDSYNC(vsptr);

    if (pvsptr->vs_flags == f)	/* if the last entry had the same flags then */
    {
        vsptr = pvsptr;		/* step back and amalgamate them */
	n += vsptr->vs_count;
    }

    while (n > 255)
    {
    	/* insert the repeat count as multiples of 32 for efficiency */
    	vsptr->vs_count = MAXSYNCLEN;
	n -= MAXSYNCLEN;
	/* and insert the sync flag bits */
	vsptr->vs_flags = f;
	vsptr = NEXTVIDSYNC(vsptr);
    }
    if (n > 0)
    {
    	/* insert the repeat count */
    	vsptr->vs_count = n;
	/* and insert the sync flag bits */
	vsptr->vs_flags = f;
	vsptr = NEXTVIDSYNC(vsptr);
    }

    return vsptr;
}

/*
                                                            *****************
                                                            *               *
                                                            *   SYNCBITS    *
                                                            *               *
                                                            *****************
-----------------------------------------------------------------------------
| Calculate the sync bit pattern required given the current horizontal and  |
| vertical sync states. h and v should be -1 if the signal is active and    |
| 0 otherwise. sync points to the sync[] array in the mon_info structure.   |
-----------------------------------------------------------------------------
*/
static byte SyncBits(h, v)
register short h, v;
{
     /* masks for each sync bit */
    static word sync_masks[] = {OP_VID_VSYNC, OP_VID_HSYNC, OP_VID_PSYNC};

    int i;
    register word syncbits = 0;
    register word addbits;
    register sync_info *sync = &monptr->sync[0];

    for (i = 0; i < NSYNCS; i++) {
        switch (sync->type) {
            case DISABLED:
                addbits = sync->polarity;
                break;

            case VERT_SYNC:
                addbits = sync->polarity ^ v;
                break;

            case HORIZ_SYNC:
                addbits = sync->polarity ^ h;
                break;

            case COMP_SYNC:
                addbits = sync->polarity ^ (h ^ v);
                break;
        }

        syncbits |= (addbits & sync_masks[i]);
        sync++;
    }

    return syncbits;
}

/*                                                                *************
                                                                  *           *
                                                                  * VID_MODE  *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| QXSSE interface routine to set up a new video mode, given:                  |
|                                                                             |
| 1. A pointer to a mon_info definition describing the monitor and display    |
|    dimensions to use.                                                       |
-------------------------------------------------------------------------------
*/

vid_mode (moninfptr)
register mon_info *moninfptr;
{
   register struct openchip *oc = OPENCHIP;
   form *sf;
   register short int i;

   /* Set up a page aligned video memory pointer in vidmem */
   /* it only needs to be 128 byte aligned, however	*/
   vidmem = (addrptr) _vidmem;

   /* Set up the screen form */
   sf		= &screenform;
   sf->bits	= &vidmem;
   sf->x	= 0;
   sf->y	= 0;
   sf->width	= moninfptr->h_blank * 32;
   sf->height	= moninfptr->v_blank;
   sf->rowwords	= RASTSIZE(sf->width, planes)/(sizeof(word)*planes);
   sf->planes	= planes;
   sf->format	= 0;
   sf->formlist	= 0;

   /* Create the video list */
   monptr = moninfptr;
   video_list = (raster_line *)(((unsigned long)_vidlist + 3L) & ~3L);
   line_addr = &rastptrs [0];
   MakeVideoList (pvidmem, sf->rowwords * sizeof(word) * planes / sizeof(long));

   /* do not mask any of the logical pixel information before lookup */
   PALETTE->ip_pmask = 0xff;

   /* Enable the palette change bit in the flags word used by PalChange() */
/*
   line_addr[sf->height - 3]->flags.vs_flags |= OP_VIDL_PCHNG;
*/

   /* Actually start up the OpenChip */
   /* A complex task, not to be undertaken lightly... */

   Q_OP_PORT1 = OP1_SET_VIDSTOP;	/* Assert VIDSTOP to stop the video */
   for (i = 67/3 + 1; i > 0; i--) ;	/* delay at least 67 clock periods */
   
   /* Set the correct video mode (VIDSEL0 and VIDSEL1). This depends on */
   /* the number of bit planes */
   /*     PLANES VIDSEL0 VIDSEL1 */
   /*        1      0      0     */
   /*        2      0      1     */
   /*        4      1      0     */

   if (planes == 2)
      Q_OP_PORT1 = OP1_SET_VIDSEL0;
   else
      Q_OP_PORT1 = OP1_RES_VIDSEL0;

   if (planes == 4)
      Q_OP_PORT1 = OP1_SET_VIDSEL1;
   else
      Q_OP_PORT1 = OP1_RES_VIDSEL1;

   /* Now reset and then reenable the video fifos */
   Q_OP_PORT1 = OP1_RES_RESFIFO;	/* reset fifo */
   Q_OP_PORT1 = OP1_SET_RESFIFO;	/* enable fifo */

   /* Write a sync pattern to the openchip with DATA bit set to zero */
   oc->op_vidsyn = 0;

   /* Write 63 to the op_vidblk register to initiate a fifo fill */
   oc->op_vidblk = 63;

   /* wait at least 67 clock cycles for this to complete */
   for (i = 67/3 + 1; i > 0; i--) ;

   /* Write an optimum value to the op_vidcnt register. */
   /* This is: 
    *
    *   1 + 32 - (((planes * prate * 37) / crate) / 32)
    *
    * where prate is the pixel rate in MHz, and crate is the CPU
    * clock speed in MHz. The latter is extracted from the OpenChip op_sysclk
    * register; the former is a constant in the EPROM.
    */
   oc->op_vidcnt = 2 + 32 - (((planes * moninfptr->prate * 37 * 1000000) / oc->op_sysclk) / 32);

   /* sync pattern whilst displaying data */
   oc->op_viewsyn = OP_VID_DATA |
    	(moninfptr->sync[0].polarity == ACTIVE_LOW ? OP_VID_VSYNC : 0) |
   	(moninfptr->sync[1].polarity == ACTIVE_LOW ? OP_VID_HSYNC : 0) |
   	(moninfptr->sync[2].polarity == ACTIVE_LOW ? OP_VID_PSYNC : 0);
   
   /* Set the op_vidstart to be at the start of the video list */
   /* this enables the OpenChip FIFO fill task */
   oc->op_vidstart = (long *) video_list;
   
   /* and finally reset VIDSTOP */
   Q_OP_PORT1 = OP1_RES_VIDSTOP;	/* deassert VIDSTOP */
   /* hopefully we have a display now ! */
}

vid_stop ()
{
    register int i;

   Q_OP_PORT1 = OP1_SET_VIDSTOP;	/* Assert VIDSTOP to stop the video */
   for (i = 67/3 + 1; i > 0; i--) ;	/* delay at least 67 clock periods */
}

vid_start ()
{
    vid_mode (monptr);
}

/*                                                                *************
                                                                  *           *
                                                                  * PAL_SEL   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Select the given palette. A QXSSE interface routine.                        |
-------------------------------------------------------------------------------
*/
pal_sel (palno)
int palno;
{
   if (palno & 1)
      Q_OP_PORT1 = OP1_SET_PALSEL0;
   else
      Q_OP_PORT1 = OP1_RES_PALSEL0;

   if (palno & 2)
      Q_OP_PORT1 = OP1_SET_PALSEL1;
   else
      Q_OP_PORT1 = OP1_RES_PALSEL1;
}

 
/*                                                                *************
                                                                  * RED_GUN   *
                                                                  * GREEN_GUN *
                                                                  * BLUE_GUN  *
                                                                  *************
-------------------------------------------------------------------------------
| Arrays defining 16 different colours.                                       |
| Each colour component is a 6 bit value (0..63).                             |
-------------------------------------------------------------------------------
*/

/* Colours are as follows:
 * 0 black
 * 1 dark blue
 * 2 dark red
 * 3 dark magenta
 * 4 dark green
 * 5 dark cyan
 * 6 dark yellow
 * 7 grey
 * 8 black
 * 9 blue
 * A red
 * B magenta
 * C green
 * D cyan
 * E yellow
 * F white
 */
byte redgun[16]	  = { 0, 0,32,32, 0, 0,32,32, 0, 0,63,63, 0, 0,63,63 };
byte greengun[16] = { 0, 0, 0, 0,32,32,32,32, 0, 0, 0, 0,63,63,63,63 };
byte bluegun[16]  = { 0,32, 0,32, 0,32, 0,32, 0,63, 0,63, 0,63, 0,63 };

/*                                                                *************
                                                                  *           *
                                                                  * PAL_DEFAULT
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Set up a default palette, according to the value of planes.                 |
| Both a QXSSE and a QXTEST routine.                                          |
-------------------------------------------------------------------------------
*/
pal_default ()
{
   register int col;
   register int t;
   register int ncolsm1;

   /* do not mask any of the logical pixel information before lookup */
   PALETTE->ip_pmask = 0xff;

   /* ncolsm1 stands for no. of colours minus 1 */
   ncolsm1 = (1 << planes) - 1;

   for (col = 0; col <= ncolsm1; col++) {
      t = (col * 15) / ncolsm1;
      pal_col(col, redgun[t], greengun[t], bluegun[t]);
   }

   pal_sel(0);			/* Select palette 1 to display */
}

/*                                                                *************
                                                                  *           *
                                                                  * PAL_COL   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Set colour c in all palettes and dithers. Q QXSSE interface routine.        |
-------------------------------------------------------------------------------
*/
pal_col (c, r, g, b)
int c;
unsigned char r, g, b;
{
   register int pal, dith;
   register int shift, mask, colmask;
   static dithmask[] = { 0, 0x3, 0x1, 0, 0x0 };

   for (dith = 0; dith < 4; dith++)
   {
      shift = ((dith ^ 3) & dithmask[planes]) * planes;
      mask = ~((~0) << planes);
      colmask = (mask & c) << shift;
      mask <<= shift;
      for (pal = 0; pal < 4; pal++)
         pal_set (pal, dith, mask, colmask, r, g, b);
   }
}

/*                                                                *************
                                                                  *           *
                                                                  * COL_SET   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Set colour c in the given palette for all dithers.                          |
-------------------------------------------------------------------------------
*/
col_set (pal, c, r, g, b)
int pal;
int c;
unsigned char r, g, b;
{
   register int dith;
   register int shift, mask, colmask;
   static dithmask[] = { 0, 0x3, 0x1, 0, 0x0 };

   for (dith = 0; dith < 4; dith++)
   {
      shift = ((dith ^ 3) & dithmask[planes]) * planes;
      mask = ~((~0) << planes);
      colmask = (mask & c) << shift;
      mask <<= shift;
      pal_set (pal, dith, mask, colmask, r, g, b);
   }
}

/*                                                                *************
                                                                  *           *
                                                                  * PAL_SET   *
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Set the RGB values for a given (palette, dither, colour) combination.       |
-------------------------------------------------------------------------------
*/
pal_set (pal, dith, mask, colmask, r, g, b)
register int pal, dith, mask, colmask;
unsigned char r, g, b;
{
   register struct imsg170 *p = PALETTE;
   register int col;
   register colsave *cp;
   unsigned int index;

   for (col = 0; col < 16; col++)
   {
      if ((col & mask) == colmask)
      {
	 index = (pal << 6) | (dith << 4) | col;
	 p->ip_paddr = index;
	 p->ip_cval  = r;
	 p->ip_cval  = g;
	 p->ip_cval  = b;

         cp = &palsave[index];
         cp->red = r;
         cp->green = g;
         cp->blue = b;
      }
   }
}

palette_set(pal, dith, col, r, g, b)
unsigned int pal, dith, col;
unsigned char r, g, b;
{
	register struct imsg170 *p = PALETTE;
	register colsave *cp;
	unsigned int index;

	index = (pal << 6) | (dith << 4) | col;
	p->ip_paddr = index;
	p->ip_cval  = r;
	p->ip_cval  = g;
	p->ip_cval  = b;

	cp = &palsave[index];
	cp->red = r;
	cp->green = g;
	cp->blue = b;
}

#ifdef VIDEO_INTERRUPT
/*                                                                *************
                                                                  *           *
                                                                  *SETVIDEOINTR
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Set the frame interrupt to occur after the given raster line.               |
-------------------------------------------------------------------------------
*/
SetVideoIntr(line)
int line;
{
   if (line != prev_line) {
      if (prev_line != -1)
         line_addr[prev_line]->flags.vs_flags &= ~OP_VIDL_FRM;

      line_addr[line]->flags.vs_flags |= OP_VIDL_FRM;
      prev_line = line;
   }
}

/*                                                                *************
                                                                  *           *
                                                                  *RESVIDEOINTR
                                                                  *           *
                                                                  *************
-------------------------------------------------------------------------------
| Disable the frame interrupt.                                                |
-------------------------------------------------------------------------------
*/
ResVideoIntr()
{
  if (prev_line != -1) {
     line_addr[prev_line]->flags.vs_flags &= ~OP_VIDL_FRM;
     prev_line = -1;
  }
}

ChangePal(pal, line)
int pal, line;
{
#ifdef notdef
   if (pal == MARKPALETTE)
#else notdef
   if (pal == 0)
#endif notdef
      line_addr[line]->flags.vs_flags &= ~OP_VIDL_PL0;
   else
      line_addr[line]->flags.vs_flags |= OP_VIDL_PL0;
}



#endif VIDEO_INTERRUPT

qpintr()
{
	printf("Stray interrupt in qp driver!\n");
}

extern int toqp;

qpdebug(arg1, arg2, arg3, arg4, arg5, arg6)
int arg1, arg2, arg3, arg4, arg5, arg6;
{
	register int savetoqp;
	register int savesr;
	
	savesr = spl7();
	savetoqp = toqp;
	toqp = 0;
	printf(arg1, arg2, arg3, arg4, arg5, arg6);
	toqp = savetoqp;
	splx(savesr);
}

/*ARGSUSED*/
qpioctl(dev, cmd, data, flag)
dev_t dev;
int cmd;
caddr_t data;
int flag;
{
	register unsigned int palno;
	register struct qpalette *qp;
	register int nplanes;

	switch (cmd)
	{
		case GIOPALGET:
			copyout(palsave, *(ulong *)data, sizeof palsave);
			break;
		case GIOPALSET:
			qp = (struct qpalette *)data;
			/*
 			 * if we are selecting for all four palettes
			 */
			if (qp->pal > 3){
				/*
				 * The number of possible colors is seletced by
				 * 2 ^^ planes. so just limit the color number
				 * to that number - 1. -1 because they start
				 * at 0.
				 */
				if (qp->color >= (1 << planes)){
					qp->color =
					    (qp->color % (1 << planes)) - 1;
				}
				pal_col(qp->color,
					(qp->r & 0xFF),
					(qp->g & 0xFF),	
					(qp->b & 0xFF));
				break;
			} else {
				/*
				 * selecting specific palette
				 */
				if (qp->dith > 3){
					/*
					 * selecting for all dithers
					 */
					col_set((qp->pal &  0x3),
						(qp->color & 0xF),
						(qp->r & 0xFF),
						(qp->g & 0xFF),
						(qp->b & 0xFF));
					break;
				}
				/*
				 * selecting specific palette, dither
				 */
				palette_set((qp->pal & 3),
					(qp->dith & 3),
					(qp->color & 0xF),
					(qp->r & 0xFF),
					(qp->g & 0xFF),
					(qp->b & 0xFF));
				break;
			}

		case GIOPALSEL:
			if ((palno = *(unsigned int *)data) > 4)
				return(EIO);
			pal_sel((palno & 3));
			break;

		case GIORESETVID:
			if ((nplanes = *(int *)data) < 0 || nplanes > 4)
				return(ENXIO);
			coninit(nplanes);
			break;

		default:
			return(ENXIO);
	}
	return(0);
}
#endif NQP > 0
