#include "qp.h"
#if	(NQP > 0)
#include <sys/types.h>
#include "console.h"

#define NULL 0

#define kmax(a,b) ((a) > (b) ? (a) : (b))
#define kmin(a,b) ((a) > (b) ? (b) : (a))

#define HEAD 1
#define TAIL 2


#ifdef DEBUG
#define CHKDEST(addr)		chkdest(addr)
#else
#define CHKDEST(addr)		/* */
#endif


blit (cps)
CopyStruct *cps;
{
    form *srcform, *destform;
    rectangle rect1, rect2;
    register int j;
    register int slidex, slidey;

    srcform = cps->sourceform;
    destform = cps->destform;

    /* do some error checking on the parameters */
    if (cps->mode > 15)
	return (-1);

    if (srcform != NULL) {
	j = cps->sourceform->planes;
	if (j != 1 && j != 2 && j != 4)
	    return (-1);
    }
    j = cps->destform->planes;
    if (j != 1 && j != 2 && j != 4)
	return (-1);

    /* create a clipped rectangle on the destination form */
    clipit (cps->destrect, cps->cliprect, &rect1);

    /* clip the destination rect using the height and width of the 
     * source rectangle.
     */
    rect2.x = rect1.x;
    rect2.y = rect1.y;
    rect2.width = cps->srcrect->width;
    rect2.height = cps->srcrect->height;
    clipit (&rect2, &rect1, &rect1);

    /* clip the destination rect using the dest form */
    clipit ((rectangle *)(&destform->x), &rect1, &rect1);

    /* clip srcrect by srcform */
    if (srcform) 
	clipit (cps->srcrect, (rectangle *)(&srcform->x), &rect2);

    /* translate srcrect to dest rect */
    slidex = rect2.x - cps->destrect->x;
    slidey = rect2.y - cps->destrect->y;
    rect2.x -= slidex;
    rect2.y -= slidey;

    /* clip translated rect by orig destrect and orig destform */
    clipit (cps->destrect, &rect2, &rect2);
    clipit (&rect2, (rectangle *)(&destform->x), &rect2);

    /* translate the srcrect back onto the src form */
    rect2.x += slidex;
    rect2.y += slidey;

    /* move the source rectangle to the destination rectangle
     * following mode, htoneform, and cindex if the dest rect
     * has a different number of planes.
     */
    cpbitmap (srcform, destform, &rect2, &rect1, cps->htoneform,
	cps->cindex, cps->mode);

    return (0);
}

clipit (a, b, c)
register rectangle *a, *b, *c;
{
    rectangle d;

    if ((a->x + a->width < b->x) || (b->x + b->width < a->x)) {
	bzero (c, sizeof (rectangle));
	return (-1);
    }
    if ((a->y + a->height < b->y) || (b->y + b->height < a->y)) {
	bzero (c, sizeof (rectangle));
	return (-1);
    }
    d.x = kmax (a->x, b->x);
    d.y = kmax (a->y, b->y);
    d.width = kmin (a->x + a->width, b->x + b->width) - d.x;
    d.height = kmin (a->y + a->height, b->y + b->height) - d.y;

    bcopy (&d, c, sizeof (rectangle));
    return (0);
}

cpbitmap (srcform, destform, srcrect, rect, htoneform, cindex, mode)
form *srcform, *destform;
rectangle *rect, *srcrect;
addrptr htoneform;
ctrans *cindex;
unsigned char mode;
{
    char nosource;
    register u_long srcaddr, destaddr, incsrc, incdest, height;

    nosource = (srcform == NULL);

    /*
     * copying onto the same place;
     */
    if (nosource)
	srcform = destform;

    /* select the loop variables 
     * height = number of raster lines
     */
    height = rect->height;

    /* select the increment to bump each address
     * pointer on successive loops
     */
    incsrc = sizeof (word) * srcform->rowwords * srcform->planes;

    incdest = sizeof (word) * destform->rowwords * destform->planes;

    /* select the initial offset into the bitmaps
     * this is calculated with:
     *	the address of the bitmap
     *	the y offset into the bitmap, given by rowwords and rectangle y
     *  the x offset into the bitmap, given by planes and rectangle x
     */
    srcaddr = (u_long)(*(srcform->bits)) +
	incsrc * (srcrect->y - srcform->y) +
	sizeof(word) * ((srcrect->x - srcform->x) * (srcform->planes))/16;
    destaddr = (u_long)(*(destform->bits)) +
	incdest * (rect->y - destform->y) +
	sizeof(word) * ((rect->x - destform->x) * (destform->planes))/16;
    
    /* move each raster line from sourceform
     * to destform within the rectangle, rect
     */
    while (height--) {
	/* move a single raster line
	 */

	mvline ((addrptr)srcaddr, (addrptr)destaddr, rect->x, rect->width,
	    srcform->planes, destform->planes, htoneform, mode, nosource, 
	    cindex);
	/* increment the bitmap pointers 
	 */
	srcaddr += incsrc;
	destaddr += incdest;
    }
}

chkdest(dest)
char *dest;
{
	extern int vidmemsize;
	extern char _vidmem[];

	if (dest > &_vidmem[vidmemsize]) {
	    qpdebug("Bad destination address: %a\n", dest);
#ifdef	DEBUGGER
	    trap15();
#endif	DEBUGGER
	}
}


mvline (srcaddr, destaddr, leftno, npixels, srcplanes, destplanes, htoneform,
	mode, nosource, cindex)
register addrptr srcaddr;
register addrptr destaddr;
register int leftno;
int npixels, srcplanes, destplanes;
register addrptr htoneform;
register unsigned char mode;
register char nosource;
ctrans *cindex;
{
    register int planes, cnt;
    register short tmp;
    char leftoff, rightoff;
    register short htone = 0xffff;
    register int ppw, ppb;

    static nosrcdummy = 0xffff;

    CHKDEST(destaddr);

    /* if the number of planes in the source form is not the
     * same as the number in the destination form, then
     * return with an error for now
     */
    planes = destplanes;
    if (!nosource)
        if (destplanes != srcplanes)
	    return (-1);

    ppw = 16 / planes;
    ppb = 8 / planes;
    leftoff = leftno % ppw;
    rightoff = (leftno + npixels) % ppw;

    destaddr = (addrptr)((unsigned long)destaddr & ~1);
    CHKDEST(destaddr);

    /* if the first pixel is not on a word boundary, then
     * move pixels within the word
     */
    if (leftoff) {
	/* calculate the offset into the halftone array,
	 * this is determined by the destination pixel number
	 * mod 16
	 */

	if (htoneform)
	    htone = htoneform [(leftno / ppw) % 16];

	CHKDEST(destaddr+1);
	/* copy bits from src to dest of low byte of word
	 */
	if (!nosource)
	    dopbits ((char *)srcaddr, (char *)((unsigned)destaddr + 1),
		ppw-leftoff, planes, htone, mode, TAIL);
	else
	    dopbits (&nosrcdummy, (char *)((unsigned)destaddr + 1),
		ppw-leftoff, planes, htone, mode, TAIL);
	leftno += ppw-leftoff;
	leftoff -= ppw-leftoff;
	npixels -= ppb-leftoff;

	/* here, we are either on a byte or word offset, if a byte,
	 * then call dopbits to copy it properly
	 */
	if (leftoff) {
	    CHKDEST(destaddr + 1);
	    if (!nosource)
		dopbits ((char *)srcaddr, (char *)((unsigned)destaddr + 1),
		    ppb, planes, htone, mode, TAIL);
	    else
		dopbits (&nosrcdummy, (char *)((unsigned)destaddr + 1),
		    ppb, planes, htone, mode, TAIL);
	    leftno += ppb;
	    leftoff -= ppb;
	    npixels -= ppb;
	} 

	srcaddr++;
	destaddr++;

	CHKDEST(destaddr);
    }
    if (!npixels) 
	return (0);

    /* move the rest of the pixels as words, until
     * a word is reached that conains an uneven number
     * of pixels
     * cnt is the number of words to get transfered
     */
    for (cnt = npixels / ppw ; cnt > 0; cnt--) {
	if (htoneform)
	    htone = htoneform [(leftno / ppw) % 16];

	tmp = nosource ? 0xffff : *srcaddr;

	switch (mode) {
	case M_ZEROS : *destaddr = 0;  break;
	case M_SANDD : *destaddr = (tmp & htone) & *destaddr;  break;
	case M_SANDND : *destaddr = (tmp & htone) & ~*destaddr;  break;
	case M_COPY : *destaddr = (tmp & htone);  break;
	case M_NSANDD : *destaddr = ~(tmp & htone) & *destaddr;  break;
	case M_DST :   break;
	case M_XOR : *destaddr = (tmp & htone) ^ *destaddr;  break;
	case M_OR : *destaddr = (tmp & htone) | *destaddr;  break;
	case M_NSANDND : *destaddr = ~(tmp & htone) & ~*destaddr;  break;
	case M_NSXORD : *destaddr = ~(tmp & htone) ^ *destaddr;  break;
	case M_NDST : *destaddr = ~*destaddr;  break;
	case M_SORND : *destaddr = (tmp & htone) | ~*destaddr;  break;
	case M_NOT : *destaddr = ~(tmp & htone);  break;
	case M_NSORD : *destaddr = ~(tmp & htone) | *destaddr;  break;
	case M_NSORND : *destaddr = ~(tmp & htone) | ~*destaddr;  break;
	case M_ONES : *destaddr = 0xffff;  break;
	}

	srcaddr++;
	destaddr++;
	CHKDEST(destaddr);
	leftno++;
    }

    /* if there are any remaining pixels to move,
     * then do it now
     */
    if (rightoff) {
	if (htoneform)
	    htone = htoneform [(leftno / ppw) % 16];

	if (!nosource)
	    dopbits(srcaddr, destaddr, rightoff, planes, htone, mode, HEAD);
	else
	    dopbits(&nosrcdummy, destaddr, rightoff, planes, htone, mode, HEAD);
    }

    return (0);
}

dopbits (srcaddr, destaddr, npixels, planes, htone, mode, where)
char *srcaddr;
char *destaddr;
short htone;
int npixels, planes, where;
register unsigned char mode;
{
    register char mask, tmp;
    register char htone2;

    /* figure out the number of pixels to move and 
     * make sure the number != 0
     */
    if (!npixels || npixels > 8)
	return (-1);

    /* put the mask on the most significant bits
     */
    if (where == HEAD) 
        mask = 0xff << (8 - npixels * planes); 

    /* put the mask on the least significant bits
     */
    else
        mask = 0xff >> (8 - npixels * planes); 

    /* compute the proper halftone */

    if ((unsigned long)srcaddr & 1) 
	htone2 = (htone >> 8) & 0xff;
    else
	htone2 = htone & 0xff;
	
    switch (mode) {
    case M_ZEROS : tmp = 0;  break;
    case M_SANDD : tmp = (*srcaddr & htone2) & *destaddr;  break;
    case M_SANDND : tmp = (*srcaddr & htone2) & ~*destaddr;  break;
    case M_COPY : tmp = (*srcaddr & htone2);  break;
    case M_NSANDD : tmp = ~(*srcaddr & htone2) & *destaddr;  break;
    case M_DST :   break;
    case M_XOR : tmp = (*srcaddr & htone2) ^ *destaddr;  break;
    case M_OR : tmp = (*srcaddr & htone2) | *destaddr;  break;
    case M_NSANDND : tmp = ~(*srcaddr & htone2) & ~*destaddr;  break;
    case M_NSXORD : tmp = ~(*srcaddr & htone2) ^ *destaddr;  break;
    case M_NDST : tmp = ~*destaddr;  break;
    case M_SORND : tmp = (*srcaddr & htone2) | ~*destaddr;  break;
    case M_NOT : tmp = ~(*srcaddr & htone2);  break;
    case M_NSORD : tmp = ~(*srcaddr & htone2) | *destaddr;  break;
    case M_NSORND : tmp = ~(*srcaddr & htone2) | ~*destaddr;  break;
    case M_ONES : tmp = 0xff;  break;
    default:
	return (-1);
    }
    *destaddr = (tmp & mask) | (*destaddr & ~mask);
    return (0);
}
#endif NQP
