/*
 * QBUS|VMEBUS: bus mapping and bad block revectoring routines
 */
/*#define BAD144DEBUG	/* */

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "conf.h"
#include "user.h"
#include "map.h"
#include "vm.h"
#include "dk.h"
#include "cmap.h"
#include "dkbad.h"
#include "uio.h"
#include "kernel.h"
#include "proc.h"

#include "../is68kdev/qbvar.h"
#include "../machine/board.h"
#define		splqb	splhigh

struct buf dumpbuf;
struct buf badbuf;
struct pte *bptopte();

struct qb_hd qb_hd;		/* VDMA resource header */

#ifndef VQX
#define mpotopf(x)      (x)       /* this is defined in board.vqx.h */
#endif VQX

/*
 * Do transfer on device argqment.  The controller
 * and qb involved are implied by the device.
 * We queue for resource wait in the qb code if necessary.
 * We return 1 if the transfer was started, 0 if it was not.
 * If you call this routine with the head of the queue for a
 * QB, it will automatically remove the device from the QB
 * queue before it returns.  If some other device is given
 * as argqment, it will be added to the request queue if the
 * request cannot be started immediately.  This means that
 * passing a device which is on the queue but not at the head
 * of the request queue is likely to be a disaster.
 */
qbgo(qi)
	register struct qb_device *qi;
{
	register struct qb_ctlr *qm = qi->qi_mi;
	register struct qb_hd *qh;
	register int s, unit;
	register struct buf *bp;

	qh = &qb_hd;
	s = splqb();
	bp = qm->qm_tab.b_actf->b_actf;
	qm->qm_qbinfo = qbsetup(bp, QB_CANTWAIT);
	if (qm->qm_qbinfo == 0)
		goto rwait;
	splx(s);
#ifdef	QBUS
	if ((bdevsw[major(bp->b_dev)].d_flags&B_18BIT) && 
		((qm->qm_qbinfo+bp->b_bcount) > 0x40000) )
			panic("buffer not addressable");
#endif	QBUS
	if (qi->qi_dk >= 0) {
		unit = qi->qi_dk;
		dk_busy |= 1<<unit;
		dk_xfer[unit]++;
		dk_wds[unit] += qm->qm_tab.b_actf->b_actf->b_bcount>>6;
	}
	if (qh->qh_actf == qi)
		qh->qh_actf = qi->qi_forw;
	(*qm->qm_driver->qd_dgo)(qm);
	return (1);
rwait:
	if (qh->qh_actf != qi) {
		qi->qi_forw = NULL;
		if (qh->qh_actf == NULL)
			qh->qh_actf = qi;
		else
			qh->qh_actl->qi_forw = qi;
		qh->qh_actl = qi;
	}
	splx(s);
	return (0);
}

/* 
 * Allocate VDMA mapping resources, returning mapping resource:
 *	Bits 31 - VDMA_CNTDHFT		Number of mapping registers.
 *	Bits VDMA_CNTSHFT-1 - 32	Start map register number
 */
qbsetup(bp, flags)
register struct buf *bp;
{
	register struct pte *pte;

	pte = bptopte(bp);
#ifndef VQX
	if (bp->b_flags  & B_READ)
		pte_flush_cache(pte, bp->b_un.b_addr, bp->b_bcount);
#endif VQX
	return(qballoc(pte, bp->b_un.b_addr, bp->b_bcount, flags));
}

/* Release VDMA mapping resources held by a given buffer */
qbdone(qm)
	register struct qb_ctlr *qm;
{
	qbrelse(&qm->qm_qbinfo);
}


/*
 * Return the number of physicaly contiguous bytes associated with a buffer.
 * On machines which support VDMA everything is allways physically contiguous.
 */
qbaddrcontig(bp, rawio)
	register struct buf *bp;
{
#ifdef	M68030
	return bp->b_bcount;
#else	M68030
	register struct pte *pte;
	register int count = bp->b_bcount, ccount= 0, i = 0, pf, o;
	int npg;

	if ((bp->b_flags & B_PHYS) == 0)
		return count;
	pte = bptopte(bp);
	pf = pte->pg_pfnum;
	o = (int)bp->b_un.b_addr & PGOFSET;
	npg = btoc(count + o);
	while (npg > 0) {
		if (pte->pg_pfnum != pf+i)
			break;
#ifdef	M68025
		/* 
		 * for pages beyond 8Meg, fail because we dont 
		 * know what the controller can do... use kernel buffers.
	 	 */
		if (rawio && (pte->pg_pfnum >= 0x00800000))
			break;
#endif	M68025
		i++;
		pte++;
		npg--;
	}
	ccount = MIN(ctob(i) - o, count);
	return (ccount);
#endif	M68030
}

qballoc(pte, v, count, flags)
register struct pte *pte;
unsigned v;
{
#ifdef	M68030
	register struct qb_hd *qh = &qb_hd;
	register int npf, reg, s, i, j;

	j = npf = btoc(count + (v & PGOFSET));
	s = splqb();
	while ((reg = rmalloc(qh->qh_map, (long)npf)) == 0) {
		if (flags == QB_CANTWAIT) {
			splx(s);
			return (0);
		}
		qh->qh_mrwant++;
		sleep((caddr_t)&qh->qh_mrwant, PSWP);
	}
	splx(s);
	i = --reg;
	while (j--) {
		if (pte->pg_pfnum >= mpotopf(physmem))
			panic("dma past EOM");
		*(short *)(&vme_short[VDMA_MAP_ADDR(i,vbnum)])=pte++->pg_pfnum;
		i++;
	}
	return((npf << VDMA_CNTSHFT) | (reg << PGSHIFT) | (v & PGOFSET));

#else	M68030
	register int pf0, pf;

	pf = pf0 = pte->pg_pfnum;
	while (count > 0) {
		if (pte->pg_pfnum >= mpotopf(physmem))
			panic("dma past EOM");
		else if (pte->pg_pfnum != pf)
			panic("non-contuguous DMA!");
		pf++;
		pte++;
		count -= NBPG;
	}
	return ((pf0 << PGSHIFT) | (v & PGOFSET));
#endif	M68030
}


qbdumpsetup(v, count)
unsigned v;
{
#ifdef	M68030
	register struct qb_hd *qh = &qb_hd;
	register int npf, reg, pfnum, i, j;
	register int *map;

	j = npf = btoc(count + (v & PGOFSET));
	pfnum = btop(v);
	if ((reg = rmalloc(qh->qh_map, (long)npf)) == 0)
		panic("qbdumpsetup");
	reg--;
	i = reg;
	while (j--) {
		if (pfnum >= physmem)
			panic("dma past EOM");
		*(short *)(&vme_short[VDMA_MAP_ADDR(i, vbnum)]) = pfnum++;
		i++;
	}
	return((npf << VDMA_CNTSHFT) | (reg << PGSHIFT) | (v & PGOFSET));

#else	M68030
	return(v);
#endif	M68030
}



/* Release mapping resources */
qbrelse(amr)
	int *amr;
{
#ifdef	M68030
	register struct qb_hd *qh = &qb_hd;
	register int s, i;
	register u_long npf, mr, reg;
 
	/*
	 * Carefully see if we should release the space, since
	 * it may be released asynchronously at qb reset time.
	 */
	s = splqb();
	if (mr = *amr) {
		*amr = 0;
		i = reg = (mr & VDMA_SPACE - 1) >> PGSHIFT;
		npf = mr >> VDMA_CNTSHFT;
		reg++;
		rmfree(qh->qh_map, npf, reg);
	}
	splx(s);

	/*
	 * Wakeup sleepers for map registers,
	 * and also, if there are processes blocked in dgo(),
	 * give them a chance at the UNIBUS.
	 */
	if (qh->qh_mrwant) {
		qh->qh_mrwant = 0;
		wakeup((caddr_t)&qh->qh_mrwant);
	}
	while (qh->qh_actf && qbgo(qh->qh_actf))
		;
#endif	M68030
}


/* Allocate iopb block */
iopballoc(addr, count)
{
#ifdef	M68030
	register struct pte *pte;
	extern char esysmap;

	if (addr >= SYSV_BASE && addr < (u_long)&esysmap) {
		pte = &Sysmap[btop(addr - SYSV_BASE)];
		if ((addr = qballoc(pte, addr, count, QB_CANTWAIT)) == 0)
			panic("out of iopb");
	} else
		panic("iopballoc: illegal kernel virtual address");
#endif	M68030
	return(addr);
}

/* free iopb block */
iopbfree(addr)
{
	qbrelse(&addr);
}

/* return the pte used to map the given buffer */
struct pte *
bptopte(bp)
	register struct buf *bp;
{
	register unsigned v;
	register struct pte *pte;
	register struct proc *rp;

	v = btop((int)bp->b_un.b_addr);
	rp = (bp->b_flags&B_DIRTY) ? &proc[2] : bp->b_proc;
	if ((bp->b_flags & B_PHYS) == 0)
		pte = &Sysmap[v - btop(SYSV_BASE)];
	else if (bp->b_flags & B_UAREA)
		pte = &rp->p_addr[v];
	else if (bp->b_flags & B_PAGET)
		pte = &Usrptmap[btokmx((struct pte *)bp->b_un.b_addr)];
	else
		pte = vtopte(rp, v);
	return pte;
}

/* return the physical address given a given buffer */
bptop(bp)
	register struct buf *bp;
{
	register struct pte	*pte = bptopte(bp);
	register int		count = bp->b_bcount;
	register int		pf0, pf;

	pf = pf0 = pte->pg_pfnum;
	while (count > 0) {
		if (pte->pg_pfnum >= mpotopf(physmem))
			panic("bptop past EOM");
		else if (pte->pg_pfnum != pf)
			panic("non-contuguous bptop!");
		pf++;
		pte++;
		count -= NBPG;
	}
	return ((pf0 << PGSHIFT) | (((int)bp->b_un.b_addr) & PGOFSET));
}

/* 
 * initialize resource map for VDMA map 
 */
qbinit()
{
#ifdef	M68030
	qb_hd.qh_map = (struct map *)kmem_alloc(NQBMAP * sizeof (struct map));
	rminit(qb_hd.qh_map, btop(VDMA_SPACE), 1, "qb", NQBMAP);
#endif	M68030
}

/* 
 * initialize VBMATM 
 */
vbminit()
{
#ifdef	M68030
	afcww(&vbmatm_reg[VBM_SHORT_SLOT], (VBM_AM_SHORT << 6)|VBM_PORT_16); 
	afcww(&vbmatm_reg[VBM_STD_SLOT], (VBM_AM_STD << 6)|VBM_PORT_16); 
	afcww(&vbmatm_reg[VBM_EXT_SLOT], (VBM_AM_EXT<<6)|VBM_PORT_16);
#endif	M68030
}


/*
 * Generate a reset on qb nqmber qbn.  Then
 * call each device in the character device table,
 * giving it a chance to clean up so as to be able to continue.
 */
qbreset()
{
#ifdef	notdef
	register struct cdevsw *cdp;
	register struct qb_hd *qh = &qb_hd;
	int s;

	s = splqb();
	qh->qh_actf = qh->qh_actl = 0;
	qh->qh_mrwant = 0;
	qbinitmaps(qh);
	wakeup((caddr_t)&qh->qh_mrwant);
	printf("qb: reset");
	for (cdp = cdevsw; cdp < cdevsw + nchrdev; cdp++)
		(*cdp->d_reset)();
	ifqbreset();
	printf("\n");
	splx(s);
#endif	notdef
}


badstrat(qi, bp, bad, strat, nspt, ntpc, ncpd, coff)
	register struct buf *bp;
	register struct qb_device *qi;
	register struct dkbad *bad;
	int (*strat)();
{
	int s, hadbad = 0, len = bp->b_bcount, error;
	daddr_t blkno;
	register int i, hi, lo;
	register int sbn = bp->b_blkno + (coff*nspt*ntpc);
	register int lbn = sbn + ((len+(DEV_BSIZE-1)) >> DEV_BSHIFT) - 1;
	register int bbn, nbs;
	register struct buf *bbp = &badbuf;
#define SAVE_BFLAGS	(B_WRITE|B_READ|B_BUSY|B_PHYS|B_AGE|B_DELWRI| \
			B_TAPE|B_UAREA|B_PAGET|B_DIRTY|B_PGIN|B_CACHE| \
			B_INVAL|B_LOCKED|B_HEAD|B_BAD|B_QUALIFY)

	/*
	 * if the bad sector map has not yet been read in then read it in
	 * and convert from DEC-144 (cyl/trk/sec) to block number.
	 */
  retry:if (bad->bt_csn == 0) {
	    if (bp != &dumpbuf) {
	    	s = splbio();
	    	if (bbp->b_flags & B_BUSY) {
		    bbp->b_flags |= B_WANTED;
		    sleep((caddr_t)bbp, PRIBIO);
		    splx(s);
		    goto retry;
		}
		splx(s);
	    }
	    nbs = 0;
	    bbp->b_flags = B_READ|B_BUSY;
	    bbp->b_dev = (bp->b_dev&~7) | 2;	/* partition C of drive */
	    bbp->b_bcount = sizeof (struct dkbad);
            bbp->b_un.b_addr = (caddr_t) bad;
	    bbp->b_blkno = blkno = ncpd * nspt * ntpc - nspt;
	    (*strat)(qi, bbp);
	    error = u.u_error;
	    biowait(bbp);
	    u.u_error = error;
	    error = bbp->b_flags & B_ERROR;
	    if (bbp->b_flags & B_WANTED)
		    wakeup((caddr_t)bbp);
	    bbp->b_flags = 0;
	    if (error) {
		    printf("%s%d: cannot read bad sector map\n",
			    qi->qi_driver->qd_dname, qi->qi_unit);
		    bad->bt_csn = -1;
		    goto done;	/* so we'll keep trying */
	    }
#ifdef	BAD144DEBUG
	    printf("%s%d: read bad144 map from block %d\n",
		    qi->qi_driver->qd_dname, qi->qi_unit, blkno);
#endif	BAD144DEBUG
	    if (bad->bt_csn != 0) {
		for (i = 0; i < MAXBADBLK; i++) {
		    if (bad->bt_bad[i].bt_cyl == 0xFFFF)
			bad->bt_bad[i].bt_bn = -1;
		    else if ((bad->bt_bad[i].bt_cyl > ncpd) ||
			(((bad->bt_bad[i].bt_trksec>>8)&0xff)>ntpc)||
			((bad->bt_bad[i].bt_trksec&0xff) > nspt) ) {
			    printf("%s%d: bad bad144 map\n",
                                ((qi->qi_driver && qi->qi_driver->qd_dname) ?
                                    qi->qi_driver->qd_dname : "<nameless>" ),
                                qi->qi_unit);
			    bad->bt_csn = -1;
			    break;
		    } else {
#ifdef	BAD144DEBUG
			    printf("%s%d:(cyl %d,trk %d,sec %d)",
				qi->qi_driver->qd_dname, qi->qi_unit,
				bad->bt_bad[i].bt_cyl,
				(bad->bt_bad[i].bt_trksec>>8) & 0xff,
				bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG
			    bad->bt_bad[i].bt_bn = 
				(((bad->bt_bad[i].bt_cyl * ntpc) +
				((bad->bt_bad[i].bt_trksec>>8)&0xff))
				*nspt)+
				(bad->bt_bad[i].bt_trksec&0xff);
			    nbs++;
#ifdef	BAD144DEBUG
			    printf("[blk %d] remapped to %d\n",
				bad->bt_bad[i].bt_bn, blkno - nbs);
#endif	BAD144DEBUG
			    
		    }
		    
		}
		if (nbs != 0)
			printf("%s%d: %d remapped sectors\n",
			    qi->qi_driver->qd_dname, qi->qi_unit, nbs);
		bad->bt_csn = 1;
		bad->bt_mbz = nbs;
	    } else
		bad->bt_csn = -1;
	}

	/* binary search the bad sector map for remapped sectors */
	if (bad->bt_csn == 1 && bad->bt_mbz) {
	    lo = 0;
	    while (sbn <= lbn) {
	    	hi = bad->bt_mbz-1;
		while ((hi - lo) > 1) {
			i = lo + (hi - lo)/2;
			if (bad->bt_bad[i].bt_bn == sbn)
				hi = lo = i;
			else if (bad->bt_bad[i].bt_bn < sbn)
				lo = i;
			else
				hi = i;
		}
		if (bad->bt_bad[lo].bt_bn >= sbn)
			hi = lo;
		bbn = bad->bt_bad[hi].bt_bn;
		if (!hadbad) {
			if (bbn < sbn || bbn > lbn)
				goto done;		/* no remaps */
			hadbad++;
	    		if (bp != &dumpbuf) {
			    s = splbio();
			    while (bbp->b_flags & B_BUSY) {
				bbp->b_flags |= B_WANTED;
				sleep((caddr_t)bbp, PRIBIO);
			    }
			    splx(s);
			}
			*bbp = *bp;
			bbp->b_flags &= SAVE_BFLAGS;
			bbp->b_dev = (bp->b_dev&~7) | 2;
		}
		if (bbn < sbn || bbn > lbn) {	/* transfer from sbn to lbn */
		    bbp->b_blkno = sbn;
		    bbp->b_bcount = len;
		    bbp->b_flags &= SAVE_BFLAGS;
		    (*strat)(qi, bbp);
		    biowait(bbp);
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = lbn+1;
		} else {
		    if (sbn < bbn) {	/* transfer from sbn to bad block bbn */
			    bbp->b_blkno = sbn;
			    bbp->b_bcount = MIN(len,(bbn - sbn) * 512);
			    bbp->b_flags &= SAVE_BFLAGS;
			    (*strat)(qi, bbp);
			    biowait(bbp);
			    bbp->b_un.b_addr += bbp->b_bcount;
			    len -= bbp->b_bcount-bbp->b_resid;
			    if (bbp->b_flags & B_ERROR)
				    break;
		    }

		    /* transfer remapped bbn */
		    bbp->b_blkno = ((ncpd*ntpc*nspt) - nspt - 1) - hi;
		    bbp->b_bcount = MIN(len, 512);
		    bbp->b_flags &= SAVE_BFLAGS;
		    (*strat)(qi, bbp);
		    biowait(bbp);
		    bbp->b_un.b_addr += bbp->b_bcount;
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = bbn+1;
		}
		if (bbp->b_flags & B_ERROR)
			break;
	    }
	    bp->b_resid = len;
	    if (bbp->b_flags & B_ERROR) {
		    bp->b_flags |= B_ERROR;
		    bp->b_error = bbp->b_error;
	    }
	    if (bbp->b_flags & B_WANTED)
		    wakeup((caddr_t)bbp);
	    bbp->b_flags = 0;
	    iodone(bp);
	    return;
	}
done:	(*strat)(qi, bp);
}
